/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.proxy;

import eglx.http.HttpUtilities;
import eglx.http.Request;
import eglx.http.Response;
import eglx.json.JsonUtilities;
import eglx.services.ServiceInvocationException;
import eglx.services.ServiceKind;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.Runtime;
import org.eclipse.edt.javart.resources.Trace;
import org.eclipse.edt.javart.services.ServiceUtilities;
import org.eclipse.edt.javart.util.JavartUtil;
import org.eclipse.edt.runtime.java.eglx.lang.EDictionary;

public class HttpServiceHandler {
    private static final String SESSION_ID = "JSESSIONID";
    private static final String EGL_SESSION_ID = "egl_statefulsessionid";
    private static final String RESPONSE_CHARSET = "edt.service.response.charset";
    private static final String COOKIE_ID = "SET-COOKIE";

    HttpServiceHandler() {
    }

    Response invokeRestService(Request request, HttpURLConnection connection) throws Throwable {
        Response response;
        eglx.lang.EDictionary headers = request.headers;
        try {
            response = new Response();
            HttpStreamReader httpsr = null;
            try {
                connection.setRequestMethod(HttpUtilities.httpMethodToString(request.method));
                Trace tracer = Runtime.getRunUnit().getTrace();
                if (tracer.traceIsOn(1)) {
                    tracer.put("REST request URL:" + request.uri);
                }
                String contentType = null;
                String responseCharset = null;
                for (Map.Entry entry : headers.entrySet()) {
                    Object entryValue = entry.getValue();
                    if (entryValue instanceof AnyBoxedObject) {
                        entryValue = ((AnyBoxedObject)entryValue).ezeUnbox();
                    }
                    if (((String)entry.getKey()).equalsIgnoreCase("Content-Type")) {
                        contentType = entryValue.toString();
                    } else if (((String)entry.getKey()).equalsIgnoreCase(RESPONSE_CHARSET)) {
                        responseCharset = entryValue.toString();
                        entryValue = null;
                    }
                    if (entryValue == null) continue;
                    connection.setRequestProperty((String)entry.getKey(), entryValue.toString());
                }
                String charset = this.getCharSet(contentType);
                byte[] resource = request.body == null ? new byte[]{} : request.body.getBytes(charset == null ? ServiceUtilities.UTF8 : charset);
                connection.setDoInput(true);
                connection.setUseCaches(false);
                long startTime = System.currentTimeMillis();
                if (resource != null && resource.length > 0) {
                    connection.setDoOutput(true);
                    DataOutputStream os = new DataOutputStream(connection.getOutputStream());
                    os.write(resource, 0, resource.length);
                    os.flush();
                    os.close();
                }
                httpsr = new HttpStreamReader(connection, responseCharset == null ? ServiceUtilities.UTF8 : responseCharset);
                Future<?> threadResult = JavartUtil.getThreadPool().submit(httpsr);
                Thread.yield();
                if (!httpsr.isDoneReading()) {
                    long expireTime = -1L;
                    boolean infinite = true;
                    try {
                        expireTime = Integer.parseInt((String)headers.get("EGL_TIMEOUT"));
                        expireTime += System.currentTimeMillis();
                        infinite = false;
                    }
                    catch (Exception exception) {}
                    while (!httpsr.isDoneReading() && (infinite || expireTime > System.currentTimeMillis())) {
                        Thread.sleep(50L);
                    }
                    if (!httpsr.isDoneReading()) {
                        threadResult.cancel(true);
                        connection.disconnect();
                        connection = null;
                        ServiceInvocationException six = ServiceUtilities.buildServiceInvocationException("EGL0037E", new String[]{request.uri}, null, ServiceKind.REST);
                        throw six;
                    }
                    if (httpsr.exception()) {
                        throw httpsr.getException();
                    }
                }
                if (tracer.traceIsOn(1)) {
                    tracer.put("Service response time:" + String.valueOf(System.currentTimeMillis() - startTime));
                }
                response.body = httpsr.getReadValue();
                response.status = connection.getResponseCode();
                response.statusMessage = connection.getResponseMessage();
                Map<String, List<String>> header = connection.getHeaderFields();
                if (header != null) {
                    if (response.headers == null) {
                        response.headers = new EDictionary();
                    }
                    this.populate(response, header);
                    this.setServiceSessionId(response, header, headers.get(EGL_SESSION_ID));
                }
            }
            catch (IOException ioe) {
                boolean useConnection = false;
                try {
                    useConnection = connection != null && connection.getResponseCode() != -1;
                }
                catch (Throwable throwable) {}
                if (useConnection) {
                    try {
                        response.status = connection.getResponseCode();
                        response.statusMessage = connection.getResponseMessage();
                        String eglException = connection.getHeaderField(JsonUtilities.JSON_RPC_ERROR_NAME_VALUE);
                        if (eglException != null) {
                            try {
                                response.body = eglException = URLDecoder.decode(eglException, ServiceUtilities.UTF8);
                            }
                            catch (Exception exception) {}
                        } else if (httpsr != null && httpsr.exception() && httpsr.getReadValue() != null && !httpsr.getReadValue().isEmpty()) {
                            response.body = JsonUtilities.createJsonAnyException(ServiceUtilities.buildInvocationException("EGL0022E", new String[]{request.uri}, response.status.toString(), response.statusMessage, String.valueOf(ServiceUtilities.getMessage(ioe)) + ":\n" + httpsr.getReadValue(), null, ServiceKind.REST));
                        }
                    }
                    catch (IOException iOException) {
                        response.status = 500;
                        response.statusMessage = "FAILED";
                    }
                } else {
                    response.status = 500;
                    response.statusMessage = "FAILED";
                }
                if (response.body == null || response.body.isEmpty()) {
                    response.body = JsonUtilities.createJsonAnyException(ServiceUtilities.buildServiceInvocationException("EGL0022E", new String[]{request.uri}, ioe, ServiceKind.REST));
                }
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return response;
    }

    private void populate(Response response, Map<String, List<String>> header) {
        for (Map.Entry<String, List<String>> entry : header.entrySet()) {
            if (entry.getKey() == null) continue;
            response.headers.put(entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
        }
    }

    private void setServiceSessionId(Response response, Map<String, List<String>> header, Object sessionKey) {
        if (sessionKey == null || sessionKey instanceof String && ((String)sessionKey).length() == 0) {
            sessionKey = SESSION_ID;
        }
        for (Map.Entry<String, List<String>> entry : header.entrySet()) {
            String sessionId;
            if (!(entry.getKey() instanceof String) || !entry.getKey().equalsIgnoreCase(COOKIE_ID) || (sessionId = this.getSessionId(entry.getValue(), sessionKey.toString())) == null) continue;
            response.headers.put(EGL_SESSION_ID, sessionId);
            break;
        }
    }

    private String getSessionId(Object value, String sessionKey) {
        String str;
        block3: {
            block4: {
                str = null;
                if (!(value instanceof Collection)) break block4;
                Iterator itr = ((Collection)value).iterator();
                while (itr.hasNext()) {
                    str = this.getSessionId(itr.next(), sessionKey);
                    if (str == null) {
                        continue;
                    }
                    break block3;
                }
                break block3;
            }
            if (!(value instanceof String) || ((String)value).indexOf(sessionKey) <= -1) break block3;
            StringTokenizer subStrings = new StringTokenizer((String)value, ";");
            while (subStrings.hasMoreElements()) {
                String id = subStrings.nextToken();
                if (id.indexOf(sessionKey) <= -1) continue;
                str = (String)value;
                break;
            }
        }
        return str;
    }

    private String getCharSet(String contentType) {
        int idx;
        if (contentType != null && (idx = contentType.toLowerCase().indexOf("charset=")) != -1) {
            return contentType.substring(idx + 8);
        }
        return null;
    }

    private class HttpStreamReader
    implements Runnable {
        private URLConnection connection;
        private boolean doneReading;
        private String value;
        private Throwable t;
        private String responseCharset;

        private HttpStreamReader(URLConnection connection, String responseCharset) {
            this.connection = connection;
            this.doneReading = false;
            this.responseCharset = responseCharset;
        }

        @Override
        public void run() {
            block19: {
                this.t = null;
                InputStream is = null;
                try {
                    try {
                        is = this.connection.getInputStream();
                        this.value = this.readStream(is);
                    }
                    catch (Throwable t) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                            is = null;
                        }
                        this.t = t;
                        if (this.connection instanceof HttpURLConnection) {
                            try {
                                is = ((HttpURLConnection)this.connection).getErrorStream();
                                this.value = this.readStream(is);
                            }
                            catch (Throwable throwable) {}
                        }
                        if (is == null) break block19;
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                        is = null;
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                        is = null;
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                    is = null;
                }
            }
            this.doneReading = true;
        }

        private String readStream(InputStream is) throws IOException, UnsupportedEncodingException {
            StringBuilder body = new StringBuilder();
            BufferedReader reader = null;
            try {
                try {
                    if (this.responseCharset == null) {
                        this.responseCharset = HttpServiceHandler.this.getCharSet(this.connection.getContentType());
                    }
                    reader = new BufferedReader(new InputStreamReader(is, this.responseCharset));
                }
                catch (Throwable throwable) {}
                if (reader == null) {
                    reader = new BufferedReader(new InputStreamReader(is, ServiceUtilities.UTF8));
                }
                int charCnt = 0;
                int nRead = reader.read();
                while (charCnt < Integer.MAX_VALUE && nRead != -1) {
                    body.append((char)nRead);
                    nRead = reader.read();
                    ++charCnt;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    reader = null;
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                reader = null;
            }
            return body.toString();
        }

        public boolean exception() {
            return this.t != null;
        }

        public boolean isDoneReading() {
            return this.doneReading;
        }

        public String getReadValue() {
            return this.value;
        }

        public Throwable getException() {
            return this.t;
        }
    }
}

