/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.DynamicAccessException;
import eglx.lang.OrderingKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.runtime.java.eglx.lang.AnyValue;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;

public class EDictionary
extends EAny
implements eglx.lang.EDictionary {
    private static final long serialVersionUID = 10L;
    private Map<String, Object> map;
    private boolean caseSensitive;
    private OrderingKind order;

    public EDictionary() {
        this(false, OrderingKind.none);
    }

    public EDictionary(boolean caseSensitive, OrderingKind order) {
        this.caseSensitive = caseSensitive;
        this.order = order;
        this.createMap();
    }

    public EDictionary(EDictionary other) throws AnyException {
        this(other.caseSensitive, other.order);
        this.insertAll(other);
    }

    @Override
    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public OrderingKind getOrdering() {
        return this.order;
    }

    private void createMap() {
        switch (this.order) {
            case byInsertion: {
                this.map = new LinkedHashMap<String, Object>();
                break;
            }
            case byKey: {
                this.map = new TreeMap<String, Object>();
                break;
            }
            default: {
                this.map = new HashMap<String, Object>();
            }
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return this.containsKey((String)key);
        }
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public Object get(Object key) {
        if (!this.caseSensitive && key instanceof String) {
            key = ((String)key).toLowerCase();
        }
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set keySet() {
        return this.map.keySet();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection values() {
        return this.map.values();
    }

    @Override
    public String[] getKeyArray() {
        String[] keyArray = new String[this.map.size()];
        int ii = 0;
        Iterator<String> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            keyArray[ii] = iter.next();
            ++ii;
        }
        return keyArray;
    }

    @Override
    public Object[] getValueArray() {
        Object[] valueArray = new Object[this.map.size()];
        int ii = 0;
        Iterator<Object> iter = this.map.values().iterator();
        while (iter.hasNext()) {
            valueArray[ii] = iter.next();
            ++ii;
        }
        return valueArray;
    }

    public void insert(String key, Object value) {
        if (!this.caseSensitive) {
            key = key.toLowerCase();
        }
        this.map.put(key, value);
    }

    @Override
    public boolean containsKey(String key) {
        if (!this.caseSensitive) {
            key = key.toLowerCase();
        }
        return this.map.containsKey(key);
    }

    @Override
    public List<String> getKeys() throws AnyException {
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : this.map.keySet()) {
            keys.add(key);
        }
        return keys;
    }

    @Override
    public List<eglx.lang.EAny> getValues() throws AnyException {
        ArrayList<eglx.lang.EAny> vals = new ArrayList<eglx.lang.EAny>();
        for (Object value : this.map.values()) {
            vals.add(value instanceof eglx.lang.EAny ? (AnyBoxedObject<Object>)value : EAny.ezeBox(value));
        }
        return vals;
    }

    @Override
    public void insertAll(eglx.lang.EDictionary d) throws AnyException {
        if (d == this) {
            return;
        }
        String[] newKeys = d.getKeyArray();
        Object[] newValues = d.getValueArray();
        int ii = 0;
        while (ii < newKeys.length) {
            this.insert(newKeys[ii], newValues[ii]);
            ++ii;
        }
    }

    @Override
    public void removeElement(String key) throws AnyException {
        if (!this.caseSensitive) {
            key = key.toLowerCase();
        }
        int originalSize = this.map.size();
        this.map.remove(key);
        if (originalSize == this.map.size()) {
            DynamicAccessException dax = new DynamicAccessException();
            dax.key = key;
            throw dax.fillInMessage("EGL0001E", key, "dictionary");
        }
    }

    @Override
    public void removeAll() {
        this.map.clear();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EDictionary theClone = (EDictionary)super.clone();
        switch (this.order) {
            case byInsertion: {
                theClone.map = new LinkedHashMap<String, Object>(this.map.size());
                break;
            }
            case byKey: {
                theClone.map = new TreeMap<String, Object>();
                break;
            }
            default: {
                theClone.map = new HashMap<String, Object>(this.map.size());
            }
        }
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof AnyValue) {
                value = ((AnyValue)value).clone();
            }
            theClone.map.put(entry.getKey(), value);
        }
        return theClone;
    }

    @Override
    public Object put(String key, Object value) {
        if (!this.caseSensitive) {
            key = key.toLowerCase();
        }
        this.map.put(key, value);
        return value;
    }

    @Override
    public eglx.lang.EAny ezeGet(String name) throws AnyException {
        Object value;
        if (!this.caseSensitive) {
            name = name.toLowerCase();
        }
        if ((value = this.map.get(name)) == null && !this.map.containsKey(name)) {
            DynamicAccessException dax = new DynamicAccessException();
            dax.key = name;
            throw dax.fillInMessage("EGL0001E", name, "dictionary");
        }
        return value instanceof eglx.lang.EAny ? (AnyBoxedObject<Object>)value : EAny.ezeBox(value);
    }

    @Override
    public void ezeSet(String name, Object value) {
        this.put(name, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.map.putAll(map);
    }
}

