/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.LibraryBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.internal.compiler.SystemEnvironmentManager;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.edt.ide.ui.internal.util.CapabilityFilterUtility;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class EGLSystemWordProposalHandler
extends EGLAbstractProposalHandler {
    public static int RETURNS = 0;
    public static int NORETURNS = 1;

    public EGLSystemWordProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor, Node boundNode) {
        super(viewer, documentOffset, prefix, editor);
        while (!(boundNode instanceof File)) {
            if (boundNode instanceof Part) {
                boundNode.accept((IASTVisitor)new DefaultASTVisitor(){

                    public boolean visit(Handler handler) {
                        return false;
                    }
                });
            }
            boundNode = boundNode.getParent();
        }
    }

    public List getProposals(int options, boolean addPrefix) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        if (this.getPrefix().length() > 0) {
            IFileEditorInput editorInput = (IFileEditorInput)this.editor.getEditorInput();
            ISystemEnvironment env = SystemEnvironmentManager.findSystemEnvironment((IProject)editorInput.getFile().getProject(), null);
            LinkedList contentAssistPartList = new LinkedList();
            contentAssistPartList.addAll(env.getSystemLibraryManager().getLibraries().values());
            contentAssistPartList.addAll(env.getContentAssistPartsManager().getExternalTypeLibraries().values());
            Collection systemLibaries = CapabilityFilterUtility.filterParts(contentAssistPartList, new CapabilityFilterUtility.IPartBindingFilter[]{new CapabilityFilterUtility.IPartBindingFilter(){

                @Override
                public boolean partBindingPasses(IPartBinding partBinding) {
                    return true;
                }
            }});
            for (PartBinding systemLibrary : systemLibaries) {
                for (IDataBinding nestedFunctionBinding : systemLibrary.getDeclaredFunctions()) {
                    IFunctionBinding functionBinding = (IFunctionBinding)nestedFunctionBinding.getType();
                    if (RETURNS == options && functionBinding.getReturnType() == null || NORETURNS == options && functionBinding.getReturnType() != null || !nestedFunctionBinding.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase())) continue;
                    proposals.addAll(this.createFunctionInvocationProposals(functionBinding, UINlsStrings.bind((String)UINlsStrings.CAProposal_LibraryFunction, (Object)systemLibrary.getCaseSensitiveName()), 40, addPrefix));
                }
                Iterator iter2 = null;
                if (systemLibrary instanceof LibraryBinding) {
                    iter2 = ((LibraryBinding)systemLibrary).getDeclaredData().iterator();
                } else {
                    if (!(systemLibrary instanceof ExternalTypeBinding)) continue;
                    iter2 = ((ExternalTypeBinding)systemLibrary).getDeclaredData().iterator();
                }
                while (iter2.hasNext()) {
                    IDataBinding variableBinding = (IDataBinding)iter2.next();
                    if (!variableBinding.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase())) continue;
                    proposals.add(this.createVariableProposal(variableBinding, 40, systemLibrary.getCaseSensitiveName(), addPrefix));
                }
            }
        }
        return proposals;
    }

    protected EGLCompletionProposal createVariableProposal(IDataBinding dataBinding, int relevance, String libraryName, boolean addPrefix) {
        String proposalString = dataBinding.getCaseSensitiveName();
        String prefix = addPrefix ? String.valueOf(dataBinding.getDeclaringPart().getCaseSensitiveName()) + "." : "";
        return new EGLCompletionProposal(this.viewer, String.valueOf(proposalString) + " (" + this.getPartTypeString(dataBinding.getType()) + ")", String.valueOf(prefix) + proposalString, UINlsStrings.bind((String)UINlsStrings.CAProposal_LibraryVariable, (Object)libraryName), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), prefix.length() + proposalString.length(), relevance);
    }
}

