/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BinaryReadOnlyFile
implements IStorage {
    private String pathString;
    private String fileString;
    private boolean isExternal;
    private String project;
    public static final String IR_EXTENSION = ".ir";
    public static final String EGLAR_IR_SEPARATOR = "|";

    public BinaryReadOnlyFile(String path, String file) {
        this.pathString = path;
        this.fileString = BinaryReadOnlyFile.resolveFileString(file);
        this.isExternal = false;
    }

    public BinaryReadOnlyFile(String path, String file, String project, boolean isExternal) {
        this.pathString = path;
        this.fileString = BinaryReadOnlyFile.resolveFileString(file);
        this.project = project;
        this.isExternal = isExternal;
    }

    public InputStream getContents() throws CoreException {
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(this.pathString);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return fs;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IPath getFullPath() {
        String path = this.pathString;
        path = String.valueOf(path) + EGLAR_IR_SEPARATOR;
        String pkg = this.getPackage();
        if (pkg != null && pkg.trim().length() > 0) {
            pkg = pkg.replace(".", "/");
            path = String.valueOf(path) + pkg + "/";
        }
        path = String.valueOf(path) + this.getName();
        return new Path(path);
    }

    public IPath getEGLARPath() {
        return new Path(this.pathString);
    }

    public String getPackage() {
        int index = this.fileString.lastIndexOf(".");
        if (index > -1) {
            return this.fileString.substring(0, index);
        }
        return "";
    }

    public String getName() {
        String irFileName = "";
        int index = this.fileString.lastIndexOf(".");
        irFileName = index > -1 ? String.valueOf(this.fileString.substring(index + 1)) + IR_EXTENSION : String.valueOf(this.fileString) + IR_EXTENSION;
        return irFileName;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public String getProject() {
        return this.project;
    }

    private static String resolveFileString(String file) {
        String fileString = file;
        int index = fileString.indexOf(":");
        if (index != -1) {
            fileString = fileString.substring(0, index);
        }
        return fileString;
    }
}

