/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.internal.codemanipulation.AddImportOperation;
import org.eclipse.edt.ide.ui.internal.codemanipulation.OrganizeImportsOperation;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.util.BoundNodeModelUtility;
import org.eclipse.edt.ide.ui.internal.editor.util.IBoundNodeRequestor;
import org.eclipse.edt.ide.ui.internal.handlers.EGLHandler;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchMessages;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchQuery;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchScopeFactory;
import org.eclipse.edt.ide.ui.internal.search.SearchUtil;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.part.EditorActionBarContributor;

public class SearchHandler
extends EGLHandler {
    protected int iScope;
    protected int iLimitTo = 2;
    protected IWorkingSet workingset = null;
    private boolean fIsQueryShowing = false;

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor;
        if (this.isInvokedFromEditorContext(event) && (editor = this.getCurrentActiveEditor(event)) instanceof EGLEditor) {
            IEditorInput editorInput;
            this.fEditor = (EGLEditor)editor;
            if (editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
                IFile resource = ((IFileEditorInput)editorInput).getFile();
                IEGLElement element = EGLCore.create((IResource)resource);
                this.fSite = editor.getSite();
                this.fSelection = new StructuredSelection((Object)element);
            }
        }
        if (this.fSelection != null) {
            this.run();
        }
        return null;
    }

    private void showOperationUnavailableDialog() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)EGLSearchMessages.EGLElementActionOperationUnavailableTitle, (String)this.getOperationUnavailableMessage());
    }

    private String getOperationUnavailableMessage() {
        return EGLSearchMessages.EGLElementActionOperationUnavailableGeneric;
    }

    @Override
    public void run() {
        this.performNewSearch();
    }

    protected Shell getShell() {
        return this.fEditor.getEditorSite().getShell();
    }

    protected void performNewSearch() {
        NewSearchUI.activateSearchResultView();
        ISelection sel = this.fEditor.getSelectionProvider().getSelection();
        ITextSelection selectionRange = (ITextSelection)sel;
        int selOffset = selectionRange.getOffset();
        IFileEditorInput fileInput = (IFileEditorInput)this.fEditor.getEditorInput();
        IFile file = fileInput.getFile();
        String selText = selectionRange.getText().trim();
        BoundNodeAnalyzer bNodeAnalyzer = new BoundNodeAnalyzer(selText);
        BoundNodeModelUtility.getBoundNodeAtOffset(file, selOffset, bNodeAnalyzer);
        selText = bNodeAnalyzer.getExpandedSelectedText();
        if (bNodeAnalyzer.canOperateOnSelection()) {
            String scopeDescription = "";
            IEGLSearchScope scope = null;
            switch (this.iScope) {
                case 0: {
                    scopeDescription = EGLSearchMessages.WorkspaceScope;
                    scope = SearchEngine.createWorkspaceScope();
                    break;
                }
                case 3: {
                    IEGLElement[] projArray = new IEGLElement[1];
                    IProject project = file.getProject();
                    try {
                        if (project != null && project.isAccessible() && project.hasNature(EGLCore.NATURE_ID)) {
                            projArray[0] = EGLCore.create((IProject)project);
                        }
                    }
                    catch (CoreException coreException) {}
                    scope = SearchEngine.createEGLSearchScope((IEGLElement[])projArray);
                    IProject[] projects = EGLSearchScopeFactory.getInstance().getProjects(scope);
                    if (projects.length >= 1) {
                        if (projects.length == 1) {
                            scopeDescription = EGLSearchMessages.bind((String)EGLSearchMessages.EnclosingProjectScope, (Object)projects[0].getName());
                            break;
                        }
                        scopeDescription = EGLSearchMessages.bind((String)EGLSearchMessages.EnclosingProjectsScope, (Object)projects[0].getName());
                        break;
                    }
                    scopeDescription = EGLSearchMessages.bind((String)EGLSearchMessages.EnclosingProjectScope, (Object)"");
                    break;
                }
                case 2: {
                    IWorkingSet[] workingSets = null;
                    workingSets = this.workingset != null ? new IWorkingSet[]{this.workingset} : EGLSearchScopeFactory.getInstance().queryWorkingSets();
                    if (workingSets == null || workingSets.length < 1) {
                        return;
                    }
                    scopeDescription = EGLSearchMessages.bind((String)EGLSearchMessages.WorkingSetScope, (Object)SearchUtil.toString(workingSets));
                    scope = EGLSearchScopeFactory.getInstance().createEGLSearchScope(workingSets);
                }
            }
            String containerName = bNodeAnalyzer.getContainerName();
            if (containerName != null) {
                selText = String.valueOf(containerName) + "." + selText;
            }
            if (selText.indexOf(46) == -1) {
                String pattern = bNodeAnalyzer.packageName;
                if (pattern == null) {
                    pattern = this.getPackageName(fileInput.getFile());
                }
                if (pattern.length() > 0) {
                    pattern = String.valueOf(pattern) + ".";
                }
                selText = String.valueOf(pattern) + selText;
            }
            EGLSearchQuery query = new EGLSearchQuery(selText, false, bNodeAnalyzer.getSearchFor(), this.iLimitTo, scope, scopeDescription, true);
            NewSearchUI.activateSearchResultView();
            NewSearchUI.runQueryInBackground((ISearchQuery)query);
        } else {
            this.showOperationUnavailableDialog();
        }
    }

    protected String getSelectionTrimedText() {
        ISelection sel = this.fEditor.getSelectionProvider().getSelection();
        ITextSelection selectionRange = (ITextSelection)sel;
        return selectionRange.getText().trim();
    }

    private String getPackageName(IFile file) {
        IEGLFile eglFile = (IEGLFile)EGLCore.create((IFile)file);
        IPackageFragment packageFragment = (IPackageFragment)eglFile.getAncestor(4);
        if (packageFragment.isDefaultPackage()) {
            return "";
        }
        String[] packageNameArray = packageFragment.getElementName().split("\\.");
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < packageNameArray.length) {
            if (i > 0) {
                buf.append(".");
            }
            buf.append(packageNameArray[i]);
            ++i;
        }
        return buf.toString();
    }

    protected void registerHelper(IEditingSupport helper) {
        if (this.fEditor == null) {
            return;
        }
        ISourceViewer viewer = this.fEditor.getViewer();
        if (viewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.register(helper);
        }
    }

    protected void deregisterHelper(IEditingSupport helper) {
        if (this.fEditor == null) {
            return;
        }
        ISourceViewer viewer = this.fEditor.getViewer();
        if (viewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.unregister(helper);
        }
    }

    protected void postRun(OrganizeImportsOperation op) {
        AddImportOperation addOp;
        IStatus status;
        if (op instanceof AddImportOperation && !(status = (addOp = (AddImportOperation)op).getStatus()).isOK()) {
            this.setStatusBarMessage(status.getMessage());
        }
    }

    protected void setStatusBarMessage(String message) {
        IEditorActionBarContributor contributor = this.fEditor.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            IStatusLineManager manager = ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
            manager.setMessage(message);
        }
    }

    protected IEditingSupport createViewerHelper() {
        return new IEditingSupport(){

            public boolean isOriginator(DocumentEvent event, IRegion subjectRegion) {
                return true;
            }

            public boolean ownsFocusShell() {
                return SearchHandler.this.fIsQueryShowing;
            }
        };
    }

    protected static class BoundNodeAnalyzer
    implements IBoundNodeRequestor {
        private String selectedText;
        private String expandedSelectedText;
        private boolean canOperateOnSelection;
        private int searchFor;
        private String packageName;
        private String containerName;

        public BoundNodeAnalyzer(String selText) {
            this.selectedText = selText;
        }

        private boolean primCanOperateOnSelection(String selText, Node boundNode) {
            if (boundNode instanceof NameType) {
                boundNode = ((NameType)boundNode).getName();
            }
            if (boundNode instanceof Name) {
                Name boundNameNode = (Name)boundNode;
                String nodeName = boundNameNode.getCanonicalName();
                if (selText.equals(nodeName = nodeName.trim())) {
                    return true;
                }
                if (boundNameNode.isQualifiedName() && selText.equals(boundNameNode.getIdentifier())) {
                    return true;
                }
            }
            return false;
        }

        private ITypeBinding getTypeBinding(Node boundNode) {
            Name boundNameNode = null;
            boundNameNode = boundNode instanceof NameType ? ((NameType)boundNode).getName() : (Name)boundNode;
            IBinding binding = boundNameNode.resolveBinding();
            if (binding != null && binding != IBinding.NOT_FOUND_BINDING) {
                ITypeBinding typeBinding = null;
                if (binding instanceof ITypeBinding) {
                    typeBinding = (ITypeBinding)binding;
                } else if (binding instanceof IDataBinding) {
                    typeBinding = ((IDataBinding)binding).getType();
                }
                return typeBinding;
            }
            return null;
        }

        private int primGetSearchFor(Node boundNode) {
            int searchFor = 0;
            ITypeBinding typeBinding = this.getTypeBinding(boundNode);
            if (typeBinding != null) {
                int typeBindingKind = typeBinding.getKind();
                switch (typeBindingKind) {
                    case 13: {
                        searchFor = 1;
                        break;
                    }
                    case 11: {
                        searchFor = 9;
                        break;
                    }
                    case 17: {
                        searchFor = 5;
                        break;
                    }
                    case 10: {
                        searchFor = 12;
                        break;
                    }
                    case 20: {
                        searchFor = 10;
                        break;
                    }
                    case 5: {
                        searchFor = 3;
                        break;
                    }
                    case 9: {
                        searchFor = 7;
                        break;
                    }
                    case 14: {
                        searchFor = 13;
                        break;
                    }
                    case 6: 
                    case 7: {
                        searchFor = 4;
                        break;
                    }
                    case 8: {
                        searchFor = 6;
                    }
                }
            }
            return searchFor;
        }

        public boolean canOperateOnSelection() {
            return this.canOperateOnSelection;
        }

        int getSearchFor() {
            return this.searchFor;
        }

        private String getPackageName(Node node) {
            ITypeBinding type = this.getTypeBinding(node);
            if (type instanceof IPartBinding) {
                IPartBinding part = (IPartBinding)type;
                String[] pkg = part.getPackageName();
                if (pkg == null || pkg.length == 0) {
                    return "";
                }
                StringBuffer buff = new StringBuffer();
                int i = 0;
                while (i < pkg.length) {
                    if (i > 0) {
                        buff.append(".");
                    }
                    buff.append(pkg[i]);
                    ++i;
                }
                return buff.toString();
            }
            return null;
        }

        @Override
        public void acceptNode(Node boundPart, Node selectedNode) {
            this.expandedSelectedText = selectedNode instanceof Name && this.selectedText.length() == 0 ? ((Name)selectedNode).getCanonicalString() : this.selectedText;
            if (this.primCanOperateOnSelection(this.expandedSelectedText, selectedNode)) {
                IBinding binding;
                this.canOperateOnSelection = true;
                this.searchFor = this.primGetSearchFor(selectedNode);
                this.packageName = this.getPackageName(selectedNode);
                if (selectedNode instanceof Name && (binding = ((Name)selectedNode).resolveBinding()) instanceof NestedFunctionBinding) {
                    this.containerName = ((NestedFunctionBinding)binding).getDeclaringPart().getCaseSensitiveName();
                }
            }
        }

        public String getExpandedSelectedText() {
            return this.expandedSelectedText;
        }

        public String getContainerName() {
            return this.containerName;
        }
    }
}

