/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.wizards.sqldb;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.ui.actions.AddProfileViewAction;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.edt.ide.internal.sql.util.RDBConnectionUtility;
import org.eclipse.edt.ide.sql.SQLPlugin;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusUtil;
import org.eclipse.edt.ide.ui.internal.record.NewRecordWizardMessages;
import org.eclipse.edt.ide.ui.internal.record.wizards.sqldb.RecordFromSqlDatabaseWizardConfiguration;
import org.eclipse.edt.ide.ui.internal.record.wizards.sqldb.RecordFromSqlDatabaseWizardConfigurationBidi;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class RecordFromSqlDatabasePage
extends WizardPage
implements SelectionListener,
ICheckStateListener {
    private IStatus fCurrStatus;
    private boolean fPageVisible;
    private Combo dbConnectionCombo;
    private Link newDatabaseConnectionLink;
    private CheckboxTreeViewer dbTableViewer;
    private Label numSelectedLabel;
    private Button qualifyTableNamesCheckbox;
    private Button saveConnectionToDDCheckbox;
    private StatusInfo databaseStatus;
    private StatusInfo connectionStatus;
    private StatusInfo tableStatus;
    private boolean confirmOverwrite = false;
    private RecordFromSqlDatabaseWizardConfiguration configuration;
    private Hashtable existingConnections;
    protected boolean isBidi = false;

    public RecordFromSqlDatabasePage(RecordFromSqlDatabaseWizardConfiguration config) {
        super(RecordFromSqlDatabasePage.class.getName());
        this.setTitle(NewRecordWizardMessages.RecordFromSqlDatabasePage_Title);
        this.setDescription(NewRecordWizardMessages.RecordFromSqlDatabasePage_Description);
        this.configuration = config;
        this.databaseStatus = new StatusInfo();
        this.connectionStatus = new StatusInfo();
        this.tableStatus = new StatusInfo();
        this.fPageVisible = false;
        this.fCurrStatus = new StatusInfo();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.createDatabaseControls(composite);
        boolean cfr_ignored_0 = this.configuration instanceof RecordFromSqlDatabaseWizardConfigurationBidi;
        this.createTableControls(composite);
        this.qualifyTableNamesCheckbox = new Button(composite, 32);
        this.qualifyTableNamesCheckbox.setText(NewRecordWizardMessages.RecordFromSqlDatabasePage_QualifyTableNames);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.qualifyTableNamesCheckbox.setLayoutData((Object)data);
        this.qualifyTableNamesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = ((Button)e.widget).getSelection();
                RecordFromSqlDatabasePage.this.configuration.setQualifiedTableNames(isSelected);
            }
        });
        this.saveConnectionToDDCheckbox = new Button(composite, 32);
        this.saveConnectionToDDCheckbox.setText(NewRecordWizardMessages.RecordFromSqlDatabasePage_SaveConnectionToDD);
        data = new GridData();
        data.horizontalSpan = 2;
        this.saveConnectionToDDCheckbox.setLayoutData((Object)data);
        this.saveConnectionToDDCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = ((Button)e.widget).getSelection();
                RecordFromSqlDatabasePage.this.configuration.setSaveConnectionToDeploymentDescriptor(isSelected);
            }
        });
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
    }

    public IWizardPage getNextPage() {
        IWizardPage page = super.getNextPage();
        return page;
    }

    private void createDatabaseControls(Composite composite) {
        Composite dbComposite = new Composite(composite, 0);
        dbComposite.setFont(composite.getFont());
        GridLayout dbLayout = new GridLayout();
        dbLayout.marginHeight = 0;
        dbLayout.marginWidth = 0;
        dbLayout.numColumns = 2;
        GridData dbData = new GridData(768);
        dbComposite.setLayout((Layout)dbLayout);
        dbComposite.setLayoutData((Object)dbData);
        Label dbLabel = new Label(dbComposite, 0);
        dbLabel.setText(NewRecordWizardMessages.RecordFromSqlDatabasePage_DBConnectionlabel);
        this.dbConnectionCombo = new Combo(dbComposite, 12);
        GridData gd = new GridData(768);
        this.dbConnectionCombo.setLayoutData((Object)gd);
        this.dbConnectionCombo.addSelectionListener((SelectionListener)this);
        new Label(dbComposite, 0);
        this.newDatabaseConnectionLink = new Link(dbComposite, 8);
        this.newDatabaseConnectionLink.setText(NewRecordWizardMessages.RecordFromSqlDatabasePage_CreateDBLink);
        this.newDatabaseConnectionLink.addSelectionListener((SelectionListener)this);
        gd = new GridData(128);
        this.newDatabaseConnectionLink.setLayoutData((Object)gd);
        this.initializeDatabaseValues();
    }

    private void createTableControls(Composite composite) {
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setFont(composite.getFont());
        GridLayout tableLayout = new GridLayout(1, false);
        tableLayout.marginHeight = 0;
        tableLayout.marginWidth = 0;
        GridData tableData = new GridData(1808);
        tableComposite.setLayout((Layout)tableLayout);
        tableComposite.setLayoutData((Object)tableData);
        Label tableLabel = new Label(tableComposite, 0);
        tableLabel.setText(NewRecordWizardMessages.RecordFromSqlDatabasePage_TablesLabel);
        this.dbTableViewer = new CheckboxTreeViewer(tableComposite);
        this.dbTableViewer.setContentProvider((IContentProvider)new DatabaseTableContentProvider());
        this.dbTableViewer.setLabelProvider((IBaseLabelProvider)new DatabaseTableLabelProvider());
        tableData = new GridData(1808);
        tableData.verticalSpan = 2;
        this.dbTableViewer.getTree().setLayoutData((Object)tableData);
        this.dbTableViewer.setInput((Object)this.configuration.getDatabaseConnection());
        this.dbTableViewer.addCheckStateListener((ICheckStateListener)this);
        this.numSelectedLabel = new Label(tableComposite, 0);
        tableData = new GridData(128);
        tableData.horizontalSpan = 2;
        this.numSelectedLabel.setLayoutData((Object)tableData);
    }

    private void initializeDatabaseValues() {
        this.dbConnectionCombo.removeAll();
        IConnectionProfile[] allProfiles = ProfileManager.getInstance().getProfiles();
        ArrayList<IConnectionProfile> profiles = new ArrayList<IConnectionProfile>();
        int profileCount = 0;
        while (profileCount < allProfiles.length) {
            IConnectionProfile profile = allProfiles[profileCount];
            Map factories = allProfiles[profileCount].getProvider().getConnectionFactories();
            if (factories != null && factories.containsKey("java.sql.Connection")) {
                profiles.add(profile);
            }
            ++profileCount;
        }
        if (profiles != null) {
            this.existingConnections = new Hashtable();
            this.sortConnections(profiles);
            for (IConnectionProfile con : profiles) {
                this.existingConnections.put(con.getName(), con);
                this.dbConnectionCombo.add(con.getName());
            }
        }
    }

    private void sortConnections(List connections) {
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((IConnectionProfile)o1).getName();
                String s2 = ((IConnectionProfile)o2).getName();
                return s1.compareToIgnoreCase(s2);
            }
        };
        Collections.sort(connections, c);
    }

    private void validatePage() {
        this.databaseStatus.setOK();
        this.tableStatus.setOK();
        IConnectionProfile databaseConnection = this.configuration.getDatabaseConnection();
        List tableContents = this.configuration.getSelectedTables();
        this.validateDatabaseConnection(databaseConnection, this.databaseStatus);
        this.validateTables(tableContents, this.tableStatus);
        this.updateStatus(new IStatus[]{this.connectionStatus, this.databaseStatus, this.tableStatus});
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fPageVisible = visible;
        if (visible && this.fCurrStatus.matches(4)) {
            StatusInfo status = new StatusInfo();
            status.setError("");
            this.fCurrStatus = status;
        }
        this.updateStatus(this.fCurrStatus);
    }

    private void validatePageConnections() {
        this.updateStatus(new IStatus[]{this.connectionStatus, this.databaseStatus, this.tableStatus});
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        IConnectionProfile profile;
        if (e.getSource() == this.dbConnectionCombo) {
            String connectionName = this.dbConnectionCombo.getText();
            this.updateDatabaseCombo(connectionName);
            if (this.confirmOverwrite) {
                this.confirmOverwrite = false;
            }
        } else if (e.getSource() == this.newDatabaseConnectionLink && (profile = this.createNewProfile()) != null) {
            this.dbConnectionCombo.add(profile.getName());
            this.existingConnections.put(profile.getName(), profile);
            this.dbConnectionCombo.select(this.dbConnectionCombo.indexOf(profile.getName()));
            this.updateDatabaseCombo(this.dbConnectionCombo.getText());
        }
        this.validatePage();
        if (e.getSource() == this.dbConnectionCombo || e.getSource() == this.newDatabaseConnectionLink) {
            this.validatePageConnections();
        }
    }

    protected IConnectionProfile createNewProfile() {
        AddProfileViewAction action = new AddProfileViewAction();
        action.run();
        return action.getAddedProfile();
    }

    private void updateDatabaseCombo(String connectionName) {
        final IConnectionProfile selectedConnection = (IConnectionProfile)this.existingConnections.get(connectionName);
        this.configuration.setDatabaseConnection(selectedConnection);
        if (selectedConnection != null) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    monitor.beginTask(NewRecordWizardMessages.RecordFromSqlDatabasePage_RetrievingTablesTask, 1);
                    if (selectedConnection != null) {
                        RecordFromSqlDatabasePage.this.dbTableViewer.setInput((Object)selectedConnection);
                    }
                    monitor.worked(1);
                }
            };
            try {
                new ProgressMonitorDialog(this.getControl().getShell()).run(false, false, runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getSource() == this.dbTableViewer) {
            if (event.getChecked()) {
                this.dbTableViewer.setSubtreeChecked(event.getElement(), true);
            } else {
                this.dbTableViewer.setSubtreeChecked(event.getElement(), false);
            }
            this.handleTablesSelected();
        }
        this.validatePage();
    }

    private void handleTablesSelected() {
        ArrayList<Object> selectedTables = new ArrayList<Object>();
        Object[] objectArray = this.dbTableViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Table) {
                selectedTables.add(o);
            }
            ++n2;
        }
        this.configuration.setSelectedTables(selectedTables);
        Integer tableSelected = new Integer(selectedTables.size());
        this.numSelectedLabel.setText(NewRecordWizardMessages.bind((String)NewRecordWizardMessages.RecordFromSqlDatabasePage_TablesSelected, (Object[])new String[]{tableSelected.toString()}));
        this.numSelectedLabel.getParent().layout();
    }

    protected void validateDatabaseConnection(IConnectionProfile dbConnection, StatusInfo status) {
        if (dbConnection == null) {
            status.setError(NewRecordWizardMessages.RecordFromSqlDatabasePage_Validation_NoConnection);
        }
    }

    protected void validateTables(List selectedTables, StatusInfo status) {
        if (selectedTables == null || selectedTables.isEmpty()) {
            status.setError(NewRecordWizardMessages.RecordFromSqlDatabasePage_Validation_NoTable);
        }
    }

    protected void updateStatus(IStatus status) {
        this.fCurrStatus = status;
        this.setPageComplete(!status.matches(4));
        if (this.fPageVisible) {
            StatusUtil.applyToStatusLine((DialogPage)this, status);
        }
    }

    protected void updateStatus(IStatus[] status) {
        this.updateStatus(StatusUtil.getMostSevere(status));
    }

    public static String getSQLDatabaseVendorPreference(IConnectionProfile profile) {
        String name = "";
        if (profile != null) {
            name = (String)profile.getBaseProperties().get("org.eclipse.datatools.connectivity.db.vendor");
        }
        return name;
    }

    public static String getSQLJDBCDriverClassPreference(IConnectionProfile profile) {
        String name = "";
        if (profile != null) {
            name = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.driverClass");
        }
        return name;
    }

    public static String getSQLDatabasePreference(IConnectionProfile profile) {
        String name = "";
        if (profile != null) {
            name = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.databaseName");
        }
        return name;
    }

    public static String getSQLConnectionURLPreference(IConnectionProfile profile) {
        String name = "";
        if (profile != null) {
            name = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.URL");
        }
        return name;
    }

    private boolean ensureConnection() {
        boolean isConnected = false;
        IConnectionProfile profile = this.configuration.getDatabaseConnection();
        if (profile == null) {
            this.connectionStatus.setError(NewRecordWizardMessages.RecordFromSqlDatabasePage_Validation_UnableToConnect);
            isConnected = false;
        } else if (profile.getConnectionState() == 1) {
            isConnected = true;
        } else {
            IStatus status = RDBConnectionUtility.connectWithPromptIfNeeded((IConnectionProfile)profile, (boolean)SQLPlugin.getPlugin().getSQLPromptDialogOption());
            if (!status.isOK()) {
                this.connectionStatus.setError(NewRecordWizardMessages.RecordFromSqlDatabasePage_Validation_UnableToConnect);
            } else {
                isConnected = true;
            }
        }
        if (isConnected) {
            this.connectionStatus.setOK();
        }
        return isConnected;
    }

    public class DatabaseTableContentProvider
    implements ITreeContentProvider {
        IConnectionProfile model = null;
        EList allSchemas;

        public Object[] getElements(Object inputElement) {
            if (this.allSchemas != null) {
                return this.allSchemas.toArray();
            }
            return null;
        }

        public Object[] getChildren(Object arg0) {
            ArrayList<Table> ret = new ArrayList<Table>();
            if (arg0 instanceof Schema) {
                Schema schema = (Schema)arg0;
                for (Object potentialTable : schema.getTables()) {
                    if (!(potentialTable instanceof Table)) continue;
                    ret.add((Table)potentialTable);
                }
            }
            return ret.toArray();
        }

        public Object getParent(Object arg0) {
            if (arg0 instanceof Table) {
                return ((Table)arg0).getSchema();
            }
            return null;
        }

        public boolean hasChildren(Object arg0) {
            if (arg0 instanceof Schema) {
                Schema cfr_ignored_0 = (Schema)arg0;
                return true;
            }
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof IConnectionProfile) {
                this.model = (IConnectionProfile)newInput;
                this.updateTableModel();
            }
        }

        private void updateTableModel() {
            Database database = null;
            if (this.model != null) {
                try {
                    IManagedConnection managedConnection;
                    if (RecordFromSqlDatabasePage.this.ensureConnection() && this.model.getConnectionState() == 1 && (managedConnection = this.model.getManagedConnection("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo")) != null) {
                        ConnectionInfo info = (ConnectionInfo)managedConnection.getConnection().getRawConnection();
                        database = info.getSharedDatabase();
                        EList schemas = this.getSchemas(database);
                        this.allSchemas = new BasicEList();
                        ListIterator schemaInterator = schemas.listIterator();
                        while (schemaInterator.hasNext()) {
                            Schema schema = (Schema)schemaInterator.next();
                            if (schema.getTables().size() <= 0) continue;
                            this.allSchemas.add((Object)schema);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private EList getSchemas(Database database) {
            BasicEList allSchemas = new BasicEList();
            EList catalogs = database.getCatalogs();
            if (catalogs != null && catalogs.size() > 0) {
                for (Catalog catalog : catalogs) {
                    if (catalog.getSchemas() == null || catalog.getSchemas().size() <= 0) continue;
                    Iterator it = catalog.getSchemas().iterator();
                    while (it.hasNext()) {
                        allSchemas.add(it.next());
                    }
                }
            } else {
                EList schemas = database.getSchemas();
                if (schemas != null && schemas.size() > 0) {
                    allSchemas.addAll((Collection)schemas);
                }
            }
            return allSchemas;
        }
    }

    public class DatabaseTableLabelProvider
    implements ILabelProvider {
        private Image schemaImage;
        private Image tableImage;

        public DatabaseTableLabelProvider() {
            try {
                URL url = new URL("platform:/plugin/org.eclipse.datatools.connectivity.sqm.core.ui/icons/table.gif");
                this.tableImage = ImageDescriptor.createFromURL((URL)url).createImage();
                url = new URL("platform:/plugin/org.eclipse.datatools.connectivity.sqm.core.ui/icons/schema.gif");
                this.schemaImage = ImageDescriptor.createFromURL((URL)url).createImage();
            }
            catch (Exception exception) {}
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            if (this.schemaImage != null) {
                this.schemaImage.dispose();
            }
            if (this.tableImage != null) {
                this.tableImage.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public Image getImage(Object element) {
            if (element instanceof Schema) {
                return this.schemaImage;
            }
            if (element instanceof Table) {
                return this.tableImage;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Table) {
                String tableName = ((Table)element).getName();
                return tableName;
            }
            if (element instanceof Schema) {
                return ((Schema)element).getName();
            }
            return "";
        }
    }
}

