/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ArrayTypeConverter;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IConfirmQuery;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IReorgQueries;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.ReorgUtils;

class OverwriteHelper {
    private Object fDestination;
    private IFile[] fFiles = new IFile[0];
    private IFolder[] fFolders = new IFolder[0];
    private IEGLFile[] fCus = new IEGLFile[0];
    private IPackageFragmentRoot[] fRoots = new IPackageFragmentRoot[0];
    private IPackageFragment[] fPackageFragments = new IPackageFragment[0];

    OverwriteHelper() {
    }

    public void setFiles(IFile[] files) {
        Assert.isNotNull((Object)files);
        this.fFiles = files;
    }

    public void setFolders(IFolder[] folders) {
        Assert.isNotNull((Object)folders);
        this.fFolders = folders;
    }

    public void setCus(IEGLFile[] cus) {
        Assert.isNotNull((Object)cus);
        this.fCus = cus;
    }

    public void setPackageFragmentRoots(IPackageFragmentRoot[] roots) {
        Assert.isNotNull((Object)roots);
        this.fRoots = roots;
    }

    public void setPackages(IPackageFragment[] fragments) {
        Assert.isNotNull((Object)fragments);
        this.fPackageFragments = fragments;
    }

    public IFile[] getFilesWithoutUnconfirmedOnes() {
        return this.fFiles;
    }

    public IFolder[] getFoldersWithoutUnconfirmedOnes() {
        return this.fFolders;
    }

    public IEGLFile[] getCusWithoutUnconfirmedOnes() {
        return this.fCus;
    }

    public IPackageFragmentRoot[] getPackageFragmentRootsWithoutUnconfirmedOnes() {
        return this.fRoots;
    }

    public IPackageFragment[] getPackagesWithoutUnconfirmedOnes() {
        return this.fPackageFragments;
    }

    public void confirmOverwritting(IReorgQueries reorgQueries, IEGLElement destination) {
        Assert.isNotNull((Object)destination);
        this.fDestination = destination;
        this.confirmOverwritting(reorgQueries);
    }

    public void confirmOverwritting(IReorgQueries reorgQueries, IResource destination) {
        Assert.isNotNull((Object)destination);
        Assert.isNotNull((Object)reorgQueries);
        this.fDestination = destination;
        this.confirmOverwritting(reorgQueries);
    }

    private void confirmOverwritting(IReorgQueries reorgQueries) {
        IConfirmQuery overwriteQuery = reorgQueries.createYesYesToAllNoNoToAllQuery(UINlsStrings.OverwriteHelper_0, true, 6);
        IConfirmQuery skipQuery = reorgQueries.createSkipQuery(UINlsStrings.OverwriteHelper_2, 7);
        this.confirmFileOverwritting(overwriteQuery);
        this.confirmFolderOverwritting(skipQuery);
        this.confirmCuOverwritting(overwriteQuery);
        this.confirmPackageFragmentRootOverwritting(skipQuery);
        this.confirmPackageOverwritting(overwriteQuery);
    }

    private void confirmPackageFragmentRootOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IPackageFragmentRoot> toNotOverwrite = new ArrayList<IPackageFragmentRoot>(1);
        int i = 0;
        while (i < this.fRoots.length) {
            IPackageFragmentRoot root = this.fRoots[i];
            if (this.canOverwrite(root) && !OverwriteHelper.skip(root.getElementName(), overwriteQuery)) {
                toNotOverwrite.add(root);
            }
            ++i;
        }
        IPackageFragmentRoot[] roots = toNotOverwrite.toArray(new IPackageFragmentRoot[toNotOverwrite.size()]);
        this.fRoots = ArrayTypeConverter.toPackageFragmentRootArray(ReorgUtils.setMinus((IEGLElement[])this.fRoots, (IEGLElement[])roots));
    }

    private void confirmCuOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IEGLFile> cusToNotOverwrite = new ArrayList<IEGLFile>(1);
        int i = 0;
        while (i < this.fCus.length) {
            IEGLFile cu = this.fCus[i];
            if (this.canOverwrite(cu) && !OverwriteHelper.overwrite((IEGLElement)cu, overwriteQuery)) {
                cusToNotOverwrite.add(cu);
            }
            ++i;
        }
        IEGLFile[] cus = cusToNotOverwrite.toArray(new IEGLFile[cusToNotOverwrite.size()]);
        this.fCus = ArrayTypeConverter.toEGLFileArray(ReorgUtils.setMinus((IEGLElement[])this.fCus, (IEGLElement[])cus));
    }

    private void confirmFolderOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IFolder> foldersToNotOverwrite = new ArrayList<IFolder>(1);
        int i = 0;
        while (i < this.fFolders.length) {
            IFolder folder = this.fFolders[i];
            if (this.canOverwrite((IResource)folder) && !OverwriteHelper.skip(folder.getName(), overwriteQuery)) {
                foldersToNotOverwrite.add(folder);
            }
            ++i;
        }
        IFolder[] folders = foldersToNotOverwrite.toArray(new IFolder[foldersToNotOverwrite.size()]);
        this.fFolders = ArrayTypeConverter.toFolderArray(ReorgUtils.setMinus((IResource[])this.fFolders, (IResource[])folders));
    }

    private void confirmFileOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IFile> filesToNotOverwrite = new ArrayList<IFile>(1);
        int i = 0;
        while (i < this.fFiles.length) {
            IFile file = this.fFiles[i];
            if (this.canOverwrite((IResource)file) && !OverwriteHelper.overwrite((IResource)file, overwriteQuery)) {
                filesToNotOverwrite.add(file);
            }
            ++i;
        }
        IFile[] files = filesToNotOverwrite.toArray(new IFile[filesToNotOverwrite.size()]);
        this.fFiles = ArrayTypeConverter.toFileArray(ReorgUtils.setMinus((IResource[])this.fFiles, (IResource[])files));
    }

    private void confirmPackageOverwritting(IConfirmQuery overwriteQuery) {
        ArrayList<IPackageFragment> toNotOverwrite = new ArrayList<IPackageFragment>(1);
        int i = 0;
        while (i < this.fPackageFragments.length) {
            IPackageFragment pack = this.fPackageFragments[i];
            if (this.canOverwrite(pack) && !OverwriteHelper.overwrite((IEGLElement)pack, overwriteQuery)) {
                toNotOverwrite.add(pack);
            }
            ++i;
        }
        IPackageFragment[] packages = toNotOverwrite.toArray(new IPackageFragment[toNotOverwrite.size()]);
        this.fPackageFragments = ArrayTypeConverter.toPackageArray(ReorgUtils.setMinus((IEGLElement[])this.fPackageFragments, (IEGLElement[])packages));
    }

    private boolean canOverwrite(IPackageFragment pack) {
        Assert.isTrue((boolean)(this.fDestination instanceof IPackageFragmentRoot));
        IPackageFragmentRoot destination = (IPackageFragmentRoot)this.fDestination;
        return !destination.equals(pack.getParent()) && destination.getPackageFragment(pack.getElementName()).exists();
    }

    private boolean canOverwrite(IResource resource) {
        if (resource == null) {
            return false;
        }
        IResource destinationResource = ReorgUtils.getResource(this.fDestination);
        if (destinationResource.equals((Object)resource.getParent())) {
            return false;
        }
        if (destinationResource instanceof IContainer) {
            IContainer container = (IContainer)destinationResource;
            IResource member = container.findMember(resource.getName());
            if (member == null || !member.exists()) {
                return false;
            }
            if (member instanceof IContainer) {
                try {
                    if (((IContainer)member).members().length == 0) {
                        return false;
                    }
                }
                catch (CoreException coreException) {
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    private boolean canOverwrite(IPackageFragmentRoot root) {
        Assert.isTrue((boolean)(this.fDestination instanceof IEGLProject));
        IEGLProject destination = (IEGLProject)this.fDestination;
        IFolder conflict = destination.getProject().getFolder(root.getElementName());
        try {
            return !destination.equals(root.getParent()) && conflict.exists() && conflict.members().length > 0;
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    private boolean canOverwrite(IEGLFile cu) {
        if (this.fDestination instanceof IPackageFragment) {
            IPackageFragment destination = (IPackageFragment)this.fDestination;
            return !destination.equals(cu.getParent()) && destination.getEGLFile(cu.getElementName()).exists();
        }
        return this.canOverwrite(ReorgUtils.getResource(cu));
    }

    private static boolean overwrite(IResource resource, IConfirmQuery overwriteQuery) {
        return OverwriteHelper.overwrite(resource.getName(), overwriteQuery);
    }

    private static boolean overwrite(IEGLElement element, IConfirmQuery overwriteQuery) {
        return OverwriteHelper.overwrite(element.getElementName(), overwriteQuery);
    }

    private static boolean overwrite(String name, IConfirmQuery overwriteQuery) {
        String question = MessageFormat.format((String)UINlsStrings.OverwriteHelper_1, (Object[])new String[]{name});
        return overwriteQuery.confirm(question);
    }

    private static boolean skip(String name, IConfirmQuery overwriteQuery) {
        String question = MessageFormat.format((String)UINlsStrings.OverwriteHelper_3, (Object[])new String[]{name});
        return overwriteQuery.confirm(question);
    }
}

