/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.results.views;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AbstractMultiPageViewer
implements ISelectionProvider {
    private CTabFolder container = null;
    private ArrayList viewForms = null;
    private ArrayList viewers = null;
    private Viewer currentViewer;
    private ArrayList selectionChangedListenerList;

    public AbstractMultiPageViewer(Composite parent) {
        this.container = this.createContainer(parent);
        this.viewForms = new ArrayList();
        this.viewers = new ArrayList();
    }

    private int addPage(Control control) {
        this.createItem(control);
        return this.getPageCount() - 1;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionChangedListenerList == null) {
            this.selectionChangedListenerList = new ArrayList();
        }
        this.selectionChangedListenerList.add(listener);
    }

    public int addViewer(Viewer viewer, ViewForm viewForm) {
        this.viewers.add(viewer);
        this.viewForms.add(viewForm);
        int loc = this.addPage((Control)viewForm);
        return loc;
    }

    public int addViewer(Viewer viewer, ViewForm viewForm, String pageName) {
        this.viewers.add(viewer);
        this.viewForms.add(viewForm);
        int loc = this.addPage((Control)viewForm);
        this.setPageText(loc, pageName);
        return loc;
    }

    private CTabFolder createContainer(Composite parent) {
        final CTabFolder container = new CTabFolder(parent, 1088);
        container.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newPageIndex = container.indexOf((CTabItem)e.item);
                AbstractMultiPageViewer.this.pageChange(newPageIndex);
            }
        });
        container.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                container.setFocus();
            }
        });
        return container;
    }

    private CTabItem createItem(Control viewerControl) {
        CTabItem item = new CTabItem(this.getContainer(), 0);
        item.setControl(viewerControl);
        return item;
    }

    public int getActivePageIndex() {
        if (this.getContainer() != null) {
            return this.getContainer().getSelectionIndex();
        }
        return -1;
    }

    private Viewer getActiveViewer() {
        int index = this.getActivePageIndex();
        if (index != -1) {
            return this.getViewer(index);
        }
        return null;
    }

    public CTabFolder getContainer() {
        return this.container;
    }

    public Viewer getCurrentViewer() {
        return this.currentViewer;
    }

    private CTabItem getItem(int pageIndex) {
        return this.getContainer().getItem(pageIndex);
    }

    public int getPageCount() {
        CTabFolder folder = this.getContainer();
        if (folder != null && !folder.isDisposed()) {
            return folder.getItemCount();
        }
        return 0;
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.currentViewer);
    }

    public Viewer getViewer(int pageIndex) {
        try {
            Viewer viewer = (Viewer)this.viewers.get(pageIndex);
            return viewer;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    protected ArrayList getViewers() {
        return this.viewers;
    }

    private ViewForm getViewForm(int pageIndex) {
        try {
            ViewForm viewForm = (ViewForm)this.viewForms.get(pageIndex);
            return viewForm;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private void pageChange(int newPageIndex) {
        this.setFocus(newPageIndex);
        this.selectionChanged();
    }

    private void removePage(int pageIndex) {
        if (pageIndex >= 0 && pageIndex < this.getPageCount()) {
            Viewer viewer = this.getViewer(pageIndex);
            ViewForm viewForm = this.getViewForm(pageIndex);
            this.getItem(pageIndex).dispose();
            if (viewer != null) {
                this.viewers.remove(viewer);
            }
            if (viewForm != null) {
                this.viewForms.remove(viewForm);
            }
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionChangedListenerList != null) {
            this.selectionChangedListenerList.remove(listener);
        }
    }

    public void removeViewer(CTabItem selTab) {
        int selIndex = this.getContainer().indexOf(selTab);
        this.removePage(selIndex);
    }

    private void selectionChanged() {
        Viewer activeViewer = this.getActiveViewer();
        if (this.currentViewer == activeViewer) {
            return;
        }
        this.currentViewer = activeViewer;
        if (this.selectionChangedListenerList != null) {
            StructuredSelection selection = new StructuredSelection((Object)this.currentViewer);
            int i = 0;
            while (i < this.selectionChangedListenerList.size()) {
                ((ISelectionChangedListener)this.selectionChangedListenerList.get(i)).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)selection));
                ++i;
            }
        }
    }

    public void setActivePage(int pageIndex) {
        if (pageIndex >= 0 && pageIndex < this.getPageCount()) {
            this.getContainer().setSelection(pageIndex);
        }
        this.selectionChanged();
    }

    public void setActivePage(CTabItem currentTab) {
        this.getContainer().setSelection(currentTab);
        this.selectionChanged();
    }

    public void setFocus() {
        this.setFocus(this.getActivePageIndex());
    }

    private void setFocus(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return;
        }
        Viewer viewer = this.getViewer(pageIndex);
        if (viewer != null) {
            viewer.getControl().setFocus();
        }
    }

    public void setImage(int pageIndex, Image newImg) {
        this.getItem(pageIndex).setImage(newImg);
    }

    public void setPageText(int pageIndex, String text) {
        this.getItem(pageIndex).setText(text);
    }

    public void setSelection(ISelection selection) {
    }
}

