/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.EglarBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.MofarBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyEglarBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyMofarBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.utils.AbsolutePathUtility;
import org.eclipse.edt.mof.serialization.IZipFileEntryManager;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.serialization.ZipFileObjectStore;

public class ZipFileBuildPathEntryManager {
    public static final String MOFAR_EXTENSION = "mofar";
    public static final String EGLAR_EXTENSION = "eglar";
    private static final ZipFileBuildPathEntryManager INSTANCE = new ZipFileBuildPathEntryManager(false);
    private static final ZipFileBuildPathEntryManager WCC_INSTANCE = new ZipFileBuildPathEntryManager(true);
    private boolean isWCC;
    private Map<Object, Map<IPath, EglarBuildPathEntry>> zipfileProjectEntries;

    private ZipFileBuildPathEntryManager(boolean isWCC) {
        this.isWCC = isWCC;
        this.init();
    }

    private void init() {
        this.zipfileProjectEntries = new HashMap<Object, Map<IPath, EglarBuildPathEntry>>();
    }

    public static ZipFileBuildPathEntryManager getInstance() {
        return INSTANCE;
    }

    public static ZipFileBuildPathEntryManager getWCCInstance() {
        return WCC_INSTANCE;
    }

    protected Map getProjectEntry(Object project) {
        Map<IPath, EglarBuildPathEntry> retVal = this.zipfileProjectEntries.get(project);
        if (retVal == null) {
            retVal = new HashMap<IPath, EglarBuildPathEntry>();
            this.zipfileProjectEntries.put(project, retVal);
        }
        return retVal;
    }

    public EglarBuildPathEntry getZipFileBuildPathEntry(Object project, IPath zipfilepath) {
        Map projectMap = this.getProjectEntry(project);
        EglarBuildPathEntry result = (EglarBuildPathEntry)((Object)projectMap.get(zipfilepath));
        if (result == null) {
            result = this.isWCC ? this.createEntry(WorkingCopyProjectEnvironmentManager.getInstance().getProjectEnvironment((IProject)project), zipfilepath) : this.createEntry(ProjectEnvironmentManager.getInstance().getProjectEnvironment((IProject)project), zipfilepath);
            projectMap.put(zipfilepath, result);
        }
        return result;
    }

    private EglarBuildPathEntry createEntry(ProjectEnvironment env, IPath path) {
        String extension = path.getFileExtension();
        if (extension.equalsIgnoreCase(MOFAR_EXTENSION)) {
            MofarBuildPathEntry entry = new MofarBuildPathEntry(env, path, ".mofxml", env.getConverter());
            ZipFileObjectStore store = new ZipFileObjectStore(new File(AbsolutePathUtility.getAbsolutePathString(path)), (org.eclipse.edt.mof.serialization.IEnvironment)env.getIREnvironment(), "XML", ".mofxml", (IZipFileEntryManager)entry);
            entry.setStore((ObjectStore)store);
            return entry;
        }
        if (extension.equalsIgnoreCase(EGLAR_EXTENSION)) {
            EglarBuildPathEntry entry = new EglarBuildPathEntry(env, path, ".eglxml", env.getConverter());
            ZipFileObjectStore store = new ZipFileObjectStore(new File(AbsolutePathUtility.getAbsolutePathString(path)), (org.eclipse.edt.mof.serialization.IEnvironment)env.getIREnvironment(), "XML", ".eglxml", "egl", (IZipFileEntryManager)entry);
            entry.setStore((ObjectStore)store);
            return entry;
        }
        return null;
    }

    private EglarBuildPathEntry createEntry(WorkingCopyProjectEnvironment env, IPath path) {
        String extension = path.getFileExtension();
        if (extension.equalsIgnoreCase(MOFAR_EXTENSION)) {
            WorkingCopyMofarBuildPathEntry entry = new WorkingCopyMofarBuildPathEntry((IEnvironment)env, path, ".mofxml", env.getConverter());
            ZipFileObjectStore store = new ZipFileObjectStore(new File(AbsolutePathUtility.getAbsolutePathString(path)), (org.eclipse.edt.mof.serialization.IEnvironment)env.getIREnvironment(), "XML", ".mofxml", (IZipFileEntryManager)entry);
            entry.setStore((ObjectStore)store);
            return entry;
        }
        if (extension.equalsIgnoreCase(EGLAR_EXTENSION)) {
            WorkingCopyEglarBuildPathEntry entry = new WorkingCopyEglarBuildPathEntry((IEnvironment)env, path, ".eglxml", env.getConverter());
            ZipFileObjectStore store = new ZipFileObjectStore(new File(AbsolutePathUtility.getAbsolutePathString(path)), (org.eclipse.edt.mof.serialization.IEnvironment)env.getIREnvironment(), "XML", ".eglxml", "egl", (IZipFileEntryManager)entry);
            entry.setStore((ObjectStore)store);
            return entry;
        }
        return null;
    }

    public void clear() {
        this.zipfileProjectEntries.clear();
    }

    public void clear(IProject project) {
        Map<IPath, EglarBuildPathEntry> projectMap = this.zipfileProjectEntries.get(project);
        if (projectMap != null) {
            for (EglarBuildPathEntry result : projectMap.values()) {
                if (result == null) continue;
                result.clear();
            }
        }
        this.zipfileProjectEntries.remove(project);
    }

    public int getCount() {
        return this.zipfileProjectEntries.size();
    }
}

