/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.testserver;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.PartWrapper;
import org.eclipse.edt.compiler.tools.IRUtils;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.utils.DefaultDeploymentDescriptorUtility;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.rui.internal.testserver.ClasspathUtil;
import org.eclipse.edt.javart.resources.egldd.Binding;

public class DeploymentDescriptorFinder {
    private DeploymentDescriptorFinder() {
    }

    public static String toArgumentString(Collection<DDFile> ddFiles) {
        if (ddFiles.size() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        boolean needSeparator = false;
        for (DDFile file : ddFiles) {
            if (needSeparator) {
                buf.append(File.pathSeparatorChar);
            } else {
                needSeparator = true;
            }
            buf.append(file.toString());
        }
        return buf.toString();
    }

    public static String getDefaultDDName(IProject project) {
        IResource member;
        String path = DefaultDeploymentDescriptorUtility.getDefaultDeploymentDescriptor((IResource)project).getPartPath();
        if (path != null && (member = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) != null && member.getType() == 1) {
            try {
                DeploymentDesc dd = DeploymentDesc.createDeploymentDescriptor((String)member.getLocation().toOSString());
                return dd.getName().toLowerCase();
            }
            catch (Exception e) {
                Activator.getDefault().log(e.getMessage(), e);
            }
        }
        return "";
    }

    public static Map<String, DDFile> findDeploymentDescriptors(IProject project) {
        HashMap<String, DDFile> ddFiles = new HashMap<String, DDFile>();
        DeploymentDescriptorFinder.addDDFiles(project, new HashSet<IProject>(), new HashSet<IResource>(), ddFiles);
        return ddFiles;
    }

    private static void addDDFiles(IProject project, Set<IProject> seenProjects, final Set<IResource> seenDDs, final Map<String, DDFile> ddFiles) {
        List<DDFile> parsed;
        IFile ddFile;
        PartWrapper defaultDD = DefaultDeploymentDescriptorUtility.getDefaultDeploymentDescriptor((IResource)project);
        if (defaultDD.getPartPath() != null && defaultDD.getPartPath().length() > 0 && (ddFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(defaultDD.getPartPath()))).exists() && (parsed = DeploymentDescriptorFinder.parseDD((IResource)ddFile, seenDDs)) != null) {
            for (DDFile next : parsed) {
                if (ddFiles.containsKey(next.name)) continue;
                ddFiles.put(next.name, next);
            }
        }
        try {
            IWorkspaceRoot root;
            if (!project.hasNature(EGLCore.NATURE_ID)) {
                return;
            }
            IEGLProject eglProject = EGLCore.create((IProject)project);
            if (eglProject == null) {
                return;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = eglProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int next = 0;
            while (next < n) {
                root = iPackageFragmentRootArray[next];
                root.getResource().accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (proxy.getType() == 1) {
                            List parsed;
                            if (IRUtils.matchesFileName((String)proxy.getName(), (char[])ClasspathUtil.SUFFIX_egldd, (char[])ClasspathUtil.SUFFIX_EGLDD) && (parsed = DeploymentDescriptorFinder.parseDD(proxy.requestResource(), seenDDs)) != null) {
                                for (DDFile next : parsed) {
                                    if (ddFiles.containsKey(next.name)) continue;
                                    ddFiles.put(next.name, next);
                                }
                            }
                            return false;
                        }
                        return true;
                    }
                }, 0);
                ++next;
            }
            root = ResourcesPlugin.getWorkspace().getRoot();
            IEGLPathEntry[] iEGLPathEntryArray = eglProject.getResolvedEGLPath(true);
            int n2 = iEGLPathEntryArray.length;
            n = 0;
            while (n < n2) {
                IResource resource;
                IEGLPathEntry entry = iEGLPathEntryArray[n];
                if (entry.getEntryKind() == 2 && (resource = root.findMember(entry.getPath())) != null && resource.getType() == 4 && resource.isAccessible()) {
                    DeploymentDescriptorFinder.addDDFiles((IProject)resource, seenProjects, seenDDs, ddFiles);
                }
                ++n;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().log(e.getMessage(), (Exception)((Object)e));
        }
    }

    private static List<DDFile> parseDD(IResource file, Set<IResource> seenDDs) {
        if (seenDDs.contains(file)) {
            return null;
        }
        seenDDs.add(file);
        try {
            String absPath = file.getLocation().toOSString();
            DeploymentDesc dd = DeploymentDesc.createDeploymentDescriptor((String)absPath);
            ArrayList<DDFile> entries = new ArrayList<DDFile>();
            entries.add(new DDFile(dd.getName().toLowerCase(), absPath, dd.getBindings()));
            ArrayList includes = dd.getIncludes();
            if (includes.size() > 0) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                for (String include : includes) {
                    List<DDFile> resolved;
                    IResource member = root.findMember(include);
                    if (member == null || member.getType() != 1 || (resolved = DeploymentDescriptorFinder.parseDD(member, seenDDs)) == null) continue;
                    entries.addAll(resolved);
                }
            }
            return entries;
        }
        catch (Exception e) {
            Activator.getDefault().log(e.getMessage(), e);
            return null;
        }
    }

    public static class DDFile {
        String name;
        String path;
        List<Binding> bindings;

        DDFile(String name, String path, List<Binding> bindings) {
            this.name = name;
            this.path = path;
            this.bindings = bindings;
        }

        public List<Binding> getBindings() {
            return this.bindings;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof DDFile) {
                DDFile file = (DDFile)o;
                if (this.name.equals(file.name) && this.path.equals(file.path) && this.bindings.size() == file.bindings.size()) {
                    for (Binding b : this.bindings) {
                        if (file.bindings.contains(b)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            try {
                return String.valueOf(URLEncoder.encode(this.name, "UTF-8")) + File.pathSeparatorChar + URLEncoder.encode(this.path, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return String.valueOf(this.name) + File.pathSeparatorChar + this.path;
            }
        }
    }
}

