/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class ResourceIdentifiers {
    public static final String ODA_APP_CONTEXT_KEY_CONSUMER_RESOURCE_IDS = "org.eclipse.datatools.connectivity.oda.util_consumerResourceIds";
    private static final String APPL_RESOURCE_TYPE = "ApplResourceType";
    private static final String DESIGN_RESOURCE_TYPE = "DesignResourceType";
    private static final String EMPTY_STRING = "";
    private HashMap<String, URILocator> m_uriLocators = new HashMap(2);

    public static ResourceIdentifiers get(Object appContext) {
        if (!(appContext instanceof Map)) {
            return null;
        }
        Object mapValue = ((Map)appContext).get(ODA_APP_CONTEXT_KEY_CONSUMER_RESOURCE_IDS);
        return mapValue instanceof ResourceIdentifiers ? (ResourceIdentifiers)mapValue : null;
    }

    public URI resolveApplResource(URI uri) {
        return this.resolveResourceURI(APPL_RESOURCE_TYPE, uri);
    }

    public URI getApplResourceBaseURI() {
        return this.getResourceBaseURI(APPL_RESOURCE_TYPE);
    }

    public void setApplResourceBaseURI(URI baseURI) {
        this.setResourceBaseURI(APPL_RESOURCE_TYPE, baseURI);
    }

    public URILocator getApplResourceURILocator() {
        return this.getResourceURILocator(APPL_RESOURCE_TYPE);
    }

    public void registerApplResourceURILocator(URILocator uriLocator) {
        this.registerResourceURILocator(APPL_RESOURCE_TYPE, uriLocator);
    }

    public URI resolveDesignResource(URI uri) {
        return this.resolveResourceURI(DESIGN_RESOURCE_TYPE, uri);
    }

    public URI getDesignResourceBaseURI() {
        return this.getResourceBaseURI(DESIGN_RESOURCE_TYPE);
    }

    public void setDesignResourceBaseURI(URI baseURI) {
        this.setResourceBaseURI(DESIGN_RESOURCE_TYPE, baseURI);
    }

    public URILocator getDesignResourceURILocator() {
        return this.getResourceURILocator(DESIGN_RESOURCE_TYPE);
    }

    public void registerDesignResourceURILocator(URILocator uriLocator) {
        this.registerResourceURILocator(DESIGN_RESOURCE_TYPE, uriLocator);
    }

    private URI getResourceBaseURI(String resourceType) {
        URILocator locator = this.getResourceURILocator(resourceType);
        return locator != null ? locator.getBaseURI() : null;
    }

    private void setResourceBaseURI(String resourceType, URI baseURI) {
        URILocator locator = this.createURILocator(baseURI);
        this.registerResourceURILocator(resourceType, locator);
    }

    private URI resolveResourceURI(String resourceType, URI uri) {
        URILocator locator = this.getResourceURILocator(resourceType);
        return locator != null ? locator.resolve(uri) : uri;
    }

    private URILocator getResourceURILocator(String resourceType) {
        return this.m_uriLocators.get(resourceType);
    }

    private void registerResourceURILocator(String resourceType, URILocator uriLocator) {
        this.m_uriLocators.put(resourceType, uriLocator);
    }

    protected URILocator createURILocator(URI baseURI) {
        return new URILocator(baseURI);
    }

    public URI resolveResourceLocation(String resourcePath) {
        URILocator locator = this.getApplResourceURILocator();
        if (locator == null) {
            locator = this.getDesignResourceURILocator();
        }
        return locator != null ? locator.resolve(resourcePath) : null;
    }

    private static URI encode(String location) {
        try {
            String encodedLocation = new File(location).toURI().toASCIIString();
            String target = new File(EMPTY_STRING).toURI().toASCIIString();
            encodedLocation = encodedLocation.replace(target, EMPTY_STRING);
            return new URI(encodedLocation);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public class URILocator {
        private URI m_baseURI;

        public URILocator(URI baseURI) {
            this.m_baseURI = baseURI;
        }

        public URI getBaseURI() {
            return this.m_baseURI;
        }

        public URI resolve(URI uri) {
            return this.resolveImpl(uri);
        }

        public URI resolve(String str) {
            URI uri = ResourceIdentifiers.encode(str);
            return this.resolve(uri);
        }

        protected URI resolveImpl(URI uri) {
            if (this.m_baseURI == null || uri == null) {
                return uri;
            }
            return this.m_baseURI.resolve(uri);
        }
    }
}

