/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.debug.javascript.internal.server;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugContextResolver;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugMessages;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugTarget;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.debug.javascript.internal.server.DebugContentProvider;
import org.eclipse.edt.ide.debug.javascript.internal.utils.RUIDebugUtil;
import org.eclipse.edt.ide.rui.server.AbstractContext;
import org.eclipse.edt.ide.rui.server.EvServer;
import org.eclipse.edt.ide.rui.server.IContext2;
import org.eclipse.edt.ide.rui.server.IServerContentProvider;
import org.eclipse.edt.javart.json.TokenMgrError;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DebugContext
extends AbstractContext
implements IContext2 {
    private RUIDebugTarget debugTarget;
    private List eventQueue;
    private final String launchConfigName;
    public static final int PRIORITY_NORMAL = 0;
    public static final int PRIORITY_HIGH = 1;

    public DebugContext(String url, Integer key, RUIDebugTarget debugTarget, String launchConfigName) {
        super(url, key, (IServerContentProvider)new DebugContentProvider());
        this.debugTarget = debugTarget;
        this.eventQueue = new ArrayList();
        this.launchConfigName = launchConfigName;
    }

    public RUIDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    public void clear() {
        this.debugTarget = null;
        this.eventQueue = null;
        this.contentProvider = null;
    }

    public String getLaunchConfigName() {
        return this.launchConfigName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(String event, int priority) {
        if (this.eventQueue != null) {
            List list = this.eventQueue;
            synchronized (list) {
                switch (priority) {
                    case 1: {
                        this.eventQueue.add(0, event);
                        break;
                    }
                    default: {
                        this.eventQueue.add(event);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextEvent() {
        if (this.eventQueue != null) {
            List list = this.eventQueue;
            synchronized (list) {
                block5: {
                    if (this.eventQueue.size() != 0) break block5;
                    return null;
                }
                return (String)this.eventQueue.remove(0);
            }
        }
        return null;
    }

    public String waitForEvent() {
        long timeOut = 5000L;
        String eventToSend = this.getNextEvent();
        while (eventToSend == null && timeOut > 0L) {
            timeOut -= 100L;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
            eventToSend = this.getNextEvent();
        }
        return eventToSend;
    }

    public void addBreakpoint(String file, String line, String enabled) {
        this.addEvent("egl.addBreakpoint(\"" + file + "\", " + line + ", " + enabled + ")", 0);
    }

    public void changeBreakpoint(String file, String oldline, String enabled) {
        this.addEvent("egl.changeBreakpoint(\"" + file + "\", " + oldline + ", " + enabled + ")", 0);
    }

    public void removeBreakpoint(String file, String line) {
        this.addEvent("egl.removeBreakpoint(\"" + file + "\", " + line + ")", 0);
    }

    public void breakpointManagerChanged(String enabled) {
        this.addEvent("egl.breakpointManagerChanged(" + enabled + ")", 0);
    }

    public void disconnectDebugger() {
        this.addEvent("egl.disconnectDebugger()", 1);
    }

    public void handleEvent(EvServer.Event event) {
        block52: {
            String url = event.url;
            try {
                if (url.indexOf("___getevent") >= 0) {
                    this.getDebugEvent(event);
                } else if (url.indexOf("___atLine") != -1) {
                    this.atLine(event);
                } else if (url.indexOf("___getUserDebugRequest") != -1) {
                    this.getUserDebugRequest(event.ps);
                } else if (url.indexOf("___debugStack") != -1) {
                    String stackStr = (String)event.arguments.get("stack");
                    if (stackStr == null) {
                        stackStr = event.xmlRequest.getContent().substring("stack=".length());
                        int indexOfAmp = (stackStr = stackStr.replaceAll("&nbsp;", " ")).indexOf(38);
                        if (indexOfAmp != -1) {
                            stackStr = stackStr.substring(0, indexOfAmp);
                        }
                    }
                    this.debugStack(event.ps, stackStr);
                } else if (url.indexOf("___debugResume") != -1) {
                    this.debugResume(event.ps, event.arguments);
                } else if (url.indexOf("___varValue") != -1) {
                    this.varValue(event.ps, event.xmlRequest.getContentArguments());
                } else if (url.indexOf("___varVariables") != -1) {
                    this.varVariables(event.ps, (String)event.xmlRequest.getContentArguments().get("variables"));
                } else if (url.indexOf("___varSetValue") != -1) {
                    this.varSetValue(event.ps, event.xmlRequest.getContentArguments());
                } else if (url.indexOf("___debugTerminate") != -1) {
                    String msg = this.debugTerminate();
                    event.ps.print(EvServer.getInstance().getGoodResponseHeader("", "text/html", false));
                    try {
                        event.ps.write(msg.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        event.ps.write(msg.getBytes());
                    }
                } else if (url.indexOf("___windowClosed") != -1) {
                    this.browserWindowClosed();
                } else if (url.indexOf("___getExistingBreakpoints") != -1) {
                    this.sendBreakpoints(event.ps);
                } else if (url.indexOf("___localeSettings") != -1) {
                    this.setDebugSessionLocale(event.ps, event.arguments);
                } else if (url.indexOf("___getBreakpointManagerState") != -1) {
                    this.getBreakpointManagerState(event.ps);
                } else if (url.indexOf("__getversion") != -1) {
                    EvServer.getInstance().sendVersion(event.ps);
                } else if (url.indexOf("___traceEvents") != -1) {
                    event.ps.print(EvServer.getInstance().getGoodResponseHeader("", EvServer.getInstance().getContentType(""), false));
                    event.ps.print("OK");
                    event.ps.flush();
                } else if (url.indexOf("..") == -1) {
                    EvServer.getInstance().loadFile(url, event.key, event.ps);
                } else {
                    EvServer.getInstance().fail(event.ps);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (url.indexOf("___getevent") == -1 && url.indexOf("___atLine") == -1) {
                    event.ps.close();
                    try {
                        event.socket.close();
                    }
                    catch (IOException iOException) {}
                }
                break block52;
            }
            catch (TokenMgrError ex) {
                try {
                    ex.printStackTrace();
                    if (url.indexOf("___getevent") != -1 || url.indexOf("___atLine") != -1) break block52;
                    event.ps.close();
                }
                catch (Throwable throwable) {
                    if (url.indexOf("___getevent") == -1 && url.indexOf("___atLine") == -1) {
                        event.ps.close();
                        try {
                            event.socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    event.socket.close();
                }
                catch (IOException iOException) {}
                break block52;
            }
            if (url.indexOf("___getevent") != -1 || url.indexOf("___atLine") != -1) break block52;
            event.ps.close();
            try {
                event.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void getDebugEvent(final EvServer.Event event) {
        new Thread(){

            @Override
            public void run() {
                String eventToSend = DebugContext.this.waitForEvent();
                event.ps.print(EvServer.getInstance().getGoodResponseHeader("", EvServer.getInstance().getContentType(""), false));
                event.ps.print(eventToSend == null ? "" : eventToSend);
                event.ps.close();
                try {
                    event.socket.close();
                }
                catch (IOException iOException) {}
            }
        }.start();
    }

    private void setDebugSessionLocale(PrintStream ps, Map args) {
        if (this.debugTarget != null) {
            this.debugTarget.setLocaleInfo(args);
        }
        ps.print(EvServer.getInstance().getGoodResponseHeader("", "text/html", false));
    }

    private void getUserDebugRequest(PrintStream ps) {
        ps.print(EvServer.getInstance().getGoodResponseHeader("", "text/html", false));
        if (this.debugTarget != null) {
            if (this.debugTarget.isTerminating()) {
                ps.print("terminate");
            } else if (this.debugTarget.isSuspending()) {
                ps.print("suspend");
            } else {
                ps.print("");
            }
        } else {
            ps.print("");
        }
    }

    private void sendBreakpoints(PrintStream ps) throws CoreException {
        StringBuffer sb = new StringBuffer();
        if (this.debugTarget != null) {
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.edt.debug.ui.presentation.java");
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (this.debugTarget.supportsBreakpoint(breakpoint)) {
                    try {
                        String relativePath = RUIDebugUtil.encodeValue(RUIDebugUtil.getRelativeBreakpointPath(breakpoint.getMarker().getResource()));
                        if (relativePath != null) {
                            sb.append(relativePath);
                            sb.append(",");
                            sb.append(Integer.toString(breakpoint.getMarker().getAttribute("lineNumber", -1)));
                            sb.append(",");
                            sb.append(Boolean.toString(breakpoint.isEnabled()));
                            if (i != breakpoints.length - 1) {
                                sb.append(",");
                            }
                        }
                    }
                    catch (DebugException debugException) {
                    }
                    catch (EGLModelException eGLModelException) {}
                }
                ++i;
            }
        }
        ps.print(EvServer.getInstance().getGoodResponseHeader("", "text/html", false));
        ps.print(sb.toString());
    }

    private void getBreakpointManagerState(PrintStream ps) throws CoreException {
        ps.print(EvServer.getInstance().getGoodResponseHeader("", "text/html", false));
        ps.print(DebugPlugin.getDefault().getBreakpointManager().isEnabled());
    }

    private void browserWindowClosed() {
        if (this.debugTarget != null) {
            this.debugTarget.windowClosed();
        }
        this.debugTerminationCleanup();
    }

    private String debugTerminate() {
        if (this.debugTarget != null) {
            this.debugTarget.terminated();
            return RUIDebugMessages.rui_debug_terminated_msg;
        }
        return RUIDebugMessages.rui_debug_refreshed_msg;
    }

    public void debugTerminationCleanup() {
        if (this.debugTarget != null) {
            if (this.debugTarget.isTerminated()) {
                RUIDebugContextResolver.getInstance().removeContext(this);
            } else {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!DebugContext.this.debugTarget.isTerminated()) {
                                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)RUIDebugMessages.DEBUG_REMOTECLIENTNOTRESPONDING_TITLE, (String)RUIDebugMessages.DEBUG_REMOTECLIENTNOTRESPONDING_MSG);
                                    DebugContext.this.debugTerminate();
                                }
                                RUIDebugContextResolver.getInstance().removeContext(DebugContext.this);
                            }
                        });
                    }
                }.start();
            }
        }
    }

    private void debugStack(PrintStream ps, String stackStr) {
        if (this.debugTarget != null) {
            this.debugTarget.parseStack(stackStr);
        }
        ps.print(EvServer.getInstance().getGoodResponseHeader("", "text/html", false));
    }

    private void debugResume(PrintStream ps, Map args) {
        if (this.debugTarget != null) {
            this.debugTarget.resume((String)args.get("resumeReason"));
        }
        ps.print(EvServer.getInstance().getGoodResponseHeader("", "text/html", false));
    }

    private void atLine(final EvServer.Event event) {
        new Thread(){

            @Override
            public void run() {
                if (DebugContext.this.debugTarget == null) {
                    event.ps.print(EvServer.getInstance().getGoodResponseHeader("", "text/html", false));
                    event.ps.print("disconnect");
                } else if (DebugContext.this.debugTarget.needsNewStack()) {
                    event.ps.print(EvServer.getInstance().getGoodResponseHeader("stack", "text/html", false));
                    event.ps.print("stack");
                } else {
                    String response = DebugContext.this.debugTarget.handleAtLine(event.arguments);
                    event.ps.print(EvServer.getInstance().getGoodResponseHeader("", "text/html", false));
                    event.ps.print(response == null ? "" : response);
                }
                event.ps.close();
                try {
                    event.socket.close();
                }
                catch (IOException iOException) {}
            }
        }.start();
    }

    private void varValue(PrintStream ps, Map args) {
        if (this.debugTarget != null) {
            this.debugTarget.varValue(args);
        }
        ps.print(EvServer.getInstance().getGoodResponseHeader("", "text/html", false));
    }

    private void varVariables(PrintStream ps, String value) {
        if (this.debugTarget != null) {
            this.debugTarget.varVariables(value);
        }
        ps.print(EvServer.getInstance().getGoodResponseHeader("", "text/html", false));
    }

    private void varSetValue(PrintStream ps, Map args) {
        if (this.debugTarget != null) {
            this.debugTarget.varSetValue(args);
        }
        ps.print(EvServer.getInstance().getGoodResponseHeader("", "text/html", false));
    }

    public boolean useTestServer() {
        return true;
    }
}

