/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.BaseCompiler;
import org.eclipse.edt.compiler.StatementValidator;
import org.eclipse.edt.compiler.SystemEnvironmentUtil;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.internal.core.lookup.BindingCreator;
import org.eclipse.edt.compiler.internal.core.validation.DefaultStatementValidator;
import org.eclipse.edt.compiler.internal.egl2mof.eglx.persistence.sql.SQLActionStatementValidator;
import org.eclipse.edt.compiler.internal.egl2mof.eglx.services.ServicesActionStatementValidator;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlActionStatement;
import org.eclipse.edt.mof.eglx.services.ServicesCallStatement;

public class EDTCompiler
extends BaseCompiler {
    static {
        StatementValidator.Registry.put("egl.io.sql.SQLRecord", new DefaultStatementValidator());
        StatementValidator.Registry.put("egl.lang", new DefaultStatementValidator());
        StatementValidator.Registry.put("eglx.persistence.sql", new SQLActionStatementValidator());
        StatementValidator.Registry.put("eglx.services", new ServicesActionStatementValidator());
    }

    @Override
    public String getSystemEnvironmentPath() {
        if (this.systemEnvironmentRootPath == null) {
            String path = SystemEnvironmentUtil.getSystemLibraryPath(BindingCreator.class, "lib");
            path = String.valueOf(path) + File.pathSeparator;
            path = String.valueOf(path) + SystemEnvironmentUtil.getSystemLibraryPath(SqlActionStatement.class, "egllib");
            path = String.valueOf(path) + File.pathSeparator;
            path = String.valueOf(path) + SystemEnvironmentUtil.getSystemLibraryPath(ServicesCallStatement.class, "egllib");
            path = String.valueOf(path) + File.pathSeparator;
            this.systemEnvironmentRootPath = String.valueOf(path) + super.getSystemEnvironmentPath();
        }
        return this.systemEnvironmentRootPath;
    }

    @Override
    public List<String> getImplicitlyUsedEnumerations() {
        ArrayList<String> implicitlyUsedEnumerations = new ArrayList<String>();
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"AlignKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"CaseFormatKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"ColorKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"ConvertDirection"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"HighlightKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"IntensityKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"LineWrapKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"EventKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"WindowAttributeKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"DataSource"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"ExportFormat"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"CommitScopeKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"DisconnectKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"IsolationLevelKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"CommitControlKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"ConsoleEventKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"PortletModeKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"SessionScopeKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"WindowStateKind"));
        implicitlyUsedEnumerations.add(InternUtil.intern((String)"SecretKind"));
        return implicitlyUsedEnumerations;
    }

    @Override
    public List<String> getAllImplicitlyUsedEnumerations() {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(super.getAllImplicitlyUsedEnumerations());
        all.addAll(this.getImplicitlyUsedEnumerations());
        return all;
    }

    @Override
    public StatementValidator getValidatorFor(Statement stmt) {
        final StatementValidator[] validator = new StatementValidator[1];
        stmt.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(FromOrToExpressionClause clause) {
                ITypeBinding type;
                if (validator[0] == null && clause.getExpression() != null && (type = clause.getExpression().resolveTypeBinding()) != null && type.getPackageName() != null) {
                    String key = IRUtils.concatWithSeparator((String[])type.getPackageName(), (String)".");
                    validator[0] = StatementValidator.Registry.get(key);
                }
                return false;
            }
        });
        if (validator[0] == null && !(stmt instanceof CallStatement)) {
            return StatementValidator.Registry.get("eglx.persistence.sql");
        }
        if (validator[0] == null && stmt instanceof CallStatement) {
            return StatementValidator.Registry.get("eglx.services");
        }
        return validator[0];
    }
}

