/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.AnnotationFieldBinding;
import org.eclipse.edt.compiler.binding.EnumerationTypeBinding;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.TypeBinding;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.BinaryExpression;
import org.eclipse.edt.compiler.core.ast.BooleanLiteral;
import org.eclipse.edt.compiler.core.ast.CharLiteral;
import org.eclipse.edt.compiler.core.ast.DBCharLiteral;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.HexLiteral;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.MBCharLiteral;
import org.eclipse.edt.compiler.core.ast.SQLLiteral;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class AnnotationTypeBinding
extends TypeBinding
implements IAnnotationTypeBinding {
    protected Map fields = Collections.EMPTY_MAP;
    protected Map defaultValues = Collections.EMPTY_MAP;
    protected Map caseSensitiveFieldNames = Collections.EMPTY_MAP;

    public AnnotationTypeBinding(String caseSensitiveInternedName, ITypeBinding singleValueType) {
        this(caseSensitiveInternedName, new Object[]{"value", singleValueType});
    }

    public AnnotationTypeBinding(String caseSensitiveInternedName, Object[] fieldNamesAndTypes) {
        this(caseSensitiveInternedName, fieldNamesAndTypes, new Object[0]);
    }

    public AnnotationTypeBinding(String caseSensitiveInternedName, Object[] fieldNamesAndTypes, Object[] defaultValues) {
        super(caseSensitiveInternedName);
        int i;
        if (fieldNamesAndTypes.length != 0) {
            this.fields = new HashMap();
            this.caseSensitiveFieldNames = new HashMap();
            i = 0;
            while (i < fieldNamesAndTypes.length) {
                this.fields.put(InternUtil.intern((String)((String)fieldNamesAndTypes[i])), fieldNamesAndTypes[i + 1]);
                this.caseSensitiveFieldNames.put(InternUtil.intern((String)((String)fieldNamesAndTypes[i])), InternUtil.internCaseSensitive((String)((String)fieldNamesAndTypes[i])));
                i += 2;
            }
        }
        if (defaultValues.length != 0) {
            this.defaultValues = new HashMap();
            i = 0;
            while (i < defaultValues.length) {
                this.defaultValues.put(InternUtil.intern((String)((String)defaultValues[i])), defaultValues[i + 1]);
                i += 2;
            }
        }
    }

    @Override
    public boolean isPartSubType() {
        return false;
    }

    @Override
    public int getKind() {
        return 18;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isValueless() {
        return false;
    }

    @Override
    public EnumerationTypeBinding getEnumerationType() {
        return null;
    }

    @Override
    public ITypeBinding getBaseType() {
        return this;
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public Object getDefaultValueForField(String fieldName) {
        return this.defaultValues.get(fieldName);
    }

    @Override
    public List getFieldNames() {
        return new ArrayList(this.fields.keySet());
    }

    @Override
    public List getCaseSensitiveFieldNames() {
        return new ArrayList(this.caseSensitiveFieldNames.values());
    }

    private static boolean hasAnnotation(String[] packageName, String annotationName, IPartBinding partBinding) {
        return partBinding == null ? false : partBinding.getAnnotation(packageName, annotationName) != null;
    }

    private static boolean isFixedRecord(IPartBinding partBinding) {
        return partBinding == null ? false : partBinding.getKind() == 6;
    }

    private static boolean isForm(IPartBinding partBinding) {
        return partBinding == null ? false : partBinding.getKind() == 8;
    }

    private static boolean isVariableFormField(IDataBinding dBinding) {
        return dBinding.getKind() == 7 && !((FormFieldBinding)dBinding).isConstant();
    }

    private static boolean isConstantFormField(IDataBinding dBinding) {
        return dBinding.getKind() == 7 && ((FormFieldBinding)dBinding).isConstant();
    }

    protected static boolean takesConsoleArrayFieldAnnotations(IBinding binding) {
        if (binding.isTypeBinding()) {
            return ((ITypeBinding)binding).getKind() == 17;
        }
        if (binding.isDataBinding()) {
            IDataBinding dBinding = (IDataBinding)binding;
            IPartBinding declaringPart = dBinding.getDeclaringPart();
            return AnnotationTypeBinding.hasAnnotation(new String[]{"egl", "ui", "console"}, "ConsoleForm", declaringPart);
        }
        return false;
    }

    protected static boolean takesConsoleFieldAnnotations(IBinding binding) {
        if (binding.isTypeBinding()) {
            return ((ITypeBinding)binding).getKind() == 17;
        }
        if (binding.isDataBinding()) {
            IDataBinding dBinding = (IDataBinding)binding;
            IPartBinding declaringPart = dBinding.getDeclaringPart();
            return AnnotationTypeBinding.hasAnnotation(new String[]{"egl", "ui", "console"}, "ConsoleForm", declaringPart);
        }
        return false;
    }

    protected static boolean takesDLIItemAnnotations(IBinding binding) {
        if (binding.isTypeBinding()) {
            return ((ITypeBinding)binding).getKind() == 17;
        }
        if (binding.isDataBinding()) {
            IDataBinding dBinding = (IDataBinding)binding;
            IPartBinding declaringPart = dBinding.getDeclaringPart();
            return AnnotationTypeBinding.isFixedRecord(declaringPart);
        }
        return false;
    }

    protected static boolean takesFieldPresentationAnnotations(IBinding binding) {
        return AnnotationTypeBinding.takesTextFormFieldAnnotations(binding);
    }

    protected static boolean takesFillerStructureItemAnnotations(IBinding binding) {
        if (binding.isTypeBinding()) {
            return ((ITypeBinding)binding).getKind() == 17;
        }
        if (binding.isDataBinding()) {
            return ((IDataBinding)binding).getKind() == 5 && binding.getName() == InternUtil.intern((String)"*");
        }
        return false;
    }

    protected static boolean takesFormattingAnnotations(IBinding binding) {
        if (binding.isTypeBinding()) {
            return ((ITypeBinding)binding).getKind() == 17;
        }
        if (binding.isDataBinding()) {
            IDataBinding dBinding = (IDataBinding)binding;
            if (dBinding.getKind() == 14 && dBinding.getType() != null && dBinding.getType().getKind() != 2) {
                return true;
            }
            if (dBinding.getKind() == 5 && dBinding.getName() != InternUtil.intern((String)"*")) {
                return true;
            }
            if (AnnotationTypeBinding.isVariableFormField(dBinding)) {
                return true;
            }
        }
        return AnnotationTypeBinding.takesConsoleArrayFieldAnnotations(binding) || AnnotationTypeBinding.takesPageItemAnnotations(binding);
    }

    protected static boolean takesFormFieldAnnotations(IBinding binding) {
        if (binding.isTypeBinding()) {
            return ((ITypeBinding)binding).getKind() == 17;
        }
        if (binding.isDataBinding()) {
            IDataBinding dBinding = (IDataBinding)binding;
            IPartBinding declaringPart = dBinding.getDeclaringPart();
            return AnnotationTypeBinding.isForm(declaringPart);
        }
        return false;
    }

    protected static boolean takesPageItemAnnotations(IBinding binding) {
        if (binding.isTypeBinding()) {
            return ((ITypeBinding)binding).getKind() == 17;
        }
        if (binding.isDataBinding()) {
            IDataBinding dBinding = (IDataBinding)binding;
            if (dBinding.getKind() == 3 || dBinding.getKind() == 2) {
                return true;
            }
            if (dBinding.getKind() == 5) {
                return dBinding.getName() != InternUtil.intern((String)"*");
            }
            if (dBinding.getKind() == 14) {
                return !AnnotationTypeBinding.takesConsoleFieldAnnotations(binding) && !AnnotationTypeBinding.takesConsoleArrayFieldAnnotations(binding);
            }
        }
        return false;
    }

    protected static boolean takesSQLItemAnnotations(IBinding binding) {
        return AnnotationTypeBinding.takesPageItemAnnotations(binding);
    }

    protected static boolean takesTextConstantFormFieldAnnotations(IBinding binding) {
        if (binding.isTypeBinding()) {
            return ((ITypeBinding)binding).getKind() == 17;
        }
        if (binding.isDataBinding()) {
            IDataBinding dBinding = (IDataBinding)binding;
            IPartBinding declaringPart = dBinding.getDeclaringPart();
            return AnnotationTypeBinding.isConstantFormField(dBinding) && AnnotationTypeBinding.hasAnnotation(new String[]{"egl", "ui", "text"}, "TextForm", declaringPart);
        }
        return false;
    }

    protected static boolean takesDataItemBinding(IBinding binding) {
        if (binding.isTypeBinding()) {
            return ((ITypeBinding)binding).getKind() == 17;
        }
        return false;
    }

    protected static boolean takesTextFormFieldAnnotations(IBinding binding) {
        return AnnotationTypeBinding.takesTextVariableFormFieldAnnotations(binding) || AnnotationTypeBinding.takesTextConstantFormFieldAnnotations(binding);
    }

    protected static boolean takesTextVariableFormFieldAnnotations(IBinding binding) {
        if (binding.isTypeBinding()) {
            return ((ITypeBinding)binding).getKind() == 17;
        }
        if (binding.isDataBinding()) {
            IDataBinding dBinding = (IDataBinding)binding;
            IPartBinding declaringPart = dBinding.getDeclaringPart();
            return AnnotationTypeBinding.isVariableFormField(dBinding) && AnnotationTypeBinding.hasAnnotation(new String[]{"egl", "ui", "text"}, "TextForm", declaringPart);
        }
        return false;
    }

    protected static boolean takesUIItemAnnotations(IBinding binding) {
        IDataBinding dBinding;
        if (binding.isTypeBinding()) {
            return ((ITypeBinding)binding).getKind() == 17;
        }
        return binding.isDataBinding() && (dBinding = (IDataBinding)binding).getKind() == 5 && dBinding.getName() != InternUtil.intern((String)"*");
    }

    protected static boolean takesValidationAnnotations(IBinding binding) {
        if (binding.isTypeBinding()) {
            return ((ITypeBinding)binding).getKind() == 17;
        }
        if (binding.isDataBinding()) {
            IDataBinding dBinding = (IDataBinding)binding;
            if (dBinding.getKind() == 14 && dBinding.getType().getKind() != 2 && !AnnotationTypeBinding.takesConsoleFieldAnnotations(binding)) {
                return true;
            }
            if (dBinding.getKind() == 5 && dBinding.getName() != InternUtil.intern((String)"*")) {
                return true;
            }
        }
        return AnnotationTypeBinding.takesTextVariableFormFieldAnnotations(binding) || AnnotationTypeBinding.takesPageItemAnnotations(binding);
    }

    protected static boolean takesVariableFormFieldAnnotations(IBinding binding) {
        if (binding.isDataBinding()) {
            return AnnotationTypeBinding.isVariableFormField((IDataBinding)binding);
        }
        return false;
    }

    @Override
    public boolean supportsElementOverride() {
        return false;
    }

    @Override
    public boolean takesExpressionInOpenUIStatement() {
        return false;
    }

    @Override
    public ITypeBinding requiredTypeForOpenUIStatement() {
        return null;
    }

    @Override
    public List getValueAnnotations() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAnnotations() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean hasSingleValue() {
        return true;
    }

    @Override
    public ITypeBinding getSingleValueType() {
        return null;
    }

    @Override
    public IDataBinding findData(String simpleName) {
        ITypeBinding tBinding = (ITypeBinding)this.fields.get(InternUtil.intern((String)simpleName));
        if (tBinding != null) {
            final AnnotationTypeBinding aTypeBinding = this;
            final ITypeBinding fieldBindingType = tBinding;
            return new AnnotationFieldBinding((String)this.caseSensitiveFieldNames.get(InternUtil.intern((String)simpleName)), null, (ITypeBinding)new AnnotationTypeBinding((String)this.caseSensitiveFieldNames.get(InternUtil.intern((String)simpleName)), new Object[0]){

                @Override
                public boolean isApplicableFor(IBinding binding) {
                    return binding == aTypeBinding;
                }

                @Override
                public boolean hasSingleValue() {
                    return true;
                }

                @Override
                public ITypeBinding getSingleValueType() {
                    return fieldBindingType;
                }

                @Override
                public EnumerationTypeBinding getEnumerationType() {
                    return 19 == fieldBindingType.getBaseType().getKind() ? (EnumerationTypeBinding)fieldBindingType.getBaseType() : null;
                }

                @Override
                public boolean isValueless() {
                    return false;
                }
            }, this);
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public List getFieldAnnotations(String field) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getPartSubTypeAnnotations() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getPartTypeAnnotations() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getFieldAccessAnnotations() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public IAnnotationTypeBinding getValidationProxy() {
        return this;
    }

    @Override
    public boolean isSystemAnnotation() {
        return false;
    }

    @Override
    public boolean isBIDIEnabled() {
        return false;
    }

    @Override
    public ITypeBinding primGetNullableInstance() {
        return this;
    }

    public static class IsArrayLiteralChecker
    extends DefaultASTVisitor {
        boolean isArrayLiteral = false;

        public boolean isArrayLiteral(Expression expr) {
            expr.accept(this);
            return this.isArrayLiteral;
        }

        @Override
        public boolean visit(ArrayLiteral arrayLiteral) {
            this.isArrayLiteral = true;
            return false;
        }
    }

    public static class IsBooleanLiteralChecker
    extends DefaultASTVisitor {
        boolean isBooleanLiteral = false;

        public boolean isBooleanLiteral(Expression expr) {
            expr.accept(this);
            return this.isBooleanLiteral;
        }

        @Override
        public boolean visit(BooleanLiteral booleanLiteral) {
            this.isBooleanLiteral = true;
            return false;
        }
    }

    public static class IsInlineSQLLiteralLiteralChecker
    extends DefaultASTVisitor {
        boolean isSQLLiteral = false;

        public boolean isInlineSQLLiteralLiteralChecker(Expression expr) {
            expr.accept(this);
            return this.isSQLLiteral;
        }

        @Override
        public boolean visit(SQLLiteral sQLLiteral) {
            this.isSQLLiteral = true;
            return false;
        }
    }

    public static class IsIntegerArrayLiteralChecker
    extends DefaultASTVisitor {
        boolean isIntegerArrayLiteral = false;

        public boolean isIntegerArrayLiteral(Expression expr) {
            expr.accept(this);
            return this.isIntegerArrayLiteral;
        }

        @Override
        public boolean visit(ArrayLiteral arrayLiteral) {
            Iterator iter = arrayLiteral.getExpressions().iterator();
            while (iter.hasNext()) {
                if (new IsIntegerLiteralChecker().isIntegerLiteral((Expression)iter.next())) continue;
                return false;
            }
            this.isIntegerArrayLiteral = true;
            return false;
        }
    }

    public static class IsIntegerLiteralChecker
    extends DefaultASTVisitor {
        boolean isIntegerLiteral = false;

        public boolean isIntegerLiteral(Expression expr) {
            expr.accept(this);
            return this.isIntegerLiteral;
        }

        @Override
        public boolean visit(IntegerLiteral integerLiteral) {
            this.isIntegerLiteral = true;
            return false;
        }
    }

    public static class IsStringArrayLiteralChecker
    extends DefaultASTVisitor {
        boolean isStringArrayLiteral = false;

        public boolean isStringArrayLiteral(Expression expr) {
            expr.accept(this);
            return this.isStringArrayLiteral;
        }

        @Override
        public boolean visit(ArrayLiteral arrayLiteral) {
            Iterator iter = arrayLiteral.getExpressions().iterator();
            while (iter.hasNext()) {
                if (new IsStringLiteralChecker().isStringLiteral((Expression)iter.next())) continue;
                return false;
            }
            this.isStringArrayLiteral = true;
            return false;
        }
    }

    public static class IsStringLiteralChecker
    extends DefaultASTVisitor {
        boolean isStringLiteral = false;

        public boolean isStringLiteral(Expression expr) {
            expr.accept(this);
            return this.isStringLiteral;
        }

        @Override
        public boolean visit(StringLiteral stringLiteral) {
            this.isStringLiteral = true;
            return false;
        }

        @Override
        public boolean visit(CharLiteral stringLiteral) {
            this.isStringLiteral = true;
            return false;
        }

        @Override
        public boolean visit(DBCharLiteral stringLiteral) {
            this.isStringLiteral = true;
            return false;
        }

        @Override
        public boolean visit(MBCharLiteral stringLiteral) {
            this.isStringLiteral = true;
            return false;
        }

        @Override
        public boolean visit(HexLiteral stringLiteral) {
            this.isStringLiteral = true;
            return false;
        }

        @Override
        public boolean visit(BinaryExpression binaryExpression) {
            if (binaryExpression.getOperator() == BinaryExpression.Operator.PLUS) {
                IsStringLiteralChecker checker1 = new IsStringLiteralChecker();
                IsStringLiteralChecker checker2 = new IsStringLiteralChecker();
                this.isStringLiteral = checker1.isStringLiteral(binaryExpression.getFirstExpression()) && checker2.isStringLiteral(binaryExpression.getSecondExpression());
            }
            return false;
        }
    }
}

