/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PartBinding;

public class DelegateBinding
extends PartBinding {
    protected List parameters = Collections.EMPTY_LIST;
    protected transient ITypeBinding returnType;
    protected boolean returnTypeIsSqlNullable;

    public DelegateBinding(String[] packageName, String caseSensitiveInternedName) {
        super(packageName, caseSensitiveInternedName);
    }

    private DelegateBinding(DelegateBinding old) {
        super(old);
        if (old.parameters == Collections.EMPTY_LIST) {
            old.parameters = new ArrayList();
        }
        this.parameters = old.parameters;
        this.returnType = old.returnType;
        this.returnTypeIsSqlNullable = old.returnTypeIsSqlNullable;
    }

    @Override
    public int getKind() {
        return 27;
    }

    public List getParemeters() {
        return this.parameters;
    }

    public void addParameter(FunctionParameterBinding parameter) {
        if (this.parameters == Collections.EMPTY_LIST) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(parameter);
    }

    public ITypeBinding getReturnType() {
        return this.realizeTypeBinding(this.returnType, this.getEnvironment());
    }

    public void setReturnType(ITypeBinding type) {
        this.returnType = this.getTypeBinding(type, null);
    }

    public boolean returnTypeIsSqlNullable() {
        return this.returnTypeIsSqlNullable;
    }

    public void setReturnTypeIsSqlNullable(boolean returnIsNullable) {
        this.returnTypeIsSqlNullable = returnIsNullable;
    }

    @Override
    public void clear() {
        super.clear();
        this.parameters = Collections.EMPTY_LIST;
        this.returnType = null;
        this.returnTypeIsSqlNullable = false;
    }

    @Override
    public boolean isStructurallyEqual(IPartBinding anotherPartBinding) {
        return false;
    }

    @Override
    public boolean isDeclarablePart() {
        return true;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public boolean isInstantiable() {
        return false;
    }

    @Override
    public ITypeBinding primGetNullableInstance() {
        DelegateBinding nullable = new DelegateBinding(this);
        nullable.setNullable(true);
        return nullable;
    }
}

