/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.BindingUtilities;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;

public abstract class FixedStructureBinding
extends PartBinding {
    protected List structureItems = Collections.EMPTY_LIST;
    protected transient Map unqualifiedNamesToDataBindings;
    protected transient List referencedStructures = Collections.EMPTY_LIST;

    public FixedStructureBinding(String[] packageName, String caseSensitiveInternedName) {
        super(packageName, caseSensitiveInternedName);
    }

    protected FixedStructureBinding(FixedRecordBinding old) {
        super(old);
        if (old.structureItems == Collections.EMPTY_LIST) {
            old.structureItems = new ArrayList();
        }
        if (old.referencedStructures == Collections.EMPTY_LIST) {
            old.referencedStructures = new ArrayList();
        }
        this.structureItems = old.structureItems;
        this.unqualifiedNamesToDataBindings = old.unqualifiedNamesToDataBindings;
        this.referencedStructures = old.referencedStructures;
    }

    public List getStructureItems() {
        return this.structureItems;
    }

    public void addStructureItem(StructureItemBinding structureItem) {
        if (this.structureItems == Collections.EMPTY_LIST) {
            this.structureItems = new ArrayList();
        }
        this.structureItems.add(structureItem);
        structureItem.setEnclosingStructureBinding(this);
        this.unqualifiedNamesToDataBindings = null;
    }

    @Override
    public void clear() {
        super.clear();
        this.structureItems = Collections.EMPTY_LIST;
        this.referencedStructures = Collections.EMPTY_LIST;
        this.unqualifiedNamesToDataBindings = null;
    }

    public boolean containsReferenceTo(FixedStructureBinding structure) {
        ArrayList processedStructures = new ArrayList();
        return this.containsReferenceTo(structure, processedStructures);
    }

    public List getReferencedStructures() {
        return this.referencedStructures;
    }

    private boolean containsReferenceTo(FixedStructureBinding structure, List processedStructures) {
        for (FixedStructureBinding currentStructure : this.getReferencedStructures()) {
            if (this.primContainsReferenceTo(structure, processedStructures, currentStructure)) {
                return true;
            }
            FixedStructureBinding resolvedCurrentStructure = (FixedStructureBinding)this.realizeTypeBinding(currentStructure, this.getEnvironment());
            if (resolvedCurrentStructure == currentStructure || !this.primContainsReferenceTo(structure, processedStructures, resolvedCurrentStructure)) continue;
            return true;
        }
        return false;
    }

    private boolean primContainsReferenceTo(FixedStructureBinding structure, List processedStructures, FixedStructureBinding currentStructure) {
        if (currentStructure == structure) {
            return true;
        }
        if (!processedStructures.contains(currentStructure)) {
            processedStructures.add(currentStructure);
            if (currentStructure.containsReferenceTo(structure, processedStructures)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected IDataBinding primFindData(String simpleName) {
        for (IDataBinding binding : this.structureItems) {
            if (binding.getName() != simpleName) continue;
            return binding;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    public void clearSimpleNamesToDataBindingsMap() {
        this.unqualifiedNamesToDataBindings = null;
        Iterator iter = this.structureItems.iterator();
        while (iter.hasNext()) {
            ((StructureItemBinding)iter.next()).clearSimpleNamesToDataBindingsMap();
        }
    }

    @Override
    public Map getSimpleNamesToDataBindingsMap() {
        if (this.unqualifiedNamesToDataBindings == null || this.unqualifiedNamesToDataBindings == Collections.EMPTY_MAP) {
            if (this.structureItems == Collections.EMPTY_LIST) {
                this.unqualifiedNamesToDataBindings = Collections.EMPTY_MAP;
            } else {
                this.unqualifiedNamesToDataBindings = new HashMap();
                for (StructureItemBinding nextItem : this.structureItems) {
                    BindingUtilities.addToUnqualifiedBindingNameMap(this.unqualifiedNamesToDataBindings, null, nextItem);
                    BindingUtilities.addAllToUnqualifiedBindingNameMap(this.unqualifiedNamesToDataBindings, null, nextItem.getSimpleNamesToDataBindingsMap());
                }
            }
        }
        return this.unqualifiedNamesToDataBindings;
    }

    public void addReferencedStructure(FixedStructureBinding structure) {
        if (this.referencedStructures == Collections.EMPTY_LIST) {
            this.referencedStructures = new ArrayList();
        }
        if (!this.referencedStructures.contains(structure)) {
            this.referencedStructures.add(structure);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.getReferencedStructures().size());
        for (FixedStructureBinding currentStructure : this.getReferencedStructures()) {
            this.writeTypeBindingReference(out, currentStructure);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = in.readInt();
        if (size == 0) {
            this.referencedStructures = Collections.EMPTY_LIST;
        } else {
            this.referencedStructures = new ArrayList();
            int i = 0;
            while (i < size) {
                FixedStructureBinding currentStructure = (FixedStructureBinding)this.readTypeBindingReference(in);
                this.referencedStructures.add(currentStructure);
                ++i;
            }
        }
        Iterator iter = this.structureItems.iterator();
        while (iter.hasNext()) {
            ((StructureItemBinding)iter.next()).setEnclosingStructureBinding(this);
        }
    }

    public int getSizeInBytes() {
        int size = 0;
        for (StructureItemBinding siBinding : this.structureItems) {
            if (siBinding.getAnnotation(new String[]{"egl", "core"}, "Redefines") != null) continue;
            size += siBinding.getLengthInBytes();
        }
        return size;
    }
}

