/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.AnnotationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.DataBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBindingFieldsCompletor;
import org.eclipse.edt.compiler.binding.FlexibleRecordFieldBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PartSubTypeAndAnnotationCollector;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.FlexibleRecordScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FlexibleRecordBindingCompletor
extends DefaultBinder {
    private FlexibleRecordBinding recordBinding;
    private IAnnotationBinding partSubTypeAnnotationBinding;
    private FlexibleRecordBindingFieldsCompletor flexibleRecordBindingFieldsCompletor;

    public FlexibleRecordBindingCompletor(Scope currentScope, FlexibleRecordBinding recordBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, recordBinding, dependencyRequestor, problemRequestor, compilerOptions);
        this.recordBinding = recordBinding;
    }

    @Override
    public boolean visit(Record record) {
        PartSubTypeAndAnnotationCollector collector = new PartSubTypeAndAnnotationCollector(this.recordBinding, this, this.currentScope, this.problemRequestor);
        record.accept(collector);
        this.processSubType(collector);
        this.flexibleRecordBindingFieldsCompletor = new FlexibleRecordBindingFieldsCompletor(this.currentScope, this.recordBinding, record.getName().getCanonicalName(), this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
        record.accept(this.flexibleRecordBindingFieldsCompletor);
        this.addImplicitFieldsFromAnnotations();
        this.processSettingsBlocksFromCollector(collector);
        this.convertItemsToNullableIfNeccesary();
        this.recordBinding.setPrivate(record.isPrivate());
        record.getName().setBinding(this.recordBinding);
        return false;
    }

    @Override
    public void endVisit(Record record) {
        this.recordBinding.setValid(true);
        this.currentScope = new FlexibleRecordScope(this.currentScope, this.recordBinding);
        record.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(Record record) {
                return true;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                FlexibleRecordBindingCompletor.this.processResolvableProperties(settingsBlock, null, null);
                return false;
            }

            @Override
            public boolean visit(StructureItem structureItem) {
                FlexibleRecordBindingCompletor.this.processResolvableProperties(structureItem);
                return false;
            }
        });
        this.currentScope = this.currentScope.getParentScope();
        super.endVisit(record);
        this.addSqlNullableAnnotations();
    }

    private void addSqlNullableAnnotations() {
        IAnnotationBinding aBinding = this.recordBinding.getAnnotation(new String[]{"egl", "io", "sql"}, "isSqlNullable");
        if (aBinding == null) {
            return;
        }
        if (aBinding != null && Boolean.YES == aBinding.getValue()) {
            IDataBinding[] fields = this.recordBinding.getFields();
            int i = 0;
            while (i < fields.length) {
                if (fields[i].getAnnotation(new String[]{"egl", "io", "sql"}, "isSqlNullable") == null) {
                    fields[i].addAnnotation(aBinding);
                }
                ++i;
            }
        }
    }

    private void processResolvableProperties(StructureItem structureItem) {
        if (structureItem.hasSettingsBlock()) {
            IDataBinding dataBinding = null;
            if (!structureItem.isEmbedded()) {
                dataBinding = (IDataBinding)structureItem.resolveBinding();
            }
            this.processResolvableProperties(structureItem.getSettingsBlock(), dataBinding, null);
        }
    }

    protected void processSubType(PartSubTypeAndAnnotationCollector collector) {
        this.partSubTypeAnnotationBinding = !collector.isFoundSubTypeInSettingsBlock() ? (collector.getSubTypeAnnotationBinding() == null ? null : collector.getSubTypeAnnotationBinding()) : collector.getSubTypeAnnotationBinding();
    }

    private void processSettingsBlocksFromCollector(PartSubTypeAndAnnotationCollector collector) {
        if (collector.getSettingsBlocks().size() > 0) {
            AnnotationLeftHandScope scope = new AnnotationLeftHandScope(new FlexibleRecordScope(this.currentScope, this.recordBinding), this.recordBinding, this.recordBinding, this.recordBinding, -1, this.recordBinding);
            if (!collector.isFoundSubTypeInSettingsBlock() && this.partSubTypeAnnotationBinding != null) {
                scope = new AnnotationLeftHandScope(scope, this.partSubTypeAnnotationBinding, this.partSubTypeAnnotationBinding.getType(), this.partSubTypeAnnotationBinding, -1, this.recordBinding);
            }
            SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(this.currentScope, this.recordBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            for (SettingsBlock block : collector.getSettingsBlocks()) {
                block.accept(blockCompletor);
            }
        }
    }

    @Override
    public boolean visit(StructureItem structureItem) {
        return false;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        return false;
    }

    @Override
    protected void processResolvableProperty(IAnnotationTypeBinding annotationType, Object value, IDataBinding dataBinding, IDataBinding[] path, Expression expr) {
        if (value == null || !this.isResolvable(annotationType)) {
            return;
        }
        IAnnotationBinding annotation = dataBinding.getAnnotationFor(annotationType, path);
        if (annotation == null) {
            return;
        }
        if (FlexibleRecordBindingCompletor.annotationIs(annotationType, new String[]{"egl", "ui"}, "NumElementsItem")) {
            if (this.isUIRecordItem(dataBinding, path)) {
                annotation.setValue(this.resolveNumElementsItem(expr, value, dataBinding, path), null, null, this.compilerOptions, false);
            }
            return;
        }
        if (FlexibleRecordBindingCompletor.annotationIs(annotationType, new String[]{"egl", "ui"}, "SelectedIndexItem")) {
            if (this.isUIRecordItem(dataBinding, path)) {
                annotation.setValue(this.resolveSelectedIndexItem(expr, value, dataBinding, path), null, null, this.compilerOptions, false);
            }
            return;
        }
        if (FlexibleRecordBindingCompletor.annotationIs(annotationType, new String[]{"egl", "core"}, "Redefines")) {
            annotation.setValue(this.resolveRedefines(expr, value, dataBinding, path), null, null, this.compilerOptions, false);
            return;
        }
        if (FlexibleRecordBindingCompletor.annotationIs(annotationType, new String[]{"egl", "ui", "console"}, "Binding")) {
            annotation.setValue(this.resolveBinding(expr, value, dataBinding, path), null, null, this.compilerOptions, false);
            return;
        }
    }

    private boolean isResolvable(IAnnotationTypeBinding annotationType) {
        return FlexibleRecordBindingCompletor.annotationIs(annotationType, new String[]{"egl", "ui"}, "NumElementsItem") || FlexibleRecordBindingCompletor.annotationIs(annotationType, new String[]{"egl", "ui"}, "SelectedIndexItem") || FlexibleRecordBindingCompletor.annotationIs(annotationType, new String[]{"egl", "core"}, "Redefines") || FlexibleRecordBindingCompletor.annotationIs(annotationType, new String[]{"egl", "ui", "console"}, "Binding");
    }

    private void addImplicitFieldsFromAnnotations() {
        int index = 0;
        for (IAnnotationBinding aBinding : this.recordBinding.getAnnotations()) {
            String annotationContributingFieldsName = aBinding.getCaseSensitiveName();
            if ((aBinding = aBinding.getAnnotation(AnnotationAnnotationTypeBinding.getInstance())) == null || IBinding.NOT_FOUND_BINDING == (aBinding = (IAnnotationBinding)aBinding.findData("implicitFields"))) continue;
            IAnnotationBinding[] implicitFields = (IAnnotationBinding[])aBinding.getValue();
            int i = 0;
            while (i < implicitFields.length) {
                IAnnotationBinding implicitField = implicitFields[i];
                IAnnotationBinding fieldNameBinding = (IAnnotationBinding)implicitField.findData("FieldName");
                IAnnotationBinding fieldTypeBinding = (IAnnotationBinding)implicitField.findData("FieldType");
                if (IBinding.NOT_FOUND_BINDING != fieldNameBinding && IBinding.NOT_FOUND_BINDING != fieldTypeBinding) {
                    FlexibleRecordFieldBinding newField = new FlexibleRecordFieldBinding(InternUtil.internCaseSensitive((String)((String)fieldNameBinding.getValue())), this.recordBinding, (ITypeBinding)fieldTypeBinding.getValue());
                    newField.setImplicit(true);
                    newField.addAnnotations(implicitField.getAnnotations());
                    Node existingField = this.flexibleRecordBindingFieldsCompletor.getNode(newField.getName());
                    if (existingField == null) {
                        this.recordBinding.addField(newField, index);
                        ++index;
                    } else {
                        this.problemRequestor.acceptProblem(existingField, 3267, new String[]{annotationContributingFieldsName, this.recordBinding.getCaseSensitiveName(), newField.getCaseSensitiveName()});
                    }
                }
                ++i;
            }
        }
    }

    private void convertItemsToNullableIfNeccesary() {
        IAnnotationBinding aBinding = this.recordBinding.getAnnotation(new String[]{"egl", "core"}, "I4GLItemsNullable");
        if (aBinding != null && Boolean.YES == aBinding.getValue()) {
            IDataBinding[] fields = this.recordBinding.getFields();
            int i = 0;
            while (i < fields.length) {
                ITypeBinding type = fields[i].getType();
                if (type != null && 3 == type.getBaseType().getKind()) {
                    ((DataBinding)fields[i]).setType(type.getNullableInstance());
                }
                ++i;
            }
        }
    }
}

