/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.edt.compiler.binding.BindingUtilities;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordFieldBinding;
import org.eclipse.edt.compiler.binding.FunctionContainerBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FlexibleRecordBindingImpl
extends FlexibleRecordBinding {
    private List fields = Collections.EMPTY_LIST;
    private transient List referencedRecords = Collections.EMPTY_LIST;

    public FlexibleRecordBindingImpl(String[] packageName, String caseSensitiveInternedName) {
        super(packageName, caseSensitiveInternedName);
    }

    private FlexibleRecordBindingImpl(FlexibleRecordBindingImpl old) {
        super(old);
        if (old.fields == Collections.EMPTY_LIST) {
            old.fields = new ArrayList();
        }
        if (old.referencedRecords == Collections.EMPTY_LIST) {
            old.referencedRecords = new ArrayList();
        }
        this.fields = old.fields;
        this.referencedRecords = old.referencedRecords;
    }

    @Override
    public List getDeclaredFields() {
        return this.fields;
    }

    @Override
    public List getDeclaredFields(boolean includeDefaultSuperType) {
        if (!includeDefaultSuperType) {
            return this.getDeclaredFields();
        }
        LinkedList retList = new LinkedList();
        retList.addAll(this.fields);
        IPartBinding spBinding = this.getDefaultSuperType();
        if (spBinding instanceof FunctionContainerBinding) {
            retList.addAll(((FunctionContainerBinding)spBinding).getDeclaredData(includeDefaultSuperType));
        } else if (spBinding instanceof ExternalTypeBinding) {
            retList.addAll(((ExternalTypeBinding)spBinding).getDeclaredAndInheritedData());
        }
        return retList;
    }

    @Override
    public int getKind() {
        return 7;
    }

    @Override
    public void addField(FlexibleRecordFieldBinding fieldBinding) {
        if (this.fields == Collections.EMPTY_LIST) {
            this.fields = new ArrayList();
        }
        this.fields.add(fieldBinding);
    }

    @Override
    public void addField(FlexibleRecordFieldBinding fieldBinding, int index) {
        if (this.fields == Collections.EMPTY_LIST) {
            this.fields = new ArrayList();
        }
        this.fields.add(index, fieldBinding);
    }

    @Override
    public void addReference(FlexibleRecordFieldBinding fieldBinding) {
        if (fieldBinding.typeBinding != null && fieldBinding.typeBinding != IBinding.NOT_FOUND_BINDING && fieldBinding.typeBinding.getBaseType().getKind() == 7) {
            this.addReferencedRecord((FlexibleRecordBinding)fieldBinding.typeBinding.getBaseType());
        }
    }

    @Override
    void addReferencedRecord(FlexibleRecordBinding record) {
        if (this.referencedRecords == Collections.EMPTY_LIST) {
            this.referencedRecords = new ArrayList();
        }
        if (!this.referencedRecords.contains(record)) {
            this.referencedRecords.add(record);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.fields = Collections.EMPTY_LIST;
        this.referencedRecords = Collections.EMPTY_LIST;
    }

    @Override
    public boolean isStructurallyEqual(IPartBinding anotherPartBinding) {
        return false;
    }

    private String getResourceAssociationName() {
        return InternUtil.intern((String)"resourceAssociation");
    }

    @Override
    protected IDataBinding primFindData(String simpleName) {
        for (IDataBinding binding : this.fields) {
            if (binding.getName() != simpleName) continue;
            return binding;
        }
        if (simpleName == this.getResourceAssociationName() && BindingUtilities.hasResourceAssociation(this)) {
            return FixedRecordBinding.RESOURCEASSOCIATION;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public boolean containsReferenceTo(FlexibleRecordBinding record) {
        ArrayList processedRecords = new ArrayList();
        return this.containsReferenceTo(record, processedRecords);
    }

    @Override
    protected List getReferencedRecords() {
        return this.referencedRecords;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.getReferencedRecords().size());
        for (FlexibleRecordBinding currentRecord : this.getReferencedRecords()) {
            this.writeTypeBindingReference(out, currentRecord);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = in.readInt();
        if (size == 0) {
            this.referencedRecords = Collections.EMPTY_LIST;
        } else {
            this.referencedRecords = new ArrayList();
            int i = 0;
            while (i < size) {
                FlexibleRecordBinding currentRecord = (FlexibleRecordBinding)this.readTypeBindingReference(in);
                this.referencedRecords.add(currentRecord);
                ++i;
            }
        }
    }

    @Override
    public boolean isDeclarablePart() {
        return !this.isAnnotationRecord();
    }

    @Override
    public IDataBinding[] getFields() {
        return this.getDeclaredFields().toArray(new IDataBinding[this.getDeclaredFields().size()]);
    }

    @Override
    public ITypeBinding primGetNullableInstance() {
        FlexibleRecordBindingImpl nullable = new FlexibleRecordBindingImpl(this);
        nullable.setNullable(true);
        return nullable;
    }
}

