/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.BindingUtilities;
import org.eclipse.edt.compiler.binding.FormDataBinding;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.FormGroupBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.binding.StaticPartDataBinding;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;

public class FormBinding
extends PartBinding {
    private transient List formFields = Collections.EMPTY_LIST;
    private transient FormDataBinding staticFormDataBinding;
    private transient Map unqualifiedNamesToDataBindings;
    private transient FormGroupBinding enclosingFormGroup;

    public FormBinding(String[] packageName, String simpleName) {
        this(packageName, simpleName, null);
    }

    public FormBinding(String[] packageName, String caseSensitiveInternedName, FormGroupBinding enclosingFormGroup) {
        super(packageName, caseSensitiveInternedName);
        this.enclosingFormGroup = enclosingFormGroup;
    }

    public List getFields() {
        return this.formFields;
    }

    public void addFormField(FormFieldBinding field) {
        if (this.formFields == Collections.EMPTY_LIST) {
            this.formFields = new ArrayList();
        }
        this.formFields.add(field);
    }

    @Override
    public int getKind() {
        return 8;
    }

    @Override
    public void clear() {
        super.clear();
        this.formFields = Collections.EMPTY_LIST;
        this.staticFormDataBinding = null;
        this.unqualifiedNamesToDataBindings = null;
    }

    @Override
    protected IDataBinding primFindData(String simpleName) {
        for (FormFieldBinding nextField : this.formFields) {
            if (nextField.getName() != simpleName) continue;
            return nextField;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public boolean isStructurallyEqual(IPartBinding anotherPartBinding) {
        return false;
    }

    public IDataBinding getStaticFormDataBinding() {
        if (this.staticFormDataBinding == null) {
            this.staticFormDataBinding = new FormDataBinding(this.getCaseSensitiveName(), this, this);
        }
        return this.staticFormDataBinding;
    }

    public boolean isNestedForm() {
        return this.enclosingFormGroup != null;
    }

    public FormGroupBinding getEnclosingFormGroup() {
        return this.enclosingFormGroup;
    }

    @Override
    public boolean isValid() {
        if (this.isNestedForm()) {
            return true;
        }
        return super.isValid();
    }

    @Override
    public Map getSimpleNamesToDataBindingsMap() {
        if (this.unqualifiedNamesToDataBindings == null) {
            if (this.formFields == Collections.EMPTY_LIST) {
                this.unqualifiedNamesToDataBindings = Collections.EMPTY_MAP;
            } else {
                this.unqualifiedNamesToDataBindings = new HashMap();
                for (FormFieldBinding nextField : this.formFields) {
                    BindingUtilities.addToUnqualifiedBindingNameMap(this.unqualifiedNamesToDataBindings, null, nextField);
                }
            }
        }
        return this.unqualifiedNamesToDataBindings;
    }

    public boolean isPrintForm() {
        return AbstractBinder.annotationIs(this.getSubType(), new String[]{"egl", "ui", "text"}, "PrintForm");
    }

    public boolean isTextForm() {
        return !this.isPrintForm();
    }

    @Override
    public boolean isDeclarablePart() {
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getConstantFields());
        out.writeObject(this.getVariableFields());
        out.writeBoolean(this.enclosingFormGroup != null);
        if (this.enclosingFormGroup != null) {
            this.writeTypeBindingReference(out, this.enclosingFormGroup);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getFields().addAll((List)in.readObject());
        this.getFields().addAll((List)in.readObject());
        boolean hasEnclosingFormGroup = in.readBoolean();
        if (hasEnclosingFormGroup) {
            this.enclosingFormGroup = (FormGroupBinding)this.readTypeBindingReference(in);
        }
    }

    @Override
    public StaticPartDataBinding getStaticPartDataBinding() {
        return (StaticPartDataBinding)this.getStaticFormDataBinding();
    }

    private List getConstantFields() {
        ArrayList<FormFieldBinding> list = new ArrayList<FormFieldBinding>();
        for (FormFieldBinding field : this.getFields()) {
            if (!field.isConstant()) continue;
            list.add(field);
        }
        return list;
    }

    private List getVariableFields() {
        ArrayList<FormFieldBinding> list = new ArrayList<FormFieldBinding>();
        for (FormFieldBinding field : this.getFields()) {
            if (!field.isVariable()) continue;
            list.add(field);
        }
        return list;
    }

    @Override
    public ITypeBinding primGetNullableInstance() {
        return this;
    }
}

