/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.edt.compiler.binding.ConstantFormFieldBinding;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.binding.VariableFormFieldBinding;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.ConstantFormField;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.VariableFormField;
import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.NullProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.DataBindingScope;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class FormBindingFieldsCompletor
extends AbstractBinder {
    private Set definedFields = new HashSet();
    private FormBinding formBinding;
    private IProblemRequestor problemRequestor;

    public FormBindingFieldsCompletor(Scope currentScope, FormBinding formBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, formBinding, dependencyRequestor, compilerOptions);
        this.formBinding = formBinding;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(TopLevelForm form) {
        return true;
    }

    @Override
    public boolean visit(NestedForm form) {
        return true;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        return false;
    }

    public VariableFormFieldBinding createVariableField(final VariableFormField variableFormField, ITypeBinding typeBinding, final IProblemRequestor problemRequestor) {
        VariableFormFieldBinding field;
        ITypeBinding baseType;
        String fieldName = variableFormField.getName().getIdentifier();
        if (this.isNullable(typeBinding)) {
            problemRequestor.acceptProblem(variableFormField.getType(), 3430);
            typeBinding = typeBinding.getBaseType();
        }
        if ((baseType = (field = new VariableFormFieldBinding(variableFormField.getName().getCaseSensitiveIdentifier(), this.formBinding, typeBinding)).getType().getBaseType()).getKind() == 3) {
            Primitive prim = ((PrimitiveTypeBinding)baseType).getPrimitive();
            if (prim == Primitive.UNICODE || prim == Primitive.ANY || prim == Primitive.MONTHSPAN_INTERVAL || prim == Primitive.SECONDSPAN_INTERVAL || prim == Primitive.INTERVAL || prim == Primitive.STRING) {
                problemRequestor.acceptProblem((Node)variableFormField.getType(), 5339, new String[]{variableFormField.getName().getCanonicalName(), this.formBinding.getCaseSensitiveName(), prim.getName()});
            }
        } else if (baseType.getKind() != 17) {
            problemRequestor.acceptProblem((Node)variableFormField.getType(), 5382, new String[]{baseType.getName(), fieldName, this.formBinding.getCaseSensitiveName()});
        }
        if (typeBinding.getKind() == 2) {
            AbstractBinder.OccursValueFinder occursFinder = new AbstractBinder.OccursValueFinder(problemRequestor, variableFormField.getName().getCanonicalName()){

                @Override
                protected void reportSizeNotIntegerError(Node errorNode, String canonicalExprString) {
                    problemRequestor.acceptProblem(errorNode, 5360, new String[]{variableFormField.getName().getCanonicalName(), FormBindingFieldsCompletor.this.formBinding.getCaseSensitiveName()});
                }
            };
            ArrayType arrayType = (ArrayType)variableFormField.getType();
            if (arrayType.hasInitialSize()) {
                arrayType.getInitialSize().accept(occursFinder);
                int occurs = occursFinder.getOccursValue();
                if (occurs > 0) {
                    field.setOccurs(occurs);
                    field.setType(field.getType().getBaseType());
                }
            } else {
                problemRequestor.acceptProblem((Node)variableFormField.getName(), 5360, new String[]{variableFormField.getName().getCanonicalName(), this.formBinding.getCaseSensitiveName()});
            }
        }
        variableFormField.getName().setBinding(field);
        return field;
    }

    @Override
    public boolean visit(VariableFormField variableFormField) {
        ITypeBinding typeBinding = null;
        try {
            typeBinding = this.bindType(variableFormField.getType());
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            return false;
        }
        final boolean[] fieldIsValid = new boolean[]{true};
        VariableFormFieldBinding fieldBinding = this.createVariableField(variableFormField, typeBinding, new DefaultProblemRequestor(){

            @Override
            public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind, String[] inserts) {
                fieldIsValid[0] = false;
                if (severity == 2) {
                    this.setHasError(true);
                }
                FormBindingFieldsCompletor.this.problemRequestor.acceptProblem(startOffset, endOffset, severity, problemKind, inserts);
            }
        });
        if (variableFormField.hasInitializer()) {
            fieldBinding.setInitialValue(FormBindingFieldsCompletor.getConstantValue(variableFormField.getInitializer(), NullProblemRequestor.getInstance(), true));
        }
        if (fieldBinding != null) {
            if (this.definedFields.contains(variableFormField.getName().getIdentifier())) {
                this.problemRequestor.acceptProblem((Node)variableFormField.getName(), 5334, new String[]{variableFormField.getName().getCanonicalName(), this.formBinding.getCaseSensitiveName()});
            } else {
                this.definedFields.add(variableFormField.getName().getIdentifier());
                if (fieldIsValid[0]) {
                    this.formBinding.addFormField(fieldBinding);
                }
            }
            variableFormField.accept(new FieldCompletor(this.currentScope, fieldBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        }
        return false;
    }

    @Override
    public boolean visit(ConstantFormField constantFormField) {
        ConstantFormFieldBinding fieldBinding = new ConstantFormFieldBinding(this.formBinding);
        this.formBinding.addFormField(fieldBinding);
        constantFormField.setBinding(fieldBinding);
        constantFormField.accept(new FieldCompletor(this.currentScope, fieldBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        return false;
    }

    public class FieldCompletor
    extends DefaultBinder {
        private FormFieldBinding fieldBinding;

        public FieldCompletor(Scope currentScope, FormFieldBinding fieldBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
            super(currentScope, fieldBinding.getDeclaringPart(), dependencyRequestor, problemRequestor, compilerOptions);
            this.fieldBinding = fieldBinding;
        }

        @Override
        public boolean visit(VariableFormField variableFormField) {
            return true;
        }

        @Override
        public void endVisit(VariableFormField variableFormField) {
            super.endVisit(variableFormField);
        }

        @Override
        public boolean visit(ConstantFormField constantFormField) {
            return true;
        }

        @Override
        public boolean visit(SettingsBlock settingsBlock) {
            DataBindingScope fieldScope = new DataBindingScope(this.currentScope, this.fieldBinding);
            AnnotationLeftHandScope annotationScope = new AnnotationLeftHandScope(fieldScope, this.fieldBinding, this.fieldBinding.getType(), this.fieldBinding, -1, this.fieldBinding.getDeclaringPart());
            settingsBlock.accept(new SettingsBlockAnnotationBindingsCompletor(this.currentScope, this.fieldBinding.getDeclaringPart(), annotationScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
            return false;
        }
    }
}

