/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.LibraryBinding;
import org.eclipse.edt.compiler.binding.annotationType.EGLIsSystemPartAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.EGLSystemConstantAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.EGLValidNumberOfArgumentsAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.Boolean;

public class FunctionBinding
extends Binding
implements IFunctionBinding {
    protected List parameters = Collections.EMPTY_LIST;
    protected transient ITypeBinding returnType;
    protected boolean returnTypeIsSqlNullable;
    protected boolean isStatic;
    protected boolean isAbstract;
    protected boolean isPrivate;
    private IPartBinding declarer;
    private boolean hasConverse;
    private boolean implicit;

    public FunctionBinding(String caseSensitiveInternedName, IPartBinding declarer) {
        super(caseSensitiveInternedName);
        this.declarer = declarer;
    }

    @Override
    public IPartBinding getDeclarer() {
        return this.declarer;
    }

    @Override
    public boolean isFunctionBinding() {
        return true;
    }

    @Override
    public List getParameters() {
        return this.parameters;
    }

    public void addParameter(FunctionParameterBinding parameter) {
        if (this.parameters == Collections.EMPTY_LIST) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(parameter);
    }

    @Override
    public ITypeBinding getReturnType() {
        return this.realizeTypeBinding(this.returnType, this.getDeclarer() != null ? this.getDeclarer().getEnvironment() : null);
    }

    public void setReturnType(ITypeBinding type) {
        this.returnType = this.getTypeBinding(type, null);
    }

    @Override
    public boolean returnTypeIsSqlNullable() {
        return this.returnTypeIsSqlNullable;
    }

    public void setReturnTypeIsSqlNullable(boolean returnIsNullable) {
        this.returnTypeIsSqlNullable = returnIsNullable;
    }

    @Override
    public boolean isSystemFunction() {
        IAnnotationBinding aBinding;
        return this.declarer != null && (aBinding = this.declarer.getAnnotation(EGLIsSystemPartAnnotationTypeBinding.getInstance())) != null && Boolean.YES == aBinding.getValue();
    }

    @Override
    public int getSystemFunctionType() {
        IAnnotationBinding ann = this.getAnnotation(EGLSystemConstantAnnotationTypeBinding.getInstance());
        if (ann != null) {
            return (Integer)ann.getValue();
        }
        return 0;
    }

    @Override
    public int[] getValidNumbersOfArguments() {
        IAnnotationBinding aBinding = this.getAnnotation(EGLValidNumberOfArgumentsAnnotationTypeBinding.getInstance());
        if (aBinding != null) {
            Object[] value = (Object[])aBinding.getValue();
            int[] result = new int[value.length];
            int i = 0;
            while (i < value.length) {
                result[i] = (Integer)value[i];
                ++i;
            }
            return result;
        }
        return new int[]{this.parameters.size()};
    }

    public IDataBinding getQualifier() {
        return null;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    @Override
    public boolean hasConverse() {
        return this.hasConverse;
    }

    public void setHasConverse(boolean hasConverse) {
        this.hasConverse = hasConverse;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeTypeBindingReference(out, this.returnType);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.returnType = this.readTypeBindingReference(in);
    }

    @Override
    public boolean isFunctionBindingWithImplicitQualifier() {
        return false;
    }

    @Override
    public IDataBinding getImplicitQualifier() {
        return null;
    }

    @Override
    public IFunctionBinding getWrappedFunctionBinding() {
        return null;
    }

    @Override
    public LibraryBinding getSystemLibrary() {
        return null;
    }

    @Override
    public int getKind() {
        return 20;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String[] getPackageName() {
        return null;
    }

    @Override
    public IDataBinding findData(String simpleName) {
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public IDataBinding findPublicData(String simpleName) {
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public Map getSimpleNamesToDataBindingsMap() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public IFunctionBinding findFunction(String simpleName) {
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public IFunctionBinding findPublicFunction(String simpleName) {
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isDynamicallyAccessible() {
        return false;
    }

    @Override
    public boolean isReferentiallyEqual(ITypeBinding anotherTypeBinding) {
        return false;
    }

    @Override
    public boolean isPartBinding() {
        return false;
    }

    @Override
    public ITypeBinding copyTypeBinding() {
        return null;
    }

    @Override
    public ITypeBinding getBaseType() {
        return this;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public ITypeBinding getNullableInstance() {
        return null;
    }

    @Override
    public String getPackageQualifiedName() {
        StringBuffer result = new StringBuffer();
        String[] packageName = this.getPackageName();
        if (packageName != null) {
            int i = 0;
            while (i < packageName.length) {
                result.append(packageName[i]);
                result.append('.');
                ++i;
            }
        }
        result.append(this.getCaseSensitiveName());
        return result.toString();
    }

    @Override
    public boolean isTopLevelFunction() {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return this.implicit;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    @Override
    public ITypeBinding getNonNullableInstance() {
        return this;
    }

    @Override
    public boolean isInstantiable() {
        return false;
    }
}

