/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.eclipse.edt.compiler.binding.ArrayDictionaryBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.DataItemBinding;
import org.eclipse.edt.compiler.binding.DataTableBinding;
import org.eclipse.edt.compiler.binding.DelegateBinding;
import org.eclipse.edt.compiler.binding.DictionaryBinding;
import org.eclipse.edt.compiler.binding.EnumerationTypeBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.FixedRecordBindingImpl;
import org.eclipse.edt.compiler.binding.FlexibleRecordBindingImpl;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormGroupBinding;
import org.eclipse.edt.compiler.binding.HandlerBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.InterfaceBinding;
import org.eclipse.edt.compiler.binding.LibraryBinding;
import org.eclipse.edt.compiler.binding.OverloadedFunctionSet;
import org.eclipse.edt.compiler.binding.ProgramBinding;
import org.eclipse.edt.compiler.binding.ServiceBinding;
import org.eclipse.edt.compiler.binding.StaticPartDataBinding;
import org.eclipse.edt.compiler.binding.TopLevelFunctionBinding;
import org.eclipse.edt.compiler.binding.TypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.EGLIsSystemPartAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.StereotypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class PartBinding
extends TypeBinding
implements IPartBinding {
    protected String[] packageName;
    protected transient IEnvironment environment;
    protected boolean isValid;
    protected boolean isPrivate;

    public PartBinding(String[] packageName, String caseSensitiveInternedName) {
        super(caseSensitiveInternedName);
        this.packageName = packageName;
    }

    protected PartBinding(PartBinding old) {
        super(old);
        this.packageName = old.packageName;
        this.environment = old.environment;
        this.isValid = old.isValid;
        this.isPrivate = old.isPrivate;
    }

    @Override
    public boolean isPartBinding() {
        return true;
    }

    @Override
    public IEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(IEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public IPartBinding realize() {
        if (this.isNullable()) {
            return (IPartBinding)this.environment.getPartBinding(this.packageName, this.getName()).getNullableInstance();
        }
        return this.environment.getPartBinding(this.packageName, this.getName());
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public static IPartBinding newPartBinding(int kind, String[] packageName, String caseSensitivePartName) {
        switch (kind) {
            case 27: {
                return new DelegateBinding(packageName, caseSensitivePartName);
            }
            case 5: {
                return new DataTableBinding(packageName, caseSensitivePartName);
            }
            case 28: {
                return new ExternalTypeBinding(packageName, caseSensitivePartName);
            }
            case 6: {
                return new FixedRecordBindingImpl(packageName, caseSensitivePartName);
            }
            case 7: {
                return new FlexibleRecordBindingImpl(packageName, caseSensitivePartName);
            }
            case 8: {
                return new FormBinding(packageName, caseSensitivePartName);
            }
            case 9: {
                return new FormGroupBinding(packageName, caseSensitivePartName);
            }
            case 10: {
                return new HandlerBinding(packageName, caseSensitivePartName);
            }
            case 15: {
                return new InterfaceBinding(packageName, caseSensitivePartName);
            }
            case 11: {
                return new LibraryBinding(packageName, caseSensitivePartName);
            }
            case 13: {
                return new ProgramBinding(packageName, caseSensitivePartName);
            }
            case 14: {
                return new ServiceBinding(packageName, caseSensitivePartName);
            }
            case 17: {
                return new DataItemBinding(packageName, caseSensitivePartName);
            }
            case 16: {
                return new FileBinding(packageName, caseSensitivePartName);
            }
            case 20: {
                return new TopLevelFunctionBinding(packageName, caseSensitivePartName);
            }
            case 22: {
                return ArrayDictionaryBinding.INSTANCE;
            }
            case 21: {
                return DictionaryBinding.INSTANCE;
            }
            case 19: {
                return new EnumerationTypeBinding(packageName, caseSensitivePartName);
            }
        }
        throw new RuntimeException("Unsupported kind: " + kind);
    }

    @Override
    public String[] getPackageName() {
        return this.packageName;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.packageName.length != 0) {
            this.packageName = InternUtil.intern((String[])this.packageName);
        }
    }

    @Override
    public boolean isReferentiallyEqual(ITypeBinding anotherTypeBinding) {
        if (!(anotherTypeBinding instanceof PartBinding)) {
            return false;
        }
        PartBinding anotherPartBinding = (PartBinding)anotherTypeBinding;
        if (!this.packageName.equals(anotherPartBinding.packageName)) {
            return false;
        }
        return this.getName().equals(anotherPartBinding.getName());
    }

    @Override
    public ITypeBinding getBaseType() {
        return this;
    }

    @Override
    public IPartSubTypeAnnotationTypeBinding getSubType() {
        IAnnotationBinding annotation = this.getSubTypeAnnotationBinding();
        if (annotation != null) {
            return (IPartSubTypeAnnotationTypeBinding)annotation.getAnnotationType();
        }
        return null;
    }

    @Override
    public IAnnotationBinding getSubTypeAnnotationBinding() {
        for (IAnnotationBinding annotation : this.getAnnotations()) {
            IAnnotationTypeBinding annotationType = annotation.getAnnotationType();
            if (annotationType == null || !annotationType.isPartSubType()) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public IAnnotationBinding getAnnotation(IAnnotationTypeBinding annotationType) {
        IAnnotationBinding subType;
        IAnnotationBinding result = super.getAnnotation(annotationType);
        if (result == null && (subType = this.getSubTypeAnnotationBinding()) != null) {
            return subType.getAnnotation(annotationType);
        }
        return result;
    }

    @Override
    public IAnnotationBinding getAnnotation(String[] packageName, String annotationName) {
        IAnnotationBinding subType;
        IAnnotationBinding result = super.getAnnotation(packageName, annotationName);
        if (result == null && (subType = this.getSubTypeAnnotationBinding()) != null) {
            return subType.getAnnotation(packageName, annotationName);
        }
        return result;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    @Override
    public boolean isReference() {
        IAnnotationBinding aBinding;
        IPartSubTypeAnnotationTypeBinding subType = this.getSubType();
        if (subType != null && (aBinding = this.getAnnotation(subType).getAnnotation(StereotypeAnnotationTypeBinding.getInstance())) != null && IBinding.NOT_FOUND_BINDING != (aBinding = (IAnnotationBinding)aBinding.findData("referenceType"))) {
            return ((Boolean)aBinding.getValue()).booleanValue();
        }
        return super.isReference();
    }

    public IPartBinding getDefaultSuperType() {
        IAnnotationBinding aBinding;
        IPartSubTypeAnnotationTypeBinding subType = this.getSubType();
        if (subType != null && (aBinding = this.getAnnotation(subType).getAnnotation(StereotypeAnnotationTypeBinding.getInstance())) != null && IBinding.NOT_FOUND_BINDING != (aBinding = (IAnnotationBinding)aBinding.findData("DefaultSuperType")) && aBinding.getValue() instanceof IPartBinding) {
            return (IPartBinding)aBinding.getValue();
        }
        return null;
    }

    @Override
    public boolean isSystemPart() {
        IAnnotationBinding aBinding = super.getAnnotation(EGLIsSystemPartAnnotationTypeBinding.getInstance());
        return aBinding != null && Boolean.YES == aBinding.getValue();
    }

    @Override
    public StaticPartDataBinding getStaticPartDataBinding() {
        return null;
    }

    public List getDeclaredFunctions() {
        return null;
    }

    private boolean isNestedFunctionOrOverloadedFunctionSet(IDataBinding binding) {
        if (!Binding.isValidBinding(binding)) {
            return false;
        }
        int kind = binding.getKind();
        return kind == 20 || kind == 23;
    }

    private void addAllFunctionsToSet(OverloadedFunctionSet set, IDataBinding binding) {
        if (!Binding.isValidBinding(binding)) {
            return;
        }
        if (binding.getKind() == 23) {
            OverloadedFunctionSet oldSet = (OverloadedFunctionSet)binding;
            for (IDataBinding next : oldSet.getNestedFunctionBindings()) {
                set.addNestedFunctionBinding(next);
            }
        } else if (binding.getKind() == 20) {
            set.addNestedFunctionBinding(binding);
        }
    }

    @Override
    public IDataBinding findData(String simpleName) {
        IDataBinding superResult;
        IDataBinding result = this.primFindData(simpleName);
        if (Binding.isValidBinding(result) && !this.isNestedFunctionOrOverloadedFunctionSet(result)) {
            return result;
        }
        if (this.getDefaultSuperType() != null && Binding.isValidBinding(superResult = this.getDefaultSuperType().findData(simpleName))) {
            if (result == IBinding.NOT_FOUND_BINDING || !this.isNestedFunctionOrOverloadedFunctionSet(superResult)) {
                return superResult;
            }
            OverloadedFunctionSet functionSet = new OverloadedFunctionSet();
            functionSet.setName(result.getCaseSensitiveName());
            this.addAllFunctionsToSet(functionSet, result);
            this.addAllFunctionsToSet(functionSet, superResult);
            return functionSet;
        }
        if (result == IBinding.NOT_FOUND_BINDING) {
            return super.findData(simpleName);
        }
        return result;
    }

    protected IDataBinding primFindData(String simpleName) {
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public IFunctionBinding findFunction(String simpleName) {
        IFunctionBinding result = this.primFindFunction(simpleName);
        if (result == IBinding.NOT_FOUND_BINDING && this.getDefaultSuperType() != null) {
            result = this.getDefaultSuperType().findFunction(simpleName);
        }
        if (result == IBinding.NOT_FOUND_BINDING) {
            return super.findFunction(simpleName);
        }
        return result;
    }

    protected IFunctionBinding primFindFunction(String simpleName) {
        return IBinding.NOT_FOUND_BINDING;
    }
}

