/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.ArrayList;
import org.eclipse.edt.compiler.binding.AnnotationBindingForElement;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.internal.core.lookup.Enumerations.IndexOrientationKind;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class PositionUtility {
    IDataBinding dataBinding;
    int arraySize;
    private ICompilerOptions compilerOptions;
    private Scope currentScope;

    public PositionUtility(IDataBinding dataBinding, int arraySize, ICompilerOptions compilerOptions, Scope currentScope) {
        this.dataBinding = dataBinding;
        this.arraySize = arraySize;
        this.compilerOptions = compilerOptions;
        this.currentScope = currentScope;
    }

    public void checkPosition() {
        ITypeBinding positionType = this.currentScope.findPackage(InternUtil.intern((String)"eglx")).resolvePackage(InternUtil.intern((String)"ui")).resolveType(InternUtil.intern((String)"Position"));
        if (IBinding.NOT_FOUND_BINDING == positionType) {
            return;
        }
        if (this.arraySize > 0) {
            EnumerationDataBinding orientation = this.getOrientation();
            int columns = this.getColumns();
            int linesBetweenRows = this.getLinesBetweenRows();
            int spacesBetweenColums = this.getSpacesBetweenColumns();
            int fieldLen = this.getFieldLen();
            int[] position = this.getPosition();
            ArrayList<AnnotationBindingForElement> newAnnotations = new ArrayList<AnnotationBindingForElement>();
            int i = 0;
            while (i < this.arraySize) {
                IAnnotationBinding annotation = this.dataBinding.getAnnotation(new String[]{"egl", "ui"}, "Position", i + 1);
                if (annotation == null || !annotation.isForElement()) {
                    Integer[] newPos = this.calculateLogicalPosition(i, orientation, columns, linesBetweenRows, spacesBetweenColums, position, fieldLen);
                    AnnotationBindingForElement posAnnotation = new AnnotationBindingForElement(InternUtil.internCaseSensitive((String)"Position"), this.dataBinding.getDeclaringPart(), (ITypeBinding)new AnnotationTypeBindingImpl((FlexibleRecordBinding)positionType, this.dataBinding.getDeclaringPart()), i + 1);
                    posAnnotation.setValue(newPos, null, null, this.compilerOptions, false);
                    posAnnotation.setCalculated(true);
                    newAnnotations.add(posAnnotation);
                }
                ++i;
            }
            this.dataBinding.addAnnotations(newAnnotations);
        }
    }

    private EnumerationDataBinding getOrientation() {
        EnumerationDataBinding orientation = IndexOrientationKind.DOWN;
        IAnnotationBinding annotation = this.dataBinding.getAnnotation(new String[]{"egl", "ui", "text"}, "IndexOrientation");
        if (annotation != null && annotation.getValue() != null) {
            orientation = (EnumerationDataBinding)annotation.getValue();
        }
        return orientation;
    }

    private int getColumns() {
        int columns = 1;
        IAnnotationBinding annotation = this.dataBinding.getAnnotation(new String[]{"egl", "ui"}, "Columns");
        if (annotation != null && annotation.getValue() != null && annotation.getValue() instanceof Integer) {
            columns = (Integer)annotation.getValue();
        }
        if (columns < 1) {
            return 1;
        }
        return columns;
    }

    private int getLinesBetweenRows() {
        int lines = 0;
        IAnnotationBinding annotation = this.dataBinding.getAnnotation(new String[]{"egl", "ui"}, "LinesBetweenRows");
        if (annotation != null && annotation.getValue() != null && annotation.getValue() instanceof Integer) {
            lines = (Integer)annotation.getValue();
        }
        return lines;
    }

    private int getSpacesBetweenColumns() {
        int spaces = 1;
        IAnnotationBinding annotation = this.dataBinding.getAnnotation(new String[]{"egl", "ui"}, "SpacesBetweenColumns");
        if (annotation != null && annotation.getValue() != null && annotation.getValue() instanceof Integer) {
            spaces = (Integer)annotation.getValue();
        }
        return spaces;
    }

    private int getFieldLen() {
        int len = 1;
        IAnnotationBinding annotation = this.dataBinding.getAnnotation(new String[]{"egl", "ui"}, "FieldLen");
        if (annotation != null && annotation.getValue() != null && annotation.getValue() instanceof Integer) {
            len = (Integer)annotation.getValue();
        }
        return len;
    }

    private int[] getPosition() {
        Integer[] pos;
        Integer[] position = new Integer[]{new Integer(1), new Integer(1)};
        IAnnotationBinding annotation = this.dataBinding.getAnnotation(new String[]{"egl", "ui"}, "Position");
        if (annotation != null && annotation.getValue() != null && annotation.getValue() instanceof Integer[] && (pos = (Integer[])annotation.getValue()).length == 2) {
            position = pos;
        }
        int[] result = new int[]{position[0], position[1]};
        return result;
    }

    private Integer[] calculateLogicalPosition(int index, EnumerationDataBinding orientation, int columns, int linesBetweenRows, int spacesBetweenColumns, int[] initialElementPosition, int fieldLen) {
        boolean indexOrientationIsDown = "down".equalsIgnoreCase(orientation.getName());
        int[] elementPosition = new int[2];
        if (indexOrientationIsDown) {
            int rows = this.arraySize / columns;
            if (this.arraySize % columns > 0) {
                ++rows;
            }
            elementPosition[0] = initialElementPosition[0] + index % rows * (linesBetweenRows + 1);
            elementPosition[1] = initialElementPosition[1] + index / rows * (spacesBetweenColumns + fieldLen);
        } else {
            elementPosition[0] = initialElementPosition[0] + index / columns * (linesBetweenRows + 1);
            elementPosition[1] = initialElementPosition[1] + index % columns * (spacesBetweenColumns + fieldLen);
        }
        Integer[] result = new Integer[]{new Integer(elementPosition[0]), new Integer(elementPosition[1])};
        return result;
    }
}

