/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.FunctionContainerBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.ProgramDataBinding;
import org.eclipse.edt.compiler.binding.ProgramParameterBinding;
import org.eclipse.edt.compiler.binding.StaticPartDataBinding;

public class ProgramBinding
extends FunctionContainerBinding {
    private final String[] EGLCORE = new String[]{"egl", "core"};
    private transient ProgramDataBinding staticLibraryDataBinding;
    private List parameters = Collections.EMPTY_LIST;
    private boolean callable;

    public ProgramBinding(String[] packageName, String caseSensitiveInternedName) {
        super(packageName, caseSensitiveInternedName);
    }

    public List getParameters() {
        return this.parameters;
    }

    public void addParameter(ProgramParameterBinding parameterBinding) {
        if (this.parameters == Collections.EMPTY_LIST) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(parameterBinding);
    }

    @Override
    public int getKind() {
        return 13;
    }

    @Override
    public void clear() {
        super.clear();
        this.parameters = Collections.EMPTY_LIST;
    }

    @Override
    public boolean isStructurallyEqual(IPartBinding anotherPartBinding) {
        return false;
    }

    @Override
    protected IDataBinding primFindData(String simpleName) {
        for (IDataBinding binding : this.parameters) {
            if (!binding.getName().equals(simpleName)) continue;
            return binding;
        }
        return super.primFindData(simpleName);
    }

    @Override
    public List getDeclaredData() {
        ArrayList result = super.getDeclaredData();
        if (this.parameters != Collections.EMPTY_LIST) {
            if (result == Collections.EMPTY_LIST) {
                result = this.parameters;
            } else {
                result = new ArrayList(result);
                result.addAll(this.parameters);
            }
        }
        return result;
    }

    @Override
    protected byte[] getStructurallySignificantBytes() throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteOutputStream);
        objectOutputStream.writeBoolean(this.isCallable());
        String alias = this.getAlias();
        if (alias == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeUTF(alias);
        }
        IDataBinding inputRecord = this.getInputRecord();
        if (inputRecord == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            objectOutputStream.writeBoolean(true);
            this.writeTypeBindingReference(objectOutputStream, inputRecord.getType());
        }
        inputRecord = this.getInputUIRecord();
        if (inputRecord == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            objectOutputStream.writeBoolean(true);
            this.writeTypeBindingReference(objectOutputStream, inputRecord.getType());
        }
        for (ProgramParameterBinding parameter : this.getParameters()) {
            this.writeTypeBindingReference(objectOutputStream, parameter.getType());
        }
        objectOutputStream.close();
        return byteOutputStream.toByteArray();
    }

    public boolean isCallable() {
        return this.callable;
    }

    public void setCallable(boolean callable) {
        this.callable = callable;
    }

    private String getAlias() {
        IAnnotationBinding ann = this.getAnnotation(this.EGLCORE, "alias");
        if (ann != null) {
            return (String)ann.getValue();
        }
        return null;
    }

    private IDataBinding getInputRecord() {
        IAnnotationBinding ann = this.getSubTypeAnnotationBinding();
        if (ann == null) {
            return null;
        }
        IDataBinding field = ann.findData("inputRecord");
        if (field == null || field == IBinding.NOT_FOUND_BINDING) {
            return null;
        }
        Object value = ((AnnotationBinding)field).getValue();
        if (value == null || value == IBinding.NOT_FOUND_BINDING) {
            return null;
        }
        if (value instanceof IDataBinding) {
            return (IDataBinding)value;
        }
        return null;
    }

    private IDataBinding getInputUIRecord() {
        IAnnotationBinding ann = this.getSubTypeAnnotationBinding();
        if (ann == null) {
            return null;
        }
        IDataBinding field = ann.findData("inputUIRecord");
        if (field == null || field == IBinding.NOT_FOUND_BINDING) {
            return null;
        }
        Object value = ((AnnotationBinding)field).getValue();
        if (value == null || value == IBinding.NOT_FOUND_BINDING) {
            return null;
        }
        if (value instanceof IDataBinding) {
            return (IDataBinding)value;
        }
        return null;
    }

    public IDataBinding getStaticProgramDataBinding() {
        if (this.staticLibraryDataBinding == null) {
            this.staticLibraryDataBinding = new ProgramDataBinding(this.getCaseSensitiveName(), this, this);
        }
        return this.staticLibraryDataBinding;
    }

    @Override
    public StaticPartDataBinding getStaticPartDataBinding() {
        return (StaticPartDataBinding)this.getStaticProgramDataBinding();
    }

    @Override
    public ITypeBinding primGetNullableInstance() {
        return this;
    }
}

