/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.lang.reflect.Array;

public class ArrayStack {
    Object[] ary;
    int top = -1;

    public ArrayStack() {
        this(10);
    }

    public ArrayStack(int initialCapacity) {
        this.ary = new Object[initialCapacity];
    }

    public Object elementAt(int i) {
        return this.ary[i];
    }

    public void removeAllElements() {
        this.top = -1;
    }

    public void push(Object object) {
        if (this.top + 1 == this.ary.length) {
            Object[] newAry = new Object[this.ary.length * 2];
            System.arraycopy(this.ary, 0, newAry, 0, this.ary.length);
            this.ary = newAry;
        }
        this.ary[++this.top] = object;
    }

    public Object peek() {
        return this.ary[this.top];
    }

    public Object pop() {
        Object result = this.ary[this.top];
        this.ary[this.top] = null;
        --this.top;
        return result;
    }

    public int size() {
        return this.top + 1;
    }

    public boolean empty() {
        return this.top == -1;
    }

    public Object get(int i) {
        return this.ary[i];
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.top + 1) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.top + 1);
        }
        System.arraycopy(this.ary, 0, a, 0, this.top + 1);
        if (a.length > this.top + 1) {
            a[this.top + 1] = null;
        }
        return a;
    }
}

