/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FieldAccess
extends Expression {
    private Expression primary;
    private String ID;
    private IDataBinding dataBinding;

    public FieldAccess(Expression primary, String ID, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.primary = primary;
        primary.setParent(this);
        this.ID = ID;
    }

    public Expression getPrimary() {
        return this.primary;
    }

    public String getID() {
        return InternUtil.intern((String)this.ID);
    }

    public String getCaseSensitiveID() {
        return InternUtil.internCaseSensitive((String)this.ID);
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.primary.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public IDataBinding resolveDataBinding() {
        return this.dataBinding;
    }

    @Override
    public void setDataBinding(IDataBinding dataBinding) {
        this.dataBinding = dataBinding;
    }

    @Override
    public String getCanonicalString() {
        return String.valueOf(this.getPrimary().getCanonicalString()) + "." + this.ID;
    }

    @Override
    public void setAttributeOnName(int attr, Object value) {
        this.primary.setAttributeOnName(attr, value);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new FieldAccess((Expression)this.primary.clone(), new String(this.ID), this.getOffset(), this.getOffset() + this.getLength());
    }
}

