/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Arrays;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Statement;

public class ForEachStatement
extends Statement {
    private List targets;
    private FromOrToExpressionClause resultSet;
    private List foreachOptions;
    private List stmts;
    private int closingParenOffset;

    public ForEachStatement(List targets, FromOrToExpressionClause resultSet, List options, List stmts, int closingParenOffset, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.targets = this.setParent(targets);
        this.resultSet = resultSet;
        resultSet.setParent(this);
        this.foreachOptions = this.setParent(options);
        this.stmts = this.setParent(stmts);
        this.closingParenOffset = closingParenOffset;
    }

    public List getTargets() {
        return this.targets;
    }

    public boolean hasResultSet() {
        return true;
    }

    public int getClosingParenOffset() {
        return this.closingParenOffset;
    }

    public FromOrToExpressionClause getResultSet() {
        return this.resultSet;
    }

    public boolean hasSQLRecord() {
        return true;
    }

    public Expression getSQLRecord() {
        if (this.targets.size() > 0) {
            return (Expression)this.targets.get(0);
        }
        return null;
    }

    public List getStmts() {
        return this.stmts;
    }

    public List getForeachOptions() {
        return this.foreachOptions;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            ForEachStatement.acceptChildren(visitor, this.targets);
            this.resultSet.accept(visitor);
            ForEachStatement.acceptChildren(visitor, this.foreachOptions);
            ForEachStatement.acceptChildren(visitor, this.stmts);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean canIncludeOtherStatements() {
        return true;
    }

    @Override
    public List getStatementBlocks() {
        return Arrays.asList(this.stmts);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new ForEachStatement(this.cloneList(this.targets), (FromOrToExpressionClause)this.resultSet.clone(), this.cloneList(this.foreachOptions), this.cloneList(this.stmts), this.closingParenOffset, this.getOffset(), this.getOffset() + this.getLength());
    }

    public static class ExpressionForEachTarget
    extends ForEachTarget {
        private Expression expression;

        public ExpressionForEachTarget(Expression expression) {
            this.expression = expression;
        }

        @Override
        boolean isExpressionForEachTarget() {
            return true;
        }

        @Override
        Expression getExpression() {
            return this.expression;
        }

        @Override
        void setParent(Node parent) {
            this.expression.setParent(parent);
        }

        @Override
        void accept(IASTVisitor visitor) {
            this.expression.accept(visitor);
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new ExpressionForEachTarget((Expression)this.expression.clone());
        }
    }

    public static abstract class ForEachTarget
    implements Cloneable {
        boolean isExpressionForEachTarget() {
            return false;
        }

        Expression getExpression() {
            return null;
        }

        boolean isResultSetForEachTarget() {
            return false;
        }

        FromOrToExpressionClause getResultSet() {
            return null;
        }

        void setParent(Node parent) {
        }

        void accept(IASTVisitor visitor) {
        }

        protected abstract Object clone() throws CloneNotSupportedException;
    }

    public static class ResultSetForEachTarget
    extends ForEachTarget {
        private FromOrToExpressionClause resultSet;

        public ResultSetForEachTarget(FromOrToExpressionClause resultSet) {
            this.resultSet = resultSet;
        }

        @Override
        boolean isResultSetForEachTarget() {
            return true;
        }

        @Override
        FromOrToExpressionClause getResultSet() {
            return this.resultSet;
        }

        @Override
        void setParent(Node parent) {
            this.resultSet.setParent(parent);
        }

        @Override
        void accept(IASTVisitor visitor) {
            this.resultSet.accept(visitor);
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new ResultSetForEachTarget((FromOrToExpressionClause)this.resultSet.clone());
        }
    }
}

