/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;

public class InlineSQLStatement
extends Node {
    private static final int POST_DELIMITER_LENGTH = 1;
    private String sqlStmt;
    private int openingBraceOffset;

    public InlineSQLStatement(String sqlStmt, int openingBraceOffset, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.sqlStmt = sqlStmt;
        this.openingBraceOffset = openingBraceOffset;
    }

    public String getValue() {
        String fulltext = this.sqlStmt;
        return fulltext.substring(this.openingBraceOffset, fulltext.length() - 1).trim();
    }

    public int getValueOffset() {
        String text = this.sqlStmt;
        int i = this.openingBraceOffset;
        while (Character.isWhitespace(text.charAt(i))) {
            ++i;
        }
        return i + this.getOffset();
    }

    public int getOpeningBraceOffset() {
        return this.getOffset() + this.openingBraceOffset;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new InlineSQLStatement(this.sqlStmt, this.openingBraceOffset, this.getOffset(), this.getOffset() + this.getLength());
    }
}

