/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.ArrayList;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.MoveModifier;
import org.eclipse.edt.compiler.core.ast.Statement;

public class MoveStatement
extends Statement {
    private Expression expr;
    private Expression lvalue;
    private MoveModifier moveModifierOpt;

    public MoveStatement(Expression expr, Expression lvalue, MoveModifier moveModifierOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.expr = expr;
        expr.setParent(this);
        this.lvalue = lvalue;
        lvalue.setParent(this);
        this.moveModifierOpt = this.setMoveModifierParent(moveModifierOpt);
    }

    public Expression getSource() {
        return this.expr;
    }

    public Expression getTarget() {
        return this.lvalue;
    }

    public MoveModifier getMoveModifierOpt() {
        return this.moveModifierOpt;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.expr.accept(visitor);
            this.lvalue.accept(visitor);
            if (this.moveModifierOpt != null) {
                this.moveModifierOpt.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    private MoveModifier setMoveModifierParent(MoveModifier mod) {
        if (mod != null) {
            mod.setParent(this);
        }
        return mod;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        new ArrayList();
        MoveModifier newMod = null;
        if (this.moveModifierOpt != null) {
            newMod = (MoveModifier)this.moveModifierOpt.clone();
        }
        return new MoveStatement((Expression)this.expr.clone(), (Expression)this.lvalue.clone(), newMod, this.getOffset(), this.getOffset() + this.getLength());
    }

    public static class DefaultMoveModifier
    extends MoveModifier {
        public static final DefaultMoveModifier BYNAME = new DefaultMoveModifier();
        public static final DefaultMoveModifier BYPOSITION = new DefaultMoveModifier();
        public static final DefaultMoveModifier FORALL = new DefaultMoveModifier();
        public static final DefaultMoveModifier WITHV60COMPAT = new DefaultMoveModifier();

        private DefaultMoveModifier() {
        }

        @Override
        public boolean isByName() {
            return this == BYNAME;
        }

        @Override
        public boolean isByPosition() {
            return this == BYPOSITION;
        }

        @Override
        public boolean isForAll() {
            return this == FORALL;
        }

        @Override
        public boolean isWithV60Compat() {
            return this == WITHV60COMPAT;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return this;
        }
    }
}

