/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;

public class Node
implements Cloneable {
    private int offset;
    private int length;
    private Node parent;

    public Node(int startOffset, int endOffset) {
        this.offset = startOffset;
        this.length = endOffset - startOffset;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    protected List setParent(List children) {
        for (Node node : children) {
            node.setParent(this);
        }
        return children;
    }

    public void accept(IASTVisitor visitor) {
    }

    protected static void acceptChildren(IASTVisitor visitor, List children) {
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).accept(visitor);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected ArrayList cloneList(List oldList) throws CloneNotSupportedException {
        if (oldList == null) {
            return null;
        }
        ArrayList<Object> newList = new ArrayList<Object>();
        Iterator iter = oldList.iterator();
        while (iter.hasNext()) {
            newList.add(((Node)iter.next()).clone());
        }
        return newList;
    }
}

