/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.PrimitiveType;

public class NumericSpecPrimitiveType
extends PrimitiveType {
    private String[] numericPrimitiveSpecOpt;

    public NumericSpecPrimitiveType(Primitive prim, String[] numericPrimitiveSpecOpt, int startOffset, int endOffset) {
        super(prim, startOffset, endOffset);
        this.numericPrimitiveSpecOpt = numericPrimitiveSpecOpt;
    }

    @Override
    public boolean hasPrimLength() {
        return this.numericPrimitiveSpecOpt != null;
    }

    @Override
    public boolean hasPrimDecimals() {
        return this.numericPrimitiveSpecOpt != null && this.numericPrimitiveSpecOpt.length == 2;
    }

    @Override
    public boolean hasPrimPattern() {
        return false;
    }

    @Override
    public String getPrimLength() {
        return this.numericPrimitiveSpecOpt[0];
    }

    @Override
    public String getPrimDecimals() {
        return this.numericPrimitiveSpecOpt[1];
    }

    @Override
    public String getPrimPattern() {
        return null;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        String[] newNumericPrimitiveSpecOpt;
        String[] stringArray = newNumericPrimitiveSpecOpt = this.numericPrimitiveSpecOpt != null ? new String[this.numericPrimitiveSpecOpt.length] : null;
        if (newNumericPrimitiveSpecOpt != null) {
            int i = 0;
            while (i < this.numericPrimitiveSpecOpt.length) {
                newNumericPrimitiveSpecOpt[i] = new String(this.numericPrimitiveSpecOpt[i]);
                ++i;
            }
        }
        return new NumericSpecPrimitiveType(this.getPrimitive(), newNumericPrimitiveSpecOpt, this.getOffset(), this.getOffset() + this.getLength());
    }
}

