/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.OpenUIStatementBinding;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.OnEventBlock;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Statement;

public class OpenUIStatement
extends Statement {
    private SettingsBlock settingsBlockOpt;
    private List expr_plus;
    private List bindOpt;
    private boolean hasBindClause;
    private List eventBlocks;
    private OpenUIStatementBinding statementBinding;

    public OpenUIStatement(SettingsBlock settingsBlockOpt, List expr_plus, List bindOpt, List eventBlocks, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        if (settingsBlockOpt != null) {
            this.settingsBlockOpt = settingsBlockOpt;
            settingsBlockOpt.setParent(this);
        }
        this.expr_plus = this.setParent(expr_plus);
        if (bindOpt == null) {
            this.bindOpt = Collections.EMPTY_LIST;
            this.hasBindClause = false;
        } else {
            this.bindOpt = this.setParent(bindOpt);
            this.hasBindClause = true;
        }
        this.eventBlocks = this.setParent(eventBlocks);
    }

    public boolean hasOpenAttributes() {
        return this.settingsBlockOpt != null;
    }

    public SettingsBlock getOpenAttributes() {
        return this.settingsBlockOpt;
    }

    public List getOpenableElements() {
        return this.expr_plus;
    }

    public boolean hasBindClause() {
        return this.hasBindClause;
    }

    public List getBindClauseVariables() {
        return this.bindOpt;
    }

    public List getEventBlocks() {
        return this.eventBlocks;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.settingsBlockOpt != null) {
                this.settingsBlockOpt.accept(visitor);
            }
            OpenUIStatement.acceptChildren(visitor, this.expr_plus);
            OpenUIStatement.acceptChildren(visitor, this.bindOpt);
            OpenUIStatement.acceptChildren(visitor, this.eventBlocks);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean canIncludeOtherStatements() {
        return true;
    }

    @Override
    public List getStatementBlocks() {
        ArrayList<List> result = new ArrayList<List>();
        Iterator iter = this.eventBlocks.iterator();
        while (iter.hasNext()) {
            result.add(((OnEventBlock)iter.next()).getStatements());
        }
        return result;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        SettingsBlock newSettingsBlockOpt = this.settingsBlockOpt != null ? (SettingsBlock)this.settingsBlockOpt.clone() : null;
        ArrayList newBindOpt = this.hasBindClause ? this.cloneList(this.bindOpt) : null;
        return new OpenUIStatement(newSettingsBlockOpt, this.cloneList(this.expr_plus), newBindOpt, this.cloneList(this.eventBlocks), this.getOffset(), this.getOffset() + this.getLength());
    }

    public OpenUIStatementBinding getStatementBinding() {
        return this.statementBinding;
    }

    public void setStatementBinding(OpenUIStatementBinding statementBinding) {
        this.statementBinding = statementBinding;
    }
}

