/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.NodeNameUtility;
import org.eclipse.edt.compiler.core.ast.Parser;

public abstract class ParseTable {
    public static int[] SCOPE_CLOSERS = new int[]{52, 54, 56, 69};
    public static int[][] LANGUAGE_CONSTRUCTS = new int[][]{{14, 98, 97}, {15, 100, 99}, {37, 120, 119}, {43, 127, 126}, {49, 129, 128}, {48, 112, 111}, {65, 137, 136}, {72, 139, 138}, {78, 145, 144}, {85, 151, 150}, {87, 153, 152}, {22, 106, 105}};
    protected static short[][] production_tab;
    protected static short[][] action_tab;
    protected static short[][] reduce_tab;
    protected static short[][] terminalCandidates;
    protected static short[][] nonTerminalCandidates;

    static {
        Parser parser = new Parser();
        production_tab = parser.production_table();
        action_tab = parser.action_table();
        reduce_tab = parser.reduce_table();
        ParseTable.initTerminalCandidates();
        ParseTable.initNonTerminalCandidates();
    }

    protected boolean isConstructPlus(int nonTerminalType) {
        int i = 0;
        while (i < LANGUAGE_CONSTRUCTS.length) {
            if (nonTerminalType == LANGUAGE_CONSTRUCTS[i][1]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isConstructStar(int nonTerminalType) {
        int i = 0;
        while (i < LANGUAGE_CONSTRUCTS.length) {
            if (nonTerminalType == LANGUAGE_CONSTRUCTS[i][2]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static final boolean isScopeCloser(int terminalType) {
        int i = 0;
        while (i < SCOPE_CLOSERS.length) {
            if (SCOPE_CLOSERS[i] == terminalType) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final void initTerminalCandidates() {
        terminalCandidates = new short[action_tab.length][];
        int i = 0;
        while (i < terminalCandidates.length) {
            int numCandidates = 0;
            short[] actions2 = action_tab[i];
            int j = 0;
            while (j < actions2.length / 2 - 1) {
                if (!ParseTable.isScopeCloser(actions2[j * 2])) {
                    ++numCandidates;
                }
                ++j;
            }
            int index = 0;
            short[] candidates = new short[numCandidates];
            int j2 = 0;
            while (j2 < actions2.length / 2 - 1) {
                if (!ParseTable.isScopeCloser(actions2[j2 * 2])) {
                    candidates[index++] = actions2[j2 * 2];
                }
                ++j2;
            }
            ParseTable.terminalCandidates[i] = candidates;
            ++i;
        }
    }

    protected final void printTerminalCandidates(int state) {
        short[] candidates = terminalCandidates[state];
        int i = 0;
        while (i < candidates.length) {
            String terminalName = NodeNameUtility.getTerminalName(candidates[i]);
            if (this.get_action(state, candidates[i]) > 0) {
                System.out.println("Shift on " + terminalName);
            } else {
                System.out.println("Reduce on " + terminalName);
            }
            ++i;
        }
    }

    protected final short[] getTerminalCandidates(int state) {
        return terminalCandidates[state];
    }

    private static final void initNonTerminalCandidates() {
        nonTerminalCandidates = new short[reduce_tab.length][];
        int i = 0;
        while (i < nonTerminalCandidates.length) {
            short[] gotos = reduce_tab[i];
            short[] candidates = new short[gotos.length / 2 - 1];
            int j = 0;
            while (j < candidates.length) {
                candidates[j] = gotos[j * 2];
                ++j;
            }
            ParseTable.nonTerminalCandidates[i] = candidates;
            ++i;
        }
    }

    protected final void printNonTermianlCandidates(int state) {
        short[] candidates = nonTerminalCandidates[state];
        int i = 0;
        while (i < candidates.length) {
            String nonTerminalName = NodeNameUtility.getNonterminalName(candidates[i]);
            System.out.println("Goto on " + nonTerminalName);
            ++i;
        }
    }

    protected final short[] getNonTerminalCandidates(int state) {
        return nonTerminalCandidates[state];
    }

    protected final short get_action(int state, int sym) {
        short[] row = action_tab[state];
        if (row.length < 20) {
            int probe = 0;
            while (probe < row.length) {
                short tag;
                if ((tag = row[probe++]) == sym || tag == -1) {
                    return row[probe];
                }
                ++probe;
            }
        } else {
            int first = 0;
            int last = (row.length - 1) / 2 - 1;
            while (first <= last) {
                int probe = (first + last) / 2;
                if (sym == row[probe * 2]) {
                    return row[probe * 2 + 1];
                }
                if (sym > row[probe * 2]) {
                    first = probe + 1;
                    continue;
                }
                last = probe - 1;
            }
            return row[row.length - 1];
        }
        return 0;
    }

    protected final short get_reduce(int state, int sym) {
        short[] row = reduce_tab[state];
        if (row == null) {
            return -1;
        }
        int probe = 0;
        while (probe < row.length) {
            short tag;
            if ((tag = row[probe++]) == sym || tag == -1) {
                return row[probe];
            }
            ++probe;
        }
        return -1;
    }
}

