/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Stack;
import java_cup.runtime.Symbol;
import org.eclipse.edt.compiler.core.ast.AbstractRecovery;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.ITokenStream;
import org.eclipse.edt.compiler.core.ast.ParseStack;
import org.eclipse.edt.compiler.core.ast.Terminal;

public class PreviousTerminalInsertionRecovery
extends AbstractRecovery {
    private int parseCheckDistance;
    private int missingTerminal;

    public PreviousTerminalInsertionRecovery(ParseStack errorStack, Stack realStack, ITokenStream tokenStream, ISyntaxErrorRequestor problemRequestor) {
        super(errorStack, realStack, tokenStream, problemRequestor);
    }

    @Override
    protected void performTrial() {
        ParseStack previousStack = this.errorStack.createCopy();
        Terminal previousTerminal = previousStack.undoLastTerminal();
        if (previousTerminal == null) {
            return;
        }
        short[] terminalCandidates = previousStack.getTerminalCandidates(previousStack.getCurrentState());
        int i = 0;
        while (i < terminalCandidates.length) {
            Terminal terminal = new Terminal(terminalCandidates[i], -1, -1, -1);
            ParseStack trialStack = previousStack.createCopy();
            trialStack.processLookAhead(terminal);
            if (trialStack.canShift(previousTerminal)) {
                trialStack.processLookAhead(previousTerminal);
                int trialDistance = trialStack.parseCheck(this.tokenStream);
                if (trialDistance > this.parseCheckDistance) {
                    this.parseCheckDistance = trialDistance;
                    this.missingTerminal = terminalCandidates[i];
                }
            }
            ++i;
        }
    }

    @Override
    public float getMisspellingIndex() {
        return 0.0f;
    }

    @Override
    public int getParseCheckDistance() {
        return this.parseCheckDistance;
    }

    @Override
    public int performRecovery() {
        Terminal previousTerminal = this.errorStack.undoLastTerminal();
        Symbol previousSymbol = (Symbol)this.realStack.peek();
        int errorStackTop = this.errorStack.getStackTop();
        int i = this.realStack.size();
        while (i > errorStackTop + 1) {
            this.realStack.pop();
            --i;
        }
        ((Symbol)this.realStack.peek()).parse_state = this.errorStack.getCurrentState();
        this.tokenStream.rollBack(previousTerminal, previousSymbol);
        Symbol symbol = new Symbol(this.missingTerminal);
        symbol.parse_state = -2;
        this.tokenStream.rollBack(new Terminal(this.missingTerminal, -1, -1, -1), symbol);
        this.problemRequestor.missingPreviousTerminal(this.missingTerminal, previousTerminal.left, previousTerminal.right);
        return 0;
    }
}

