/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.io.Serializable;
import java.util.ArrayList;

public class Primitive
implements Serializable {
    public static final int ANY_PRIMITIVE = 0;
    public static final Primitive ANY = new Primitive(0, "any");
    public static final int BIGINT_PRIMITIVE = 1;
    public static final Primitive BIGINT = new Primitive(1, "bigInt", 18);
    public static final int BIN_PRIMITIVE = 2;
    public static final Primitive BIN = new Primitive(2, "bin");
    public static final int BOOLEAN_PRIMITIVE = 3;
    public static final Primitive BOOLEAN = new Primitive(3, "boolean", 1);
    public static final int CHAR_PRIMITIVE = 4;
    public static final Primitive CHAR = new Primitive(4, "char");
    public static final int DBCHAR_PRIMITIVE = 5;
    public static final Primitive DBCHAR = new Primitive(5, "dbChar");
    public static final int DBCHARLIT_PRIMITIVE = 6;
    public static final Primitive DBCHARLIT = new Primitive(6, "dbChar");
    public static final int DECIMAL_PRIMITIVE = 7;
    public static final Primitive DECIMAL = new Primitive(7, "decimal");
    public static final int FLOAT_PRIMITIVE = 8;
    public static final Primitive FLOAT = new Primitive(8, "float", 8);
    public static final int HEX_PRIMITIVE = 9;
    public static final Primitive HEX = new Primitive(9, "hex");
    public static final int INT_PRIMITIVE = 10;
    public static final Primitive INT = new Primitive(10, "int", 9);
    public static final int MBCHAR_PRIMITIVE = 11;
    public static final Primitive MBCHAR = new Primitive(11, "mbChar");
    public static final int MONEY_PRIMITIVE = 12;
    public static final Primitive MONEY = new Primitive(12, "money", 16, 2);
    public static final int NUM_PRIMITIVE = 13;
    public static final Primitive NUM = new Primitive(13, "num");
    public static final int NUMBER_PRIMITIVE = 14;
    public static final Primitive NUMBER = new Primitive(14, "number");
    public static final int NUMC_PRIMITIVE = 15;
    public static final Primitive NUMC = new Primitive(15, "numc");
    public static final int PACF_PRIMITIVE = 16;
    public static final Primitive PACF = new Primitive(16, "pacf");
    public static final int SMALLFLOAT_PRIMITIVE = 17;
    public static final Primitive SMALLFLOAT = new Primitive(17, "smallFloat", 4);
    public static final int SMALLINT_PRIMITIVE = 18;
    public static final Primitive SMALLINT = new Primitive(18, "smallInt", 4);
    public static final int STRING_PRIMITIVE = 19;
    public static final Primitive STRING = new Primitive(19, "string");
    public static final int UNICODE_PRIMITIVE = 20;
    public static final Primitive UNICODE = new Primitive(20, "unicode");
    public static final int BLOB_PRIMITIVE = 21;
    public static final Primitive BLOB = new Primitive(21, "blob");
    public static final int CLOB_PRIMITIVE = 22;
    public static final Primitive CLOB = new Primitive(22, "clob");
    public static final int DATE_PRIMITIVE = 23;
    public static final Primitive DATE = new Primitive(23, "date", 8);
    public static final int MONTHSPAN_INTERVAL_PRIMITIVE = 24;
    public static final Primitive MONTHSPAN_INTERVAL = new Primitive(24, "interval", 7);
    public static final int SECONDSPAN_INTERVAL_PRIMITIVE = 25;
    public static final Primitive SECONDSPAN_INTERVAL = new Primitive(25, "interval", 7);
    public static final int INTERVAL_PRIMITIVE = 26;
    public static final Primitive INTERVAL = new Primitive(26, "interval", 7);
    public static final int TIME_PRIMITIVE = 27;
    public static final Primitive TIME = new Primitive(27, "time", 6);
    public static final int TIMESTAMP_PRIMITIVE = 28;
    public static final Primitive TIMESTAMP = new Primitive(28, "timeStamp", 14);
    private static Primitive[] types;
    private int type;
    private String name;
    private int defaultLength;
    private boolean hasDefaultLength;
    private int defaultDecimals;
    private boolean hasDefaultDecimals;

    static {
        ArrayList<Primitive> primitiveList = new ArrayList<Primitive>();
        primitiveList.add(ANY);
        primitiveList.add(BIGINT);
        primitiveList.add(BIN);
        primitiveList.add(BOOLEAN);
        primitiveList.add(CHAR);
        primitiveList.add(DBCHAR);
        primitiveList.add(DBCHARLIT);
        primitiveList.add(DECIMAL);
        primitiveList.add(FLOAT);
        primitiveList.add(HEX);
        primitiveList.add(INT);
        primitiveList.add(MBCHAR);
        primitiveList.add(MONEY);
        primitiveList.add(NUM);
        primitiveList.add(NUMBER);
        primitiveList.add(NUMC);
        primitiveList.add(PACF);
        primitiveList.add(SMALLFLOAT);
        primitiveList.add(SMALLINT);
        primitiveList.add(STRING);
        primitiveList.add(UNICODE);
        primitiveList.add(BLOB);
        primitiveList.add(CLOB);
        primitiveList.add(DATE);
        primitiveList.add(MONTHSPAN_INTERVAL);
        primitiveList.add(SECONDSPAN_INTERVAL);
        primitiveList.add(INTERVAL);
        primitiveList.add(TIME);
        primitiveList.add(TIMESTAMP);
        types = primitiveList.toArray(new Primitive[primitiveList.size()]);
    }

    private Primitive(int type, String name) {
        this.type = type;
        this.name = name;
    }

    private Primitive(int type, String name, int defaultLength) {
        this(type, name);
        this.defaultLength = defaultLength;
        this.hasDefaultLength = true;
    }

    private Primitive(int type, String name, int defaultLength, int defaultDecimals) {
        this(type, name, defaultLength);
        this.defaultDecimals = defaultDecimals;
        this.hasDefaultDecimals = true;
    }

    private Object readResolve() {
        return Primitive.getPrimitive(this.name);
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    private boolean isOfType(String type) {
        return this.getName().equalsIgnoreCase(type.trim());
    }

    public static Primitive getPrimitive(String type) {
        int i = 0;
        while (i < types.length) {
            if (types[i].isOfType(type)) {
                return types[i];
            }
            ++i;
        }
        return null;
    }

    public boolean hasDefaultLength() {
        return this.hasDefaultLength;
    }

    public int getDefaultLength() {
        if (this.hasDefaultLength) {
            return this.defaultLength;
        }
        throw new UnsupportedOperationException();
    }

    public boolean hasDefaultDecimals() {
        return this.hasDefaultDecimals;
    }

    public int getDefaultDecimals() {
        if (this.hasDefaultDecimals) {
            return this.defaultDecimals;
        }
        throw new UnsupportedOperationException();
    }

    public static boolean isIntegerType(Primitive prim) {
        return prim == SMALLINT || prim == INT || prim == BIGINT;
    }

    public static boolean isFloatType(Primitive prim) {
        return prim == SMALLFLOAT || prim == FLOAT;
    }

    public static boolean isNumericType(Primitive prim) {
        return prim == BIGINT || prim == BIN || prim == DECIMAL || prim == INT || prim == NUM || prim == NUMBER || prim == NUMC || prim == PACF || prim == SMALLINT || prim == FLOAT || prim == SMALLFLOAT || prim == MONEY;
    }

    public static boolean isStringType(Primitive prim) {
        return prim == CHAR || prim == DBCHAR || prim == DBCHARLIT || prim == HEX || prim == MBCHAR || prim == UNICODE || prim == STRING;
    }

    public static boolean isDateTimeType(Primitive prim) {
        return prim.getType() == DATE.getType() || prim.getType() == TIME.getType() || prim.getType() == TIMESTAMP.getType() || prim.getType() == MONTHSPAN_INTERVAL.getType() || prim.getType() == SECONDSPAN_INTERVAL.getType() || prim.getType() == INTERVAL.getType();
    }

    public static boolean isLargeObjectType(Primitive prim) {
        return prim.getType() == BLOB.getType() || prim.getType() == CLOB.getType();
    }

    public static boolean isLooseType(Primitive prim, int length) {
        if (prim == NUMBER) {
            return true;
        }
        return (prim == CHAR || prim == DBCHAR || prim == HEX || prim == DECIMAL || prim == UNICODE || prim == MBCHAR) && length == 0;
    }
}

