/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.edt.compiler.internal.EGLCaseInsensitiveComparator;
import org.eclipse.edt.compiler.internal.EGLSystemFunctionWord;
import org.eclipse.edt.compiler.internal.EGLSystemVariable;
import org.eclipse.edt.compiler.internal.EGLSystemWord;

public class EGLSystemWordHandler {
    static TreeMap systemWords;
    static TreeMap mathLibWords;
    static TreeMap strLibWords;
    static TreeMap sysLibWords;
    static TreeMap sysVarWords;
    static TreeMap consoleLibWords;
    static TreeMap reportLibWords;
    static TreeMap lobLibWords;
    static TreeMap dynArrayWords;
    static TreeMap dictionaryWords;
    static TreeMap recordWords;
    static TreeMap reportHandlerWords;
    static TreeMap birtHandlerWords;
    static TreeMap vgLibWords;
    static TreeMap vgVarWords;
    static TreeMap converseVarWords;
    static TreeMap javaLibWords;
    static TreeMap dateTimeLibWords;
    static TreeMap j2eeLibWords;
    static TreeMap converseLibWords;
    static TreeMap dliVarWords;
    static TreeMap dliLibWords;
    static TreeMap serviceLibWords;
    public static final int SYSTEM_WORD_NONE = 0;
    public static final int SYSTEM_WORD_VAGEN_COMPATIBILITY = 2;
    public static final int SYSTEM_WORD_CHARACTER = 4;
    public static final int SYSTEM_WORD_NUMERIC = 8;
    public static final int SYSTEM_WORD_DICTIONARY = 16;
    public static final int SYSTEM_WORD_NAMEDTYPE = 32;
    public static final int SYSTEM_WORD_REF = 64;
    public static final int SYSTEM_WORD_READ_ONLY = 128;
    public static final int SYSTEM_WORD_RETURNS = 256;
    public static final int SYSTEM_WORD_NO_RETURNS = 512;
    public static final int SYSTEM_WORD_PAGEHANDLER = 1024;
    public static final int SYSTEM_WORD_REPORTHANDLER = 2048;
    public static final int SYSTEM_WORD_RETURN_TYPE_IS_NULLABLE = 4096;
    public static final int SYSTEM_WORD_BIRTHANDLER = 8192;
    public static final int ARG_COUNT_N_OR_MORE = -1;
    public static final String mathLibrary = "mathLib";
    public static final String stringLibrary = "strLib";
    public static final String systemLibrary = "sysLib";
    public static final String systemVariablesLibrary = "sysVar";
    public static final String converseVariablesLibrary = "converseVar";
    public static final String dateTimeLibrary = "dateTimeLib";
    public static final String serviceLibrary = "serviceLib";
    public static final String dynamicArraySystemWord = "dynamicArray";
    public static final String dictionarySystemWord = "dictionary";
    public static final String recordSystemFunction = "record";
    public static final String arrayElement = "arrayElement";
    public static final String textField = "textField";
    public static final String identifier = "identifier";
    public static final String reportHandlerSystemFunction = "reportHandler";
    public static final String mnemonic = "mnemonic";
    public static final String vagText = "vagText";
    public static final String vagTextOrNumeric = "vagTextOrNumeric";
    public static final String anyEglPrimitive = "anyEglPrimitive";
    public static final String attribute = "attribute";
    public static final String itemOrRecord = "itemOrRecord";
    public static final String fixedOrFlexibleRecord = "fixedOrFlexibleRecord";
    public static final String serviceOrInterface = "serviceOrInterface";
    public static final String largeObjectSystemFunction = "largeObject";
    public static int INOUT;
    public static int IN;
    public static int OUT;

    static {
        INOUT = 0;
        IN = 1;
        OUT = 2;
        systemWords = new TreeMap(new EGLCaseInsensitiveComparator());
        mathLibWords = new TreeMap(new EGLCaseInsensitiveComparator());
        strLibWords = new TreeMap(new EGLCaseInsensitiveComparator());
        sysLibWords = new TreeMap(new EGLCaseInsensitiveComparator());
        sysVarWords = new TreeMap(new EGLCaseInsensitiveComparator());
        consoleLibWords = new TreeMap(new EGLCaseInsensitiveComparator());
        reportLibWords = new TreeMap(new EGLCaseInsensitiveComparator());
        lobLibWords = new TreeMap(new EGLCaseInsensitiveComparator());
        vgLibWords = new TreeMap(new EGLCaseInsensitiveComparator());
        vgVarWords = new TreeMap(new EGLCaseInsensitiveComparator());
        converseVarWords = new TreeMap(new EGLCaseInsensitiveComparator());
        javaLibWords = new TreeMap(new EGLCaseInsensitiveComparator());
        dateTimeLibWords = new TreeMap(new EGLCaseInsensitiveComparator());
        j2eeLibWords = new TreeMap(new EGLCaseInsensitiveComparator());
        converseLibWords = new TreeMap(new EGLCaseInsensitiveComparator());
        dynArrayWords = new TreeMap(new EGLCaseInsensitiveComparator());
        dictionaryWords = new TreeMap(new EGLCaseInsensitiveComparator());
        recordWords = new TreeMap(new EGLCaseInsensitiveComparator());
        reportHandlerWords = new TreeMap(new EGLCaseInsensitiveComparator());
        dliVarWords = new TreeMap(new EGLCaseInsensitiveComparator());
        dliLibWords = new TreeMap(new EGLCaseInsensitiveComparator());
        serviceLibWords = new TreeMap(new EGLCaseInsensitiveComparator());
        systemWords.put(mathLibrary, mathLibWords);
        systemWords.put(stringLibrary, strLibWords);
        systemWords.put(systemLibrary, sysLibWords);
        systemWords.put(systemVariablesLibrary, sysVarWords);
        systemWords.put(dateTimeLibrary, dateTimeLibWords);
        systemWords.put(converseVariablesLibrary, converseVarWords);
        systemWords.put(dynamicArraySystemWord, dynArrayWords);
        systemWords.put(dictionarySystemWord, dictionaryWords);
        systemWords.put(recordSystemFunction, recordWords);
        systemWords.put(reportHandlerSystemFunction, reportHandlerWords);
        systemWords.put(serviceLibrary, serviceLibWords);
        mathLibWords.put("abs", new EGLSystemFunctionWord("abs", 256, 1, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("acos", new EGLSystemFunctionWord("acos", 256, 2, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("asin", new EGLSystemFunctionWord("asin", 256, 4, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("atan", new EGLSystemFunctionWord("atan", 256, 5, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("atan2", new EGLSystemFunctionWord("atan2", 256, 6, mathLibrary, "NUMBER", 9, new String[]{"numericItem1", "numericItem2"}, new String[]{"NUMBER", "NUMBER"}, new int[]{INOUT, INOUT}, new int[]{2}));
        mathLibWords.put("ceiling", new EGLSystemFunctionWord("ceiling", 256, 7, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("compareNum", new EGLSystemFunctionWord("compareNum", 256, 8, mathLibrary, "INT", 9, new String[]{"numericItem1", "numericItem2"}, new String[]{"NUMBER", "NUMBER"}, new int[]{INOUT, INOUT}, new int[]{2}));
        mathLibWords.put("cos", new EGLSystemFunctionWord("cos", 256, 9, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("cosh", new EGLSystemFunctionWord("cosh", 256, 10, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("exp", new EGLSystemFunctionWord("exp", 256, 11, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("floatingAssign", new EGLSystemFunctionWord("floatingAssign", 256, 12, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("floatingDifference", new EGLSystemFunctionWord("floatingDifference", 256, 13, mathLibrary, "NUMBER", 9, new String[]{"numericItem1", "numericItem2"}, new String[]{"NUMBER", "NUMBER"}, new int[]{INOUT, INOUT}, new int[]{2}));
        mathLibWords.put("floatingMod", new EGLSystemFunctionWord("floatingMod", 256, 14, mathLibrary, "NUMBER", 9, new String[]{"numericItem1", "numericItem2"}, new String[]{"NUMBER", "NUMBER"}, new int[]{INOUT, INOUT}, new int[]{2}));
        mathLibWords.put("floatingProduct", new EGLSystemFunctionWord("floatingProduct", 256, 15, mathLibrary, "NUMBER", 9, new String[]{"numericItem1", "numericItem2"}, new String[]{"NUMBER", "NUMBER"}, new int[]{INOUT, INOUT}, new int[]{2}));
        mathLibWords.put("floatingQuotient", new EGLSystemFunctionWord("floatingQuotient", 256, 16, mathLibrary, "NUMBER", 9, new String[]{"numericItem1", "numericItem2"}, new String[]{"NUMBER", "NUMBER"}, new int[]{INOUT, INOUT}, new int[]{2}));
        mathLibWords.put("floatingSum", new EGLSystemFunctionWord("floatingSum", 256, 17, mathLibrary, "NUMBER", 9, new String[]{"numericItem1", "numericItem2"}, new String[]{"NUMBER", "NUMBER"}, new int[]{INOUT, INOUT}, new int[]{2}));
        mathLibWords.put("floor", new EGLSystemFunctionWord("floor", 256, 18, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("frexp", new EGLSystemFunctionWord("frexp", 256, 19, mathLibrary, "NUMBER", 9, new String[]{"numericItem", "integerExponent"}, new String[]{"NUMBER", "INT"}, new int[]{INOUT, IN}, new int[]{2}));
        mathLibWords.put("ldexp", new EGLSystemFunctionWord("ldexp", 256, 20, mathLibrary, "NUMBER", 9, new String[]{"numericItem", "integer"}, new String[]{"NUMBER", "INT"}, new int[]{INOUT, IN}, new int[]{2}));
        mathLibWords.put("log", new EGLSystemFunctionWord("log", 256, 21, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("log10", new EGLSystemFunctionWord("log10", 256, 22, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("maximum", new EGLSystemFunctionWord("maximum", 256, 23, mathLibrary, "NUMBER", 9, new String[]{"numericItem1", "numericItem2"}, new String[]{"NUMBER", "NUMBER"}, new int[]{INOUT, INOUT}, new int[]{2}));
        mathLibWords.put("minimum", new EGLSystemFunctionWord("minimum", 256, 24, mathLibrary, "NUMBER", 9, new String[]{"numericItem1", "numericItem2"}, new String[]{"NUMBER", "NUMBER"}, new int[]{INOUT, INOUT}, new int[]{2}));
        mathLibWords.put("modf", new EGLSystemFunctionWord("modf", 256, 25, mathLibrary, "NUMBER", 9, new String[]{"numericItem", "integerNumericItem"}, new String[]{"NUMBER", "NUMBER"}, new int[]{INOUT, INOUT}, new int[]{2}));
        mathLibWords.put("pow", new EGLSystemFunctionWord("pow", 256, 26, mathLibrary, "NUMBER", 9, new String[]{"numericItem1", "numericItem2"}, new String[]{"NUMBER", "NUMBER"}, new int[]{INOUT, INOUT}, new int[]{2}));
        mathLibWords.put("precision", new EGLSystemFunctionWord("precision", 256, 27, mathLibrary, "BIN", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("round", new EGLSystemFunctionWord("round", 256, 28, mathLibrary, "NUMBER", 9, new String[]{"numericExpression", "power"}, new String[]{"NUMBER", "INT"}, new int[]{IN, INOUT}, new int[]{1, 2}));
        mathLibWords.put("sin", new EGLSystemFunctionWord("sin", 256, 29, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("sinh", new EGLSystemFunctionWord("sinh", 256, 30, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("sqrt", new EGLSystemFunctionWord("sqrt", 256, 31, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("tan", new EGLSystemFunctionWord("tan", 256, 32, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("tanh", new EGLSystemFunctionWord("tanh", 256, 33, mathLibrary, "NUMBER", 9, new String[]{"numericItem"}, new String[]{"NUMBER"}, new int[]{INOUT}, new int[]{1}));
        mathLibWords.put("stringAsInt", new EGLSystemFunctionWord("stringAsInt", 4352, 34, mathLibrary, "BIGINT", 18, new String[]{"numberAsText"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        mathLibWords.put("stringAsDecimal", new EGLSystemFunctionWord("stringAsDecimal", 4352, 35, mathLibrary, "NUMBER", 0, new String[]{"numberAsText"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        mathLibWords.put("stringAsFloat", new EGLSystemFunctionWord("stringAsFloat", 4352, 36, mathLibrary, "FLOAT", 8, new String[]{"numberAsText"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        strLibWords.put("compareStr", new EGLSystemFunctionWord("compareStr", 256, 50, stringLibrary, "BIN", 9, new String[]{"targetString", "targetIndex", "targetLength", "sourceString", "sourceIndex", "sourceLength"}, new String[]{vagText, "INT", "INT", vagText, "INT", "INT"}, new int[]{IN, IN, IN, IN, IN, IN}, new int[]{6}));
        strLibWords.put("concatenate", new EGLSystemFunctionWord("concatenate", 256, 51, stringLibrary, "BIN", 9, new String[]{"targetString", "sourceString"}, new String[]{vagText, vagText}, new int[]{INOUT, IN}, new int[]{2}));
        strLibWords.put("concatenateWithSeparator", new EGLSystemFunctionWord("concatenateWithSeparator", 256, 52, stringLibrary, "BIN", 9, new String[]{"targetString", "sourceString", "separatorString"}, new String[]{vagText, vagText, vagText}, new int[]{INOUT, IN, IN}, new int[]{3}));
        strLibWords.put("copyStr", new EGLSystemFunctionWord("copyStr", 0, 53, stringLibrary, null, 0, new String[]{"targetString", "targetIndex", "targetLength", "sourceString", "sourceIndex", "sourceLength"}, new String[]{vagText, "INT", "INT", vagText, "INT", "INT"}, new int[]{INOUT, IN, IN, IN, IN, IN}, new int[]{6}));
        strLibWords.put("findStr", new EGLSystemFunctionWord("findStr", 256, 54, stringLibrary, "BIN", 9, new String[]{"sourceString", "sourceIndex", "sourceLength", "searchString"}, new String[]{vagText, "INT", "INT", vagText}, new int[]{IN, INOUT, IN, IN}, new int[]{4}));
        strLibWords.put("getNextToken", new EGLSystemFunctionWord("getNextToken", 256, 55, stringLibrary, "BIN", 9, new String[]{"targetString", "sourceString", "sourceIndex", "sourceLength", "characterDelimiters"}, new String[]{vagText, vagText, "INT", "INT", vagText}, new int[]{INOUT, IN, INOUT, INOUT, IN}, new int[]{5}));
        strLibWords.put("setBlankTerminator", new EGLSystemFunctionWord("setBlankTerminator", 0, 56, stringLibrary, null, 0, new String[]{"targetString"}, new String[]{vagText}, new int[]{INOUT}, new int[]{1}));
        strLibWords.put("setNullTerminator", new EGLSystemFunctionWord("setNullTerminator", 0, 57, stringLibrary, null, 0, new String[]{"targetString"}, new String[]{vagText}, new int[]{INOUT}, new int[]{1}));
        strLibWords.put("setSubStr", new EGLSystemFunctionWord("setSubStr", 0, 58, stringLibrary, null, 0, new String[]{"targetString", "targetIndex", "targetLength", "sourceCharacter"}, new String[]{vagText, "INT", "INT", vagText}, new int[]{INOUT, IN, IN, IN}, new int[]{4}));
        strLibWords.put("strLen", new EGLSystemFunctionWord("strLen", 256, 59, stringLibrary, "BIN", 9, new String[]{"sourceString"}, new String[]{vagText}, new int[]{IN}, new int[]{1}));
        strLibWords.put("textLen", new EGLSystemFunctionWord("textLen", 256, 60, stringLibrary, "INT", 0, new String[]{"aString"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        strLibWords.put("characterAsInt", new EGLSystemFunctionWord("characterAsInt", 256, 209, stringLibrary, "INT", 0, new String[]{"characterExpression"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        strLibWords.put("clip", new EGLSystemFunctionWord("clip", 256, 200, stringLibrary, "STRING", 0, new String[]{"text"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        strLibWords.put("formatNumber", new EGLSystemFunctionWord("formatNumber", 256, 203, stringLibrary, "STRING", 0, new String[]{"numericExpression", "numericFormat"}, new String[]{"NUMBER", "STRING"}, new int[]{IN, IN}, new int[]{1, 2}));
        strLibWords.put("integerAsChar", new EGLSystemFunctionWord("integerAsChar", 256, 204, stringLibrary, "STRING", 0, new String[]{"integerExpression"}, new String[]{"INT"}, new int[]{IN}, new int[]{1}));
        strLibWords.put("lowerCase", new EGLSystemFunctionWord("lowerCase", 256, 205, stringLibrary, "STRING", 0, new String[]{"characterItem"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        strLibWords.put("spaces", new EGLSystemFunctionWord("spaces", 256, 206, stringLibrary, "STRING", 0, new String[]{"characterCount"}, new String[]{"INT"}, new int[]{IN}, new int[]{1}));
        strLibWords.put("upperCase", new EGLSystemFunctionWord("upperCase", 256, 207, stringLibrary, "STRING", 0, new String[]{"characterItem"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        strLibWords.put("formatDate", new EGLSystemFunctionWord("formatDate", 256, 218, stringLibrary, "STRING", 0, new String[]{"inputItem", "characterDateFormat"}, new String[]{"DATE", "STRING"}, new int[]{IN, IN}, new int[]{1, 2}));
        strLibWords.put("formatTime", new EGLSystemFunctionWord("formatTime", 256, 219, stringLibrary, "STRING", 0, new String[]{"inputItem", "characterTimeFormat"}, new String[]{"TIME", "STRING"}, new int[]{IN, IN}, new int[]{1, 2}));
        strLibWords.put("formatTimeStamp", new EGLSystemFunctionWord("formatTimeStamp", 256, 220, stringLibrary, "STRING", 0, new String[]{"inputItem", "timeStampFormat"}, new String[]{"TIMESTAMP_F6", "STRING"}, new int[]{IN, IN}, new int[]{1, 2}));
        strLibWords.put("isoDateFormat", new EGLSystemVariable("isoDateFormat", 132, 770, "CHAR", 10, stringLibrary));
        strLibWords.put("usaDateFormat", new EGLSystemVariable("usaDateFormat", 132, 771, "CHAR", 10, stringLibrary));
        strLibWords.put("eurDateFormat", new EGLSystemVariable("eurDateFormat", 132, 772, "CHAR", 10, stringLibrary));
        strLibWords.put("jisDateFormat", new EGLSystemVariable("jisDateFormat", 132, 773, "CHAR", 10, stringLibrary));
        strLibWords.put("isoTimeFormat", new EGLSystemVariable("isoTimeFormat", 132, 774, "CHAR", 8, stringLibrary));
        strLibWords.put("usaTimeFormat", new EGLSystemVariable("usaTimeFormat", 132, 775, "CHAR", 8, stringLibrary));
        strLibWords.put("eurTimeFormat", new EGLSystemVariable("eurTimeFormat", 132, 776, "CHAR", 8, stringLibrary));
        strLibWords.put("jisTimeFormat", new EGLSystemVariable("jisTimeFormat", 132, 777, "CHAR", 8, stringLibrary));
        strLibWords.put("db2TimeStampFormat", new EGLSystemVariable("db2TimeStampFormat", 132, 778, "CHAR", 26, stringLibrary));
        strLibWords.put("odbcTimeStampFormat", new EGLSystemVariable("odbcTimeStampFormat", 132, 779, "CHAR", 26, stringLibrary));
        strLibWords.put("defaultDateFormat", new EGLSystemVariable("defaultDateFormat", 4, 783, "STRING", 0, stringLibrary));
        strLibWords.put("defaultTimeFormat", new EGLSystemVariable("defaultTimeFormat", 4, 784, "STRING", 0, stringLibrary));
        strLibWords.put("defaultTimeStampFormat", new EGLSystemVariable("defaultTimeStampFormat", 4, 785, "STRING", 0, stringLibrary));
        strLibWords.put("defaultMoneyFormat", new EGLSystemVariable("defaultMoneyFormat", 4, 786, "STRING", 0, stringLibrary));
        strLibWords.put("defaultNumericFormat", new EGLSystemVariable("defaultNumericFormat", 4, 787, "STRING", 0, stringLibrary));
        dynArrayWords.put("appendElement", new EGLSystemFunctionWord("appendElement", 0, 170, dynamicArraySystemWord, null, 0, new String[]{"appendElement"}, new String[]{arrayElement}, new int[]{IN}, new int[]{1}));
        dynArrayWords.put("appendAll", new EGLSystemFunctionWord("appendAll", 0, 171, dynamicArraySystemWord, null, 0, new String[]{"array"}, new String[]{"arrayElement[]"}, new int[]{IN}, new int[]{1}));
        dynArrayWords.put("insertElement", new EGLSystemFunctionWord("insertElement", 0, 172, dynamicArraySystemWord, null, 0, new String[]{"insertElement", "arrayIndex"}, new String[]{arrayElement, "INT"}, new int[]{IN, IN}, new int[]{2}));
        dynArrayWords.put("removeElement", new EGLSystemFunctionWord("removeElement", 0, 173, dynamicArraySystemWord, null, 0, new String[]{"arrayIndex"}, new String[]{"INT"}, new int[]{IN}, new int[]{1}));
        dynArrayWords.put("removeAll", new EGLSystemFunctionWord("removeAll", 0, 174, dynamicArraySystemWord, null, 0, new String[0], new String[0], new int[0], new int[1]));
        dynArrayWords.put("resize", new EGLSystemFunctionWord("resize", 0, 175, dynamicArraySystemWord, null, 0, new String[]{"newDimension"}, new String[]{"INT"}, new int[]{IN}, new int[]{1}));
        dynArrayWords.put("resizeAll", new EGLSystemFunctionWord("resizeAll", 0, 176, dynamicArraySystemWord, null, 0, new String[]{"newDimensions"}, new String[]{"INT[]"}, new int[]{IN}, new int[]{1}));
        dynArrayWords.put("setMaxSize", new EGLSystemFunctionWord("setMaxSize", 0, 177, dynamicArraySystemWord, null, 0, new String[]{"maxSize"}, new String[]{"INT"}, new int[]{IN}, new int[]{1}));
        dynArrayWords.put("setMaxSizes", new EGLSystemFunctionWord("setMaxSizes", 0, 178, dynamicArraySystemWord, null, 0, new String[]{"maxSizes"}, new String[]{"INT[]"}, new int[]{IN}, new int[]{1}));
        dynArrayWords.put("getSize", new EGLSystemFunctionWord("getSize", 256, 179, dynamicArraySystemWord, "BIN", 9, new String[0], new String[0], new int[0], new int[1]));
        dynArrayWords.put("getMaxSize", new EGLSystemFunctionWord("getMaxSize", 256, 180, dynamicArraySystemWord, "BIN", 9, new String[0], new String[0], new int[0], new int[1]));
        dynArrayWords.put("setElementsEmpty", new EGLSystemFunctionWord("setElementsEmpty", 0, 181, dynamicArraySystemWord, null, 0, new String[0], new String[0], new int[0], new int[1]));
        dictionaryWords.put("containsKey", new EGLSystemFunctionWord("containsKey", 256, 250, dictionarySystemWord, "BOOLEAN", 0, new String[]{"key"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        dictionaryWords.put("getKeys", new EGLSystemFunctionWord("getKeys", 256, 251, dictionarySystemWord, "STRING[]", 0, new String[0], new String[0], new int[0], new int[1]));
        dictionaryWords.put("getValues", new EGLSystemFunctionWord("getValues", 256, 252, dictionarySystemWord, "ANY[]", 0, new String[0], new String[0], new int[0], new int[1]));
        dictionaryWords.put("insertAll", new EGLSystemFunctionWord("insertAll", 0, 253, dictionarySystemWord, null, 0, new String[]{dictionarySystemWord}, new String[]{"DICTIONARY"}, new int[]{IN}, new int[]{1}));
        dictionaryWords.put("removeElement", new EGLSystemFunctionWord("removeElement", 0, 254, dictionarySystemWord, null, 0, new String[]{"key"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        dictionaryWords.put("removeAll", new EGLSystemFunctionWord("removeAll", 0, 255, dictionarySystemWord, null, 0, new String[0], new String[0], new int[0], new int[1]));
        dictionaryWords.put("size", new EGLSystemFunctionWord("size", 256, 256, dictionarySystemWord, "BIN", 9, new String[0], new String[0], new int[0], new int[1]));
        sysLibWords.put("commit", new EGLSystemFunctionWord("commit", 0, 73, systemLibrary, null, 0, new String[0], new String[0], new int[0], new int[1]));
        sysLibWords.put("connect", new EGLSystemFunctionWord("connect", 0, 74, systemLibrary, null, 0, new String[]{"database", "userid", "password", "commitScope", "disconnectOption", "isolationLevel", "commitControl"}, new String[]{"STRING", "STRING", "STRING", mnemonic, mnemonic, mnemonic, mnemonic}, new int[]{IN, IN, IN, IN, IN, IN, IN}, new int[]{3, 4, 5, 6, 7}));
        int[] nArray = new int[2];
        nArray[1] = 1;
        sysLibWords.put("disconnect", new EGLSystemFunctionWord("disconnect", 0, 117, systemLibrary, null, 0, new String[]{"database"}, new String[]{"STRING"}, new int[]{IN}, nArray));
        sysLibWords.put("disconnectAll", new EGLSystemFunctionWord("disconnectAll", 0, 118, systemLibrary, null, 0, new String[0], new String[0], new int[0], new int[1]));
        sysLibWords.put("rollback", new EGLSystemFunctionWord("rollback", 0, 96, systemLibrary, null, 0, new String[0], new String[0], new int[0], new int[1]));
        sysLibWords.put("queryCurrentDatabase", new EGLSystemFunctionWord("queryCurrentDatabase", 0, 119, systemLibrary, null, 0, new String[]{"product", "release"}, new String[]{"CHAR8", "CHAR8"}, new int[]{IN, IN}, new int[]{2}));
        sysLibWords.put("setCurrentDatabase", new EGLSystemFunctionWord("setCurrentDatabase", 0, 120, systemLibrary, null, 0, new String[]{"database"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        sysLibWords.put("beginDatabaseTransaction", new EGLSystemFunctionWord("beginDatabaseTransaction", 0, 125, systemLibrary, null, 0, new String[]{"databaseName"}, new String[]{"STRING"}, new int[]{IN}, nArray2));
        sysLibWords.put("defineDatabaseAlias", new EGLSystemFunctionWord("defineDatabaseAlias", 0, 126, systemLibrary, null, 0, new String[]{"alias", "databaseName"}, new String[]{"STRING", "STRING"}, new int[]{IN, IN}, new int[]{2}));
        sysLibWords.put("audit", new EGLSystemFunctionWord("audit", 0, 103, systemLibrary, null, 0, new String[]{recordSystemFunction, "jid"}, new String[]{recordSystemFunction, "SMALLINT"}, new int[]{IN, IN}, new int[]{1, 2}));
        sysLibWords.put("bytes", new EGLSystemFunctionWord("bytes", 256, 71, systemLibrary, "BIN", 9, new String[]{itemOrRecord}, new String[]{itemOrRecord}, new int[]{IN}, new int[]{1}));
        sysLibWords.put("calculateChkDigitMod10", new EGLSystemFunctionWord("calculateChkDigitMod10", 0, 82, systemLibrary, null, 0, new String[]{"input", "length", "result"}, new String[]{"CHAR", "INT", "SMALLINT"}, new int[]{INOUT, IN, INOUT}, new int[]{3}));
        sysLibWords.put("calculateChkDigitMod11", new EGLSystemFunctionWord("calculateChkDigitMod11", 0, 121, systemLibrary, null, 0, new String[]{"input", "length", "result"}, new String[]{"CHAR", "INT", "SMALLINT"}, new int[]{INOUT, IN, INOUT}, new int[]{3}));
        sysLibWords.put("convert", new EGLSystemFunctionWord("convert", 0, 76, systemLibrary, null, 0, new String[]{"target", "direction", "conversionTable"}, new String[]{identifier, "STRING", "CHAR"}, new int[]{INOUT, IN, IN}, new int[]{1, 2, 3}));
        sysLibWords.put("purge", new EGLSystemFunctionWord("purge", 0, 95, systemLibrary, null, 0, new String[]{"queueName"}, new String[]{"CHAR"}, new int[]{IN}, new int[]{1}));
        sysLibWords.put("setError", new EGLSystemFunctionWord("setError", 0, 100, systemLibrary, null, 0, new String[]{"messageText", "messageKey", "inserts"}, new String[]{"CHAR", "STRING", "STRING"}, new int[]{IN, IN, IN}, new int[]{-1, 1}));
        sysLibWords.put("setLocale", new EGLSystemFunctionWord("setLocale", 0, 101, systemLibrary, null, 0, new String[]{"languageCode", "countryCode", "variant"}, new String[]{"CHAR2", "CHAR2", "CHAR2"}, new int[]{IN, IN, IN}, new int[]{2, 3}));
        sysLibWords.put("setRemoteUser", new EGLSystemFunctionWord("setRemoteUser", 0, 106, systemLibrary, null, 0, new String[]{"userid", "password"}, new String[]{"STRING", "STRING"}, new int[]{IN, IN}, new int[]{2}));
        sysLibWords.put("startTransaction", new EGLSystemFunctionWord("startTransaction", 0, 104, systemLibrary, null, 0, new String[]{"request", "prid", "termid"}, new String[]{recordSystemFunction, anyEglPrimitive, "CHAR"}, new int[]{IN, IN, IN}, new int[]{1, 2, 3}));
        sysLibWords.put("verifyChkDigitMod10", new EGLSystemFunctionWord("verifyChkDigitMod10", 0, 77, systemLibrary, null, 0, new String[]{"input", "length", "result"}, new String[]{"CHAR", "INT", "SMALLINT"}, new int[]{INOUT, IN, INOUT}, new int[]{3}));
        sysLibWords.put("verifyChkDigitMod11", new EGLSystemFunctionWord("verifyChkDigitMod11", 0, 78, systemLibrary, null, 0, new String[]{"input", "length", "result"}, new String[]{"CHAR", "INT", "SMALLINT"}, new int[]{INOUT, IN, INOUT}, new int[]{3}));
        sysLibWords.put("wait", new EGLSystemFunctionWord("wait", 0, 102, systemLibrary, null, 0, new String[]{"seconds"}, new String[]{"BIN9_2"}, new int[]{IN}, new int[]{1}));
        sysLibWords.put("maximumSize", new EGLSystemFunctionWord("maximumSize", 256, 124, systemLibrary, "BIN", 9, new String[]{dynamicArraySystemWord}, new String[]{"DYNAMICARRAY"}, new int[]{IN}, new int[]{1}));
        sysLibWords.put("size", new EGLSystemFunctionWord("size", 256, 123, systemLibrary, "BIN", 9, new String[]{"arrayOrTable"}, new String[]{"ARRAYORTABLE"}, new int[]{IN}, new int[]{1}));
        sysLibWords.put("callCmd", new EGLSystemFunctionWord("callCmd", 0, 208, systemLibrary, null, 0, new String[]{"commandString", "modeString"}, new String[]{"STRING", "STRING"}, new int[]{IN, IN}, new int[]{1, 2}));
        sysLibWords.put("getCmdLineArgCount", new EGLSystemFunctionWord("getCmdLineArgCount", 256, 210, systemLibrary, "INT", 0, new String[0], new String[0], new int[0], new int[1]));
        sysLibWords.put("getCmdLineArg", new EGLSystemFunctionWord("getCmdLineArg", 256, 211, systemLibrary, "STRING", 0, new String[]{"index"}, new String[]{"INT"}, new int[]{IN}, new int[]{1}));
        sysLibWords.put("startCmd", new EGLSystemFunctionWord("startCmd", 0, 212, systemLibrary, null, 0, new String[]{"commandString", "modeString"}, new String[]{"STRING", "STRING"}, new int[]{IN, IN}, new int[]{1, 2}));
        sysLibWords.put("loadTable", new EGLSystemFunctionWord("loadTable", 0, 213, systemLibrary, null, 0, new String[]{"filename", "insertIntoClause", "delimiter"}, new String[]{"STRING", "STRING", "STRING"}, new int[]{IN, IN, IN}, new int[]{2, 3}));
        sysLibWords.put("unloadTable", new EGLSystemFunctionWord("unloadTable", 0, 214, systemLibrary, null, 0, new String[]{"filename", "selectStatement", "delimiter"}, new String[]{"STRING", "STRING", "STRING"}, new int[]{IN, IN, IN}, new int[]{2, 3}));
        sysLibWords.put("getProperty", new EGLSystemFunctionWord("getProperty", 256, 216, systemLibrary, "STRING", 0, new String[]{"textVariableOrLiteral "}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        sysLibWords.put("writeStdout", new EGLSystemFunctionWord("writeStdout", 0, 198, systemLibrary, null, 0, new String[]{"text"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        sysLibWords.put("writeStderr", new EGLSystemFunctionWord("writeStderr", 0, 199, systemLibrary, null, 0, new String[]{"text"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        sysLibWords.put("currentException", new EGLSystemVariable("currentException", 16, 790, "DICTIONARY", 0, systemLibrary.toLowerCase()));
        sysLibWords.put("getMessage", new EGLSystemFunctionWord("getMessage", 256, 128, systemLibrary, "STRING", 0, new String[]{"key", "inserts"}, new String[]{"STRING", "STRING[]"}, new int[]{IN, IN}, new int[]{1, 2}));
        sysLibWords.put("startLog", new EGLSystemFunctionWord("startLog", 0, 440, systemLibrary, null, 0, new String[]{"filename"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        sysLibWords.put("errorLog", new EGLSystemFunctionWord("errorLog", 0, 441, systemLibrary, null, 0, new String[]{"errorMessage"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        sysLibWords.put("conditionAsInt", new EGLSystemFunctionWord("conditionAsInt", 256, 129, systemLibrary, "SMALLINT", 4, new String[]{"errorMessage"}, new String[]{"BOOLEAN"}, new int[]{IN}, new int[]{1}));
        sysVarWords.put("arrayIndex", new EGLSystemVariable("arrayIndex", 8, 741, "BIN", 9));
        sysVarWords.put("callConversionTable", new EGLSystemVariable("callConversionTable", 4, 763, "CHAR", 8));
        sysVarWords.put("sessionId", new EGLSystemVariable("sessionId", 132, 739, "CHAR", 8));
        sysVarWords.put("errorCode", new EGLSystemVariable("errorCode", 4, 729, "CHAR", 8));
        sysVarWords.put("formConversionTable", new EGLSystemVariable("formConversionTable", 4, 764, "CHAR", 8));
        recordWords.put("resourceAssociation", new EGLSystemVariable("resourceAssociation", 4, 752, "CHAR", 65, recordSystemFunction));
        sysVarWords.put("overflowIndicator", new EGLSystemVariable("overflowIndicator", 8, 725, "NUM", 1));
        sysVarWords.put("remoteSystemId", new EGLSystemVariable("remoteSystemId", 4, 719, "CHAR", 8));
        sysVarWords.put("returnCode", new EGLSystemVariable("returnCode", 8, 726, "BIN", 9));
        sysVarWords.put("conversationId", new EGLSystemVariable("conversationId", 132, 720, "CHAR", 8));
        sysVarWords.put("sqlca", new EGLSystemVariable("sqlca", 0, 733, "HEX", 136));
        sysVarWords.put("sqlcode", new EGLSystemVariable("sqlcode", 8, 732, "BIN", 9));
        sysVarWords.put("sqlState", new EGLSystemVariable("sqlState", 4, 748, "CHAR", 5));
        sysVarWords.put("systemType", new EGLSystemVariable("systemType", 132, 738, "CHAR", 8));
        sysVarWords.put("terminalId", new EGLSystemVariable("terminalId", 132, 721, "CHAR", 8));
        sysVarWords.put("transactionId", new EGLSystemVariable("transactionId", 4, 731, "CHAR", 50));
        sysVarWords.put("transferName", new EGLSystemVariable("transferName", 4, 715, "CHAR", 8));
        sysVarWords.put("userId", new EGLSystemVariable("userId", 132, 740, "CHAR", 8));
        converseVarWords.put("eventKey", new EGLSystemVariable("eventKey", 132, 742, "CHAR", 8, converseVariablesLibrary));
        converseVarWords.put("printerAssociation", new EGLSystemVariable("printerAssociation", 4, 744, "CHAR", 50, converseVariablesLibrary));
        converseVarWords.put("segmentedMode", new EGLSystemVariable("segmentedMode", 10, 751, "BIN", 9, converseVariablesLibrary));
        converseVarWords.put("validationMsgNum", new EGLSystemVariable("validationMsgNum", 8, 750, "BIN", 9, converseVariablesLibrary));
        converseVarWords.put("commitOnConverse", new EGLSystemVariable("commitOnConverse", 10, 716, "NUM", 1, converseVariablesLibrary));
        dateTimeLibWords.put("currentDate", new EGLSystemFunctionWord("currentDate", 256, 229, dateTimeLibrary, "DATE", 8, new String[0], new String[0], new int[0], new int[1]));
        dateTimeLibWords.put("currentTime", new EGLSystemFunctionWord("currentTime", 256, 227, dateTimeLibrary, "TIME", 6, new String[0], new String[0], new int[0], new int[1]));
        dateTimeLibWords.put("currentTimeStamp", new EGLSystemFunctionWord("currentTimeStamp", 256, 762, dateTimeLibrary, "TIMESTAMP_F6", 20, new String[0], new String[0], new int[0], new int[1]));
        dateTimeLibWords.put("dateValue", new EGLSystemFunctionWord("dateValue", 256, 230, dateTimeLibrary, "DATE", 8, new String[]{"characterExpression"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        dateTimeLibWords.put("dateValueFromGregorian", new EGLSystemFunctionWord("dateValueFromGregorian", 256, 231, dateTimeLibrary, "DATE", 8, new String[]{"gregorianDateAsInteger"}, new String[]{"INT"}, new int[]{IN}, new int[]{1}));
        dateTimeLibWords.put("dateValueFromJulian", new EGLSystemFunctionWord("dateValueFromJulian", 256, 232, dateTimeLibrary, "DATE", 8, new String[]{"julianDateAsInteger"}, new String[]{"INT"}, new int[]{IN}, new int[]{1}));
        dateTimeLibWords.put("timeValue", new EGLSystemFunctionWord("timeValue", 256, 233, dateTimeLibrary, "TIME", 6, new String[]{"characterExpression"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        dateTimeLibWords.put("intervalValue", new EGLSystemFunctionWord("intervalValue", 256, 234, dateTimeLibrary, "INTERVAL", 28, new String[]{"characterExpression"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        dateTimeLibWords.put("intervalValueWithPattern", new EGLSystemFunctionWord("intervalValueWithPattern", 256, 235, dateTimeLibrary, "INTERVAL", 28, new String[]{"characterExpression", "intervalPattern"}, new String[]{"STRING", "STRING"}, new int[]{IN, IN}, new int[]{1, 2}));
        dateTimeLibWords.put("timeStampValue", new EGLSystemFunctionWord("timeStampValue", 256, 236, dateTimeLibrary, "TIMESTAMP_F6", 20, new String[]{"characterExpression"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        dateTimeLibWords.put("timeStampValueWithPattern", new EGLSystemFunctionWord("timeStampValueWithPattern", 256, 237, dateTimeLibrary, "TIMESTAMP", 20, new String[]{"characterExpression", "timeSpanPattern"}, new String[]{"STRING", "STRING"}, new int[]{IN, IN}, new int[]{1, 2}));
        dateTimeLibWords.put("timestampFrom", new EGLSystemFunctionWord("timestampFrom", 256, 238, dateTimeLibrary, "TIMESTAMP_F6", 20, new String[]{"dateValue", "timeValue"}, new String[]{"DATE", "TIME"}, new int[]{IN, IN}, new int[]{2}));
        dateTimeLibWords.put("dayOf", new EGLSystemFunctionWord("dayOf", 256, 239, dateTimeLibrary, "INT", 9, new String[]{"timestampValue"}, new String[]{"TIMESTAMP"}, new int[]{IN}, new int[]{1}));
        dateTimeLibWords.put("monthOf", new EGLSystemFunctionWord("monthOf", 256, 241, dateTimeLibrary, "INT", 9, new String[]{"timestampValue"}, new String[]{"TIMESTAMP"}, new int[]{IN}, new int[]{1}));
        dateTimeLibWords.put("yearOf", new EGLSystemFunctionWord("yearOf", 256, 240, dateTimeLibrary, "INT", 9, new String[]{"timestampValue"}, new String[]{"TIMESTAMP"}, new int[]{IN}, new int[]{1}));
        dateTimeLibWords.put("weekdayOf", new EGLSystemFunctionWord("weekdayOf", 256, 242, dateTimeLibrary, "INT", 9, new String[]{"timestampValue"}, new String[]{"TIMESTAMP"}, new int[]{IN}, new int[]{1}));
        dateTimeLibWords.put("mdy", new EGLSystemFunctionWord("mdy", 256, 243, dateTimeLibrary, "DATE", 8, new String[]{"monthValue", "dayValue", "yearValue"}, new String[]{"INT", "INT", "INT"}, new int[]{IN, IN, IN}, new int[]{3}));
        dateTimeLibWords.put("dateOf", new EGLSystemFunctionWord("dateOf", 256, 244, dateTimeLibrary, "DATE", 8, new String[]{"timestampValue"}, new String[]{"TIMESTAMP"}, new int[]{IN}, new int[]{1}));
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        dateTimeLibWords.put("timeOf", new EGLSystemFunctionWord("timeOf", 256, 245, dateTimeLibrary, "TIME", 6, new String[]{"timestampValue"}, new String[]{"TIMESTAMP_F6"}, new int[]{IN}, nArray3));
        dateTimeLibWords.put("extend", new EGLSystemFunctionWord("extend", 256, 246, dateTimeLibrary, "TIMESTAMP", 20, new String[]{"extensionItem", "timeSpanPattern"}, new String[]{"TIMESTAMP_F6", "STRING"}, new int[]{IN, IN}, new int[]{1, 2}));
        reportHandlerWords.put("getReportParameter", new EGLSystemFunctionWord("getReportParameter", 2304, 300, "", "ANY", 0, new String[]{"parameter"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        reportHandlerWords.put("setReportVariableValue", new EGLSystemFunctionWord("setReportVariableValue", 2048, 301, "", null, 0, new String[]{"variable", "value"}, new String[]{"STRING", "ANY"}, new int[]{IN, IN}, new int[]{2}));
        reportHandlerWords.put("getReportVariableValue", new EGLSystemFunctionWord("getReportVariableValue", 2304, 302, "", "ANY", 0, new String[]{"variable"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        reportHandlerWords.put("getFieldValue", new EGLSystemFunctionWord("getFieldValue", 2304, 303, "", "ANY", 0, new String[]{"fieldName"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        reportHandlerWords.put("addReportData", new EGLSystemFunctionWord("addReportData", 2048, 304, "", null, 0, new String[]{"rd", "dataSetName"}, new String[]{"REPORTDATA", "STRING"}, new int[]{IN, IN}, new int[]{2}));
        reportHandlerWords.put("getReportData", new EGLSystemFunctionWord("getReportData", 2304, 305, "", "REPORTDATA", 0, new String[]{"dataSetName"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
        serviceLibWords.put("setWebEndpoint", new EGLSystemFunctionWord("setWebEndpoint", 512, 450, serviceLibrary, null, 0, new String[]{"service", "endpoint"}, new String[]{serviceOrInterface, "STRING"}, new int[]{IN, IN}, new int[]{2}));
        serviceLibWords.put("getWebEndpoint", new EGLSystemFunctionWord("getWebEndpoint", 256, 451, serviceLibrary, "STRING", 0, new String[]{"service"}, new String[]{serviceOrInterface}, new int[]{IN}, new int[]{1}));
        serviceLibWords.put("setTCPIPLocation", new EGLSystemFunctionWord("setTCPIPLocation", 512, 452, serviceLibrary, null, 0, new String[]{"service", "location"}, new String[]{serviceOrInterface, "STRING"}, new int[]{IN, IN}, new int[]{2}));
        serviceLibWords.put("getTCPIPLocation", new EGLSystemFunctionWord("getTCPIPLocation", 256, 453, serviceLibrary, "STRING", 0, new String[]{"service"}, new String[]{serviceOrInterface}, new int[]{IN}, new int[]{1}));
        birtHandlerWords.put("getDataColumnBinding", new EGLSystemFunctionWord("getDataColumnBinding", 8448, 330, "", "ANY", 0, new String[]{"fieldName"}, new String[]{"STRING"}, new int[]{IN}, new int[]{1}));
    }

    public static List getArrayMathLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = mathLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < mathLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getMathLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(mathLibWords.size());
        Collection systemWordsValues = mathLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < mathLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getMathLibWordsAsMap() {
        return mathLibWords;
    }

    public static List getMathLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(mathLibWords.size());
        Collection systemWordsValues = mathLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < mathLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getMathLibWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(mathLibWords.size());
        Collection systemWordsValues = mathLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < mathLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getmathLibFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = mathLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < mathLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getMathLibFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = mathLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < mathLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getMathLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = mathLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < mathLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getMathLibFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = mathLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < mathLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getMathLibFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = mathLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < mathLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibraryMathLibWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = mathLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < mathLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilityMathLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = mathLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < mathLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerMathLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = mathLibWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)mathLibWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLMathLibWord(String key) {
        return (EGLSystemWord)mathLibWords.get(key);
    }

    public static List getMathLibVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = mathLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < mathLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getMathLibVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = mathLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < mathLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getMathLibNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = mathLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < mathLibWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getArrayStrLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = strLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < strLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getStrLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(strLibWords.size());
        Collection systemWordsValues = strLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < strLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getStrLibWordsAsMap() {
        return strLibWords;
    }

    public static List getStrLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(strLibWords.size());
        Collection systemWordsValues = strLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < strLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getStrLibWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(strLibWords.size());
        Collection systemWordsValues = strLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < strLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getStrLibFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = strLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < strLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getStrLibFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = strLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < strLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getStrLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = strLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < strLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getStrLibFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = strLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < strLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getStrLibFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = strLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < strLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibraryStrLibWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = strLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < strLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilityStrLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = strLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < strLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerStrLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = strLibWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)strLibWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLStrLibWord(String key) {
        return (EGLSystemWord)strLibWords.get(key);
    }

    public static List getStrLibVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = strLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < strLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getStrLibVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = strLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < strLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getStrLibNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = strLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < strLibWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getArraySysLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = sysLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getSysLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(sysLibWords.size());
        Collection systemWordsValues = sysLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getSysLibWordsAsMap() {
        return sysLibWords;
    }

    public static List getSysLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(sysLibWords.size());
        Collection systemWordsValues = sysLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysLibWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(sysLibWords.size());
        Collection systemWordsValues = sysLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysLibFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = sysLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysLibFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = sysLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = sysLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysLibFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = sysLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysLibFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = sysLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibrarySysLibWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = sysLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilitySysLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = sysLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerSysLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = sysLibWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)sysLibWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLSysLibWord(String key) {
        return (EGLSystemWord)sysLibWords.get(key);
    }

    public static List getSysLibVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = sysLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysLibVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = sysLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysLibNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = sysLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysLibWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getArraySysVarWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = sysVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getSysVarWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(sysVarWords.size());
        Collection systemWordsValues = sysVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getSysVarWordsAsMap() {
        return sysVarWords;
    }

    public static List getSysVarWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(sysVarWords.size());
        Collection systemWordsValues = sysVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysVarWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(sysVarWords.size());
        Collection systemWordsValues = sysVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysVarFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = sysVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysVarWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysVarFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = sysVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysVarWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysVarFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = sysVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysVarFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = sysVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysVarWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysVarFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = sysVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysVarWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibrarySysVarWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = sysVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilitySysVarWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = sysVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerSysVarFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = sysVarWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)sysVarWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLSysVarWord(String key) {
        return (EGLSystemWord)sysVarWords.get(key);
    }

    public static List getSysVarVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = sysVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysVarVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = sysVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getSysVarNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = sysVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < sysVarWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getArrayDictionaryWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = dictionaryWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dictionaryWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getDictionaryWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(dictionaryWords.size());
        Collection systemWordsValues = dictionaryWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dictionaryWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getDictionaryWordsAsMap() {
        return dictionaryWords;
    }

    public static List getDictionaryWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(dictionaryWords.size());
        Collection systemWordsValues = dictionaryWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dictionaryWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getDictionaryWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(dictionaryWords.size());
        Collection systemWordsValues = dictionaryWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dictionaryWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getDictionaryFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dictionaryWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dictionaryWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDictionaryFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = dictionaryWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dictionaryWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDictionaryFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dictionaryWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dictionaryWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDictionaryFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dictionaryWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dictionaryWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDictionaryFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = dictionaryWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dictionaryWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibraryDictionaryWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = dictionaryWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dictionaryWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilityDictionaryWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dictionaryWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dictionaryWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerDictionaryFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = dictionaryWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)dictionaryWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLDictionaryWord(String key) {
        return (EGLSystemWord)dictionaryWords.get(key);
    }

    public static List getDictionaryVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dictionaryWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dictionaryWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDictionaryVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = dictionaryWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dictionaryWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDictionaryNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dictionaryWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dictionaryWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getArrayConsoleLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = consoleLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < consoleLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getConsoleLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(consoleLibWords.size());
        Collection systemWordsValues = consoleLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < consoleLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getConsoleLibWordsAsMap() {
        return consoleLibWords;
    }

    public static List getConsoleLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(consoleLibWords.size());
        Collection systemWordsValues = consoleLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < consoleLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getConsoleLibWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(consoleLibWords.size());
        Collection systemWordsValues = consoleLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < consoleLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getConsoleLibFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = consoleLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < consoleLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConsoleLibFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = consoleLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < consoleLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConsoleLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = consoleLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < consoleLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConsoleLibFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = consoleLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < consoleLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConsoleLibFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = consoleLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < consoleLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibraryConsoleLibWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = consoleLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < consoleLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilityConsoleLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = consoleLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < consoleLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerConsoleLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = consoleLibWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)consoleLibWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLConsoleLibWord(String key) {
        return (EGLSystemWord)consoleLibWords.get(key);
    }

    public static List getConsoleLibVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = consoleLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < consoleLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConsoleLibVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = consoleLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < consoleLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConsoleLibNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = consoleLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < consoleLibWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getArrayDynArrayWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = dynArrayWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dynArrayWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getDynArrayWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(dynArrayWords.size());
        Collection systemWordsValues = dynArrayWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dynArrayWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getDynArrayWordsAsMap() {
        return dynArrayWords;
    }

    public static List getDynArrayWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(dynArrayWords.size());
        Collection systemWordsValues = dynArrayWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dynArrayWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getDynArrayWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(dynArrayWords.size());
        Collection systemWordsValues = dynArrayWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dynArrayWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getDynArrayFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dynArrayWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dynArrayWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDynArrayFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = dynArrayWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dynArrayWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDynArrayFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dynArrayWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dynArrayWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDynArrayFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dynArrayWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dynArrayWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDynArrayFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = dynArrayWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dynArrayWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibraryDynArrayWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = dynArrayWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dynArrayWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilityDynArrayWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dynArrayWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dynArrayWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerDynArrayFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = dynArrayWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)dynArrayWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLDynArrayWord(String key) {
        return (EGLSystemWord)dynArrayWords.get(key);
    }

    public static List getDynArrayVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dynArrayWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dynArrayWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDynArrayVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = dynArrayWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dynArrayWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDynArrayNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dynArrayWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dynArrayWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getArrayRecordWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = recordWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < recordWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getRecordWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(recordWords.size());
        Collection systemWordsValues = recordWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < recordWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getRecordWordsAsMap() {
        return recordWords;
    }

    public static List getRecordWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(recordWords.size());
        Collection systemWordsValues = recordWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < recordWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getRecordWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(recordWords.size());
        Collection systemWordsValues = recordWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < recordWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getRecordFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = recordWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < recordWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getRecordFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = recordWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < recordWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getRecordFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = recordWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < recordWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getRecordFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = recordWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < recordWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getRecordFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = recordWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < recordWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibraryRecordWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = recordWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < recordWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilityRecordWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = recordWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < recordWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerRecordFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = recordWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)recordWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLRecordWord(String key) {
        return (EGLSystemWord)recordWords.get(key);
    }

    public static List getRecordVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = recordWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < recordWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getRecordVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = recordWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < recordWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getRecordNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = recordWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < recordWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getArrayReportLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = reportLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < reportLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getReportLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(reportLibWords.size());
        Collection systemWordsValues = reportLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < reportLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static List getReportHandlerLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(reportHandlerWords.size());
        Collection systemWordsValues = reportHandlerWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < reportHandlerWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getReportLibWordsAsMap() {
        return reportLibWords;
    }

    public static List getReportLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(reportLibWords.size());
        Collection systemWordsValues = reportLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < reportLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getReportLibWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(reportLibWords.size());
        Collection systemWordsValues = reportLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < reportLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getReportLibFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = reportLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < reportLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getReportLibFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = reportLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < reportLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getReportLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = reportLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < reportLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getReportLibFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = reportLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < reportLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getReportLibFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = reportLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < reportLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibraryReportLibWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = reportLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < reportLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilityReportLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = reportLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < reportLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerReportLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = reportLibWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)reportLibWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLReportLibWord(String key) {
        return (EGLSystemWord)reportLibWords.get(key);
    }

    public static List getReportLibVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = reportLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < reportLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getReportLibVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = reportLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < reportLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getReportLibNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = reportLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < reportLibWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getArrayConverseLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = converseLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getConverseLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(converseLibWords.size());
        Collection systemWordsValues = converseLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getConverseLibWordsAsMap() {
        return converseLibWords;
    }

    public static List getConverseLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(converseLibWords.size());
        Collection systemWordsValues = converseLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseLibWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(converseLibWords.size());
        Collection systemWordsValues = converseLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseLibFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = converseLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseLibFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = converseLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = converseLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseLibFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = converseLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseLibFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = converseLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibraryConverseLibWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = converseLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilityConverseLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = converseLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerConverseLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = converseLibWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)converseLibWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLConverseLibWord(String key) {
        return (EGLSystemWord)converseLibWords.get(key);
    }

    public static List getConverseLibVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = converseLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseLibVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = converseLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseLibNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = converseLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseLibWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getArrayLobLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = lobLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < lobLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getLobLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(lobLibWords.size());
        Collection systemWordsValues = lobLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < lobLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getLobLibWordsAsMap() {
        return lobLibWords;
    }

    public static List getLobLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(lobLibWords.size());
        Collection systemWordsValues = lobLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < lobLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getLobLibWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(lobLibWords.size());
        Collection systemWordsValues = lobLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < lobLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getLobLibFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = lobLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < lobLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLobLibFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = lobLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < lobLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLobLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = lobLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < lobLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLobLibFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = lobLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < lobLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLobLibFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = lobLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < lobLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibraryLobLibWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = lobLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < lobLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilityLobLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = lobLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < lobLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerLobLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = lobLibWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)lobLibWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLLobLibWord(String key) {
        return (EGLSystemWord)lobLibWords.get(key);
    }

    public static List getLobLibVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = lobLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < lobLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLobLibVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = lobLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < lobLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLobLibNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = lobLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < lobLibWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getArrayVGLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = vgLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getVGLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(vgLibWords.size());
        Collection systemWordsValues = vgLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getVGLibWordsAsMap() {
        return vgLibWords;
    }

    public static List getVGLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(vgLibWords.size());
        Collection systemWordsValues = vgLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGLibWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(vgLibWords.size());
        Collection systemWordsValues = vgLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGLibFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = vgLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGLibFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = vgLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = vgLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGLibFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = vgLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGLibFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = vgLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibraryVGLibWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = vgLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilityVGLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = vgLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerVGLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = vgLibWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)vgLibWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLVGLibWord(String key) {
        return (EGLSystemWord)vgLibWords.get(key);
    }

    public static List getVGLibVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = vgLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGLibVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = vgLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGLibNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = vgLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgLibWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getArrayJavaLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = javaLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < javaLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getJavaLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(javaLibWords.size());
        Collection systemWordsValues = javaLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < javaLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getJavaLibWordsAsMap() {
        return javaLibWords;
    }

    public static List getJavaLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(javaLibWords.size());
        Collection systemWordsValues = javaLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < javaLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getJavaLibWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(javaLibWords.size());
        Collection systemWordsValues = javaLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < javaLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getJavaLibFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = javaLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < javaLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getJavaLibFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = javaLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < javaLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getJavaLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = javaLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < javaLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getJavaLibFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = javaLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < javaLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getJavaLibFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = javaLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < javaLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibraryJavaLibWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = javaLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < javaLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilityJavaLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = javaLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < javaLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerJavaLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = javaLibWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)javaLibWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLJavaLibWord(String key) {
        return (EGLSystemWord)javaLibWords.get(key);
    }

    public static List getJavaLibVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = javaLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < javaLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getJavaLibVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = javaLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < javaLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getJavaLibNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = javaLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < javaLibWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getArrayDateTimeLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = dateTimeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dateTimeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getDateTimeLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(dateTimeLibWords.size());
        Collection systemWordsValues = dateTimeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dateTimeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getDateTimeLibWordsAsMap() {
        return dateTimeLibWords;
    }

    public static List getDateTimeLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(dateTimeLibWords.size());
        Collection systemWordsValues = dateTimeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dateTimeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getDateTimeLibWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(dateTimeLibWords.size());
        Collection systemWordsValues = dateTimeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dateTimeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getDateTimeLibFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dateTimeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dateTimeLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDateTimeLibFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = dateTimeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dateTimeLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDateTimeLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dateTimeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dateTimeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDateTimeLibFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dateTimeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dateTimeLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDateTimeLibFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = dateTimeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dateTimeLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibraryDateTimeLibWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = dateTimeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dateTimeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilityDateTimeLibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dateTimeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dateTimeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerDateTimeLibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = dateTimeLibWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)dateTimeLibWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLDateTimeLibWord(String key) {
        return (EGLSystemWord)dateTimeLibWords.get(key);
    }

    public static List getDateTimeLibVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dateTimeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dateTimeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDateTimeLibVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = dateTimeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dateTimeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDateTimeLibNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = dateTimeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dateTimeLibWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getServiceLibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(serviceLibWords.size());
        Collection systemWordsValues = serviceLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < serviceLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static List getArrayJ2EELibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = j2eeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < j2eeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getJ2EELibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(j2eeLibWords.size());
        Collection systemWordsValues = j2eeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < j2eeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getJ2EELibWordsAsMap() {
        return j2eeLibWords;
    }

    public static List getJ2EELibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(j2eeLibWords.size());
        Collection systemWordsValues = j2eeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < j2eeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getJ2EELibWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(j2eeLibWords.size());
        Collection systemWordsValues = j2eeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < j2eeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getJ2EELibFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = j2eeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < j2eeLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getJ2EELibFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = j2eeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < j2eeLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getJ2EELibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = j2eeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < j2eeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getJ2EELibFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = j2eeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < j2eeLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getJ2EELibFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = j2eeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < j2eeLibWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibraryJ2EELibWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = j2eeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < j2eeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilityJ2EELibWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = j2eeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < j2eeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerJ2EELibFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = j2eeLibWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)j2eeLibWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLJ2EELibWord(String key) {
        return (EGLSystemWord)j2eeLibWords.get(key);
    }

    public static List getJ2EELibVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = j2eeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < j2eeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getJ2EELibVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = j2eeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < j2eeLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getJ2EELibNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = j2eeLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < j2eeLibWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getArrayConverseVarWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = converseVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getConverseVarWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(converseVarWords.size());
        Collection systemWordsValues = converseVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getConverseVarWordsAsMap() {
        return converseVarWords;
    }

    public static List getConverseVarWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(converseVarWords.size());
        Collection systemWordsValues = converseVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseVarWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(converseVarWords.size());
        Collection systemWordsValues = converseVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseVarFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = converseVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseVarWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseVarFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = converseVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseVarWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseVarFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = converseVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseVarFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = converseVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseVarWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseVarFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = converseVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseVarWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibraryConverseVarWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = converseVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilityConverseVarWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = converseVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerConsoleConverseVarFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = converseVarWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)converseVarWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLConverseVarWord(String key) {
        return (EGLSystemWord)converseVarWords.get(key);
    }

    public static List getConverseVarVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = converseVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseVarVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = converseVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getConverseVarNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = converseVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < converseVarWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getArrayVGVarWordsWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = vgVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isArrayWord()) {
                systemWordsList.add(systemWord);
            }
            ++i;
        }
        return systemWordsList;
    }

    public static List getVGVarWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(vgVarWords.size());
        Collection systemWordsValues = vgVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static Map getVGVarWordsWordsAsMap() {
        return vgVarWords;
    }

    public static List getVGVarWordsWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>(vgVarWords.size());
        Collection systemWordsValues = vgVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName());
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGVarWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>(vgVarWords.size());
        Collection systemWordsValues = vgVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordNames.add(systemWord.getName().toLowerCase());
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGVarFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = vgVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgVarWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGVarFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = vgVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgVarWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGVarFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = vgVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGVarFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = vgVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgVarWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGVarFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = vgVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgVarWords.size()) {
            EGLSystemFunctionWord functionWord;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemFunctionWord && !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getLibraryVGVarWords(String library) {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = vgVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.getLibrary().equals(library)) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilityVGVarWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = vgVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord.isVAGCompatible()) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getPageHandlerVGVarFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Iterator iter = vgVarWords.keySet().iterator();
        while (iter.hasNext()) {
            EGLSystemWord systemWord = (EGLSystemWord)vgVarWords.get(iter.next());
            if (!systemWord.isPageHandlerSystemFunction()) continue;
            systemWordNames.add(systemWord.getName());
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLVGVarWord(String key) {
        return (EGLSystemWord)vgVarWords.get(key);
    }

    public static List getVGVarVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = vgVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGVarVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection systemWordsValues = vgVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable) {
                systemWordNames.add(systemWord);
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getVGVarNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection systemWordsValues = vgVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < vgVarWords.size()) {
            EGLSystemVariable systemVariable;
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            if (systemWord instanceof EGLSystemVariable && (systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) {
                systemWordNames.add(systemVariable.getName());
            }
            ++i;
        }
        return systemWordNames;
    }

    public static List getDLILibWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(dliLibWords.size());
        Collection systemWordsValues = dliLibWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dliLibWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static List getDLIVarWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>(dliVarWords.size());
        Collection systemWordsValues = dliVarWords.values();
        Iterator iter = systemWordsValues.iterator();
        int i = 0;
        while (i < dliVarWords.size()) {
            EGLSystemWord systemWord = (EGLSystemWord)iter.next();
            systemWordsList.add(systemWord);
            ++i;
        }
        return systemWordsList;
    }

    public static List getArraySystemWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord systemWord : systemWordsValues) {
                if (!systemWord.isArrayWord()) continue;
                systemWordsList.add(systemWord);
            }
            ++jj;
        }
        return systemWordsList;
    }

    public static List getSystemWords() {
        ArrayList<EGLSystemWord> systemWordsList = new ArrayList<EGLSystemWord>();
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord systemWord : systemWordsValues) {
                systemWordsList.add(systemWord);
            }
            ++jj;
        }
        return systemWordsList;
    }

    public static Map getSystemWordsAsMap() {
        return systemWords;
    }

    public static List getSystemWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord systemWord : systemWordsValues) {
                systemWordNames.add(systemWord.getName());
            }
            ++jj;
        }
        return systemWordNames;
    }

    public static List getSystemWordNamesToLowerCase() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord systemWord : systemWordsValues) {
                systemWordNames.add(systemWord.getName().toLowerCase());
            }
            ++jj;
        }
        return systemWordNames;
    }

    public static List getSystemFunctionWordNamesWithReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord systemWord : systemWordsValues) {
                EGLSystemFunctionWord functionWord;
                if (!(systemWord instanceof EGLSystemFunctionWord) || !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) continue;
                systemWordNames.add(systemWord.getName());
            }
            ++jj;
        }
        return systemWordNames;
    }

    public static List getSystemFunctionWordsWithReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord systemWord : systemWordsValues) {
                EGLSystemFunctionWord functionWord;
                if (!(systemWord instanceof EGLSystemFunctionWord) || !(functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) continue;
                systemWordNames.add(systemWord);
            }
            ++jj;
        }
        return systemWordNames;
    }

    public static List getSystemFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord systemWord : systemWordsValues) {
                if (!(systemWord instanceof EGLSystemFunctionWord)) continue;
                systemWordNames.add(systemWord.getName());
            }
            ++jj;
        }
        return systemWordNames;
    }

    public static List getSystemFunctionWordNamesWithoutReturnValue() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord systemWord : systemWordsValues) {
                EGLSystemFunctionWord functionWord;
                if (!(systemWord instanceof EGLSystemFunctionWord) || (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) continue;
                systemWordNames.add(systemWord.getName());
            }
            ++jj;
        }
        return systemWordNames;
    }

    public static List getSystemFunctionWordsWithoutReturnValue() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord systemWord : systemWordsValues) {
                EGLSystemFunctionWord functionWord;
                if (!(systemWord instanceof EGLSystemFunctionWord) || (functionWord = (EGLSystemFunctionWord)systemWord).hasReturnCode()) continue;
                systemWordNames.add(systemWord);
            }
            ++jj;
        }
        return systemWordNames;
    }

    public static List getLibrarySystemWords(String library) {
        if (library.equalsIgnoreCase(mathLibrary)) {
            return EGLSystemWordHandler.getMathLibWords();
        }
        if (library.equalsIgnoreCase(stringLibrary)) {
            return EGLSystemWordHandler.getStrLibWords();
        }
        if (library.equalsIgnoreCase(systemLibrary)) {
            return EGLSystemWordHandler.getSysLibWords();
        }
        if (library.equalsIgnoreCase(systemVariablesLibrary)) {
            return EGLSystemWordHandler.getSysVarWords();
        }
        if (library.equalsIgnoreCase(dateTimeLibrary)) {
            return EGLSystemWordHandler.getDateTimeLibWords();
        }
        if (library.equalsIgnoreCase(serviceLibrary)) {
            return EGLSystemWordHandler.getServiceLibWords();
        }
        if (library.equalsIgnoreCase(dynamicArraySystemWord)) {
            return EGLSystemWordHandler.getDynArrayWords();
        }
        if (library.equalsIgnoreCase(dictionarySystemWord)) {
            return EGLSystemWordHandler.getDictionaryWords();
        }
        if (library.equalsIgnoreCase(recordSystemFunction)) {
            return EGLSystemWordHandler.getRecordWords();
        }
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord systemWord : systemWordsValues) {
                if (!systemWord.getLibrary().equals(library)) continue;
                systemWordNames.add(systemWord);
            }
            ++jj;
        }
        return systemWordNames;
    }

    public static List getVAGCompatibilitySystemWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord systemWord : systemWordsValues) {
                if (!systemWord.isVAGCompatible()) continue;
                systemWordNames.add(systemWord.getName());
            }
            ++jj;
        }
        return systemWordNames;
    }

    public static List getPageHandlerSystemFunctionWordNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord systemWord : systemWordsValues) {
                if (!systemWord.isPageHandlerSystemFunction()) continue;
                systemWordNames.add(systemWord.getName());
            }
            ++jj;
        }
        return systemWordNames;
    }

    public static EGLSystemWord getEGLSystemWord(String key) {
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord next : systemWordsValues) {
                if (!next.getName().equalsIgnoreCase(key)) continue;
                return next;
            }
            ++jj;
        }
        return null;
    }

    public static EGLSystemWord getEGLSystemWord(String key, String libName) {
        Map map = (Map)systemWords.get(libName);
        Collection<Object> systemWordsValues = map == null ? new ArrayList() : map.values();
        for (EGLSystemWord eGLSystemWord : systemWordsValues) {
            if (!eGLSystemWord.getName().equalsIgnoreCase(key)) continue;
            return eGLSystemWord;
        }
        return null;
    }

    public static List getSystemVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord systemWord : systemWordsValues) {
                if (!(systemWord instanceof EGLSystemVariable)) continue;
                systemWordNames.add(systemWord.getName());
            }
            ++jj;
        }
        return systemWordNames;
    }

    public static List getSystemVariables() {
        ArrayList<EGLSystemWord> systemWordNames = new ArrayList<EGLSystemWord>();
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord systemWord : systemWordsValues) {
                if (!(systemWord instanceof EGLSystemVariable)) continue;
                systemWordNames.add(systemWord);
            }
            ++jj;
        }
        return systemWordNames;
    }

    public static List getSystemNumericVariableNames() {
        ArrayList<String> systemWordNames = new ArrayList<String>();
        Collection wordTreeMaps = systemWords.values();
        Iterator mapsIter = wordTreeMaps.iterator();
        int jj = 0;
        while (jj < wordTreeMaps.size()) {
            Collection systemWordsValues = ((TreeMap)mapsIter.next()).values();
            for (EGLSystemWord systemWord : systemWordsValues) {
                EGLSystemVariable systemVariable;
                if (!(systemWord instanceof EGLSystemVariable) || !(systemVariable = (EGLSystemVariable)systemWord).isNumericVariable()) continue;
                systemWordNames.add(systemVariable.getName());
            }
            ++jj;
        }
        return systemWordNames;
    }
}

