/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.edt.compiler.binding.AmbiguousDataBinding;
import org.eclipse.edt.compiler.binding.AmbiguousFunctionBinding;
import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.AnnotationFieldBinding;
import org.eclipse.edt.compiler.binding.AnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ArrayDictionaryBinding;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ConstructorBinding;
import org.eclipse.edt.compiler.binding.DataBinding;
import org.eclipse.edt.compiler.binding.DataItemBinding;
import org.eclipse.edt.compiler.binding.DelegateBinding;
import org.eclipse.edt.compiler.binding.DictionaryBinding;
import org.eclipse.edt.compiler.binding.DynamicDataBinding;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordFieldBinding;
import org.eclipse.edt.compiler.binding.ForeignLanguageTypeBinding;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.HandlerBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.InterfaceBinding;
import org.eclipse.edt.compiler.binding.IsNotStateBinding;
import org.eclipse.edt.compiler.binding.LocalVariableBinding;
import org.eclipse.edt.compiler.binding.MultiplyOccuringItemTypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.NilBinding;
import org.eclipse.edt.compiler.binding.OverloadedFunctionSet;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.ProgramBinding;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.VariableBinding;
import org.eclipse.edt.compiler.binding.VariableFormFieldBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.binding.annotationType.EGLNotInCurrentReleaseAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.ArrayAccess;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.AsExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.BinaryExpression;
import org.eclipse.edt.compiler.core.ast.BooleanLiteral;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.CharLiteral;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.CloseStatement;
import org.eclipse.edt.compiler.core.ast.DBCharLiteral;
import org.eclipse.edt.compiler.core.ast.DecimalLiteral;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.ElseBlock;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.FloatLiteral;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.ForwardStatement;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.FunctionInvocationStatement;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.GetByPositionStatement;
import org.eclipse.edt.compiler.core.ast.HexLiteral;
import org.eclipse.edt.compiler.core.ast.IfStatement;
import org.eclipse.edt.compiler.core.ast.InExpression;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.IsAExpression;
import org.eclipse.edt.compiler.core.ast.IsNotExpression;
import org.eclipse.edt.compiler.core.ast.LikeMatchesExpression;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;
import org.eclipse.edt.compiler.core.ast.MBCharLiteral;
import org.eclipse.edt.compiler.core.ast.MoveModifier;
import org.eclipse.edt.compiler.core.ast.MoveStatement;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.NullLiteral;
import org.eclipse.edt.compiler.core.ast.NullableType;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.PrimitiveType;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.ProgramParameter;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.ReturningToNameClause;
import org.eclipse.edt.compiler.core.ast.ReturnsDeclaration;
import org.eclipse.edt.compiler.core.ast.SQLLiteral;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.SubstringAccess;
import org.eclipse.edt.compiler.core.ast.ThisExpression;
import org.eclipse.edt.compiler.core.ast.TryStatement;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.TypeLiteralExpression;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.core.ast.UsingPCBClause;
import org.eclipse.edt.compiler.core.ast.WhenClause;
import org.eclipse.edt.compiler.core.ast.WhileStatement;
import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.NullProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.DataBindingScope;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionArgumentValidator;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionResolver;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.NullScope;
import org.eclipse.edt.compiler.internal.core.lookup.ProgramScope;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemPartManager;
import org.eclipse.edt.compiler.internal.core.lookup.TypeBindingScope;
import org.eclipse.edt.compiler.internal.core.lookup.VAGenResolutionWarningsValidator;
import org.eclipse.edt.compiler.internal.core.utils.ExpressionParser;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.annotation.LengthItemForSerialMessageOrIndexedRecordValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.RecordNumItemValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.LValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.RValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.type.PrimitiveTypeValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class DefaultBinder
extends AbstractBinder {
    protected IProblemRequestor problemRequestor;
    private List IOObjectsInCurrentStatement = Collections.EMPTY_LIST;
    private boolean visitingIntoClause;
    private List FormGroupsInProgram = Collections.EMPTY_LIST;
    private boolean bindingFunctionInvocationTarget;
    private boolean dotOperatorAllowedForArrays = false;
    private static Set invalidIsNotStatesForDLISegments = new HashSet();
    private static List VALID_STRING_CASTS;
    private static List VALID_NUMERIC_CASTS;
    FunctionInvocation functionInvocationFromFunctionInvocationStatement;
    private static final Set systemFunctionsOnlyAllowedInPageHandlers;
    private static final Set systemFunctionsNotAllowedInPageHandlers;
    private static final Set systemFunctionsOnlyAllowedInProgramsWithDLIAnnotation;
    private static final Set systemFunctionsNotAllowedInServices;

    static {
        invalidIsNotStatesForDLISegments.add(IsNotStateBinding.FILENOTFOUND);
        invalidIsNotStatesForDLISegments.add(IsNotStateBinding.DEADLOCK);
        invalidIsNotStatesForDLISegments.add(IsNotStateBinding.INVALIDFORMAT);
        invalidIsNotStatesForDLISegments.add(IsNotStateBinding.FILENOTAVAILABLE);
        invalidIsNotStatesForDLISegments.add(IsNotStateBinding.FULL);
        VALID_STRING_CASTS = Arrays.asList(ForeignLanguageTypeBinding.OBJIDJAVA, ForeignLanguageTypeBinding.JAVACHAR);
        VALID_NUMERIC_CASTS = Arrays.asList(ForeignLanguageTypeBinding.JAVASHORT, ForeignLanguageTypeBinding.JAVAINT, ForeignLanguageTypeBinding.JAVALONG, ForeignLanguageTypeBinding.JAVAFLOAT, ForeignLanguageTypeBinding.JAVADOUBLE, ForeignLanguageTypeBinding.JAVABOOLEAN, ForeignLanguageTypeBinding.JAVABIGINTEGER, ForeignLanguageTypeBinding.JAVABIGDECIMAL, ForeignLanguageTypeBinding.JAVABYTE);
        systemFunctionsOnlyAllowedInPageHandlers = new HashSet();
        systemFunctionsOnlyAllowedInPageHandlers.add(new FunctionArgumentValidator.FunctionIdentifier(new String[]{"egl", "java"}, "J2EELib", "CLEARREQUESTATTR"));
        systemFunctionsOnlyAllowedInPageHandlers.add(new FunctionArgumentValidator.FunctionIdentifier(new String[]{"egl", "java"}, "J2EELib", "CLEARSESSIONATTR"));
        systemFunctionsOnlyAllowedInPageHandlers.add(new FunctionArgumentValidator.FunctionIdentifier(new String[]{"egl", "java"}, "J2EELib", "GETREQUESTATTR"));
        systemFunctionsOnlyAllowedInPageHandlers.add(new FunctionArgumentValidator.FunctionIdentifier(new String[]{"egl", "java"}, "J2EELib", "GETSESSIONATTR"));
        systemFunctionsOnlyAllowedInPageHandlers.add(new FunctionArgumentValidator.FunctionIdentifier(new String[]{"egl", "java"}, "J2EELib", "SETREQUESTATTR"));
        systemFunctionsOnlyAllowedInPageHandlers.add(new FunctionArgumentValidator.FunctionIdentifier(new String[]{"egl", "java"}, "J2EELib", "SETSESSIONATTR"));
        systemFunctionsNotAllowedInPageHandlers = new HashSet();
        systemFunctionsNotAllowedInPageHandlers.add(new FunctionArgumentValidator.FunctionIdentifier(new String[]{"egl", "ui", "console"}, "ConsoleLib", "DISPLAYLINEMODE"));
        systemFunctionsOnlyAllowedInProgramsWithDLIAnnotation = new HashSet();
        systemFunctionsOnlyAllowedInProgramsWithDLIAnnotation.add(new FunctionArgumentValidator.FunctionIdentifier(new String[]{"egl", "io", "dli"}, "DLILib", "AIBTDLI"));
        systemFunctionsOnlyAllowedInProgramsWithDLIAnnotation.add(new FunctionArgumentValidator.FunctionIdentifier(new String[]{"egl", "io", "dli"}, "DLILib", "EGLTDLI"));
        systemFunctionsOnlyAllowedInProgramsWithDLIAnnotation.add(new FunctionArgumentValidator.FunctionIdentifier(new String[]{"egl", "vg"}, "VGLib", "VGTDLI"));
        systemFunctionsNotAllowedInServices = new HashSet();
        systemFunctionsNotAllowedInServices.add(new FunctionArgumentValidator.FunctionIdentifier(new String[]{"egl", "core"}, "SysLib", "setError"));
    }

    public DefaultBinder(Scope currentScope, IPartBinding currentBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, currentBinding, dependencyRequestor, compilerOptions);
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(QualifiedName qualifiedName) {
        if (qualifiedName.resolveBinding() == null) {
            try {
                this.bindExpressionName(qualifiedName, this.bindingFunctionInvocationTarget);
                IBinding qualifierBinding = qualifiedName.getQualifier().resolveBinding();
                if (IBinding.NOT_FOUND_BINDING != qualifierBinding && qualifierBinding != null && qualifierBinding.isTypeBinding() && 11 == ((ITypeBinding)qualifierBinding).getKind() && qualifierBinding.getAnnotation(EGLNotInCurrentReleaseAnnotationTypeBinding.getInstance()) != null) {
                    this.problemRequestor.acceptProblem((Node)qualifiedName.getQualifier(), 3459, new String[]{qualifierBinding.getCaseSensitiveName()});
                }
            }
            catch (ResolutionException e) {
                qualifiedName.setBinding(IBinding.NOT_FOUND_BINDING);
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            }
        }
        return false;
    }

    protected void handleNameResolutionException(ResolutionException e) {
        this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
    }

    @Override
    public boolean visit(SimpleName simpleName) {
        if (this.bindingFunctionInvocationTarget && simpleName.getIdentifier().toLowerCase().startsWith("eze")) {
            simpleName.setBinding(IBinding.NOT_FOUND_BINDING);
            return false;
        }
        if (simpleName.resolveBinding() == null) {
            if (this.visitingIntoClause) {
                this.bindNameFromSQLRecordArrayBindingsInIOObjects(simpleName);
            }
            if (simpleName.resolveBinding() == null) {
                try {
                    this.bindExpressionName(simpleName, this.bindingFunctionInvocationTarget);
                }
                catch (ResolutionException e) {
                    this.handleNameResolutionException(e);
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void endVisit(Program program) {
        Iterator iter = this.FormGroupsInProgram.iterator();
        boolean iterHelpGroup = false;
        while (iter.hasNext()) {
            UseStatement useStatement = (UseStatement)iter.next();
            if (!useStatement.getUsedTypeBinding().isHelpGroup()) continue;
            if (iterHelpGroup) {
                this.problemRequestor.acceptProblem((Node)useStatement.getNames().get(0), 4932);
                continue;
            }
            iterHelpGroup = true;
        }
        this.FormGroupsInProgram = Collections.EMPTY_LIST;
    }

    @Override
    public void endVisit(UseStatement useStatement) {
        if (this.FormGroupsInProgram == Collections.EMPTY_LIST) {
            this.FormGroupsInProgram = new ArrayList();
        }
        this.FormGroupsInProgram.add(useStatement);
    }

    @Override
    public boolean visit(FunctionInvocation functionInvocation) {
        this.bindingFunctionInvocationTarget = true;
        functionInvocation.getTarget().accept(this);
        this.bindingFunctionInvocationTarget = false;
        ITypeBinding tBinding = functionInvocation.getTarget().resolveTypeBinding();
        if (IBinding.NOT_FOUND_BINDING != tBinding && tBinding != null) {
            if (tBinding.isFunctionBinding()) {
                IFunctionBinding cfr_ignored_0 = (IFunctionBinding)tBinding;
            } else if (27 != tBinding.getKind()) {
                if (functionInvocation.getTarget() instanceof ThisExpression) {
                    OverloadedFunctionSet funcSet = this.getConstructors(tBinding);
                    if (funcSet == null || funcSet.getNestedFunctionBindings().isEmpty()) {
                        this.problemRequestor.acceptProblem((Node)functionInvocation.getTarget(), 7830, new String[]{tBinding.getName()});
                    } else {
                        functionInvocation.getTarget().setDataBinding(funcSet);
                    }
                } else {
                    this.problemRequestor.acceptProblem(functionInvocation.getTarget(), 6751);
                }
            }
        }
        Iterator iter = functionInvocation.getArguments().iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ThisExpression thisExpression) {
        if (thisExpression.resolveTypeBinding() != null) {
            return false;
        }
        Scope scopeForThis = this.currentScope.getScopeForKeywordThis();
        if (scopeForThis instanceof FunctionContainerScope) {
            thisExpression.setTypeBinding(((FunctionContainerScope)scopeForThis).getPartBinding());
        } else {
            thisExpression.setTypeBinding(IBinding.NOT_FOUND_BINDING);
            this.problemRequestor.acceptProblem((Node)thisExpression, 6619, new String[]{thisExpression.getCanonicalString()});
        }
        return false;
    }

    @Override
    public boolean visit(TypeLiteralExpression typeLiteralExpression) {
        try {
            this.bindType(typeLiteralExpression.getType());
        }
        catch (ResolutionException resolutionException) {}
        return false;
    }

    @Override
    public boolean visit(ArrayAccess arrayAccess) {
        if (arrayAccess.getIndices().size() > 1) {
            this.problemRequestor.acceptProblem((Node)arrayAccess, 3472, new String[]{arrayAccess.getCanonicalString()});
        }
        return true;
    }

    @Override
    public void endVisit(ArrayAccess arrayAccess) {
        if (arrayAccess.resolveTypeBinding() != null) {
            return;
        }
        ITypeBinding type = arrayAccess.getArray().resolveTypeBinding();
        if (type != null && type != IBinding.NOT_FOUND_BINDING) {
            ITypeBinding indexType;
            if (arrayAccess.getIndices().size() == 1 && (indexType = ((Expression)arrayAccess.getIndices().get(0)).resolveTypeBinding()) != null && indexType.getKind() == 3 && Primitive.isStringType(((PrimitiveTypeBinding)indexType).getPrimitive())) {
                if (!type.isDynamicallyAccessible() && type.getKind() != 7 && type.getKind() != 28) {
                    this.problemRequestor.acceptProblem((Node)arrayAccess.getArray(), 6588, new String[]{arrayAccess.getArray().getCanonicalString()});
                }
                arrayAccess.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.ANY));
                return;
            }
            int[] dimensions = this.getDimensions(arrayAccess.getArray());
            int currentSubscriptNum = 0;
            for (Expression nextIndex : arrayAccess.getIndices()) {
                ITypeBinding tBinding = nextIndex.resolveTypeBinding();
                if (tBinding != null) {
                    PrimitiveTypeBinding pTypeBinding;
                    boolean typeIsValid = false;
                    if (tBinding.isDynamic()) {
                        typeIsValid = true;
                    } else if (3 == tBinding.getKind() && Primitive.isNumericType((pTypeBinding = (PrimitiveTypeBinding)tBinding).getPrimitive()) && pTypeBinding.getDecimals() == 0) {
                        typeIsValid = true;
                    }
                    if (!typeIsValid) {
                        this.problemRequestor.acceptProblem((Node)nextIndex, 6583, new String[]{nextIndex.getCanonicalString(), arrayAccess.getCanonicalString()});
                    }
                }
                if (currentSubscriptNum < dimensions.length) {
                    int currentDimension = dimensions[currentSubscriptNum];
                    int currentSubscript = this.getInt(nextIndex);
                    if (currentSubscript != -1 && currentSubscript > currentDimension) {
                        this.problemRequestor.acceptProblem((Node)nextIndex, 6582, new String[]{Integer.toString(currentSubscript), arrayAccess.getCanonicalString()});
                    }
                } else if (!type.isDynamic()) {
                    if (dimensions.length == 0) {
                        this.problemRequestor.acceptProblem((Node)arrayAccess.getArray(), 6586, new String[]{arrayAccess.getArray().getCanonicalString()});
                        break;
                    }
                    this.problemRequestor.acceptProblem((Node)arrayAccess.getArray(), 6581, new String[]{arrayAccess.getCanonicalString()});
                    break;
                }
                ++currentSubscriptNum;
            }
            if (type.getKind() == 2) {
                ArrayTypeBinding arrayTypeBinding = (ArrayTypeBinding)type;
                int i = 0;
                while (i < arrayAccess.getIndices().size() - 1) {
                    ITypeBinding elementType = arrayTypeBinding.getElementType();
                    if (elementType.getKind() == 2) {
                        arrayTypeBinding = (ArrayTypeBinding)elementType;
                    }
                    ++i;
                }
                arrayAccess.setTypeBinding(arrayTypeBinding.getElementType());
            } else if (type.isDynamic()) {
                arrayAccess.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.ANY));
            } else if (22 == type.getKind()) {
                arrayAccess.setTypeBinding(DictionaryBinding.INSTANCE);
            } else {
                IDataBinding dBinding = arrayAccess.getArray().resolveDataBinding();
                if (dBinding != null && dBinding != IBinding.NOT_FOUND_BINDING) {
                    if (5 == dBinding.getKind()) {
                        arrayAccess.setDataBinding(dBinding);
                        arrayAccess.setTypeBinding(dBinding.getType());
                        if (((StructureItemBinding)dBinding).isMultiplyOccuring() && this.numSubscripts(arrayAccess) < dimensions.length && !this.compilerOptions.isVAGCompatible()) {
                            arrayAccess.setTypeBinding(new MultiplyOccuringItemTypeBinding(dBinding.getType()));
                        }
                    } else if (7 == dBinding.getKind() && ((FormFieldBinding)dBinding).isMultiplyOccuring()) {
                        arrayAccess.setDataBinding(dBinding);
                        arrayAccess.setTypeBinding(dBinding.getType());
                    }
                }
            }
        }
    }

    private int[] getDimensions(Expression expr) {
        return new DimensionGatherer().getDimensions(expr);
    }

    private int numSubscripts(Expression expr) {
        return new SubscriptsGatherer().getSubscripts(expr).size();
    }

    private int getInt(Expression expr) {
        return new IntGetter().getInt(expr);
    }

    @Override
    public void endVisit(SubstringAccess substringAccess) {
        ITypeBinding type = substringAccess.getPrimary().resolveTypeBinding();
        if (type != null) {
            Primitive prim;
            boolean typeIsValid = false;
            if (type.getKind() == 3 && (typeIsValid = Primitive.isStringType(prim = ((PrimitiveTypeBinding)type).getPrimitive()))) {
                boolean typeIsNullable = type.isNullable();
                type = PrimitiveTypeBinding.getInstance(prim, this.getSubstringLength(substringAccess.getExpr(), substringAccess.getExpr2()));
                if (typeIsNullable) {
                    type = type.getNullableInstance();
                }
            }
            if (typeIsValid) {
                substringAccess.setTypeBinding(type);
            } else {
                this.problemRequestor.acceptProblem((Node)substringAccess.getPrimary(), 3362, new String[]{substringAccess.getPrimary().getCanonicalString()});
            }
        }
        this.checkSubstringIndex(substringAccess.getExpr(), substringAccess);
        this.checkSubstringIndex(substringAccess.getExpr2(), substringAccess);
    }

    private int getSubstringLength(Expression firstExpr, Expression secondExpr) {
        int intFromSecondExpr = new IntFromExpressionGetter().getInt(secondExpr);
        if (intFromSecondExpr == -1) {
            return -1;
        }
        int intFromFirstExpr = new IntFromExpressionGetter().getInt(firstExpr);
        if (intFromFirstExpr == -1) {
            return -1;
        }
        return intFromSecondExpr - intFromFirstExpr + 1;
    }

    private void checkSubstringIndex(Expression index, SubstringAccess parentAccess) {
        ITypeBinding tBinding = index.resolveTypeBinding();
        if (tBinding != null) {
            PrimitiveTypeBinding pTypeBinding;
            boolean typeIsValid = false;
            if (tBinding.isDynamic()) {
                typeIsValid = true;
            } else if (3 == tBinding.getKind() && Primitive.isNumericType((pTypeBinding = (PrimitiveTypeBinding)tBinding).getPrimitive()) && pTypeBinding.getDecimals() == 0) {
                typeIsValid = true;
            }
            if (!typeIsValid) {
                this.problemRequestor.acceptProblem((Node)index, 3363, new String[]{index.getCanonicalString(), parentAccess.getCanonicalString()});
            }
        }
    }

    @Override
    public void endVisit(FieldAccess fieldAccess) {
        int[] dimensions;
        if (fieldAccess.resolveTypeBinding() != null) {
            return;
        }
        IDataBinding expressionData = fieldAccess.getPrimary().resolveDataBinding();
        ITypeBinding expressionType = fieldAccess.getPrimary().resolveTypeBinding();
        IDataBinding dataBinding = null;
        if (expressionData == IBinding.NOT_FOUND_BINDING) {
            dataBinding = null;
        } else if (expressionData != null && expressionData.getKind() == 5) {
            dataBinding = ((StructureItemBinding)expressionData).findData(fieldAccess.getID());
        } else if (expressionType != null) {
            if (expressionType == IBinding.NOT_FOUND_BINDING) {
                dataBinding = null;
            } else {
                IFunctionBinding findFunction;
                if (fieldAccess.getParent() instanceof FunctionInvocation && 21 == expressionType.getKind() && IBinding.NOT_FOUND_BINDING != (findFunction = expressionType.findFunction(fieldAccess.getID()))) {
                    dataBinding = new NestedFunctionBinding(InternUtil.internCaseSensitive((String)fieldAccess.getCanonicalString()), null, findFunction);
                }
                if (dataBinding == null) {
                    dataBinding = expressionType.isDynamicallyAccessible() ? new DynamicDataBinding(fieldAccess.getCaseSensitiveID(), null) : (fieldAccess.getPrimary() instanceof ThisExpression ? expressionType.findData(fieldAccess.getID()) : this.findData(expressionType, fieldAccess.getID()));
                }
            }
        }
        if (dataBinding == null) {
            return;
        }
        if (dataBinding == IBinding.NOT_FOUND_BINDING) {
            int endOffset = fieldAccess.getOffset() + fieldAccess.getLength();
            this.problemRequestor.acceptProblem(endOffset - fieldAccess.getID().length(), endOffset, 6619, new String[]{fieldAccess.getCanonicalString()});
        } else {
            if (dataBinding.isDataBindingWithImplicitQualifier()) {
                fieldAccess.setAttributeOnName(Name.IMPLICIT_QUALIFIER_DATA_BINDING, dataBinding.getImplicitQualifier());
                dataBinding = dataBinding.getWrappedDataBinding();
            }
            fieldAccess.setDataBinding(dataBinding);
            if (dataBinding != null && dataBinding != IBinding.NOT_FOUND_BINDING) {
                ITypeBinding type = dataBinding.getType();
                fieldAccess.setTypeBinding(type);
                if (dataBinding.getKind() == 12) {
                    fieldAccess.setDataBinding(IBinding.NOT_FOUND_BINDING);
                    this.problemRequestor.acceptProblem((Node)fieldAccess, 6620, new String[]{fieldAccess.getCanonicalString()});
                } else if (type != null) {
                    this.dependencyRequestor.recordTypeBinding(type);
                }
            }
        }
        if (expressionType != null && expressionType != IBinding.NOT_FOUND_BINDING && expressionType.getKind() == 2 && 6 != expressionType.getBaseType().getKind() && fieldAccess.resolveTypeBinding() != null && !fieldAccess.resolveTypeBinding().isFunctionBinding()) {
            if (this.dotOperatorAllowedForArrays) {
                ITypeBinding currentType = fieldAccess.resolveTypeBinding();
                if (Binding.isValidBinding(currentType)) {
                    fieldAccess.setTypeBinding(ArrayTypeBinding.getInstance(currentType));
                }
            } else {
                this.problemRequestor.acceptProblem((Node)fieldAccess.getPrimary(), 6585, new String[]{fieldAccess.getPrimary().getCanonicalString()});
            }
        }
        new CheckNoDynamicAccessVisitor().check(fieldAccess.getPrimary(), fieldAccess);
        IDataBinding fieldAccessDB = fieldAccess.resolveDataBinding();
        if (fieldAccessDB != null && fieldAccessDB != IBinding.NOT_FOUND_BINDING && this.isMultiplyOccuringItem(fieldAccessDB) && (dimensions = this.getDimensions(fieldAccess)).length != 0 && !this.compilerOptions.isVAGCompatible()) {
            fieldAccess.setTypeBinding(new MultiplyOccuringItemTypeBinding(fieldAccessDB.getType()));
        }
    }

    @Override
    public void endVisit(SimpleName simpleName) {
        ITypeBinding qualifierTypeBinding;
        this.endVisitName(simpleName);
        IDataBinding qualifier = (IDataBinding)simpleName.getAttribute(Name.IMPLICIT_QUALIFIER_DATA_BINDING);
        if (Binding.isValidBinding(qualifier) && Binding.isValidBinding(qualifier.getType()) && 2 == (qualifierTypeBinding = qualifier.getType()).getKind() && 6 == qualifierTypeBinding.getBaseType().getKind() && !this.compilerOptions.isVAGCompatible() && (simpleName.resolveTypeBinding() == null || !simpleName.resolveTypeBinding().isFunctionBinding())) {
            simpleName.setTypeBinding(new MultiplyOccuringItemTypeBinding(simpleName.resolveTypeBinding()));
        }
    }

    @Override
    public void endVisit(QualifiedName qualifiedName) {
        this.endVisitName(qualifiedName);
        ITypeBinding qualifierTypeBinding = this.findArrayInQualifiers(qualifiedName);
        if (qualifierTypeBinding != null && 2 == qualifierTypeBinding.getKind()) {
            if (6 == qualifierTypeBinding.getBaseType().getKind()) {
                if (!(this.compilerOptions.isVAGCompatible() || qualifiedName.resolveTypeBinding() != null && qualifiedName.resolveTypeBinding().isFunctionBinding())) {
                    qualifiedName.setTypeBinding(new MultiplyOccuringItemTypeBinding(qualifiedName.resolveTypeBinding()));
                }
            } else if (qualifiedName.resolveTypeBinding() != null && !qualifiedName.resolveTypeBinding().isFunctionBinding()) {
                if (this.dotOperatorAllowedForArrays) {
                    ITypeBinding currentType = qualifiedName.resolveTypeBinding();
                    if (Binding.isValidBinding(currentType)) {
                        qualifiedName.setTypeBinding(ArrayTypeBinding.getInstance(currentType));
                    }
                } else {
                    this.problemRequestor.acceptProblem((Node)qualifiedName.getQualifier(), 6585, new String[]{qualifiedName.getQualifier().getCanonicalName()});
                }
            }
        }
    }

    private ITypeBinding findArrayInQualifiers(QualifiedName qName) {
        Name qualifier = qName.getQualifier();
        ITypeBinding qualifierType = qualifier.resolveTypeBinding();
        if (Binding.isValidBinding(qualifierType) && 2 == qualifierType.getKind()) {
            return qualifierType;
        }
        if (qualifier.isQualifiedName()) {
            return this.findArrayInQualifiers((QualifiedName)qualifier);
        }
        return null;
    }

    private void endVisitName(Name name) {
        int[] dimensions;
        IDataBinding dBinding = name.resolveDataBinding();
        if (dBinding != null && dBinding != IBinding.NOT_FOUND_BINDING && this.isMultiplyOccuringItem(dBinding) && (dimensions = this.getDimensions(name)).length != 0 && !this.compilerOptions.isVAGCompatible()) {
            name.setTypeBinding(new MultiplyOccuringItemTypeBinding(dBinding.getType()));
        }
    }

    private boolean isMultiplyOccuringItem(IDataBinding dBinding) {
        switch (dBinding.getKind()) {
            case 5: {
                return ((StructureItemBinding)dBinding).isMultiplyOccuring();
            }
            case 7: {
                return ((FormFieldBinding)dBinding).isMultiplyOccuring();
            }
        }
        return false;
    }

    private void bindNameFromSQLRecordArrayBindingsInIOObjects(SimpleName simpleName) {
        Iterator iter = this.IOObjectsInCurrentStatement.iterator();
        while (iter.hasNext()) {
            IDataBinding dataBindingFromIOObject;
            ITypeBinding baseElementType;
            ITypeBinding nextTypeBinding;
            IDataBinding nextDataBinding = ((Expression)iter.next()).resolveDataBinding();
            if (nextDataBinding == null || nextDataBinding == IBinding.NOT_FOUND_BINDING || (nextTypeBinding = nextDataBinding.getType()).getKind() != 2 || (baseElementType = ((ArrayTypeBinding)nextTypeBinding).getBaseType()).getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord") == null || (dataBindingFromIOObject = (IDataBinding)baseElementType.getSimpleNamesToDataBindingsMap().get(simpleName.getIdentifier())) == null) continue;
            if (simpleName.resolveBinding() == null) {
                simpleName.setBinding(dataBindingFromIOObject);
                simpleName.setTypeBinding(dataBindingFromIOObject.getType());
                simpleName.setAttribute(Name.IMPLICIT_QUALIFIER_DATA_BINDING, nextDataBinding);
                continue;
            }
            simpleName.setBinding(AmbiguousDataBinding.getInstance());
        }
    }

    protected IDataBinding[] getPCBParams() {
        IAnnotationBinding pcbparamsBinding;
        IAnnotationBinding dliBinding = this.getDLIAnnotation();
        if (dliBinding != null && (pcbparamsBinding = (IAnnotationBinding)dliBinding.findData(InternUtil.intern((String)"pcbParms"))) != IBinding.NOT_FOUND_BINDING) {
            IDataBinding[] dataBindings = (IDataBinding[])pcbparamsBinding.getValue();
            return dataBindings;
        }
        return null;
    }

    protected IDataBinding getPSB() {
        IAnnotationBinding psbBinding;
        IAnnotationBinding dliBinding = this.getDLIAnnotation();
        if (dliBinding != null && (psbBinding = (IAnnotationBinding)dliBinding.findData(InternUtil.intern((String)"psb"))) != IBinding.NOT_FOUND_BINDING) {
            IDataBinding dataBindings = (IDataBinding)psbBinding.getValue();
            return dataBindings;
        }
        return null;
    }

    protected IAnnotationBinding getDLIAnnotation() {
        IPartBinding functionContainerBinding = this.currentScope.getPartBinding();
        if (functionContainerBinding != null) {
            return functionContainerBinding.getAnnotation(new String[]{"egl", "io", "dli"}, "DLI");
        }
        return null;
    }

    @Override
    public boolean visit(UsingPCBClause usingPCBClause) {
        final Expression expr = usingPCBClause.getPCB();
        final DefaultBinder thisobject = this;
        expr.accept(new AbstractASTVisitor(){
            boolean bFound = false;

            @Override
            public boolean visit(QualifiedName qualifiedName) {
                qualifiedName.getQualifier().accept(thisobject);
                IDataBinding qDataBinding = qualifiedName.getQualifier().resolveDataBinding();
                if (StatementValidator.isValidBinding(qDataBinding)) {
                    ITypeBinding typeBinding;
                    String name = qualifiedName.getIdentifier();
                    IDataBinding dataBinding = DefaultBinder.this.getPSB();
                    if (StatementValidator.isValidBinding(dataBinding) && qDataBinding == dataBinding && StatementValidator.isValidBinding(typeBinding = dataBinding.getType()) && typeBinding.getAnnotation(new String[]{"egl", "io", "dli"}, "PSBRecord") != null && typeBinding.getKind() == 7) {
                        List fields = ((FlexibleRecordBinding)typeBinding).getDeclaredFields();
                        for (FlexibleRecordFieldBinding field : fields) {
                            if (field.getName() != name) continue;
                            qualifiedName.setBinding(field);
                            qualifiedName.setTypeBinding(field.getType());
                            DefaultBinder.this.dependencyRequestor.recordTypeBinding(field.getType());
                            this.bFound = true;
                        }
                    }
                }
                if (!this.bFound) {
                    qualifiedName.setBinding(IBinding.NOT_FOUND_BINDING);
                    qualifiedName.setTypeBinding(IBinding.NOT_FOUND_BINDING);
                    this.doError();
                }
                return false;
            }

            @Override
            public boolean visit(SimpleName simpleName) {
                IDataBinding[] dataBindings = DefaultBinder.this.getPCBParams();
                if (dataBindings != null) {
                    int i = 0;
                    while (i < dataBindings.length) {
                        IDataBinding binding = dataBindings[i];
                        if (StatementValidator.isValidBinding(binding) && InternUtil.intern((String)simpleName.getCanonicalString()) == binding.getName()) {
                            simpleName.setBinding(binding);
                            this.bFound = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (!this.bFound) {
                    simpleName.setBinding(IBinding.NOT_FOUND_BINDING);
                    this.doError();
                }
                return false;
            }

            public void doError() {
                IPartBinding functionContainerBinding = DefaultBinder.this.currentScope.getPartBinding();
                if (functionContainerBinding != null && (functionContainerBinding.getKind() == 11 || functionContainerBinding.getKind() == 13)) {
                    DefaultBinder.this.problemRequestor.acceptProblem((Node)expr, 7871, new String[]{expr.getCanonicalString()});
                }
            }
        });
        return false;
    }

    @Override
    public boolean visit(OpenStatement openStatement) {
        this.IOObjectsInCurrentStatement = openStatement.getIOObjects();
        return true;
    }

    @Override
    public void endVisit(OpenStatement openStatement) {
        this.IOObjectsInCurrentStatement = Collections.EMPTY_LIST;
    }

    @Override
    public boolean visit(GetByKeyStatement openStatement) {
        this.IOObjectsInCurrentStatement = openStatement.getIOObjects();
        return true;
    }

    @Override
    public void endVisit(GetByKeyStatement getByKeyStatement) {
        this.IOObjectsInCurrentStatement = Collections.EMPTY_LIST;
        this.validateIOStatementInDLIProgram(getByKeyStatement);
    }

    @Override
    public void endVisit(DeleteStatement getByKeyStatement) {
        this.IOObjectsInCurrentStatement = Collections.EMPTY_LIST;
        this.validateIOStatementInDLIProgram(getByKeyStatement);
    }

    @Override
    public boolean visit(GetByPositionStatement openStatement) {
        this.IOObjectsInCurrentStatement = openStatement.getIOObjects();
        return true;
    }

    @Override
    public void endVisit(GetByPositionStatement openStatement) {
        this.IOObjectsInCurrentStatement = Collections.EMPTY_LIST;
        this.validateIOStatementInDLIProgram(openStatement);
    }

    @Override
    public void endVisit(AddStatement openStatement) {
        this.validateIOStatementInDLIProgram(openStatement);
    }

    @Override
    public void endVisit(ReplaceStatement openStatement) {
        this.validateIOStatementInDLIProgram(openStatement);
    }

    @Override
    public boolean visit(ExecuteStatement openStatement) {
        this.IOObjectsInCurrentStatement = openStatement.getIOObjects();
        return true;
    }

    @Override
    public void endVisit(ExecuteStatement openStatement) {
        this.IOObjectsInCurrentStatement = Collections.EMPTY_LIST;
    }

    @Override
    public boolean visit(IntoClause intoClause) {
        this.visitingIntoClause = true;
        return true;
    }

    @Override
    public void endVisit(IntoClause intoClause) {
        this.visitingIntoClause = false;
    }

    @Override
    public boolean visit(IsAExpression isAExpression) {
        isAExpression.getExpression().accept(this);
        try {
            Type typeAST = isAExpression.getType();
            ITypeBinding type = this.bindType(typeAST);
            this.checkTypeForIsaOrAs(typeAST, type);
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
        }
        return false;
    }

    @Override
    public boolean visit(AsExpression asExpression) {
        asExpression.getExpression().accept(this);
        try {
            if (asExpression.hasType()) {
                Type typeAST = asExpression.getType();
                ITypeBinding type = this.bindType(typeAST);
                this.checkTypeForIsaOrAs(typeAST, type);
            }
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
        }
        return false;
    }

    private void checkTypeForIsaOrAs(Type typeAST, ITypeBinding type) {
        if (type.isPartBinding() && !((IPartBinding)type).isDeclarablePart()) {
            this.problemRequestor.acceptProblem((Node)typeAST, 3261, new String[]{typeAST.getCanonicalName()});
        } else {
            Type baseType = typeAST.getBaseType();
            if (baseType.isPrimitiveType()) {
                PrimitiveTypeValidator.validate((PrimitiveType)baseType, this.problemRequestor, this.compilerOptions);
            }
            if (typeAST.isNullableType()) {
                this.problemRequestor.acceptProblem(typeAST, 3275);
            }
            Type tempTypeAST = typeAST;
            while (tempTypeAST.isArrayType()) {
                if (((ArrayType)tempTypeAST).hasInitialSize()) {
                    this.problemRequestor.acceptProblem(((ArrayType)tempTypeAST).getInitialSize(), 3264);
                }
                if (!(tempTypeAST = ((ArrayType)tempTypeAST).getElementType()).isNullableType()) continue;
                tempTypeAST = ((NullableType)tempTypeAST).getBaseType();
            }
        }
    }

    @Override
    public boolean visit(InExpression inExpression) {
        inExpression.getFirstExpression().accept(this);
        this.dotOperatorAllowedForArrays = true;
        inExpression.getSecondExpression().accept(this);
        this.dotOperatorAllowedForArrays = false;
        if (inExpression.hasFromExpression()) {
            inExpression.getFromExpression().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(LikeMatchesExpression likeMatchesExpression) {
        likeMatchesExpression.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN));
        Expression operand1 = likeMatchesExpression.getFirstExpression();
        Expression operand2 = likeMatchesExpression.getSecondExpression();
        ITypeBinding type1 = operand1.resolveTypeBinding();
        ITypeBinding type2 = operand2.resolveTypeBinding();
        this.checkTypeForLikeMatchesOperand(type1, operand1);
        this.checkTypeForLikeMatchesOperand(type2, operand2);
        if (likeMatchesExpression.hasEscapeString()) {
            String escapeCharacter = likeMatchesExpression.getEscapeString();
            escapeCharacter = escapeCharacter.replaceFirst("^\\\"", "");
            if ((escapeCharacter = escapeCharacter.replaceFirst("\\\"$", "")).length() > 1 || escapeCharacter.getBytes().length > 1) {
                this.problemRequestor.acceptProblem((Node)likeMatchesExpression, 5040, new String[]{escapeCharacter});
            }
        }
    }

    private void checkTypeForLikeMatchesOperand(ITypeBinding type, Expression operandNode) {
        if (type != null) {
            if (3 != type.getKind()) {
                this.problemRequestor.acceptProblem((Node)operandNode, 5041, new String[]{operandNode.getCanonicalString()});
            } else if (!type.isDynamic()) {
                Primitive prim = ((PrimitiveTypeBinding)type).getPrimitive();
                if (!Primitive.isStringType(prim)) {
                    this.problemRequestor.acceptProblem((Node)operandNode, 5041, new String[]{operandNode.getCanonicalString()});
                } else if (Primitive.HEX == prim || Primitive.DBCHAR == prim) {
                    this.problemRequestor.acceptProblem((Node)operandNode, 5042, new String[]{operandNode.getCanonicalString()});
                }
            }
        }
    }

    @Override
    public boolean visit(NewExpression newExpression) {
        ITypeBinding type = null;
        try {
            if (newExpression.resolveTypeBinding() == null) {
                type = this.convertDataItemToPrimitive(this.bindType(newExpression.getType()));
                newExpression.setTypeBinding(type);
            }
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            newExpression.setTypeBinding(IBinding.NOT_FOUND_BINDING);
        }
        if (newExpression.getType().isNullableType()) {
            this.problemRequestor.acceptProblem(newExpression.getType(), 3275);
        }
        if (newExpression.hasSettingsBlock() && (type = newExpression.resolveTypeBinding()) != IBinding.NOT_FOUND_BINDING) {
            LocalVariableBinding dataBinding = new LocalVariableBinding(type.getCaseSensitiveName(), null, type);
            newExpression.setDataBindingForAnnotations(dataBinding);
            TypeBindingScope typeScope = new TypeBindingScope(NullScope.INSTANCE, type, null);
            AnnotationLeftHandScope lhScope = new AnnotationLeftHandScope(typeScope, type, type, dataBinding, -1, this.currentBinding);
            lhScope.setWithinNewExpression(true);
            SettingsBlockAnnotationBindingsCompletor completor = new SettingsBlockAnnotationBindingsCompletor(this.currentScope, this.currentBinding, lhScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            newExpression.getSettingsBlock().accept(completor);
            Iterator iter = newExpression.getSettingsBlock().getSettings().iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).accept(this);
            }
        }
        if (type != null && type != IBinding.NOT_FOUND_BINDING) {
            if (type.isReference()) {
                if ((14 == type.getKind() || 15 == type.getKind()) && type != SystemPartManager.findType(type.getName())) {
                    this.problemRequestor.acceptProblem(newExpression.getType(), 7825);
                }
            } else if (type.isPartBinding() && !((IPartBinding)type).isDeclarablePart()) {
                this.problemRequestor.acceptProblem((Node)newExpression.getType(), 3259, new String[]{newExpression.getType().getCanonicalName()});
            }
        }
        if (newExpression.hasArgumentList()) {
            Iterator iter = newExpression.getArguments().iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        Node parent = settingsBlock.getParent();
        final boolean[] invalid = new boolean[1];
        parent.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(IfStatement ifStatement) {
                invalid[0] = true;
                return false;
            }

            @Override
            public boolean visit(ElseBlock elseBlock) {
                invalid[0] = true;
                return false;
            }

            @Override
            public boolean visit(WhileStatement whileStatement) {
                invalid[0] = true;
                return false;
            }

            @Override
            public boolean visit(WhenClause whenClause) {
                invalid[0] = true;
                return false;
            }

            @Override
            public boolean visit(TryStatement tryStatement) {
                invalid[0] = true;
                return false;
            }

            @Override
            public boolean visit(OnExceptionBlock onExceptionBlock) {
                invalid[0] = true;
                return false;
            }

            @Override
            public boolean visit(ForStatement forStatement) {
                invalid[0] = true;
                return false;
            }

            @Override
            public boolean visit(ForEachStatement forEachStatement) {
                invalid[0] = true;
                return false;
            }
        });
        if (invalid[0]) {
            this.problemRequestor.acceptProblem((Node)settingsBlock, 3249, new String[0]);
        }
        return super.visit(settingsBlock);
    }

    private ITypeBinding convertDataItemToPrimitive(ITypeBinding type) {
        if (type != null && IBinding.NOT_FOUND_BINDING != type) {
            switch (type.getKind()) {
                case 17: {
                    return ((DataItemBinding)type).getPrimitiveTypeBinding();
                }
                case 2: {
                    return ArrayTypeBinding.getInstance(this.convertDataItemToPrimitive(((ArrayTypeBinding)type).getElementType()));
                }
            }
        }
        return type;
    }

    @Override
    public void endVisit(NewExpression newExpression) {
        block11: {
            block12: {
                IDataBinding matchingConstructor;
                Type type;
                block13: {
                    FunctionResolver resolver;
                    ITypeBinding targetType = newExpression.getType().resolveTypeBinding();
                    if (targetType == null) break block11;
                    if (DefaultBinder.typeIs(targetType, new String[]{"egl", "ui", "console"}, "Menu")) {
                        final boolean[] hasLabelKeyOrLabelText = new boolean[1];
                        if (newExpression.hasSettingsBlock()) {
                            Iterator iter = newExpression.getSettingsBlock().getSettings().iterator();
                            while (!hasLabelKeyOrLabelText[0] && iter.hasNext()) {
                                ((Node)iter.next()).accept(new DefaultASTVisitor(){

                                    @Override
                                    public boolean visit(Assignment assignment) {
                                        assignment.getLeftHandSide().accept(new AbstractASTExpressionVisitor(){

                                            @Override
                                            public boolean visitName(Name name) {
                                                String identifier = name.getIdentifier();
                                                if (InternUtil.intern((String)"labelKey") == identifier || InternUtil.intern((String)"labelText") == identifier) {
                                                    hasLabelKeyOrLabelText[0] = true;
                                                }
                                                return false;
                                            }
                                        });
                                        return false;
                                    }
                                });
                            }
                        }
                        if (!hasLabelKeyOrLabelText[0]) {
                            this.problemRequestor.acceptProblem((Node)newExpression.getType(), 7724, new String[]{"labelText"});
                        }
                    }
                    if (!newExpression.hasArgumentList()) break block12;
                    OverloadedFunctionSet constructors = this.getConstructors(targetType);
                    type = newExpression.getType();
                    if (type.isNameType()) {
                        ((NameType)type).getName().setAttribute(Name.OVERLOADED_FUNCTION_SET, constructors);
                    }
                    if (IBinding.NOT_FOUND_BINDING != (matchingConstructor = (resolver = new FunctionResolver(this.compilerOptions)).findMatchingFunction(constructors, this.getArgumentTypes(newExpression.getArguments()), false)) && AmbiguousDataBinding.getInstance() != matchingConstructor) break block13;
                    this.problemRequestor.acceptProblem((Node)newExpression.getType(), 7830, new String[]{targetType.getCaseSensitiveName()});
                    newExpression.setConstructorBinding(IBinding.NOT_FOUND_BINDING);
                    break block11;
                }
                newExpression.setConstructorBinding(matchingConstructor);
                if (!Binding.isValidBinding(matchingConstructor) || !((ConstructorBinding)matchingConstructor).isPrivate() || this.currentScope.getPartBinding() == ((ConstructorBinding)matchingConstructor).getDeclaringPart()) break block11;
                this.problemRequestor.acceptProblem((Node)type, 3434, new String[]{type.getCanonicalName()});
                break block11;
            }
            ITypeBinding tBinding = newExpression.getType().resolveTypeBinding();
            if (Binding.isValidBinding(tBinding) && tBinding.isReference() && !tBinding.isInstantiable() && !tBinding.isNullable() && this.currentScope.getPartBinding() != tBinding) {
                this.problemRequestor.acceptProblem((Node)newExpression.getType(), 3435, new String[]{newExpression.getType().getCanonicalName()});
            } else {
                Type currType = newExpression.getType();
                while (currType.isArrayType()) {
                    ArrayType arrayType = (ArrayType)currType;
                    if (arrayType.hasInitialSize() && !this.isZeroLiteral(arrayType.getInitialSize()) && Binding.isValidBinding(tBinding = arrayType.getElementType().resolveTypeBinding()) && tBinding.isReference() && !tBinding.isInstantiable() && !tBinding.isNullable() && this.currentScope.getPartBinding() != tBinding) {
                        this.problemRequestor.acceptProblem((Node)arrayType.getElementType(), 3435, new String[]{arrayType.getElementType().getCanonicalName()});
                    }
                    currType = arrayType.getElementType();
                }
            }
        }
        if (newExpression.getType().isArrayType()) {
            newExpression.getType().accept(new AbstractASTVisitor(){

                @Override
                public boolean visit(ArrayType arrayType) {
                    if (arrayType.hasInitialSize()) {
                        final boolean[] sizeIsValid = new boolean[1];
                        arrayType.getInitialSize().accept(new DefaultASTVisitor(){

                            @Override
                            public boolean visit(IntegerLiteral integerLiteral) {
                                sizeIsValid[0] = true;
                                return false;
                            }
                        });
                        if (!sizeIsValid[0]) {
                            DefaultBinder.this.problemRequestor.acceptProblem((Node)arrayType.getInitialSize(), 3263, new String[]{arrayType.getInitialSize().getCanonicalString()});
                        }
                    }
                    return true;
                }
            });
        }
        if (newExpression.hasSettingsBlock()) {
            newExpression.getSettingsBlock().accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(SettingsBlock settingsBlock) {
                    return true;
                }

                @Override
                public boolean visit(Assignment assignment) {
                    DefaultBinder.this.validateAssignment(assignment, true);
                    return false;
                }
            });
        }
    }

    private boolean isZeroLiteral(Expression expr) {
        final boolean[] isZero = new boolean[1];
        expr.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(IntegerLiteral integerLiteral) {
                isZero[0] = Integer.valueOf(integerLiteral.getValue()) == 0;
                return false;
            }
        });
        return isZero[0];
    }

    private List getArgumentTypes(List functionArguments) {
        ArrayList<ITypeBinding> list = new ArrayList<ITypeBinding>();
        Iterator i = functionArguments.iterator();
        while (i.hasNext()) {
            list.add(((Expression)i.next()).resolveTypeBinding());
        }
        return list;
    }

    private boolean[] getArgumentIsLiteralArray(List arguments) {
        boolean[] result = new boolean[arguments.size()];
        int i = 0;
        while (i < arguments.size()) {
            result[i] = arguments.get(i) instanceof LiteralExpression;
            ++i;
        }
        return result;
    }

    private OverloadedFunctionSet getConstructors(ITypeBinding targetType) {
        OverloadedFunctionSet constructors;
        block4: {
            block5: {
                block3: {
                    constructors = new OverloadedFunctionSet();
                    constructors.setName(InternUtil.internCaseSensitive((String)"constructor"));
                    if (28 != targetType.getKind()) break block3;
                    Iterator iter = ((ExternalTypeBinding)targetType).getConstructors().iterator();
                    while (iter.hasNext()) {
                        constructors.addNestedFunctionBinding((IDataBinding)iter.next());
                    }
                    break block4;
                }
                if (10 != targetType.getKind()) break block5;
                Iterator iter = ((HandlerBinding)targetType).getConstructors().iterator();
                while (iter.hasNext()) {
                    constructors.addNestedFunctionBinding((IDataBinding)iter.next());
                }
                break block4;
            }
            if (21 != targetType.getKind()) break block4;
            Iterator iter = ((DictionaryBinding)targetType).getConstructors().iterator();
            while (iter.hasNext()) {
                constructors.addNestedFunctionBinding((IDataBinding)iter.next());
            }
        }
        return constructors;
    }

    @Override
    public boolean visit(CloseStatement closeStatement) {
        IProblemRequestor pRequestor = this.problemRequestor;
        this.problemRequestor = NullProblemRequestor.getInstance();
        closeStatement.getExpr().accept(this);
        this.problemRequestor = pRequestor;
        return false;
    }

    @Override
    public boolean visit(IsNotExpression isNotExpression) {
        this.problemRequestor.acceptProblem((Node)isNotExpression, 5009, new String[0]);
        isNotExpression.getFirstExpression().accept(this);
        final IDataBinding leftExpressionDataBinding = isNotExpression.getFirstExpression().resolveDataBinding();
        isNotExpression.getSecondExpression().accept(new AbstractASTExpressionVisitor(){
            boolean stateIsValid = false;

            @Override
            public boolean visit(SimpleName simpleName) {
                IsNotStateBinding dBinding = IsNotStateBinding.toIsNotStateBinding(simpleName.getIdentifier());
                if (dBinding != null) {
                    simpleName.setBinding(dBinding);
                    this.stateIsValid = true;
                } else {
                    simpleName.setBinding(IBinding.NOT_FOUND_BINDING);
                }
                return false;
            }

            @Override
            public boolean visit(QualifiedName qualifiedName) {
                qualifiedName.setBinding(IBinding.NOT_FOUND_BINDING);
                return false;
            }

            @Override
            public void endVisitExpression(Expression expression) {
                if (!(this.stateIsValid || DefaultBinder.dataBindingIs(leftExpressionDataBinding, new String[]{"egl", "core"}, "SysVar", "SYSTEMTYPE") && DefaultBinder.this.currentScope.getPartBinding() != null)) {
                    DefaultBinder.this.problemRequestor.acceptProblem((Node)expression, 5168, new String[]{expression.getCanonicalString()});
                }
            }
        });
        return false;
    }

    @Override
    public boolean visit(ReturningToNameClause returningToNameClause) {
        try {
            this.bindTypeName(returningToNameClause.getName());
        }
        catch (ResolutionException resolutionException) {}
        return false;
    }

    @Override
    public boolean visit(ForwardStatement forwardStatement) {
        if (forwardStatement.hasForwardTarget()) {
            final Expression expr = forwardStatement.getForwardTarget();
            if (forwardStatement.isForwardToURL()) {
                expr.accept(this);
            } else {
                final DefaultBinder thisDefaultBinder = this;
                expr.accept(new AbstractASTExpressionVisitor(){

                    @Override
                    public boolean visit(StringLiteral stringLiteral) {
                        String pgmname = InternUtil.intern((String)stringLiteral.getValue());
                        ITypeBinding result = DefaultBinder.this.currentScope.findType(pgmname);
                        if (result == IBinding.NOT_FOUND_BINDING) {
                            expr.setTypeBinding(IBinding.NOT_FOUND_BINDING);
                        } else if (result == ITypeBinding.AMBIGUOUS_TYPE) {
                            expr.setTypeBinding(ITypeBinding.AMBIGUOUS_TYPE);
                        } else {
                            DefaultBinder.this.dependencyRequestor.recordTypeBinding(result);
                        }
                        expr.setTypeBinding(result);
                        return false;
                    }

                    @Override
                    public boolean visitExpression(Expression expr2) {
                        if (expr2.isName()) {
                            try {
                                DefaultBinder.this.bindExpressionName((Name)expr2);
                            }
                            catch (ResolutionException resolutionException) {
                                DefaultBinder.this.problemRequestor.acceptProblem(expr2, 5190);
                                return false;
                            }
                        } else {
                            expr2.accept(thisDefaultBinder);
                        }
                        ITypeBinding tBinding = expr2.resolveTypeBinding();
                        if (Binding.isValidBinding(tBinding) && !TypeCompatibilityUtil.isMoveCompatible(PrimitiveTypeBinding.getInstance(Primitive.STRING), tBinding, expr2, DefaultBinder.this.compilerOptions)) {
                            DefaultBinder.this.problemRequestor.acceptProblem(expr2, 5190);
                        }
                        return false;
                    }
                });
            }
        }
        Iterator iter = forwardStatement.getArguments().iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).accept(this);
        }
        iter = forwardStatement.getForwardOptions().iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(ParenthesizedExpression parenthesizedExpression) {
        parenthesizedExpression.setTypeBinding(parenthesizedExpression.getExpression().resolveTypeBinding());
    }

    @Override
    public void endVisit(UnaryExpression unaryExpression) {
        Expression operand = unaryExpression.getExpression();
        ITypeBinding operandType = operand.resolveTypeBinding();
        if (operandType != null) {
            UnaryExpression.Operator operator = unaryExpression.getOperator();
            if (operator == UnaryExpression.Operator.PLUS || operator == UnaryExpression.Operator.MINUS) {
                unaryExpression.setTypeBinding(DefaultBinder.inferTypeForNumericOperand(operand, this.problemRequestor));
            } else {
                unaryExpression.setTypeBinding(DefaultBinder.inferTypeForBooleanOperand(operand, this.problemRequestor));
            }
        }
    }

    @Override
    public void endVisit(BinaryExpression binaryExpression) {
        Expression operand1 = binaryExpression.getFirstExpression();
        Expression operand2 = binaryExpression.getSecondExpression();
        ITypeBinding type1 = operand1.resolveTypeBinding();
        ITypeBinding type2 = operand2.resolveTypeBinding();
        BinaryExpression.Operator operator = binaryExpression.getOperator();
        new VAGenResolutionWarningsValidator(this.problemRequestor, this.compilerOptions).checkOperands(this.currentScope.getPartBinding(), operand1, operand2, binaryExpression);
        if (type1 != null) {
            if (operator == BinaryExpression.Operator.CONCAT && (2 == type1.getKind() || type2 != null && 2 == type2.getKind())) {
                if (2 == type1.getKind()) {
                    binaryExpression.setTypeBinding(type1);
                } else if (type2 != null && 2 == type2.getKind()) {
                    binaryExpression.setTypeBinding(type2);
                }
            } else if ((DefaultBinder.isStringType(type1) || DefaultBinder.isStringType(type2)) && (operator == BinaryExpression.Operator.PLUS || operator == BinaryExpression.Operator.CONCAT || operator == BinaryExpression.Operator.NULLCONCAT)) {
                binaryExpression.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.STRING));
            } else if (operator == BinaryExpression.Operator.PLUS && DefaultBinder.isStringType(type1) || operator == BinaryExpression.Operator.CONCAT || operator == BinaryExpression.Operator.NULLCONCAT) {
                int length2;
                if (type2 != null) {
                    if (type2.getKind() != 3 && !type2.isDynamic()) {
                        this.problemRequestor.acceptProblem((Node)operand2, 5085, new String[]{operand2.getCanonicalString()});
                    } else if (!(type2.isDynamic() || type1 instanceof PrimitiveTypeBinding && type2 instanceof PrimitiveTypeBinding && (TypeCompatibilityUtil.isMoveCompatible((PrimitiveTypeBinding)type1, (PrimitiveTypeBinding)type2) || Primitive.BOOLEAN == ((PrimitiveTypeBinding)type2).getPrimitive()))) {
                        this.problemRequestor.acceptProblem((Node)binaryExpression, 5084, new String[]{operand1.getCanonicalString(), operand2.getCanonicalString()});
                    }
                    if ((operator == BinaryExpression.Operator.CONCAT || operator == BinaryExpression.Operator.NULLCONCAT) && Binding.isValidBinding(type1) && !DefaultBinder.isStringType(type1)) {
                        this.problemRequestor.acceptProblem((Node)operand1, 5085, new String[]{operand1.getCanonicalString()});
                    }
                } else {
                    operand2.accept(new AbstractASTExpressionVisitor(){

                        @Override
                        public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                            return true;
                        }

                        @Override
                        public void endVisit(SQLLiteral sQLLiteral) {
                            DefaultBinder.this.problemRequestor.acceptProblem((Node)sQLLiteral, 5085, new String[]{sQLLiteral.getCanonicalString()});
                        }
                    });
                }
                int length1 = Binding.isValidBinding(type1) ? this.getFixedLength(type1) : -1;
                int n = length2 = Binding.isValidBinding(type2) ? this.getFixedLength(type2) : -1;
                if (length1 != -1 && length2 != -1) {
                    binaryExpression.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.STRING, length1 + length2));
                } else {
                    binaryExpression.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.STRING));
                }
            } else if (operator == BinaryExpression.Operator.DIVIDE || operator == BinaryExpression.Operator.MINUS || operator == BinaryExpression.Operator.MODULO || operator == BinaryExpression.Operator.PLUS || operator == BinaryExpression.Operator.TIMES || operator == BinaryExpression.Operator.TIMESTIMES) {
                ITypeBinding result = this.validateArithmeticOperation(operand1, operand2, operator, binaryExpression);
                if (result != null) {
                    binaryExpression.setTypeBinding(result);
                }
            } else if (operator == BinaryExpression.Operator.BITAND || operator == BinaryExpression.Operator.BITOR || operator == BinaryExpression.Operator.XOR) {
                type1 = DefaultBinder.inferTypeForBitwiseOperand(operand1, this.problemRequestor);
                type2 = type2 == null ? null : DefaultBinder.inferTypeForBitwiseOperand(operand2, this.problemRequestor);
                binaryExpression.setTypeBinding(type2 == null ? type1 : this.getWiderType(type1, type2));
            } else {
                binaryExpression.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN));
                if (operator == BinaryExpression.Operator.AND || operator == BinaryExpression.Operator.OR) {
                    DefaultBinder.inferTypeForBooleanOperand(operand1, this.problemRequestor);
                    if (type2 != null) {
                        DefaultBinder.inferTypeForBooleanOperand(operand2, this.problemRequestor);
                    }
                } else {
                    boolean[] shouldContinue = new boolean[]{true};
                    class NoNewOrSetValuesExpressionChecker
                    extends AbstractASTExpressionVisitor {
                        boolean isNewOrSetValuesExpression = false;
                        private final /* synthetic */ boolean[] val$shouldContinue;

                        NoNewOrSetValuesExpressionChecker(boolean[] blArray) {
                            this.val$shouldContinue = blArray;
                        }

                        @Override
                        public boolean visitExpression(Expression expression) {
                            return false;
                        }

                        @Override
                        public boolean visit(NewExpression newExpression) {
                            this.isNewOrSetValuesExpression = true;
                            return false;
                        }

                        @Override
                        public boolean visit(SetValuesExpression setValuesExpression) {
                            this.isNewOrSetValuesExpression = true;
                            return false;
                        }

                        @Override
                        public void endVisitExpression(Expression expression) {
                            if (this.isNewOrSetValuesExpression) {
                                DefaultBinder.this.problemRequestor.acceptProblem(expression, 7512);
                                this.val$shouldContinue[0] = false;
                            }
                        }
                    }
                    operand1.accept(new NoNewOrSetValuesExpressionChecker(shouldContinue));
                    operand2.accept(new NoNewOrSetValuesExpressionChecker(shouldContinue));
                    if (!shouldContinue[0]) {
                        return;
                    }
                    if ((type1.isReference() && !type1.isDynamic() || NilBinding.INSTANCE == type1 || type2 != null && (type2.isReference() && !type2.isDynamic() || NilBinding.INSTANCE == type2)) && operator != BinaryExpression.Operator.EQUALS && operator != BinaryExpression.Operator.NOT_EQUALS && (!this.isNumberOrDecimal(type1) || !this.isNumberOrDecimal(type2))) {
                        this.problemRequestor.acceptProblem(binaryExpression, 5048);
                        return;
                    }
                    if ((6 == type1.getKind() || 7 == type1.getKind()) && NilBinding.INSTANCE != type2) {
                        this.problemRequestor.acceptProblem(operand1, 5052);
                        shouldContinue[0] = false;
                    }
                    if (operator == BinaryExpression.Operator.GREATER || operator == BinaryExpression.Operator.GREATER_EQUALS || operator == BinaryExpression.Operator.LESS || operator == BinaryExpression.Operator.LESS_EQUALS) {
                        if (3 == type1.getKind() && ((PrimitiveTypeBinding)type1).getPrimitive() == Primitive.BOOLEAN) {
                            this.problemRequestor.acceptProblem((Node)operand1, 5089, new String[]{operand1.getCanonicalString(), operand2.getCanonicalString()});
                            shouldContinue[0] = false;
                        } else if (Binding.isValidBinding(type2) && 3 == type2.getKind() && ((PrimitiveTypeBinding)type2).getPrimitive() == Primitive.BOOLEAN) {
                            this.problemRequestor.acceptProblem((Node)operand2, 5089, new String[]{operand2.getCanonicalString(), operand1.getCanonicalString()});
                            shouldContinue[0] = false;
                        }
                    }
                    if (!shouldContinue[0]) {
                        return;
                    }
                    if (type1.getAnnotation(new String[]{"egl", "io", "dli"}, "PSBRecord") != null && type1 == type2) {
                        this.problemRequestor.acceptProblem((Node)operand1, 5089, new String[]{operand1.getCanonicalString(), operand2.getCanonicalString()});
                        return;
                    }
                    if (type2 != null) {
                        if (!TypeCompatibilityUtil.isMoveCompatible(type1, type2, operand2, this.compilerOptions) && !TypeCompatibilityUtil.isMoveCompatible(type2, type1, operand1, this.compilerOptions)) {
                            this.problemRequestor.acceptProblem((Node)operand1, 5089, new String[]{operand1.getCanonicalString(), operand2.getCanonicalString()});
                            return;
                        }
                        if ((type1.isDynamic() || type2.isDynamic()) && operator != BinaryExpression.Operator.EQUALS && operator != BinaryExpression.Operator.NOT_EQUALS) {
                            this.problemRequestor.acceptProblem((Node)operand1, 5089, new String[]{operand1.getCanonicalString(), operand2.getCanonicalString()});
                            return;
                        }
                    }
                }
            }
        }
    }

    private boolean isNumberOrDecimal(ITypeBinding type) {
        if (Binding.isValidBinding(type)) {
            return type.getKind() == 3 && (((PrimitiveTypeBinding)type).getPrimitive() == Primitive.NUMBER || ((PrimitiveTypeBinding)type).getPrimitive() == Primitive.DECIMAL);
        }
        return false;
    }

    private ITypeBinding validateArithmeticOperation(Expression operand1, Expression operand2, BinaryExpression.Operator operator, Node node) {
        ITypeBinding type1 = DefaultBinder.inferTypeForNumericOperand(operand1, this.problemRequestor);
        ITypeBinding type2 = operand2.resolveTypeBinding();
        type2 = type2 == null ? null : DefaultBinder.inferTypeForNumericOperand(operand2, this.problemRequestor);
        ITypeBinding result = null;
        if (type1 != null && type2 != null) {
            if (DefaultBinder.isDateTimeType(type1) || DefaultBinder.isDateTimeType(type2)) {
                Primitive inferredPrim = TypeCompatibilityUtil.getDateTimeArithmeticResult(type1, type2, operator);
                if (inferredPrim == null) {
                    this.problemRequestor.acceptProblem(node, 5079, new String[]{operand1.getCanonicalString(), operand2.getCanonicalString(), operator.toString()});
                } else {
                    PrimitiveTypeBinding primTypeBinding = Primitive.SECONDSPAN_INTERVAL == inferredPrim ? PrimitiveTypeBinding.getInstance(inferredPrim, "ddmmssffffff") : (Primitive.MONTHSPAN_INTERVAL == inferredPrim ? PrimitiveTypeBinding.getInstance(inferredPrim, "yyyyMM") : PrimitiveTypeBinding.getInstance(inferredPrim));
                    result = primTypeBinding;
                }
            } else if (!type1.isDynamic() && !type2.isDynamic()) {
                result = this.getWiderType(type1, type2);
                if (!TypeCompatibilityUtil.isMoveCompatible((PrimitiveTypeBinding)type1, (PrimitiveTypeBinding)type2)) {
                    this.problemRequestor.acceptProblem(node, 5084, new String[]{operand1.getCanonicalString(), operand2.getCanonicalString()});
                }
            } else {
                result = PrimitiveTypeBinding.getInstance(Primitive.ANY);
            }
        }
        return result;
    }

    private int getFixedLength(ITypeBinding type1) {
        switch (type1.getKind()) {
            case 6: {
                return ((FixedRecordBinding)type1).getSizeInBytes();
            }
            case 3: {
                int bytes = ((PrimitiveTypeBinding)type1).getBytes();
                return bytes == 0 ? -1 : bytes;
            }
        }
        return -1;
    }

    private ITypeBinding getWiderType(ITypeBinding type1, ITypeBinding type2) {
        return TypeCompatibilityUtil.valueWideningDistance(type1, type2, this.compilerOptions) > 0 ? type2 : type1;
    }

    @Override
    public void endVisit(Assignment assignment) {
        Expression rightHandSide = assignment.getRightHandSide();
        ITypeBinding rhType = rightHandSide.resolveTypeBinding();
        Expression leftHandSide = assignment.getLeftHandSide();
        ITypeBinding lhType = leftHandSide.resolveTypeBinding();
        if (Binding.isValidBinding(rhType) && Binding.isValidBinding(lhType)) {
            Assignment.Operator operator = assignment.getOperator();
            if (Assignment.Operator.PLUS != operator && Assignment.Operator.MINUS != operator && Assignment.Operator.TIMES != operator && Assignment.Operator.DIVIDE != operator && Assignment.Operator.MODULO != operator && Assignment.Operator.TIMESTIMES != operator) {
                if (Assignment.Operator.OR == operator || Assignment.Operator.AND == operator || Assignment.Operator.XOR == operator) {
                    DefaultBinder.inferTypeForBitwiseOperand(rightHandSide, this.problemRequestor);
                } else if (Assignment.Operator.CONCAT == operator) {
                    if (!DefaultBinder.isStringType(lhType) && !DefaultBinder.isArrayType(lhType)) {
                        this.problemRequestor.acceptProblem((Node)leftHandSide, 5085, new String[]{leftHandSide.getCanonicalString()});
                    }
                } else if (Assignment.Operator.NULLCONCAT == operator && !DefaultBinder.isStringType(lhType)) {
                    this.problemRequestor.acceptProblem((Node)leftHandSide, 5085, new String[]{leftHandSide.getCanonicalString()});
                }
            }
            if (DefaultBinder.isArithmeticAssignment(assignment)) {
                this.validateArithmeticOperation(assignment.getLeftHandSide(), assignment.getRightHandSide(), DefaultBinder.getBinaryOperator(operator), assignment);
            }
        }
    }

    public static boolean isArithmeticAssignment(Assignment assignment) {
        if (assignment == null) {
            return false;
        }
        Assignment.Operator operator = assignment.getOperator();
        BinaryExpression.Operator binOperator = DefaultBinder.getBinaryOperator(operator);
        Expression rightHandSide = assignment.getRightHandSide();
        ITypeBinding rhType = rightHandSide.resolveTypeBinding();
        Expression leftHandSide = assignment.getLeftHandSide();
        ITypeBinding lhType = leftHandSide.resolveTypeBinding();
        if (binOperator == BinaryExpression.Operator.CONCAT && (Binding.isValidBinding(lhType) && 2 == lhType.getKind() || Binding.isValidBinding(rhType) && 2 == rhType.getKind())) {
            return false;
        }
        if (binOperator == BinaryExpression.Operator.PLUS && (DefaultBinder.isStringType(lhType) || DefaultBinder.isStringType(rhType)) || binOperator == BinaryExpression.Operator.CONCAT || binOperator == BinaryExpression.Operator.NULLCONCAT) {
            return false;
        }
        return operator == Assignment.Operator.DIVIDE || operator == Assignment.Operator.MINUS || operator == Assignment.Operator.MODULO || operator == Assignment.Operator.PLUS || operator == Assignment.Operator.TIMES || operator == Assignment.Operator.TIMESTIMES;
    }

    private static BinaryExpression.Operator getBinaryOperator(Assignment.Operator operator) {
        if (operator == Assignment.Operator.AND) {
            return BinaryExpression.Operator.AND;
        }
        if (operator == Assignment.Operator.CONCAT) {
            return BinaryExpression.Operator.CONCAT;
        }
        if (operator == Assignment.Operator.DIVIDE) {
            return BinaryExpression.Operator.DIVIDE;
        }
        if (operator == Assignment.Operator.MINUS) {
            return BinaryExpression.Operator.MINUS;
        }
        if (operator == Assignment.Operator.MODULO) {
            return BinaryExpression.Operator.MODULO;
        }
        if (operator == Assignment.Operator.NULLCONCAT) {
            return BinaryExpression.Operator.NULLCONCAT;
        }
        if (operator == Assignment.Operator.OR) {
            return BinaryExpression.Operator.OR;
        }
        if (operator == Assignment.Operator.PLUS) {
            return BinaryExpression.Operator.PLUS;
        }
        if (operator == Assignment.Operator.TIMES) {
            return BinaryExpression.Operator.TIMES;
        }
        if (operator == Assignment.Operator.TIMESTIMES) {
            return BinaryExpression.Operator.TIMESTIMES;
        }
        if (operator == Assignment.Operator.XOR) {
            return BinaryExpression.Operator.XOR;
        }
        return null;
    }

    @Override
    public void endVisit(InExpression inExpression) {
        Expression fromExpression;
        ITypeBinding fromType;
        inExpression.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN));
        Expression operand1 = inExpression.getFirstExpression();
        Expression operand2 = inExpression.getSecondExpression();
        ITypeBinding type1 = operand1.resolveTypeBinding();
        ITypeBinding type2 = operand2.resolveTypeBinding();
        if (type1 != null && 3 != type1.getKind()) {
            this.problemRequestor.acceptProblem((Node)operand1, 5090, new String[]{operand1.getCanonicalString()});
            return;
        }
        if (type1 != null && type2 != null) {
            boolean rightSideValidForInFrom = true;
            if (2 == type2.getKind()) {
                type2 = ((ArrayTypeBinding)type2).getElementType();
            } else if (26 == type2.getKind()) {
                type2 = ((MultiplyOccuringItemTypeBinding)type2).getBaseType();
            } else {
                IDataBinding rightSideDBinding = operand2.resolveDataBinding();
                if (Binding.isValidBinding(rightSideDBinding)) {
                    if (5 == rightSideDBinding.getKind()) {
                        if (!(5 == rightSideDBinding.getDeclaringPart().getKind() || ((StructureItemBinding)rightSideDBinding).isMultiplyOccuring() && this.compilerOptions.isVAGCompatible())) {
                            QualifierBindingGatherer qb = new QualifierBindingGatherer(true);
                            operand2.accept(qb);
                            ITypeBinding qualifierType2 = qb.qualifierTBinding;
                            if (Binding.isValidBinding(qualifierType2)) {
                                rightSideValidForInFrom = 2 == qualifierType2.getKind() && 6 == ((ArrayTypeBinding)qualifierType2).getElementType().getKind();
                            }
                        }
                    } else {
                        rightSideValidForInFrom = 7 == rightSideDBinding.getKind() ? rightSideDBinding instanceof VariableFormFieldBinding && ((VariableFormFieldBinding)rightSideDBinding).isMultiplyOccuring() : false;
                    }
                }
            }
            if (!rightSideValidForInFrom && inExpression.hasFromExpression()) {
                this.problemRequestor.acceptProblem((Node)operand2, 5091, new String[]{operand2.getCanonicalString()});
            } else if (3 != type2.getKind() || !TypeCompatibilityUtil.isMoveCompatible(type2, type1, null, this.compilerOptions)) {
                this.problemRequestor.acceptProblem((Node)operand1, 5089, new String[]{operand1.getCanonicalString(), operand2.getCanonicalString()});
            }
        }
        if (inExpression.hasFromExpression() && Binding.isValidBinding(fromType = (fromExpression = inExpression.getFromExpression()).resolveTypeBinding())) {
            PrimitiveTypeBinding primTBinding;
            boolean exprIsValid = false;
            if (3 == fromType.getKind() && Primitive.isNumericType((primTBinding = (PrimitiveTypeBinding)fromType).getPrimitive()) && primTBinding.getDecimals() == 0) {
                exprIsValid = true;
            }
            if (!exprIsValid) {
                this.problemRequestor.acceptProblem((Node)fromExpression, 5193, new String[]{fromExpression.getCanonicalString()});
            }
        }
    }

    public static ITypeBinding inferTypeForNumericOperand(Expression operand, IProblemRequestor problemRequestor) {
        ITypeBinding operandType = operand.resolveTypeBinding();
        if (operandType.getKind() == 3) {
            PrimitiveTypeBinding operandPrimType = (PrimitiveTypeBinding)operandType;
            if (TypeCompatibilityUtil.isMoveCompatible(PrimitiveTypeBinding.getInstance(Primitive.INT), operandPrimType)) {
                return operandType;
            }
            problemRequestor.acceptProblem((Node)operand, 5088, new String[]{operandPrimType.getPrimitive().getName(), operand.getCanonicalString()});
        } else {
            problemRequestor.acceptProblem((Node)operand, 5085, new String[]{operand.getCanonicalString()});
        }
        return null;
    }

    public static ITypeBinding inferTypeForBooleanOperand(Expression operand, IProblemRequestor problemRequestor) {
        ITypeBinding operandType = operand.resolveTypeBinding();
        if (operandType.getKind() == 3) {
            Primitive operandPrim = ((PrimitiveTypeBinding)operandType).getPrimitive();
            if (operandPrim != Primitive.BOOLEAN) {
                problemRequestor.acceptProblem((Node)operand, 7690, new String[]{operandPrim.getName(), operand.getCanonicalString()});
            }
        } else {
            problemRequestor.acceptProblem((Node)operand, 5085, new String[]{operand.getCanonicalString()});
        }
        return PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN);
    }

    public static ITypeBinding inferTypeForBitwiseOperand(Expression operand, IProblemRequestor problemRequestor) {
        ITypeBinding operandType = operand.resolveTypeBinding();
        if (operandType.getKind() == 3) {
            PrimitiveTypeBinding operandPrimType = (PrimitiveTypeBinding)operandType;
            if (Primitive.INT == operandPrimType.getPrimitive() || Primitive.SMALLINT == operandPrimType.getPrimitive()) {
                return operandType;
            }
            if (Primitive.HEX == operandPrimType.getPrimitive() && (operandPrimType.getLength() == 2 || operandPrimType.getLength() == 4 || operandPrimType.getLength() == 8)) {
                return PrimitiveTypeBinding.getInstance(Primitive.INT);
            }
            problemRequestor.acceptProblem((Node)operand, 5176, new String[]{operandPrimType.toString(), operand.getCanonicalString()});
        } else {
            problemRequestor.acceptProblem((Node)operand, 5085, new String[]{operand.getCanonicalString()});
        }
        return null;
    }

    @Override
    public void endVisit(IsAExpression isAExpression) {
        isAExpression.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN));
    }

    @Override
    public void endVisit(final AsExpression asExpression) {
        if (asExpression.hasType()) {
            ITypeBinding fromType = asExpression.getExpression().resolveTypeBinding();
            ITypeBinding toType = asExpression.getType().resolveTypeBinding();
            if (fromType != null && fromType.isValid() && toType != null && toType.isValid()) {
                if (fromType.isDynamic() || fromType.getBaseType().isDynamic() && 2 == toType.getKind() || TypeCompatibilityUtil.typesOrElementTypesMoveCompatible(toType, fromType, this.compilerOptions) || TypeCompatibilityUtil.areCompatibleExceptions(fromType, toType, this.compilerOptions)) {
                    asExpression.setTypeBinding(this.convertDataItemToPrimitive(toType));
                } else {
                    this.problemRequestor.acceptProblem((Node)asExpression, 6653, new String[]{StatementValidator.getTypeString(fromType), StatementValidator.getTypeString(toType), asExpression.getCanonicalString()});
                }
            }
        } else {
            asExpression.getExpression().accept(new AbstractASTExpressionVisitor(){

                @Override
                public boolean visit(NullLiteral nilLiteral) {
                    asExpression.getStringLiteral().setTypeBinding(ForeignLanguageTypeBinding.NULL);
                    asExpression.setTypeBinding(ForeignLanguageTypeBinding.NULL);
                    return false;
                }

                @Override
                public boolean visitExpression(Expression expression) {
                    ForeignLanguageTypeBinding foreignLanguageType = ForeignLanguageTypeBinding.getInstance(((StringLiteral)asExpression.getStringLiteral()).getValue());
                    if (foreignLanguageType == null) {
                        DefaultBinder.this.problemRequestor.acceptProblem((Node)asExpression.getStringLiteral(), 4297, new String[]{this.toCommaList(ForeignLanguageTypeBinding.getSupportedCastStrings())});
                    } else {
                        asExpression.getStringLiteral().setTypeBinding(foreignLanguageType);
                        asExpression.setTypeBinding(foreignLanguageType);
                        ITypeBinding argType = asExpression.getExpression().resolveTypeBinding();
                        if (argType != null && IBinding.NOT_FOUND_BINDING != argType) {
                            boolean isString = false;
                            boolean isNumeric = false;
                            boolean isBoolean = false;
                            if (3 == argType.getKind()) {
                                Primitive prim = ((PrimitiveTypeBinding)argType).getPrimitive();
                                isString = Primitive.isStringType(prim);
                                isNumeric = Primitive.isNumericType(prim);
                                boolean bl = isBoolean = Primitive.BOOLEAN == prim;
                            }
                            if (!isBoolean || ForeignLanguageTypeBinding.JAVABOOLEAN != foreignLanguageType) {
                                if (VALID_STRING_CASTS.contains(foreignLanguageType) && !isString) {
                                    DefaultBinder.this.problemRequestor.acceptProblem((Node)asExpression.getExpression(), 4298, new String[]{foreignLanguageType.getCaseSensitiveName(), foreignLanguageType.getCaseSensitiveName()});
                                    asExpression.setTypeBinding(null);
                                } else if (VALID_NUMERIC_CASTS.contains(foreignLanguageType) && !isNumeric) {
                                    DefaultBinder.this.problemRequestor.acceptProblem((Node)asExpression.getExpression(), 4299, new String[]{foreignLanguageType.getCaseSensitiveName(), foreignLanguageType.getCaseSensitiveName()});
                                    asExpression.setTypeBinding(null);
                                }
                            }
                        }
                    }
                    return false;
                }

                private String toCommaList(Collection supportedCastStrings) {
                    StringBuffer sb = new StringBuffer();
                    Iterator iter = supportedCastStrings.iterator();
                    while (iter.hasNext()) {
                        sb.append((String)iter.next());
                        if (!iter.hasNext()) continue;
                        sb.append(", ");
                    }
                    return sb.toString();
                }
            });
        }
    }

    @Override
    public void endVisit(final IsNotExpression isNotExpression) {
        isNotExpression.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN));
        isNotExpression.getSecondExpression().accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(SimpleName simpleName) {
                final boolean[] shouldContinue = new boolean[]{true};
                final IBinding binding = simpleName.resolveBinding();
                isNotExpression.getFirstExpression().accept(new AbstractASTExpressionVisitor(){

                    @Override
                    public void endVisitName(Name name) {
                        IBinding nameBinding = name.resolveBinding();
                        if (nameBinding != IBinding.NOT_FOUND_BINDING && nameBinding.isDataBinding()) {
                            IDataBinding dataBinding = (IDataBinding)nameBinding;
                            if (DefaultBinder.dataBindingIs(dataBinding, new String[]{"egl", "core"}, "SysVar", "SYSTEMTYPE")) {
                                if (binding == IBinding.NOT_FOUND_BINDING || ((IsNotStateBinding)binding).getIsNotStateKind() != 1) {
                                    shouldContinue[0] = false;
                                    (this).DefaultBinder.this.problemRequestor.acceptProblem((Node)isNotExpression.getSecondExpression(), 5165, new String[]{isNotExpression.getSecondExpression().getCanonicalString()});
                                }
                            } else if (DefaultBinder.dataBindingIs(dataBinding, new String[]{"egl", "ui", "text"}, "ConverseVar", "EVENTKEY") && (binding == IBinding.NOT_FOUND_BINDING || ((IsNotStateBinding)binding).getIsNotStateKind() != 0)) {
                                shouldContinue[0] = false;
                                (this).DefaultBinder.this.problemRequestor.acceptProblem((Node)isNotExpression.getSecondExpression(), 5164, new String[]{isNotExpression.getSecondExpression().getCanonicalString()});
                            }
                        }
                    }
                });
                if (!shouldContinue[0]) {
                    return false;
                }
                if (binding != IBinding.NOT_FOUND_BINDING) {
                    final IsNotStateBinding stateBinding = (IsNotStateBinding)binding;
                    isNotExpression.getFirstExpression().accept(new AbstractASTExpressionVisitor(){

                        @Override
                        public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                            return true;
                        }

                        @Override
                        public void endVisit(FunctionInvocation functionInvocation) {
                            shouldContinue[0] = false;
                            (this).DefaultBinder.this.problemRequestor.acceptProblem(functionInvocation, 6720);
                        }
                    });
                    if (!shouldContinue[0]) {
                        return false;
                    }
                    if (invalidIsNotStatesForDLISegments.contains(stateBinding)) {
                        isNotExpression.getFirstExpression().accept(new AbstractASTExpressionVisitor(){

                            @Override
                            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                                return true;
                            }

                            @Override
                            public void endVisitName(Name name) {
                                IBinding binding = name.resolveBinding();
                                if (binding != IBinding.NOT_FOUND_BINDING && binding.getAnnotation(new String[]{"egl", "io", "dli"}, "DLISegment") != null) {
                                    shouldContinue[0] = false;
                                    (this).DefaultBinder.this.problemRequestor.acceptProblem((Node)isNotExpression.getSecondExpression(), 7868, new String[]{stateBinding.getCaseSensitiveName()});
                                }
                            }
                        });
                    }
                    if (!shouldContinue[0]) {
                        return false;
                    }
                    isNotExpression.getFirstExpression().accept(new AbstractASTExpressionVisitor(){

                        @Override
                        public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                            return true;
                        }

                        @Override
                        public void endVisit(SimpleName simpleName) {
                        }

                        @Override
                        public void endVisit(QualifiedName qualifiedName) {
                        }

                        @Override
                        public void endVisit(ArrayAccess arrayAccess) {
                        }

                        @Override
                        public void endVisit(FieldAccess fieldAccess) {
                        }

                        @Override
                        public void endVisit(SubstringAccess substringAccess) {
                        }

                        @Override
                        public void endVisit(FunctionInvocation functionInvocation) {
                        }

                        @Override
                        public void endVisit(ParenthesizedExpression parenthesizedExpression) {
                        }

                        @Override
                        public void endVisitExpression(Expression expression) {
                            shouldContinue[0] = false;
                            (this).DefaultBinder.this.problemRequestor.acceptProblem(expression, 6721);
                        }
                    });
                    if (!shouldContinue[0]) {
                        return false;
                    }
                    switch (stateBinding.getIsNotStateKind()) {
                        case 0: {
                            isNotExpression.getFirstExpression().accept(new SystemVariableOnlyChecker(new String[]{"egl", "ui", "text"}, "ConverseVar", "EVENTKEY", DefaultBinder.this.problemRequestor, stateBinding, 5169));
                            break;
                        }
                        case 1: {
                            isNotExpression.getFirstExpression().accept(new SystemVariableOnlyChecker(new String[]{"egl", "core"}, "SysVar", "SYSTEMTYPE", DefaultBinder.this.problemRequestor, stateBinding, 5170));
                            break;
                        }
                        case 2: {
                            isNotExpression.getFirstExpression().accept(new IsNotBindingChecker(DefaultBinder.this.problemRequestor, 5092){

                                @Override
                                boolean isValid(IBinding binding) {
                                    ITypeBinding typeBinding;
                                    if (binding.isDataBinding()) {
                                        binding = ((IDataBinding)binding).getType();
                                    }
                                    if (binding.isTypeBinding() && 2 == (typeBinding = (ITypeBinding)binding).getKind()) {
                                        ITypeBinding elementType = ((ArrayTypeBinding)typeBinding).getElementType();
                                        return elementType.getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord") != null || elementType.getAnnotation(new String[]{"egl", "io", "file"}, "CSVRecord") != null || elementType.getAnnotation(new String[]{"egl", "io", "dli"}, "DLISegment") != null;
                                    }
                                    return binding.getAnnotation(new String[]{"egl", "io", "file"}, "SerialRecord") != null || binding.getAnnotation(new String[]{"egl", "io", "file"}, "RelativeRecord") != null || binding.getAnnotation(new String[]{"egl", "io", "mq"}, "MQRecord") != null || binding.getAnnotation(new String[]{"egl", "io", "file"}, "IndexedRecord") != null || binding.getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord") != null || binding.getAnnotation(new String[]{"egl", "io", "file"}, "CSVRecord") != null || binding.getAnnotation(new String[]{"egl", "io", "dli"}, "DLISegment") != null;
                                }
                            });
                            break;
                        }
                        case 3: {
                            isNotExpression.getFirstExpression().accept(new IsNotBindingChecker(DefaultBinder.this.problemRequestor, 5093){

                                @Override
                                boolean isValid(IBinding binding) {
                                    if (binding.isDataBinding()) {
                                        IDataBinding dataBinding = (IDataBinding)binding;
                                        if (dataBinding.getKind() == 0) {
                                            return ((FunctionParameterBinding)dataBinding).isField();
                                        }
                                        if (7 == dataBinding.getKind()) {
                                            return dataBinding.getDeclaringPart().getAnnotation(new String[]{"egl", "ui", "text"}, "TextForm") != null;
                                        }
                                    }
                                    return false;
                                }
                            });
                            break;
                        }
                        case 4: {
                            isNotExpression.getFirstExpression().accept(new IsNotBindingChecker(DefaultBinder.this.problemRequestor, 5094){

                                @Override
                                boolean isValid(IBinding binding) {
                                    if (binding.isDataBinding()) {
                                        IDataBinding dataBinding = (IDataBinding)binding;
                                        if (dataBinding.getKind() == 0 && ((FunctionParameterBinding)dataBinding).isField()) {
                                            return true;
                                        }
                                        if (7 == dataBinding.getKind()) {
                                            return dataBinding.getDeclaringPart().getAnnotation(new String[]{"egl", "ui", "text"}, "TextForm") != null;
                                        }
                                        if ((2 == dataBinding.getKind() || 3 == dataBinding.getKind()) && ((VariableBinding)dataBinding).isConstant()) {
                                            return false;
                                        }
                                        binding = dataBinding.getType();
                                    }
                                    if (binding.isTypeBinding()) {
                                        ITypeBinding typeBinding = (ITypeBinding)binding;
                                        return 3 == typeBinding.getKind() && Primitive.isStringType(((PrimitiveTypeBinding)typeBinding).getPrimitive());
                                    }
                                    return false;
                                }
                            });
                            break;
                        }
                        case 5: {
                            isNotExpression.getFirstExpression().accept(new IsNotBindingChecker(DefaultBinder.this.problemRequestor, 5143){

                                @Override
                                boolean isValid(IBinding binding) {
                                    ITypeBinding typeBinding;
                                    if (binding.isDataBinding()) {
                                        IDataBinding dataBinding = (IDataBinding)binding;
                                        if ((2 == dataBinding.getKind() || 3 == dataBinding.getKind()) && ((VariableBinding)dataBinding).isConstant()) {
                                            return false;
                                        }
                                        binding = dataBinding.getType();
                                    }
                                    if (binding.isTypeBinding() && 3 == (typeBinding = (ITypeBinding)binding).getKind()) {
                                        Primitive prim = ((PrimitiveTypeBinding)typeBinding).getPrimitive();
                                        return prim == Primitive.CHAR || prim == Primitive.MBCHAR || prim == Primitive.STRING || prim == Primitive.UNICODE;
                                    }
                                    return false;
                                }
                            });
                            break;
                        }
                        case 8: {
                            isNotExpression.getFirstExpression().accept(new IsNotBindingChecker(DefaultBinder.this.problemRequestor, 5096){

                                @Override
                                boolean isValid(IBinding binding) {
                                    ITypeBinding typeBinding;
                                    if (binding.isDataBinding()) {
                                        IDataBinding dataBinding = (IDataBinding)binding;
                                        if (dataBinding.getKind() == 0) {
                                            return ((FunctionParameterBinding)dataBinding).isField();
                                        }
                                        if (7 == dataBinding.getKind()) {
                                            return dataBinding.getDeclaringPart().getAnnotation(new String[]{"egl", "ui", "text"}, "TextForm") != null;
                                        }
                                        if (5 == dataBinding.getKind()) {
                                            return dataBinding.getDeclaringPart().getAnnotation(new String[]{"egl", "ui", "webTransaction"}, "VGUIRecord") != null;
                                        }
                                        binding = dataBinding.getType();
                                    }
                                    return binding.isTypeBinding() && ((typeBinding = (ITypeBinding)binding).getAnnotation(new String[]{"egl", "ui", "text"}, "TextForm") != null || typeBinding.getAnnotation(new String[]{"egl", "ui", "webTransaction"}, "VGUIRecord") != null);
                                }
                            });
                            break;
                        }
                        case 7: {
                            final boolean[] isValid = new boolean[]{true};
                            isNotExpression.getFirstExpression().accept(new DefaultASTVisitor(){

                                @Override
                                public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                                    return true;
                                }

                                @Override
                                public boolean visit(SubstringAccess substringAccess) {
                                    (this).DefaultBinder.this.problemRequestor.acceptProblem(substringAccess, 6725);
                                    isValid[0] = false;
                                    return false;
                                }
                            });
                            if (!isValid[0]) break;
                            isNotExpression.getFirstExpression().accept(new IsNotBindingChecker(DefaultBinder.this.problemRequestor, 5177){

                                @Override
                                boolean isValid(IBinding binding) {
                                    if (binding.isDataBinding()) {
                                        IDataBinding dataBinding = (IDataBinding)binding;
                                        if (5 == dataBinding.getKind() || 14 == dataBinding.getKind()) {
                                            return dataBinding.getDeclaringPart().getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord") != null;
                                        }
                                        if (dataBinding.getKind() == 0) {
                                            return ((FunctionParameterBinding)dataBinding).isSQLNullable();
                                        }
                                    }
                                    return false;
                                }
                            });
                        }
                    }
                }
                return false;
            }
        });
    }

    private static boolean isStringType(ITypeBinding type) {
        if (!Binding.isValidBinding(type)) {
            return false;
        }
        return type.getKind() == 3 && Primitive.isStringType(((PrimitiveTypeBinding)type).getPrimitive());
    }

    private static boolean isArrayType(ITypeBinding type) {
        return type.getKind() == 2;
    }

    private static boolean isDateTimeType(ITypeBinding type) {
        return type.getKind() == 3 && Primitive.isDateTimeType(((PrimitiveTypeBinding)type).getPrimitive());
    }

    @Override
    public void endVisit(IntegerLiteral integerLiteral) {
        if (integerLiteral.resolveTypeBinding() == null) {
            integerLiteral.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.INT));
            String strVal = integerLiteral.getValue();
            if (strVal.length() > 32) {
                this.problemRequestor.acceptProblem((Node)integerLiteral, 3250, new String[]{strVal});
            }
        }
    }

    @Override
    public void endVisit(DecimalLiteral decimalLiteral) {
        if (decimalLiteral.resolveTypeBinding() == null) {
            decimalLiteral.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.DECIMAL, DefaultBinder.getLengthFromLiteral(decimalLiteral), DefaultBinder.getDecimalsFromLiteral(decimalLiteral)));
            String strVal = decimalLiteral.getValue();
            if (strVal.length() > (strVal.indexOf(46) == -1 ? 32 : 33)) {
                this.problemRequestor.acceptProblem((Node)decimalLiteral, 3251, new String[]{strVal});
            }
        }
    }

    @Override
    public void endVisit(FloatLiteral floatLiteral) {
        if (floatLiteral.resolveTypeBinding() == null) {
            try {
                floatLiteral.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.FLOAT));
                String strVal = floatLiteral.getValue();
                if (Double.isInfinite(Double.parseDouble(strVal))) {
                    this.problemRequestor.acceptProblem((Node)floatLiteral, 3252, new String[]{strVal});
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public void endVisit(BooleanLiteral booleanLiteral) {
        booleanLiteral.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN));
    }

    @Override
    public void endVisit(StringLiteral stringLiteral) {
        if (stringLiteral.resolveTypeBinding() == null) {
            byte[] bytes;
            IAnnotationBinding aBinding;
            String value = stringLiteral.getValue();
            boolean textLiteralDefaultIsString = true;
            Primitive prim = null;
            int length = value.length();
            IPartBinding functionContainerBinding = this.currentScope.getPartBinding();
            if (functionContainerBinding != null && (aBinding = functionContainerBinding.getAnnotation(new String[]{"egl", "core"}, "TextLiteralDefaultIsString")) != null) {
                boolean bl = textLiteralDefaultIsString = Boolean.YES == aBinding.getValue();
            }
            prim = textLiteralDefaultIsString ? Primitive.STRING : ((bytes = value.getBytes()).length == length ? Primitive.CHAR : (bytes.length == length * 2 ? Primitive.DBCHARLIT : Primitive.MBCHAR));
            stringLiteral.setTypeBinding(PrimitiveTypeBinding.getInstance(prim, length));
            if (stringLiteral.isHex() && stringLiteral.getValue().length() % 4 != 0) {
                this.problemRequestor.acceptProblem((Node)stringLiteral, 3266, new String[]{stringLiteral.getValue()});
            }
        }
    }

    @Override
    public void endVisit(HexLiteral hexLiteral) {
        if (hexLiteral.resolveTypeBinding() == null) {
            hexLiteral.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.HEX, hexLiteral.getValue().length()));
            if (hexLiteral.getValue().length() % 2 != 0) {
                this.problemRequestor.acceptProblem((Node)hexLiteral, 3265, new String[]{hexLiteral.getValue()});
            }
        }
    }

    @Override
    public void endVisit(CharLiteral charLiteral) {
        if (charLiteral.resolveTypeBinding() == null) {
            charLiteral.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.CHAR, charLiteral.getValue().length()));
            if (charLiteral.isHex() && charLiteral.getValue().length() % 2 != 0) {
                this.problemRequestor.acceptProblem((Node)charLiteral, 3265, new String[]{charLiteral.getValue()});
            }
        }
    }

    @Override
    public void endVisit(DBCharLiteral dbcharLiteral) {
        if (dbcharLiteral.resolveTypeBinding() == null) {
            dbcharLiteral.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.DBCHARLIT, dbcharLiteral.getValue().length()));
            if (dbcharLiteral.isHex() && dbcharLiteral.getValue().length() % 4 != 0) {
                this.problemRequestor.acceptProblem((Node)dbcharLiteral, 3266, new String[]{dbcharLiteral.getValue()});
            }
        }
    }

    @Override
    public void endVisit(MBCharLiteral mbcharLiteral) {
        if (mbcharLiteral.resolveTypeBinding() == null) {
            mbcharLiteral.setTypeBinding(PrimitiveTypeBinding.getInstance(Primitive.MBCHAR, mbcharLiteral.getValue().length()));
            if (mbcharLiteral.isHex() && mbcharLiteral.getValue().length() % 2 != 0) {
                this.problemRequestor.acceptProblem((Node)mbcharLiteral, 3265, new String[]{mbcharLiteral.getValue()});
            }
        }
    }

    @Override
    public void endVisit(SQLLiteral sqlLiteral) {
        sqlLiteral.setTypeBinding(SystemPartManager.SQLSTRING_BINDING);
    }

    @Override
    public void endVisit(TypeLiteralExpression typeLiteralExpression) {
        typeLiteralExpression.setTypeBinding(SystemPartManager.TYPEREF_BINDING);
    }

    private static int getLengthFromLiteral(LiteralExpression literalExpr) {
        return literalExpr.getValue().length();
    }

    private static int getDecimalsFromLiteral(LiteralExpression literalExpr) {
        if (literalExpr.getLiteralKind() == 1) {
            return DefaultBinder.getLengthFromLiteral(literalExpr) - literalExpr.getValue().indexOf(46) + 1;
        }
        if (literalExpr.getLiteralKind() == 2) {
            String literal = literalExpr.getValue();
            int length = literal.indexOf(101) + 1;
            if (length < 1) {
                length = literal.indexOf(69) + 1;
            }
            return --length - (literal.indexOf(46) + 1);
        }
        return 0;
    }

    protected boolean canMixTypesInArrayLiterals() {
        return true;
    }

    @Override
    public void endVisit(ArrayLiteral arrayLiteral) {
        if (arrayLiteral.resolveTypeBinding() == null) {
            List expressions = arrayLiteral.getExpressions();
            if (expressions.isEmpty()) {
                arrayLiteral.setTypeBinding(ArrayTypeBinding.getNonReferenceInstance(PrimitiveTypeBinding.getInstance(Primitive.ANY)));
            } else {
                Expression firstElementExpr = (Expression)expressions.get(0);
                ITypeBinding firstElementType = this.stripPrimitiveLength(firstElementExpr.resolveTypeBinding());
                if (firstElementType instanceof AnnotationTypeBindingImpl) {
                    firstElementType = ((AnnotationTypeBindingImpl)firstElementType).getAnnotationRecord();
                }
                if (firstElementType == null && firstElementExpr instanceof Name && IBinding.NOT_FOUND_BINDING == ((Name)firstElementExpr).resolveBinding()) {
                    return;
                }
                if (firstElementType != null && firstElementType != IBinding.NOT_FOUND_BINDING) {
                    boolean allTypesSame = true;
                    Iterator iter = expressions.iterator();
                    iter.next();
                    while (iter.hasNext() && allTypesSame) {
                        Expression nextExpr = (Expression)iter.next();
                        ITypeBinding nextType = this.stripPrimitiveLength(nextExpr.resolveTypeBinding());
                        if (nextType instanceof AnnotationTypeBindingImpl) {
                            nextType = ((AnnotationTypeBindingImpl)nextType).getAnnotationRecord();
                        }
                        if (nextType == null || IBinding.NOT_FOUND_BINDING == nextType || nextType == firstElementType) continue;
                        ITypeBinding commonExternalTypeSuperType = this.getCommonExtendedTypeSupertype(firstElementType, nextType, this.compilerOptions);
                        if (commonExternalTypeSuperType != null) {
                            firstElementType = commonExternalTypeSuperType;
                            continue;
                        }
                        allTypesSame = false;
                        if (TypeCompatibilityUtil.isMoveCompatible(firstElementType, nextType, nextExpr, this.compilerOptions) || this.canMixTypesInArrayLiterals()) continue;
                        this.problemRequestor.acceptProblem((Node)nextExpr, 6653, new String[]{StatementValidator.getShortTypeString(firstElementType), StatementValidator.getShortTypeString(nextType), "[" + firstElementExpr.getCanonicalString() + ", ..., " + nextExpr.getCanonicalString() + "]"});
                    }
                    if (allTypesSame) {
                        arrayLiteral.setTypeBinding(ArrayTypeBinding.getNonReferenceInstance(firstElementType));
                    }
                }
            }
            if (arrayLiteral.resolveTypeBinding() == null) {
                arrayLiteral.setTypeBinding(ArrayTypeBinding.getNonReferenceInstance(PrimitiveTypeBinding.getInstance(Primitive.ANY)));
            }
        }
    }

    private ITypeBinding getCommonExtendedTypeSupertype(ITypeBinding type1, ITypeBinding type2, ICompilerOptions compilerOptions) {
        List extendedTypes2;
        List extendedTypes1;
        if (28 == type1.getKind() && 28 == type2.getKind()) {
            extendedTypes1 = ((ExternalTypeBinding)type1).getExtendedTypes();
            extendedTypes2 = ((ExternalTypeBinding)type2).getExtendedTypes();
            if (extendedTypes1.contains(type2)) {
                return type2;
            }
            if (extendedTypes2.contains(type1)) {
                return type1;
            }
            for (ITypeBinding next : extendedTypes1) {
                if (!extendedTypes2.contains(next)) continue;
                return next;
            }
        }
        if (15 == type1.getKind() && 15 == type2.getKind()) {
            extendedTypes1 = ((InterfaceBinding)type1).getExtendedTypes();
            extendedTypes2 = ((InterfaceBinding)type2).getExtendedTypes();
            if (extendedTypes1.contains(type2)) {
                return type2;
            }
            if (extendedTypes2.contains(type1)) {
                return type1;
            }
            for (ITypeBinding next : extendedTypes1) {
                if (!extendedTypes2.contains(next)) continue;
                return next;
            }
        }
        return null;
    }

    private ITypeBinding stripPrimitiveLength(ITypeBinding binding) {
        if (binding == null || binding == IBinding.NOT_FOUND_BINDING) {
            return binding;
        }
        switch (binding.getKind()) {
            case 2: {
                return ArrayTypeBinding.getInstance(this.stripPrimitiveLength(((ArrayTypeBinding)binding).getElementType()));
            }
            case 3: {
                return PrimitiveTypeBinding.getInstance(((PrimitiveTypeBinding)binding).getPrimitive());
            }
        }
        return binding;
    }

    @Override
    public void endVisit(NullLiteral nilLiteral) {
        nilLiteral.setTypeBinding(NilBinding.INSTANCE);
    }

    @Override
    public void endVisit(AnnotationExpression annotationExpression) {
        annotationExpression.setTypeBinding(annotationExpression.getName().resolveTypeBinding());
    }

    @Override
    public boolean visit(SetValuesExpression setValuesExpression) {
        if (setValuesExpression.getExpression().resolveDataBinding() == IBinding.NOT_FOUND_BINDING) {
            return false;
        }
        setValuesExpression.getExpression().accept(this);
        ITypeBinding typeBinding = setValuesExpression.getExpression().resolveTypeBinding();
        if (typeBinding != null) {
            TypeBindingScope newScope = new TypeBindingScope(NullScope.INSTANCE, typeBinding, setValuesExpression.getExpression().resolveDataBinding());
            setValuesExpression.getSettingsBlock().accept(new SetValuesExpressionCompletor(this.currentScope, this.currentBinding, newScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        } else if (setValuesExpression.getExpression().resolveDataBinding() != IBinding.NOT_FOUND_BINDING) {
            setValuesExpression.getSettingsBlock().accept(this);
        }
        return true;
    }

    @Override
    public boolean visit(FunctionInvocationStatement functionInvocationStatement) {
        this.functionInvocationFromFunctionInvocationStatement = functionInvocationStatement.getFunctionInvocation();
        return true;
    }

    @Override
    public void endVisit(FunctionInvocationStatement functionInvocationStatement) {
        this.functionInvocationFromFunctionInvocationStatement = null;
    }

    @Override
    public void endVisit(FunctionInvocation functionInvocation) {
        ITypeBinding binding;
        IDataBinding fInvocationDBinding = functionInvocation.getTarget().resolveDataBinding();
        if (IBinding.NOT_FOUND_BINDING != fInvocationDBinding && fInvocationDBinding != null && 23 == fInvocationDBinding.getKind()) {
            FunctionResolver resolver = new FunctionResolver(this.compilerOptions);
            OverloadedFunctionSet overloadedFunctionSet = (OverloadedFunctionSet)fInvocationDBinding;
            boolean isConstructor = functionInvocation.getTarget() instanceof ThisExpression;
            IDataBinding matchingFunction = resolver.findMatchingFunction(overloadedFunctionSet, this.getArgumentTypes(functionInvocation.getArguments()), this.getArgumentIsLiteralArray(functionInvocation.getArguments()), !isConstructor);
            if (isConstructor && (IBinding.NOT_FOUND_BINDING == matchingFunction || AmbiguousDataBinding.getInstance() == matchingFunction)) {
                this.problemRequestor.acceptProblem((Node)functionInvocation.getTarget(), 7830, new String[]{functionInvocation.getTarget().resolveTypeBinding().getCaseSensitiveName()});
                functionInvocation.getTarget().setDataBinding(IBinding.NOT_FOUND_BINDING);
                return;
            }
            functionInvocation.getTarget().setAttributeOnName(Name.OVERLOADED_FUNCTION_SET, overloadedFunctionSet);
            if (AmbiguousDataBinding.getInstance() == matchingFunction) {
                boolean hasNullArgument = false;
                Iterator iter = functionInvocation.getArguments().iterator();
                while (iter.hasNext() && !hasNullArgument) {
                    if (((Expression)iter.next()).resolveTypeBinding() != null) continue;
                    hasNullArgument = true;
                }
                if (!hasNullArgument) {
                    this.problemRequestor.acceptProblem((Node)functionInvocation.getTarget(), 3468, new String[]{fInvocationDBinding.getCaseSensitiveName()});
                }
                if (functionInvocation.getTarget().isName()) {
                    ((Name)functionInvocation.getTarget()).setBinding(IBinding.NOT_FOUND_BINDING);
                }
                functionInvocation.getTarget().setDataBinding(IBinding.NOT_FOUND_BINDING);
                functionInvocation.getTarget().setTypeBinding(null);
            } else {
                if (functionInvocation.getTarget().isName()) {
                    ((Name)functionInvocation.getTarget()).setBinding(matchingFunction);
                }
                functionInvocation.getTarget().setDataBinding(matchingFunction);
                functionInvocation.getTarget().setTypeBinding(matchingFunction.getType());
            }
        }
        if ((binding = functionInvocation.getTarget().resolveTypeBinding()) != IBinding.NOT_FOUND_BINDING && binding != null && binding != AmbiguousFunctionBinding.getInstance() && (binding.isFunctionBinding() || 27 == binding.getKind())) {
            FunctionBinding functionBinding = binding.isFunctionBinding() ? (FunctionBinding)binding : this.createFunctionBindingFromDelegate((DelegateBinding)binding);
            ITypeBinding returnType = functionBinding.getReturnType();
            if (returnType == null) {
                if (functionInvocation != this.functionInvocationFromFunctionInvocationStatement) {
                    this.problemRequestor.acceptProblem((Node)functionInvocation, 6654, new String[]{functionBinding.getName()});
                }
            } else {
                functionInvocation.setTypeBinding(returnType);
                this.dependencyRequestor.recordTypeBinding(returnType);
            }
            IPartBinding functionContainerBinding = this.currentScope.getPartBinding();
            this.checkSystemFunctionUsedInCorrectLocation(functionBinding, functionInvocation, functionContainerBinding);
            functionInvocation.accept(new FunctionArgumentValidator(functionBinding, functionContainerBinding, this.problemRequestor, this.compilerOptions));
        }
    }

    private FunctionBinding createFunctionBindingFromDelegate(DelegateBinding binding) {
        FunctionBinding result = new FunctionBinding(binding.getCaseSensitiveName(), binding);
        result.setPrivate(binding.isPrivate());
        result.setReturnType(binding.getReturnType());
        result.setReturnTypeIsSqlNullable(binding.returnTypeIsSqlNullable());
        Iterator iter = binding.getParemeters().iterator();
        while (iter.hasNext()) {
            result.addParameter((FunctionParameterBinding)iter.next());
        }
        return result;
    }

    private void checkSystemFunctionUsedInCorrectLocation(IFunctionBinding functionBinding, FunctionInvocation functionInvocation, IPartBinding functionContainerBinding) {
        FunctionArgumentValidator.FunctionIdentifier fIdentifier = new FunctionArgumentValidator.FunctionIdentifier(functionBinding);
        if ((functionContainerBinding == null || functionContainerBinding.getAnnotation(new String[]{"egl", "ui", "jsf"}, "JSFHandler") == null) && AbstractBinder.typeIs(functionBinding.getDeclarer(), new String[]{"egl", "java"}, "PortalLib")) {
            this.problemRequestor.acceptProblem((Node)functionInvocation.getTarget(), 5252, new String[]{functionBinding.getCaseSensitiveName()});
            return;
        }
        if (systemFunctionsNotAllowedInPageHandlers.contains(fIdentifier)) {
            if (functionContainerBinding != null && functionContainerBinding.getAnnotation(new String[]{"egl", "ui", "jsf"}, "JSFHandler") != null) {
                this.problemRequestor.acceptProblem((Node)functionInvocation.getTarget(), 4912, new String[]{functionBinding.getCaseSensitiveName()});
            }
        } else if (systemFunctionsOnlyAllowedInProgramsWithDLIAnnotation.contains(fIdentifier)) {
            IDataBinding dliAnnotation = null;
            if (functionContainerBinding != null) {
                dliAnnotation = functionContainerBinding.getAnnotation(new String[]{"egl", "io", "dli"}, "DLI");
            }
            if (dliAnnotation == null) {
                this.problemRequestor.acceptProblem(functionInvocation.getTarget(), 7935);
            } else {
                IAnnotationBinding callInterfaceAnnotation = (IAnnotationBinding)dliAnnotation.findData(InternUtil.intern((String)"callInterface"));
                if (!(callInterfaceAnnotation != IBinding.NOT_FOUND_BINDING && InternUtil.intern((String)"AIBTDLI") != ((EnumerationDataBinding)callInterfaceAnnotation.getValue()).getName() || DefaultBinder.functionBindingIs(functionBinding, new String[]{"egl", "io", "dli"}, "DLILib", "AIBTDLI"))) {
                    this.problemRequestor.acceptProblem((Node)functionInvocation.getTarget(), 7947, new String[]{functionBinding.getCaseSensitiveName()});
                }
            }
        } else if (systemFunctionsNotAllowedInServices.contains(fIdentifier) && functionContainerBinding != null && 14 == functionContainerBinding.getKind()) {
            this.problemRequestor.acceptProblem((Node)functionInvocation.getTarget(), 4913, new String[]{functionBinding.getCaseSensitiveName()});
        }
    }

    @Override
    public void endVisit(MoveStatement moveStatement) {
        MoveModifier modifier = moveStatement.getMoveModifierOpt();
        if (modifier != null && (modifier.isFor() || modifier.isForAll())) {
            moveStatement.getTarget().accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                    return true;
                }

                @Override
                public boolean visit(ArrayAccess arrayAccess) {
                    ITypeBinding arrayType;
                    ITypeBinding indexType;
                    List indices = arrayAccess.getIndices();
                    if (indices.size() == 1 && (indexType = ((Expression)indices.get(0)).resolveTypeBinding()) != null && 3 == indexType.getKind() && Primitive.isNumericType(((PrimitiveTypeBinding)indexType).getPrimitive()) && (arrayType = arrayAccess.getArray().resolveTypeBinding()) != null) {
                        arrayAccess.setTypeBinding(DefaultBinder.this.compilerOptions.isVAGCompatible() && 2 != arrayType.getKind() ? new MultiplyOccuringItemTypeBinding(arrayType) : arrayType);
                    }
                    return false;
                }
            });
        }
    }

    @Override
    public void endVisit(CloseStatement closeStatement) {
        closeStatement.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visitExpression(Expression expression) {
                ITypeBinding typeBinding = expression.resolveTypeBinding();
                if (StatementValidator.isValidBinding(typeBinding) && typeBinding.getAnnotation(new String[]{"egl", "ui", "text"}, "PrintForm") != null) {
                    ProgramBinding binding;
                    Scope scope = DefaultBinder.this.currentScope;
                    while (scope != null) {
                        if (scope.isProgramScope()) break;
                        scope = scope.getParentScope();
                    }
                    if (scope != null && (binding = ((ProgramScope)scope).getProgramBinding()).getAnnotation(new String[]{"egl", "ui", "webTransaction"}, "VGWebTransaction") != null) {
                        DefaultBinder.this.problemRequestor.acceptProblem(expression, 7774);
                    }
                }
                return false;
            }
        });
    }

    @Override
    public void endVisit(SetValuesExpression setValuesExpression) {
        setValuesExpression.setTypeBinding(setValuesExpression.getExpression().resolveTypeBinding());
        setValuesExpression.getSettingsBlock().accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            @Override
            public boolean visit(Assignment assignment) {
                DefaultBinder.this.validateAssignment(assignment, false);
                return false;
            }
        });
        ITypeBinding type = setValuesExpression.getExpression().resolveTypeBinding();
        if (Binding.isValidBinding(type) && (type.getKind() == 20 || type.getKind() == 27)) {
            this.problemRequestor.acceptProblem((Node)setValuesExpression.getSettingsBlock(), 3249, new String[0]);
        }
    }

    private void validateAssignment(Assignment assignment, final boolean canAssignToReadOnlyFields) {
        if (assignment.resolveBinding() == null) {
            Expression leftHandSide = assignment.getLeftHandSide();
            ITypeBinding lhType = leftHandSide.resolveTypeBinding();
            IDataBinding lhDBinding = leftHandSide.resolveDataBinding();
            Expression rightHandSide = assignment.getRightHandSide();
            ITypeBinding rhType = rightHandSide.resolveTypeBinding();
            IDataBinding rhDBinding = rightHandSide.resolveDataBinding();
            if (StatementValidator.isValidBinding(lhType) && StatementValidator.isValidBinding(rhType) && 18 != lhType.getKind()) {
                if ((Assignment.Operator.CONCAT == assignment.getOperator() || Assignment.Operator.NULLCONCAT == assignment.getOperator()) && 2 == lhType.getKind()) {
                    lhType = ((ArrayTypeBinding)lhType).getElementType();
                }
                if (!(TypeCompatibilityUtil.isMoveCompatible(lhType, rhType, rightHandSide, this.compilerOptions) || rhType.isDynamic() || TypeCompatibilityUtil.areCompatibleExceptions(rhType, lhType, this.compilerOptions))) {
                    this.problemRequestor.acceptProblem((Node)rightHandSide, 6653, new String[]{StatementValidator.getShortTypeString(lhType), StatementValidator.getShortTypeString(rhType), String.valueOf(leftHandSide.getCanonicalString()) + "=" + rightHandSide.getCanonicalString()});
                }
                if (StatementValidator.isValidBinding(lhDBinding)) {
                    new LValueValidator(this.problemRequestor, this.compilerOptions, lhDBinding, leftHandSide, new LValueValidator.DefaultLValueValidationRules(){

                        @Override
                        public boolean canAssignToReadOnlyVariables() {
                            return canAssignToReadOnlyFields;
                        }
                    }).validate();
                }
                if (StatementValidator.isValidBinding(rhDBinding)) {
                    new RValueValidator(this.problemRequestor, this.compilerOptions, lhDBinding, leftHandSide).validate();
                }
            }
        }
    }

    protected Object resolveSelectedIndexItem(Node node, Object value, IDataBinding varBinding, IDataBinding[] path) {
        Object result;
        if (!(value instanceof String)) {
            return value;
        }
        IDataBinding dataBinding = this.getDataBindingForAnnotation(varBinding, path);
        if (dataBinding.getKind() != 5) {
            return value;
        }
        StructureItemBinding structItem = (StructureItemBinding)dataBinding;
        String selectedIndexName = (String)value;
        Name name = new ExpressionParser(this.compilerOptions).parseAsName(selectedIndexName);
        if (name == null) {
            return IBinding.NOT_FOUND_BINDING;
        }
        Scope saveScope = this.currentScope;
        this.currentScope = new TypeBindingScope(NullScope.INSTANCE, structItem.getEnclosingStructureBinding(), null);
        try {
            this.bindExpressionName(name);
            result = name;
        }
        catch (ResolutionException resolutionException) {
            this.problemRequestor.acceptProblem(node, 2063, 2, new String[]{selectedIndexName, structItem.getName(), structItem.getEnclosingStructureBinding().getName()});
            result = IBinding.NOT_FOUND_BINDING;
        }
        this.currentScope = saveScope;
        return result;
    }

    protected Object resolveValueRef(Node node, Object value, IDataBinding varBinding, IDataBinding[] path) {
        if (!(value instanceof String)) {
            return value;
        }
        IPartBinding partBinding = varBinding.getDeclaringPart();
        if (partBinding == null || 6 != partBinding.getKind()) {
            return value;
        }
        String selectedIndexName = (String)value;
        Name name = new ExpressionParser(this.compilerOptions).parseAsName(selectedIndexName);
        if (name == null) {
            return IBinding.NOT_FOUND_BINDING;
        }
        Object result = ((FixedRecordBinding)partBinding).getSimpleNamesToDataBindingsMap().get(name.getIdentifier());
        if (result == null) {
            result = IBinding.NOT_FOUND_BINDING;
            this.problemRequestor.acceptProblem(node, 7799, new String[]{name.getCanonicalName()});
        }
        return result;
    }

    protected Object resolveNumElementsItem(Node node, Object value, IDataBinding varBinding, IDataBinding[] path) {
        Object result;
        if (!(value instanceof String)) {
            return value;
        }
        IDataBinding dataBinding = this.getDataBindingForAnnotation(varBinding, path);
        if (dataBinding.getKind() != 5) {
            return value;
        }
        StructureItemBinding structItem = (StructureItemBinding)dataBinding;
        String numElementsName = (String)value;
        Name name = new ExpressionParser(this.compilerOptions).parseAsName(numElementsName);
        if (name == null) {
            return IBinding.NOT_FOUND_BINDING;
        }
        Scope saveScope = this.currentScope;
        this.currentScope = new TypeBindingScope(NullScope.INSTANCE, structItem.getEnclosingStructureBinding(), null);
        try {
            ITypeBinding tBinding;
            IDataBinding dBinding = this.bindExpressionName(name);
            result = name;
            if (dBinding != IBinding.NOT_FOUND_BINDING && (tBinding = dBinding.getType()) != null) {
                boolean typeIsValid = false;
                if (3 == tBinding.getKind()) {
                    PrimitiveTypeBinding primTBinding = (PrimitiveTypeBinding)tBinding;
                    boolean bl = typeIsValid = Primitive.isNumericType(primTBinding.getPrimitive()) && primTBinding.getDecimals() == 0;
                }
                if (!typeIsValid) {
                    this.problemRequestor.acceptProblem(node, 3138, new String[]{numElementsName, structItem.getName(), structItem.getEnclosingStructureBinding().getCaseSensitiveName()});
                }
            }
        }
        catch (ResolutionException resolutionException) {
            this.problemRequestor.acceptProblem(node, 3137, new String[]{numElementsName, structItem.getName(), structItem.getEnclosingStructureBinding().getCaseSensitiveName()});
            result = IBinding.NOT_FOUND_BINDING;
        }
        this.currentScope = saveScope;
        return result;
    }

    protected IDataBinding getDataBindingForAnnotation(IDataBinding dataBinding, IDataBinding[] path) {
        if (path == null || path.length == 0) {
            return dataBinding;
        }
        return path[path.length - 1];
    }

    protected void processResolvableProperties(SettingsBlock block, IDataBinding dataBinding, IDataBinding[] path) {
        this.processResolvableProperties(block, dataBinding, path, null);
    }

    protected void processResolvableProperties(SettingsBlock block, final IDataBinding dataBinding, final IDataBinding[] path, final IAnnotationBinding currentAnnotation) {
        block.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(Assignment assignment) {
                IAnnotationBinding annotation = assignment.resolveBinding();
                if (annotation != null && dataBinding != null) {
                    DefaultBinder.this.processResolvableProperty(this.getAnnotationType(annotation), annotation.getValue(), dataBinding, path, assignment.getRightHandSide());
                }
                return false;
            }

            private IAnnotationTypeBinding getAnnotationType(IAnnotationBinding annotation) {
                IAnnotationTypeBinding enclosingType;
                if (annotation.isAnnotationField() && (enclosingType = ((AnnotationFieldBinding)annotation).getEnclosingAnnotationType()).hasSingleValue()) {
                    return enclosingType;
                }
                return annotation.getAnnotationType();
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                IDataBinding exprData = setValuesExpression.getExpression().resolveDataBinding();
                if (exprData != null && exprData != IBinding.NOT_FOUND_BINDING) {
                    if (exprData.getKind() == 13) {
                        DefaultBinder.this.processResolvableProperties(setValuesExpression.getSettingsBlock(), dataBinding, path, (IAnnotationBinding)exprData);
                    } else {
                        final IDataBinding[][] pathArr = new IDataBinding[][]{path};
                        setValuesExpression.getExpression().accept(new AbstractASTExpressionVisitor(){

                            @Override
                            public boolean visitExpression(Expression expression) {
                                return true;
                            }

                            @Override
                            public boolean visit(ArrayAccess arrayAccess) {
                                arrayAccess.getArray().accept(this);
                                return false;
                            }

                            @Override
                            public void endVisitExpression(Expression expression) {
                                IDataBinding exprBinding = expression.resolveDataBinding();
                                if (dataBinding != null && dataBinding != IBinding.NOT_FOUND_BINDING) {
                                    pathArr[0] = DefaultBinder.this.addElement(exprBinding, pathArr[0], dataBinding);
                                }
                            }
                        });
                        if (dataBinding == null) {
                            DefaultBinder.this.processResolvableProperties(setValuesExpression.getSettingsBlock(), exprData, pathArr[0]);
                        } else {
                            DefaultBinder.this.processResolvableProperties(setValuesExpression.getSettingsBlock(), dataBinding, pathArr[0]);
                        }
                    }
                }
                return false;
            }

            @Override
            public boolean visitExpression(Expression expression) {
                if (currentAnnotation != null && !currentAnnotation.isAnnotationField() && currentAnnotation.getAnnotationType().hasSingleValue()) {
                    DefaultBinder.this.processResolvableProperty(currentAnnotation.getAnnotationType(), currentAnnotation.getValue(), dataBinding, path, expression);
                }
                return false;
            }
        });
    }

    protected IDataBinding[] addElement(IDataBinding newElement, IDataBinding[] array, IDataBinding dataBinding) {
        if (array == null) {
            if (newElement == dataBinding) {
                return null;
            }
            return new IDataBinding[]{newElement};
        }
        if (newElement == array[array.length - 1]) {
            return array;
        }
        if (newElement.getKind() == 5 && array[array.length - 1].getKind() == 5) {
            array[array.length - 1] = newElement;
            return array;
        }
        IDataBinding[] newArray = new IDataBinding[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = newElement;
        return newArray;
    }

    protected Object resolveRedefines(Node node, Object value, IDataBinding varBinding, IDataBinding[] path) {
        IDataBinding result;
        if (!(value instanceof String)) {
            return value;
        }
        String redefinesName = (String)value;
        Name name = new ExpressionParser(this.compilerOptions).parseAsName(redefinesName);
        if (name == null) {
            this.problemRequestor.acceptProblem(node, 3114, 2, new String[]{"redefines"});
            return IBinding.NOT_FOUND_BINDING;
        }
        try {
            this.bindExpressionName(name);
            result = name.resolveDataBinding();
        }
        catch (ResolutionException resolutionException) {
            this.problemRequestor.acceptProblem(node, 3114, 2, new String[]{"redefines"});
            result = IBinding.NOT_FOUND_BINDING;
        }
        return result;
    }

    protected Object resolveFunctionMemberRef(Node node, IAnnotationBinding aBinding, Object value, IDataBinding varBinding, IDataBinding[] path) {
        if (!(value instanceof String)) {
            return value;
        }
        String functionName = (String)value;
        Name name = new ExpressionParser(this.compilerOptions).parseAsName(functionName);
        if (name == null) {
            return IBinding.NOT_FOUND_BINDING;
        }
        IDataBinding result = null;
        boolean resultValid = true;
        try {
            IDataBinding dataBinding;
            this.bindExpressionName(name);
            result = dataBinding = name.resolveDataBinding();
            resultValid = 20 == dataBinding.getKind();
        }
        catch (ResolutionException resolutionException) {
            resultValid = false;
        }
        if (!resultValid) {
            this.problemRequestor.acceptProblem(node, 5556, new String[]{functionName, aBinding.getCaseSensitiveName(), varBinding.getCaseSensitiveName()});
            result = IBinding.NOT_FOUND_BINDING;
        }
        return result;
    }

    protected Object resolveBinding(final Node node, Object value, IDataBinding varBinding, IDataBinding[] path) {
        IDataBinding result;
        if (!(value instanceof String)) {
            return value;
        }
        String bindingName = (String)value;
        boolean resultIsValid = false;
        Expression expr = new ExpressionParser(this.compilerOptions).parseAsLvalue(bindingName);
        if (expr == null) {
            result = IBinding.NOT_FOUND_BINDING;
        } else {
            final IProblemRequestor oldProblemRequestor = this.problemRequestor;
            this.problemRequestor = new DefaultProblemRequestor(){

                @Override
                public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind, String[] inserts) {
                    if (severity == 2) {
                        this.setHasError(true);
                    }
                    oldProblemRequestor.acceptProblem(node, problemKind, severity, inserts);
                }

                @Override
                public boolean shouldReportProblem(int problemKind) {
                    return oldProblemRequestor.shouldReportProblem(problemKind);
                }
            };
            expr.accept(this);
            this.problemRequestor = oldProblemRequestor;
            resultIsValid = true;
            result = expr.resolveDataBinding();
            if (result == null) {
                result = IBinding.NOT_FOUND_BINDING;
            }
        }
        if (!resultIsValid) {
            this.problemRequestor.acceptProblem(node, 6619, new String[]{value.toString()});
        }
        return result;
    }

    protected boolean isUIRecordItem(IDataBinding dataBinding, IDataBinding[] path) {
        if (path == null || path.length < 2) {
            return dataBinding.getAnnotation(new String[]{"egl", "ui", "webTransaction"}, "VGUIRecord") != null;
        }
        IDataBinding[] newPath = new IDataBinding[path.length - 1];
        System.arraycopy(path, 0, newPath, 0, newPath.length);
        return dataBinding.getAnnotationFor(new String[]{"egl", "ui", "webTransaction"}, "VGUIRecord", newPath) != null;
    }

    @Override
    public void endVisit(ClassDataDeclaration classDataDeclaration) {
        IDataBinding dbinding;
        IPartBinding partBinding;
        Type type = classDataDeclaration.getType();
        if (type != null) {
            while (type.isArrayType()) {
                type = ((ArrayType)type).getElementType();
            }
            if (type.isPrimitiveType()) {
                PrimitiveTypeValidator.validate((PrimitiveType)type, this.problemRequestor, this.compilerOptions);
            }
        }
        if (classDataDeclaration.hasInitializer()) {
            if (classDataDeclaration.hasSettingsBlock()) {
                this.issueErrorForInitialization(classDataDeclaration.getSettingsBlockOpt(), ((Name)classDataDeclaration.getNames().get(0)).getCanonicalName(), 3436);
            }
        } else {
            ITypeBinding tBinding = classDataDeclaration.getType().resolveTypeBinding();
            if (Binding.isValidBinding(tBinding) && !tBinding.isNullable() && tBinding.isReference() && !tBinding.isInstantiable() && this.currentScope.getPartBinding() != tBinding) {
                this.problemRequestor.acceptProblem((Node)type, 3433, new String[]{type.getCanonicalName()});
            }
            if (classDataDeclaration.hasSettingsBlock() && Binding.isValidBinding(tBinding) && tBinding.isNullable()) {
                this.issueErrorForInitialization(classDataDeclaration.getSettingsBlockOpt(), ((Name)classDataDeclaration.getNames().get(0)).getCanonicalName(), 3437);
            }
        }
        if (StatementValidator.isValidBinding(partBinding = this.currentScope.getPartBinding()) && partBinding.getKind() == 11 && partBinding.getAnnotation(new String[]{"egl", "core"}, "NativeLibrary") != null) {
            Object name;
            boolean error = false;
            if (type.isPrimitiveType()) {
                error = true;
            } else if (type.isNameType()) {
                name = ((NameType)type).getName();
                IBinding binding = ((Name)name).resolveBinding();
                ITypeBinding typeBinding = null;
                if (IBinding.NOT_FOUND_BINDING != binding) {
                    if (binding.isDataBinding()) {
                        error = true;
                    } else if (binding.isTypeBinding() && (typeBinding = (ITypeBinding)binding).getKind() != 14 && typeBinding.getKind() != 15) {
                        error = true;
                    }
                }
            }
            if (error) {
                name = ((Expression)classDataDeclaration.getNames().get(0)).getCanonicalString();
                this.problemRequestor.acceptProblem((Node)classDataDeclaration, classDataDeclaration.isConstant() ? 5614 : 5615, new String[]{name, partBinding.getCaseSensitiveName()});
            }
        }
        if (classDataDeclaration.hasSettingsBlock() && Binding.isValidBinding(dbinding = ((Expression)classDataDeclaration.getNames().get(0)).resolveDataBinding())) {
            this.issueErrorForPropertyOverrides(dbinding, classDataDeclaration.getSettingsBlockOpt());
        }
    }

    @Override
    public void endVisit(final FunctionDataDeclaration functionDataDeclaration) {
        IDataBinding dbinding;
        Type type = functionDataDeclaration.getType();
        if (type != null) {
            IBinding binding;
            if (type.isNameType() && StatementValidator.isValidBinding(binding = ((NameType)type).getName().resolveBinding()) && binding.isTypeBinding() && ((ITypeBinding)binding).getKind() == 22 && functionDataDeclaration.hasSettingsBlock()) {
                functionDataDeclaration.getSettingsBlockOpt().accept(new AbstractASTExpressionVisitor(){
                    int initSize = -1;

                    @Override
                    public boolean visit(NewExpression newExpression) {
                        Expression initsizeexpr;
                        if (newExpression.getType().isArrayType() && (initsizeexpr = ((ArrayType)newExpression.getType()).getInitialSize()) != null) {
                            initsizeexpr.accept(new AbstractASTExpressionVisitor(){

                                @Override
                                public boolean visit(IntegerLiteral integerLiteral) {
                                    int size = Integer.valueOf(integerLiteral.getValue());
                                    if (initSize != -1 && initSize != size) {
                                        (this).DefaultBinder.this.problemRequestor.acceptProblem(functionDataDeclaration, 3231);
                                    }
                                    initSize = size;
                                    return false;
                                }
                            });
                        }
                        return false;
                    }
                });
            }
            while (type.isArrayType()) {
                type = ((ArrayType)type).getElementType();
            }
            if (type.isPrimitiveType()) {
                PrimitiveTypeValidator.validate((PrimitiveType)type, this.problemRequestor, this.compilerOptions);
            }
            if (functionDataDeclaration.hasInitializer()) {
                if (functionDataDeclaration.hasSettingsBlock()) {
                    this.issueErrorForInitialization(functionDataDeclaration.getSettingsBlockOpt(), ((Name)functionDataDeclaration.getNames().get(0)).getCanonicalName(), 3436);
                }
            } else {
                ITypeBinding tBinding = functionDataDeclaration.getType().resolveTypeBinding();
                if (Binding.isValidBinding(tBinding) && !tBinding.isNullable() && tBinding.isReference() && !tBinding.isInstantiable() && this.currentScope.getPartBinding() != tBinding) {
                    this.problemRequestor.acceptProblem((Node)type, 3433, new String[]{type.getCanonicalName()});
                }
                if (functionDataDeclaration.hasSettingsBlock() && Binding.isValidBinding(tBinding) && tBinding.isNullable()) {
                    this.issueErrorForInitialization(functionDataDeclaration.getSettingsBlockOpt(), ((Name)functionDataDeclaration.getNames().get(0)).getCanonicalName(), 3437);
                }
            }
        }
        if (functionDataDeclaration.hasSettingsBlock() && Binding.isValidBinding(dbinding = ((Expression)functionDataDeclaration.getNames().get(0)).resolveDataBinding())) {
            this.issueErrorForPropertyOverrides(dbinding, functionDataDeclaration.getSettingsBlockOpt());
        }
    }

    @Override
    public void endVisit(FunctionParameter functionParameter) {
        Type type = functionParameter.getType();
        if (type != null) {
            if (type.isArrayType()) {
                String name = functionParameter.getName().getCanonicalName();
                StatementValidator.validateRecordParamDimensions(type, this.problemRequestor, functionParameter, name);
                type = ((ArrayType)type).getElementType();
            }
            if (type.isPrimitiveType()) {
                PrimitiveTypeValidator.validateParamInFunction((PrimitiveType)type, this.problemRequestor, this.compilerOptions);
            }
        }
    }

    @Override
    public void endVisit(ProgramParameter programParameter) {
        Type type = programParameter.getType();
        if (type != null) {
            Type baseType;
            if (type.isArrayType()) {
                String name = programParameter.getName().getCanonicalName();
                StatementValidator.validateRecordParamDimensions(type, this.problemRequestor, programParameter, name);
            }
            if ((baseType = type.getBaseType()).isPrimitiveType()) {
                PrimitiveTypeValidator.validate((PrimitiveType)baseType, this.problemRequestor, this.compilerOptions);
            }
            if (type.isNameType() && InternUtil.intern((String)((NameType)type).getName().getCanonicalName()) == InternUtil.intern((String)"DB_PCBRECORD") && this.getDLIAnnotation() == null) {
                this.problemRequestor.acceptProblem(programParameter, 7929);
            }
        }
    }

    @Override
    public void endVisit(StructureItem structureItem) {
        IDataBinding dbinding;
        Type type = structureItem.getType();
        if (type != null) {
            Type baseType = type.getBaseType();
            if (baseType.isPrimitiveType()) {
                PrimitiveTypeValidator.validate((PrimitiveType)baseType, this.problemRequestor, this.compilerOptions);
            }
            if (structureItem.hasInitializer() && structureItem.hasSettingsBlock() && structureItem.getName() != null) {
                this.issueErrorForInitialization(structureItem.getSettingsBlock(), structureItem.getName().getCanonicalName(), 3436);
            }
            if (!structureItem.hasInitializer()) {
                ITypeBinding tBinding = type.resolveTypeBinding();
                if (Binding.isValidBinding(tBinding) && !tBinding.isNullable() && tBinding.isReference() && !tBinding.isInstantiable() && this.currentScope.getPartBinding() != tBinding) {
                    this.problemRequestor.acceptProblem((Node)type, 3433, new String[]{type.getCanonicalName()});
                }
                if (structureItem.hasSettingsBlock() && Binding.isValidBinding(tBinding) && tBinding.isNullable() && structureItem.getName() != null) {
                    this.issueErrorForInitialization(structureItem.getSettingsBlock(), structureItem.getName().getCanonicalName(), 3437);
                }
            }
        }
        if (structureItem.hasSettingsBlock() && structureItem.getName() != null && Binding.isValidBinding(dbinding = structureItem.getName().resolveDataBinding())) {
            this.issueErrorForPropertyOverrides(dbinding, structureItem.getSettingsBlock());
        }
    }

    @Override
    public void endVisit(ReturnsDeclaration returnStatement) {
        Type baseType;
        Type type = returnStatement.getType();
        if (type != null && (baseType = type.getBaseType()).isPrimitiveType()) {
            PrimitiveTypeValidator.validate((PrimitiveType)baseType, this.problemRequestor, this.compilerOptions);
        }
    }

    @Override
    public void endVisit(CallStatement callStatement) {
        if (callStatement.hasArguments()) {
            VAGenResolutionWarningsValidator val = new VAGenResolutionWarningsValidator(this.problemRequestor, this.compilerOptions);
            Iterator iter = callStatement.getArguments().iterator();
            while (iter.hasNext()) {
                val.checkItemRecordNameOverlap(this.currentScope, (Expression)iter.next());
            }
        }
    }

    protected void validateIOStatementInDLIProgram(final Node node) {
        node.accept(new AbstractASTExpressionVisitor(){
            boolean processed = false;

            @Override
            public boolean visitExpression(Expression expression) {
                if (this.processed) {
                    return false;
                }
                this.processed = true;
                ITypeBinding typeBinding = expression.resolveTypeBinding();
                if (StatementValidator.isValidBinding(typeBinding)) {
                    IPartBinding partBinding;
                    if (typeBinding.getKind() == 2) {
                        typeBinding = typeBinding.getBaseType();
                    }
                    if (typeBinding.getAnnotation(new String[]{"egl", "io", "dli"}, "DLISegment") != null && StatementValidator.isValidBinding(partBinding = DefaultBinder.this.currentScope.getPartBinding())) {
                        if (partBinding.getKind() != 13 && partBinding.getKind() != 11) {
                            DefaultBinder.this.problemRequestor.acceptProblem(node, 7902);
                        } else if (partBinding.getAnnotation(new String[]{"egl", "io", "dli"}, "DLI") == null) {
                            DefaultBinder.this.problemRequestor.acceptProblem(node, 7903);
                        }
                    }
                }
                return false;
            }
        });
    }

    protected void processResolvableProperties(Name name) {
        IDataBinding dataBinding = name.resolveDataBinding();
        if (dataBinding == null || dataBinding == IBinding.NOT_FOUND_BINDING) {
            return;
        }
        this.processResolvablePropertiesAndFields(dataBinding, null, name);
    }

    private void processResolvablePropertiesAndFields(IDataBinding varBinding, IDataBinding[] path, Node node) {
        this.processResolvableProperties(varBinding, path, node);
        IDataBinding dataBinding = this.getDataBindingForAnnotation(varBinding, path);
        if (dataBinding.getKind() == 5) {
            StructureItemBinding structItem = (StructureItemBinding)dataBinding;
            for (StructureItemBinding curItem : structItem.getChildren()) {
                IDataBinding[] newPath = this.addElement(curItem, path, varBinding);
                this.processResolvablePropertiesAndFields(varBinding, newPath, node);
            }
            return;
        }
        if (dataBinding.getType() == null || dataBinding.getType() == IBinding.NOT_FOUND_BINDING || dataBinding.getType().getBaseType() == null || dataBinding.getType().getBaseType() == IBinding.NOT_FOUND_BINDING) {
            return;
        }
        ITypeBinding typeBinding = dataBinding.getType().getBaseType();
        if (typeBinding.getKind() == 7) {
            FlexibleRecordBinding flexRec = (FlexibleRecordBinding)typeBinding;
            for (FlexibleRecordFieldBinding field : flexRec.getDeclaredFields()) {
                IDataBinding[] newPath = this.addElement(field, path, varBinding);
                this.processResolvablePropertiesAndFields(varBinding, newPath, node);
            }
            return;
        }
        if (typeBinding.getKind() == 6) {
            FixedRecordBinding fixedRec = (FixedRecordBinding)typeBinding;
            for (StructureItemBinding curItem : fixedRec.getStructureItems()) {
                IDataBinding[] newPath = this.addElement(curItem, path, varBinding);
                this.processResolvablePropertiesAndFields(varBinding, newPath, node);
            }
            return;
        }
    }

    private void processResolvableProperties(IDataBinding dataBinding, IDataBinding[] path, Node node) {
        AnnotationBinding newAnnotation;
        Object newValue;
        IAnnotationBinding annotation3;
        IPartSubTypeAnnotationTypeBinding subType;
        IDataBinding bindingBeingAnnotated = this.getDataBindingForAnnotation(dataBinding, path);
        ITypeBinding typeOfBindingBeingAnnotated = bindingBeingAnnotated.getType();
        if (typeOfBindingBeingAnnotated != null && typeOfBindingBeingAnnotated.isPartBinding() && (subType = ((IPartBinding)typeOfBindingBeingAnnotated).getSubType()) != null) {
            AnnotationFieldBinding newAnnotation2;
            Object newValue2;
            ArrayList<AnnotationFieldBinding> newFields = new ArrayList<AnnotationFieldBinding>();
            IAnnotationBinding subTypeAnnotationBinding = bindingBeingAnnotated.getAnnotation(subType);
            IAnnotationBinding annotation2 = this.getField(subTypeAnnotationBinding, "lengthItem");
            if (annotation2 != null && (newValue2 = this.resolveLengthItem(node, annotation2.getValue(), dataBinding, path, true)) != annotation2.getValue()) {
                newAnnotation2 = new AnnotationFieldBinding(InternUtil.internCaseSensitive((String)"lengthItem"), null, this.getInternalAnnotationType("lengthItem"), subType);
                newAnnotation2.setValue(newValue2, null, null, this.compilerOptions, false);
                newFields.add(newAnnotation2);
            }
            if ((annotation2 = this.getField(subTypeAnnotationBinding, "putOptionsRecord")) != null && (newValue2 = this.resolveMQRecordProperty(node, annotation2.getValue(), dataBinding, path, "putOptionsRecord")) != annotation2.getValue()) {
                newAnnotation2 = new AnnotationFieldBinding(InternUtil.internCaseSensitive((String)"putOptionsRecord"), null, this.getInternalAnnotationType("putOptionsRecord"), subType);
                newAnnotation2.setValue(newValue2, null, null, this.compilerOptions, false);
                newFields.add(newAnnotation2);
            }
            if ((annotation2 = this.getField(subTypeAnnotationBinding, "openOptionsRecord")) != null && (newValue2 = this.resolveMQRecordProperty(node, annotation2.getValue(), dataBinding, path, "openOptionsRecord")) != annotation2.getValue()) {
                newAnnotation2 = new AnnotationFieldBinding(InternUtil.internCaseSensitive((String)"openOptionsRecord"), null, this.getInternalAnnotationType("openOptionsRecord"), subType);
                newAnnotation2.setValue(newValue2, null, null, this.compilerOptions, false);
                newFields.add(newAnnotation2);
            }
            if ((annotation2 = this.getField(subTypeAnnotationBinding, "getOptionsRecord")) != null && (newValue2 = this.resolveMQRecordProperty(node, annotation2.getValue(), dataBinding, path, "getOptionsRecord")) != annotation2.getValue()) {
                newAnnotation2 = new AnnotationFieldBinding(InternUtil.internCaseSensitive((String)"getOptionsRecord"), null, this.getInternalAnnotationType("getOptionsRecord"), subType);
                newAnnotation2.setValue(newValue2, null, null, this.compilerOptions, false);
                newFields.add(newAnnotation2);
            }
            if ((annotation2 = this.getField(subTypeAnnotationBinding, "msgDescriptorRecord")) != null && (newValue2 = this.resolveMQRecordProperty(node, annotation2.getValue(), dataBinding, path, "msgDescriptorRecord")) != annotation2.getValue()) {
                newAnnotation2 = new AnnotationFieldBinding(InternUtil.internCaseSensitive((String)"msgDescriptorRecord"), null, this.getInternalAnnotationType("msgDescriptorRecord"), subType);
                newAnnotation2.setValue(newValue2, null, null, this.compilerOptions, false);
                newFields.add(newAnnotation2);
            }
            if ((annotation2 = this.getField(subTypeAnnotationBinding, "queueDescriptorRecord")) != null && (newValue2 = this.resolveMQRecordProperty(node, annotation2.getValue(), dataBinding, path, "queueDescriptorRecord")) != annotation2.getValue()) {
                newAnnotation2 = new AnnotationFieldBinding(InternUtil.internCaseSensitive((String)"queueDescriptorRecord"), null, this.getInternalAnnotationType("queueDescriptorRecord"), subType);
                newAnnotation2.setValue(newValue2, null, null, this.compilerOptions, false);
                newFields.add(newAnnotation2);
            }
            if ((annotation2 = this.getField(subTypeAnnotationBinding, "numElementsItem")) != null && (newValue2 = this.resolveNumElementsItem(node, annotation2.getValue(), dataBinding, path)) != annotation2.getValue()) {
                newAnnotation2 = new AnnotationFieldBinding(InternUtil.internCaseSensitive((String)"numElementsItem"), null, this.getInternalAnnotationType("numElementsItem"), subType);
                newAnnotation2.setValue(newValue2, null, null, this.compilerOptions, false);
                newFields.add(newAnnotation2);
            }
            if ((annotation2 = this.getField(subTypeAnnotationBinding, "keyItem")) != null && (newValue2 = this.resolveKeyItem(node, annotation2.getValue(), dataBinding, path)) != annotation2.getValue()) {
                newAnnotation2 = new AnnotationFieldBinding(InternUtil.internCaseSensitive((String)"keyItem"), null, this.getInternalAnnotationType("keyItem"), subType);
                newAnnotation2.setValue(newValue2, null, null, this.compilerOptions, false);
                newFields.add(newAnnotation2);
            }
            if ((annotation2 = this.getField(subTypeAnnotationBinding, "recordNumItem")) != null && (newValue2 = this.resolveRecordNumItem(node, annotation2.getValue(), dataBinding, path, true)) != annotation2.getValue()) {
                newAnnotation2 = new AnnotationFieldBinding(InternUtil.internCaseSensitive((String)"recordNumItem"), null, this.getInternalAnnotationType("recordNumItem"), subType);
                newAnnotation2.setValue(newValue2, null, null, this.compilerOptions, false);
                newFields.add(newAnnotation2);
            }
            if (!newFields.isEmpty()) {
                AnnotationBinding newSubtypeAnnotation = new AnnotationBinding(subTypeAnnotationBinding.getCaseSensitiveName(), bindingBeingAnnotated.getDeclaringPart(), subType);
                Iterator iter = subTypeAnnotationBinding.getAnnotationFields().iterator();
                while (iter.hasNext()) {
                    newSubtypeAnnotation.addField((IAnnotationBinding)iter.next());
                }
                iter = newFields.iterator();
                while (iter.hasNext()) {
                    newSubtypeAnnotation.addField((IAnnotationBinding)iter.next());
                }
                bindingBeingAnnotated.addAnnotation(newSubtypeAnnotation);
            }
        }
        if (this.isPageHandler() && (annotation3 = dataBinding.getAnnotationFor(new String[]{"egl", "ui"}, "NumElementsItem", path)) != null && (newValue = this.resolveNumElementsItem(node, annotation3.getValue(), dataBinding, path)) != annotation3.getValue()) {
            newAnnotation = new AnnotationBinding(InternUtil.internCaseSensitive((String)"NumElementsItem"), annotation3.getDeclaringPart(), annotation3.getType());
            newAnnotation.setValue(newValue, null, null, this.compilerOptions, false);
            dataBinding.addAnnotation(newAnnotation, path);
        }
        if ((annotation3 = dataBinding.getAnnotationFor(new String[]{"egl", "ui", "jsf"}, "SelectFromListItem", path)) != null && (newValue = this.resolveSelectFromListItem(node, annotation3.getValue(), dataBinding, path)) != annotation3.getValue()) {
            newAnnotation = new AnnotationBinding(InternUtil.internCaseSensitive((String)"SelectFromListItem"), null, annotation3.getType());
            newAnnotation.setValue(newValue, null, null, this.compilerOptions, false);
            dataBinding.addAnnotation(newAnnotation, path);
        }
        if ((annotation3 = dataBinding.getAnnotationFor(new String[]{"egl", "core"}, "Redefines", path)) != null && (newValue = this.resolveRedefines(node, annotation3.getValue(), dataBinding, path)) != annotation3.getValue()) {
            newAnnotation = new AnnotationBinding(InternUtil.internCaseSensitive((String)"Redefines"), null, annotation3.getType());
            newAnnotation.setValue(newValue, null, null, this.compilerOptions, false);
            dataBinding.addAnnotation(newAnnotation, path);
        }
        List annotationsFor = dataBinding.getAnnotationsFor(path);
        ArrayList<AnnotationBinding> newAnnotations = new ArrayList<AnnotationBinding>();
        for (IAnnotationBinding annotation3 : annotationsFor) {
            Object newValue3;
            IAnnotationTypeBinding annotationType = (IAnnotationTypeBinding)annotation3.getType();
            if (!annotationType.hasSingleValue() || SystemPartManager.FUNCTIONMEMBERREF_BINDING != annotationType.getSingleValueType() || (newValue3 = this.resolveFunctionMemberRef(node, annotation3, annotation3.getValue(), dataBinding, path)) == annotation3.getValue()) continue;
            AnnotationBinding newAnnotation3 = new AnnotationBinding(InternUtil.internCaseSensitive((String)"Redefines"), null, annotation3.getType());
            newAnnotation3.setValue(newValue3, null, null, this.compilerOptions, false);
            newAnnotations.add(newAnnotation3);
        }
        Iterator iter = newAnnotations.iterator();
        while (iter.hasNext()) {
            dataBinding.addAnnotation((IAnnotationBinding)iter.next(), path);
        }
    }

    private ITypeBinding getInternalAnnotationType(String name) {
        return new AnnotationTypeBinding(InternUtil.internCaseSensitive((String)name), SystemPartManager.INTERNALREF_BINDING){

            @Override
            public ITypeBinding getSingleValueType() {
                return SystemPartManager.INTERNALREF_BINDING;
            }

            @Override
            public boolean isApplicableFor(IBinding binding) {
                return true;
            }
        };
    }

    private Object resolveLengthItem(Node node, Object value, IDataBinding varBinding, IDataBinding[] path, boolean validateValue) {
        Object result;
        if (!(value instanceof String)) {
            return value;
        }
        String itemName = (String)value;
        Name name = new ExpressionParser(this.compilerOptions).parseAsName(itemName);
        if (name == null) {
            return IBinding.NOT_FOUND_BINDING;
        }
        this.currentScope = new DataBindingScope(this.currentScope, this.getDataBindingForAnnotation(varBinding, path), true);
        try {
            this.bindExpressionName(name);
            if (validateValue) {
                AnnotationFieldBinding annBinding = new AnnotationFieldBinding(InternUtil.internCaseSensitive((String)"lengthItem"), null, this.getInternalAnnotationType("lengthItem"), null);
                annBinding.setValue(name, null, null, this.compilerOptions, false);
                new LengthItemForSerialMessageOrIndexedRecordValidator().validate(node, null, annBinding, this.problemRequestor, this.compilerOptions);
            }
            result = name;
        }
        catch (ResolutionException e) {
            if (6619 == e.getProblemKind()) {
                this.problemRequestor.acceptProblem(node, 6619, new String[]{"lengthItem - \"" + itemName + "\""});
            } else {
                this.problemRequestor.acceptProblem(node, e.getProblemKind(), 2, e.getInserts());
            }
            result = IBinding.NOT_FOUND_BINDING;
        }
        this.currentScope = this.currentScope.getParentScope();
        return result;
    }

    private Object resolveKeyItem(Node node, Object value, IDataBinding varBinding, IDataBinding[] path) {
        Object result;
        if (!(value instanceof String)) {
            return value;
        }
        IDataBinding dataBinding = this.getDataBindingForAnnotation(varBinding, path);
        String keyName = (String)value;
        Name name = new ExpressionParser(this.compilerOptions).parseAsName(keyName);
        if (name == null) {
            return IBinding.NOT_FOUND_BINDING;
        }
        boolean isIndexed = varBinding.getAnnotationFor(new String[]{"egl", "io", "file"}, "IndexedRecord", path) != null;
        varBinding.getAnnotationFor(new String[]{"egl", "io", "dli"}, "DLISegment", path);
        Scope saveScope = this.currentScope;
        this.currentScope = new DataBindingScope(NullScope.INSTANCE, dataBinding, true);
        try {
            this.bindExpressionName(name);
            result = name;
        }
        catch (ResolutionException resolutionException) {
            if (isIndexed) {
                this.problemRequestor.acceptProblem(node, 3202, 2, new String[]{keyName, dataBinding.getType().getBaseType().getName()});
            } else {
                this.problemRequestor.acceptProblem(node, 7866, 2, new String[]{keyName, dataBinding.getType().getBaseType().getName()});
            }
            result = IBinding.NOT_FOUND_BINDING;
        }
        this.currentScope = saveScope;
        return result;
    }

    private Object resolveRecordNumItem(Node node, Object value, IDataBinding varBinding, IDataBinding[] path, boolean validateValue) {
        Object result;
        if (!(value instanceof String)) {
            return value;
        }
        IDataBinding dataBinding = this.getDataBindingForAnnotation(varBinding, path);
        String keyName = (String)value;
        Name name = new ExpressionParser(this.compilerOptions).parseAsName(keyName);
        if (name == null) {
            return IBinding.NOT_FOUND_BINDING;
        }
        Scope saveScope = this.currentScope;
        this.currentScope = new DataBindingScope(this.currentScope, dataBinding, true);
        try {
            this.bindExpressionName(name);
            if (validateValue) {
                AnnotationFieldBinding annBinding = new AnnotationFieldBinding(InternUtil.internCaseSensitive((String)"recordNumItem"), null, this.getInternalAnnotationType("lengthItem"), null);
                annBinding.setValue(name, null, null, this.compilerOptions, false);
                new RecordNumItemValidator().validate(node, null, annBinding, this.problemRequestor, this.compilerOptions);
            }
            result = name;
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(node, e.getProblemKind(), 2, e.getInserts());
            result = IBinding.NOT_FOUND_BINDING;
        }
        this.currentScope = saveScope;
        return result;
    }

    private Object resolveSelectFromListItem(Node node, Object value, IDataBinding varBinding, IDataBinding[] path) {
        Object result;
        if (!(value instanceof String)) {
            return value;
        }
        String selectFromListName = (String)value;
        Name name = new ExpressionParser(this.compilerOptions).parseAsName(selectFromListName);
        if (name == null) {
            return IBinding.NOT_FOUND_BINDING;
        }
        try {
            IDataBinding db = this.bindExpressionName(name);
            result = name;
            if (db != IBinding.NOT_FOUND_BINDING) {
                boolean valid = false;
                if (this.isArray(db)) {
                    boolean bl = valid = 7 != db.getDeclaringPart().getKind() && 3 == db.getType().getBaseType().getKind();
                }
                if (!valid) {
                    this.problemRequestor.acceptProblem(node, 3130, new String[]{value.toString()});
                }
            }
        }
        catch (ResolutionException e) {
            if (e.getProblemKind() == 6620) {
                this.problemRequestor.acceptProblem(node, 5384, 2, new String[]{"selectFromListItem", selectFromListName, this.getDataBindingForAnnotation(varBinding, path).getName()});
            } else {
                this.problemRequestor.acceptProblem(node, 5383, 2, new String[]{"selectFromListItem", selectFromListName, this.getDataBindingForAnnotation(varBinding, path).getName()});
            }
            result = IBinding.NOT_FOUND_BINDING;
        }
        return result;
    }

    private boolean isArray(IDataBinding db) {
        StructureItemBinding sItemBinding;
        if (5 == db.getKind() && (5 == (sItemBinding = (StructureItemBinding)db).getEnclosingStructureBinding().getKind() || sItemBinding.isMultiplyOccuring())) {
            return true;
        }
        ITypeBinding tBinding = db.getType();
        return tBinding == null || 2 == tBinding.getKind();
    }

    private Object resolveMQRecordProperty(Node node, Object value, IDataBinding varBinding, IDataBinding[] path, String annotationType) {
        Object result;
        if (!(value instanceof String)) {
            return value;
        }
        String propName = (String)value;
        Name name = new ExpressionParser(this.compilerOptions).parseAsName(propName);
        if (name == null) {
            return IBinding.NOT_FOUND_BINDING;
        }
        try {
            this.bindExpressionName(name);
            result = name;
            if (!this.isBasicRecordReferece(name.resolveDataBinding())) {
                this.problemRequestor.acceptProblem(node, 5558, 2, new String[]{propName, annotationType});
            }
        }
        catch (ResolutionException e) {
            if (6619 == e.getProblemKind()) {
                this.problemRequestor.acceptProblem(node, 5556, new String[]{propName, annotationType, varBinding.getName()});
            } else if (6620 == e.getProblemKind()) {
                this.problemRequestor.acceptProblem(node, 5557, new String[]{propName, annotationType, varBinding.getName()});
            } else {
                this.problemRequestor.acceptProblem(node, e.getProblemKind(), 2, e.getInserts());
            }
            result = IBinding.NOT_FOUND_BINDING;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processResolvableProperty(IAnnotationTypeBinding annotationType, Object value, IDataBinding dataBinding, IDataBinding[] path, Expression expr) {
        if (value == null) {
            return;
        }
        IAnnotationBinding annotation = dataBinding.getAnnotationFor(annotationType, path);
        if (annotation == null) {
            if (dataBinding.getType() == null || !dataBinding.getType().isPartBinding()) return;
            IPartSubTypeAnnotationTypeBinding subType = ((IPartBinding)dataBinding.getType()).getSubType();
            if (subType == null) return;
            annotation = (IAnnotationBinding)dataBinding.getAnnotation(subType).findData(annotationType.getName());
            if (IBinding.NOT_FOUND_BINDING == annotation) {
                return;
            }
        }
        if (DefaultBinder.annotationIs(annotationType, new String[]{"egl", "ui", "jsf"}, "SelectFromListItem")) {
            annotation.setValue(this.resolveSelectFromListItem(expr, value, dataBinding, path), null, null, this.compilerOptions, false);
            return;
        }
        if (DefaultBinder.annotationIs(annotationType, new String[]{"egl", "ui"}, "SelectedIndexItem")) {
            if (!this.isUIRecordItem(dataBinding, path)) return;
            annotation.setValue(this.resolveSelectedIndexItem(expr, value, dataBinding, path), null, null, this.compilerOptions, false);
            return;
        }
        if (DefaultBinder.annotationIs(annotationType, new String[]{"egl", "core"}, "redefines")) {
            annotation.setValue(this.resolveRedefines(expr, value, dataBinding, path), null, null, this.compilerOptions, false);
            return;
        }
        if (DefaultBinder.annotationIs(annotationType, new String[]{"egl", "ui"}, "NumElementsItem")) {
            if (!this.isUIRecordItem(dataBinding, path) && !this.isPageHandler()) return;
            annotation.setValue(this.resolveNumElementsItem(expr, value, dataBinding, path), null, null, this.compilerOptions, false);
            return;
        }
        String annotationName = annotation.getName();
        String caseSensitiveAnnotationName = annotation.getCaseSensitiveName();
        IAnnotationTypeBinding enclosingAnnotationType = annotation.getEnclosingAnnotationType();
        if (DefaultBinder.annotationIs(enclosingAnnotationType, new String[]{"egl", "io", "mq"}, "MQRecord") && (InternUtil.intern((String)"putOptionsRecord") == annotationName || InternUtil.intern((String)"openOptionsRecord") == annotationName || InternUtil.intern((String)"getOptionsRecord") == annotationName || InternUtil.intern((String)"msgDescriptorRecord") == annotationName || InternUtil.intern((String)"queueDescriptorRecord") == annotationName)) {
            annotation.setValue(this.resolveMQRecordProperty(expr, value, dataBinding, path, caseSensitiveAnnotationName), null, null, this.compilerOptions, false);
            return;
        }
        if (DefaultBinder.annotationIs(enclosingAnnotationType, new String[]{"egl", "io", "file"}, "RelativeRecord")) {
            annotation.setValue(this.resolveRecordNumItem(expr, value, dataBinding, path, false), null, null, this.compilerOptions, false);
        }
        if (DefaultBinder.annotationIs(enclosingAnnotationType, new String[]{"egl", "io", "file"}, "IndexedRecord") || DefaultBinder.annotationIs(enclosingAnnotationType, new String[]{"egl", "io", "mq"}, "MQRecord") || DefaultBinder.annotationIs(enclosingAnnotationType, new String[]{"egl", "io", "file"}, "SerialRecord") || DefaultBinder.annotationIs(enclosingAnnotationType, new String[]{"egl", "io", "dli"}, "DLISegment")) {
            if (InternUtil.intern((String)"numElementsItem") == annotationName) {
                annotation.setValue(this.resolveNumElementsItem(expr, value, dataBinding, path), null, null, this.compilerOptions, false);
                return;
            }
            if (InternUtil.intern((String)"lengthItem") == annotationName) {
                annotation.setValue(this.resolveLengthItem(expr, value, dataBinding, path, false), null, null, this.compilerOptions, false);
                return;
            }
        }
        if (!annotationType.hasSingleValue() || SystemPartManager.FUNCTIONMEMBERREF_BINDING != annotationType.getSingleValueType()) return;
        annotation.setValue(this.resolveFunctionMemberRef(expr, annotation, value, dataBinding, path), null, null, this.compilerOptions, false);
    }

    protected boolean isPageHandler() {
        return false;
    }

    private boolean isBasicRecordReferece(IDataBinding dataBinding) {
        if (dataBinding.getType().getKind() == 2) {
            return false;
        }
        return dataBinding.getAnnotation(new String[]{"egl", "core"}, "BasicRecord") != null;
    }

    private IAnnotationBinding getField(IAnnotationBinding aBinding, String fieldName) {
        if (!Binding.isValidBinding(aBinding)) {
            return null;
        }
        IDataBinding fieldBinding = aBinding.findData(fieldName);
        return IBinding.NOT_FOUND_BINDING == fieldBinding ? null : (IAnnotationBinding)fieldBinding;
    }

    private void issueErrorForPropertyOverrides(IDataBinding fieldBinding, SettingsBlock settings) {
        if (!(fieldBinding instanceof DataBinding) || ((DataBinding)fieldBinding).getPropertyOverrides().isEmpty()) {
            return;
        }
        final Stack<IDataBinding> stack = new Stack<IDataBinding>();
        stack.push(fieldBinding);
        final Node[] errorNode = new Node[1];
        settings.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(Assignment assignment) {
                if (errorNode[0] != null) {
                    return false;
                }
                if (Binding.isValidBinding(assignment.resolveBinding()) && stack.size() > 1) {
                    errorNode[0] = assignment;
                }
                return false;
            }

            @Override
            public boolean visit(AnnotationExpression annotationExpression) {
                if (errorNode[0] != null) {
                    return false;
                }
                if (stack.size() > 1) {
                    errorNode[0] = annotationExpression;
                }
                return false;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                if (errorNode[0] != null) {
                    return false;
                }
                IDataBinding dBinding = setValuesExpression.getExpression().resolveDataBinding();
                if (Binding.isValidBinding(dBinding)) {
                    if (dBinding.getKind() == 13) {
                        if (stack.size() > 1) {
                            errorNode[0] = setValuesExpression.getExpression();
                        }
                    } else {
                        stack.push(dBinding);
                        setValuesExpression.getSettingsBlock().accept(this);
                    }
                }
                return false;
            }

            @Override
            public void endVisit(SetValuesExpression setValuesExpression) {
                IDataBinding dBinding = setValuesExpression.getExpression().resolveDataBinding();
                if (Binding.isValidBinding(dBinding) && dBinding.getKind() != 13) {
                    stack.pop();
                }
            }

            @Override
            public boolean visitExpression(Expression expression) {
                return false;
            }
        });
        this.problemRequestor.acceptProblem(errorNode[0], 3438, 2, new String[]{fieldBinding.getCaseSensitiveName()});
    }

    private void issueErrorForInitialization(SettingsBlock settings, String fieldName, int errorNo) {
        final Node[] errorNode = new Node[1];
        settings.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(Assignment assignment) {
                IDataBinding dBinding;
                if (errorNode[0] != null) {
                    return false;
                }
                if (assignment.resolveBinding() == null && Binding.isValidBinding(dBinding = assignment.getLeftHandSide().resolveDataBinding()) && dBinding.getKind() != 13) {
                    errorNode[0] = assignment;
                }
                return false;
            }

            @Override
            public boolean visit(AnnotationExpression annotationExpression) {
                return false;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                if (errorNode[0] != null) {
                    return false;
                }
                IDataBinding dBinding = setValuesExpression.getExpression().resolveDataBinding();
                if (Binding.isValidBinding(dBinding) && dBinding.getKind() != 13) {
                    setValuesExpression.getSettingsBlock().accept(this);
                }
                return false;
            }

            @Override
            public boolean visitExpression(Expression expression) {
                if (errorNode[0] != null) {
                    return false;
                }
                errorNode[0] = expression;
                return false;
            }
        });
        if (errorNode[0] != null) {
            this.problemRequestor.acceptProblem(errorNode[0], errorNo, 2, new String[]{fieldName});
        }
    }

    private class CheckNoDynamicAccessVisitor
    extends AbstractASTVisitor {
        boolean dynamicAccessUsed = false;

        private CheckNoDynamicAccessVisitor() {
        }

        void check(Expression expr, Node nodeToHangErrorOn) {
            expr.accept(this);
            if (this.dynamicAccessUsed) {
                DefaultBinder.this.problemRequestor.acceptProblem(nodeToHangErrorOn, 6584);
            }
        }

        @Override
        public boolean visit(ArrayAccess arrayAccess) {
            ITypeBinding indexType;
            if (arrayAccess.getIndices().size() == 1 && (indexType = ((Expression)arrayAccess.getIndices().get(0)).resolveTypeBinding()) != null && indexType.getKind() == 3 && Primitive.isStringType(((PrimitiveTypeBinding)indexType).getPrimitive())) {
                this.dynamicAccessUsed = true;
            }
            return true;
        }
    }

    private static class DimensionGatherer
    extends AbstractASTExpressionVisitor {
        List dimensions = new ArrayList();
        boolean haveProcessedStructureItem = false;

        private DimensionGatherer() {
        }

        int[] getDimensions(Expression expr) {
            expr.accept(this);
            int[] result = new int[this.dimensions.size()];
            int i = 0;
            Iterator iter = this.dimensions.iterator();
            while (iter.hasNext()) {
                result[i++] = (Integer)iter.next();
            }
            return result;
        }

        private List getDimensions(StructureItemBinding itemBinding) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            StructureItemBinding parentItem = itemBinding.getParentItem();
            if (parentItem != null) {
                result.addAll(this.getDimensions(parentItem));
            } else if (5 == itemBinding.getEnclosingStructureBinding().getKind() && !itemBinding.hasOccurs()) {
                result.add(new Integer(Integer.MAX_VALUE));
            }
            if (itemBinding.hasOccurs()) {
                result.add(new Integer(itemBinding.getOccurs()));
            }
            return result;
        }

        private void processBinding(IDataBinding dBinding) {
            if (5 == dBinding.getKind()) {
                if (!this.haveProcessedStructureItem) {
                    this.haveProcessedStructureItem = true;
                    this.dimensions.addAll(0, this.getDimensions((StructureItemBinding)dBinding));
                }
            } else if (7 == dBinding.getKind()) {
                FormFieldBinding fieldBinding = (FormFieldBinding)dBinding;
                if (fieldBinding.isMultiplyOccuring()) {
                    this.dimensions.add(0, new Integer(fieldBinding.getOccurs()));
                }
            } else if (2 == dBinding.getKind() || 3 == dBinding.getKind() || dBinding.getKind() == 0 || 1 == dBinding.getKind() || 14 == dBinding.getKind() || 4 == dBinding.getKind()) {
                ITypeBinding tBinding = dBinding.getType();
                this.processBinding(tBinding);
            }
        }

        private void processBinding(ITypeBinding tBinding) {
            if (tBinding != null) {
                while (2 == tBinding.getKind()) {
                    this.dimensions.add(0, new Integer(Integer.MAX_VALUE));
                    tBinding = ((ArrayTypeBinding)tBinding).getElementType();
                }
                if (ArrayDictionaryBinding.INSTANCE == tBinding) {
                    this.dimensions.add(0, new Integer(Integer.MAX_VALUE));
                }
            }
        }

        @Override
        public boolean visitName(Name name) {
            IDataBinding dBinding = name.resolveDataBinding();
            if (dBinding != null && dBinding != IBinding.NOT_FOUND_BINDING) {
                this.processBinding(dBinding);
                if (5 == dBinding.getKind()) {
                    Expression target;
                    Node parent;
                    IDataBinding implicitQualifier = (IDataBinding)name.getAttribute(Name.IMPLICIT_QUALIFIER_DATA_BINDING);
                    if (implicitQualifier != null) {
                        this.processBinding(implicitQualifier);
                    }
                    if (name.isSimpleName() && (parent = name.getParent()) instanceof Assignment && name == ((Assignment)parent).getLeftHandSide() && (parent = parent.getParent()) instanceof SettingsBlock && (parent = parent.getParent()) instanceof SetValuesExpression && (target = ((SetValuesExpression)parent).getExpression()) instanceof ArrayAccess) {
                        this.processIndices(((ArrayAccess)target).getIndices());
                    }
                }
            }
            return true;
        }

        private void processIndices(List indices) {
            Iterator iter = indices.iterator();
            while (iter.hasNext()) {
                ITypeBinding indexType = ((Expression)iter.next()).resolveTypeBinding();
                if (indexType != null && 3 == indexType.getKind() && Primitive.isStringType(((PrimitiveTypeBinding)indexType).getPrimitive()) || this.dimensions.isEmpty()) continue;
                this.dimensions.remove(0);
            }
        }

        @Override
        public boolean visitExpression(Expression expression) {
            ITypeBinding tBinding = expression.resolveTypeBinding();
            if (tBinding != null) {
                this.processBinding(tBinding);
            }
            return false;
        }

        @Override
        public boolean visit(ParenthesizedExpression parenthesizedExpression) {
            return true;
        }

        @Override
        public boolean visit(FieldAccess fieldAccess) {
            IDataBinding dBinding = fieldAccess.resolveDataBinding();
            if (dBinding != null && dBinding != IBinding.NOT_FOUND_BINDING) {
                this.processBinding(dBinding);
            }
            return true;
        }

        @Override
        public boolean visit(ThisExpression thisExpression) {
            this.processBinding(thisExpression.resolveTypeBinding());
            return false;
        }

        @Override
        public boolean visit(ArrayAccess arrayAccess) {
            arrayAccess.getArray().accept(this);
            this.processIndices(arrayAccess.getIndices());
            return false;
        }
    }

    private static class IntFromExpressionGetter
    extends DefaultASTVisitor {
        int result = -1;
        boolean isNegative = false;

        private IntFromExpressionGetter() {
        }

        int getInt(Expression expr) {
            IDataBinding dBinding = expr.resolveDataBinding();
            if (dBinding != null) {
                Object constValue;
                VariableBinding varBinding;
                if (dBinding != IBinding.NOT_FOUND_BINDING && (3 == dBinding.getKind() || 2 == dBinding.getKind()) && (varBinding = (VariableBinding)dBinding).isConstant() && (constValue = varBinding.getConstantValue()) instanceof Integer) {
                    this.result = (Integer)constValue;
                }
                return this.result;
            }
            expr.accept(this);
            if (this.isNegative && this.result != -1) {
                this.result *= -1;
            }
            return this.result;
        }

        @Override
        public boolean visit(ParenthesizedExpression parenthesizedExpression) {
            return true;
        }

        @Override
        public boolean visit(UnaryExpression unaryExpression) {
            if (unaryExpression.getOperator() == UnaryExpression.Operator.MINUS) {
                this.isNegative = !this.isNegative;
            }
            return true;
        }

        @Override
        public boolean visit(IntegerLiteral integerLiteral) {
            this.result = Integer.parseInt(integerLiteral.getValue());
            return false;
        }
    }

    private static class IntGetter
    extends DefaultASTVisitor {
        int intValue = -1;
        boolean isNegative = false;

        private IntGetter() {
        }

        int getInt(Expression expr) {
            expr.accept(this);
            return this.intValue;
        }

        @Override
        public boolean visit(UnaryExpression unaryExpression) {
            if (unaryExpression.getOperator() == UnaryExpression.Operator.MINUS) {
                this.isNegative = !this.isNegative;
            }
            return true;
        }

        @Override
        public boolean visit(IntegerLiteral integerLiteral) {
            this.intValue = Integer.parseInt(integerLiteral.getValue());
            if (this.isNegative) {
                this.intValue *= -1;
            }
            return false;
        }

        @Override
        public boolean visit(ParenthesizedExpression parenthesizedExpression) {
            return true;
        }
    }

    private static abstract class IsNotBindingChecker
    extends AbstractASTExpressionVisitor {
        IProblemRequestor problemRequestor;
        int problemKind;
        boolean bindingIsValid = false;

        IsNotBindingChecker(IProblemRequestor problemRequestor, int problemKind) {
            this.problemRequestor = problemRequestor;
            this.problemKind = problemKind;
        }

        @Override
        public boolean visit(ParenthesizedExpression parenthesizedExpression) {
            return true;
        }

        @Override
        public boolean visitExpression(Expression expression) {
            if (expression.resolveTypeBinding() != null) {
                this.bindingIsValid = this.isValid(expression.resolveTypeBinding());
            }
            return false;
        }

        @Override
        public boolean visitName(Name name) {
            IBinding binding = name.resolveBinding();
            this.bindingIsValid = binding == IBinding.NOT_FOUND_BINDING ? true : this.isValid(binding);
            return false;
        }

        @Override
        public boolean visit(ArrayAccess arrayAccess) {
            IBinding binding = arrayAccess.resolveDataBinding();
            if (binding == null || binding == IBinding.NOT_FOUND_BINDING) {
                this.bindingIsValid = true;
            } else {
                IDataBinding dBinding = binding;
                ITypeBinding tBinding = dBinding.getType();
                if (tBinding != null && 2 == tBinding.getKind()) {
                    binding = arrayAccess.resolveTypeBinding();
                }
                if (binding != null) {
                    this.bindingIsValid = this.isValid(binding);
                }
            }
            return false;
        }

        @Override
        public void endVisitExpression(Expression expression) {
            if (!this.bindingIsValid) {
                this.problemRequestor.acceptProblem((Node)expression, this.problemKind, new String[]{expression.getCanonicalString()});
            }
        }

        abstract boolean isValid(IBinding var1);
    }

    private static class QualifierBindingGatherer
    extends DefaultASTVisitor {
        IDataBinding qualifierDBinding;
        ITypeBinding qualifierTBinding;
        private boolean returnTopLevelQualifier;

        public QualifierBindingGatherer(boolean returnTopLevelQualifier) {
            this.returnTopLevelQualifier = returnTopLevelQualifier;
        }

        @Override
        public boolean visit(QualifiedName qualifiedName) {
            Name expr = qualifiedName.getQualifier();
            this.qualifierDBinding = ((Expression)expr).resolveDataBinding();
            this.qualifierTBinding = expr.resolveTypeBinding();
            return this.returnTopLevelQualifier;
        }

        @Override
        public boolean visit(ArrayAccess arrayAccess) {
            arrayAccess.getArray().accept(this);
            return false;
        }
    }

    protected static class SetValuesExpressionCompletor
    extends DefaultBinder {
        TypeBindingScope leftHandScope;

        public SetValuesExpressionCompletor(Scope currentScope, IPartBinding currentBinding, TypeBindingScope leftHandScope, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
            super(currentScope, currentBinding, dependencyRequestor, problemRequestor, compilerOptions);
            this.leftHandScope = leftHandScope;
        }

        @Override
        public boolean visit(SettingsBlock settingsBlock) {
            return true;
        }

        @Override
        public boolean visit(Assignment assignment) {
            Scope saved = this.currentScope;
            this.currentScope = this.leftHandScope;
            assignment.getLeftHandSide().accept(this);
            this.currentScope = saved;
            assignment.getRightHandSide().accept(this);
            return false;
        }

        @Override
        public boolean visit(SetValuesExpression setValuesExpression) {
            Scope saved = this.currentScope;
            this.currentScope = this.leftHandScope;
            setValuesExpression.getExpression().accept(this);
            this.currentScope = saved;
            ITypeBinding typeBinding = setValuesExpression.getExpression().resolveTypeBinding();
            if (Binding.isValidBinding(typeBinding)) {
                TypeBindingScope newScope = new TypeBindingScope(NullScope.INSTANCE, typeBinding, setValuesExpression.getExpression().resolveDataBinding());
                setValuesExpression.getSettingsBlock().accept(new SetValuesExpressionCompletor(this.currentScope, this.currentBinding, newScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
            } else {
                SetValuesExpressionCompletor.bindNamesToNotFound(setValuesExpression.getSettingsBlock());
            }
            return false;
        }

        @Override
        public boolean visit(ThisExpression thisExpression) {
            thisExpression.setTypeBinding(this.leftHandScope.getTypeBinding());
            return false;
        }
    }

    private static class SubscriptsGatherer
    extends AbstractASTVisitor {
        List subscripts = new ArrayList();

        private SubscriptsGatherer() {
        }

        List getSubscripts(Expression expr) {
            expr.accept(this);
            return this.subscripts;
        }

        @Override
        public boolean visit(ArrayAccess arrayAccess) {
            arrayAccess.getArray().accept(this);
            for (Expression nextExpr : arrayAccess.getIndices()) {
                ITypeBinding indexType = nextExpr.resolveTypeBinding();
                if (indexType != null && 3 == indexType.getKind() && Primitive.isStringType(((PrimitiveTypeBinding)indexType).getPrimitive())) continue;
                this.subscripts.add(nextExpr);
            }
            return false;
        }
    }

    private static class SystemVariableOnlyChecker
    extends AbstractASTExpressionVisitor {
        String[] systemLibraryPackage;
        String systemLibraryName;
        String systemVariableName;
        IProblemRequestor problemRequestor;
        IsNotStateBinding stateBinding;
        int problemKind;

        SystemVariableOnlyChecker(String[] systemLibraryPackage, String systemLibraryName, String systemVariableName, IProblemRequestor problemRequestor, IsNotStateBinding stateBinding, int problemKind) {
            this.systemLibraryPackage = InternUtil.intern((String[])systemLibraryPackage);
            this.systemLibraryName = InternUtil.intern((String)systemLibraryName);
            this.systemVariableName = InternUtil.intern((String)systemVariableName);
            this.problemRequestor = problemRequestor;
            this.stateBinding = stateBinding;
            this.problemKind = problemKind;
        }

        @Override
        public boolean visit(ParenthesizedExpression parenthesizedExpression) {
            return true;
        }

        @Override
        public void endVisit(FunctionInvocation functionInvocation) {
        }

        @Override
        public void endVisitName(Name name) {
            IPartBinding declaringPart;
            IBinding binding = name.resolveBinding();
            boolean isValid = false;
            if (binding == IBinding.NOT_FOUND_BINDING) {
                isValid = true;
            } else if (binding.isDataBinding() && (declaringPart = ((IDataBinding)binding).getDeclaringPart()) != null) {
                boolean bl = isValid = declaringPart.getPackageName() == this.systemLibraryPackage && declaringPart.getName() == this.systemLibraryName && binding.getName() == this.systemVariableName;
            }
            if (!isValid) {
                this.endVisitExpression(name);
            }
        }

        @Override
        public void endVisitExpression(Expression expression) {
            this.problemRequestor.acceptProblem((Node)expression, this.problemKind, new String[]{this.stateBinding.getName().toLowerCase(), this.stateBinding.getName().toLowerCase()});
        }
    }
}

