/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.AnnotationFieldBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.FixedRecordBindingCompletor;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FunctionContainerBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.TypeReferenceClassFieldBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.NullProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultScope;
import org.eclipse.edt.compiler.internal.core.lookup.FixedStructureScope;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.utils.ExpressionParser;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FixedRecordBinder
extends DefaultBinder {
    private FixedRecordBinding recordBinding;
    private Scope scope;

    public FixedRecordBinder(FixedRecordBinding recordBinding, Scope scope, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(scope, recordBinding, dependencyRequestor, problemRequestor, compilerOptions);
        this.recordBinding = recordBinding;
        this.scope = scope;
    }

    @Override
    public boolean visit(Record record) {
        record.accept(new FixedRecordBindingCompletor(this.scope, this.recordBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        this.currentScope = new FixedStructureScope(this.currentScope, this.recordBinding);
        return true;
    }

    @Override
    public void endVisit(Record record) {
        if (FixedRecordBinder.annotationIs(this.recordBinding.getSubType(), new String[]{"egl", "ui", "webTransaction"}, "VGUIRecord")) {
            this.dependencyRequestor.recordFunctionContainerScope(new FunctionContainerScope(this.scope, new UIRecordFunctionContainerBinding(this.recordBinding, this.compilerOptions, this.currentScope)));
            HashSet<Object> validatorFunctions = new HashSet<Object>();
            IAnnotationBinding aBinding = (IAnnotationBinding)this.recordBinding.getAnnotation(new String[]{"egl", "ui", "webTransaction"}, "VGUIRecord").findData(InternUtil.intern((String)"runValidatorFromProgram"));
            if (aBinding != IBinding.NOT_FOUND_BINDING && Boolean.NO == aBinding.getValue() && (aBinding = (IAnnotationBinding)this.recordBinding.getAnnotation(new String[]{"egl", "ui", "webTransaction"}, "VGUIRecord").findData(InternUtil.intern((String)"validatorFunction"))) != IBinding.NOT_FOUND_BINDING && aBinding.getValue() != null && IBinding.NOT_FOUND_BINDING != aBinding.getValue()) {
                validatorFunctions.add(aBinding.getValue());
            }
            Iterator iter = this.recordBinding.getStructureItems().iterator();
            while (iter.hasNext()) {
                this.addValidatorFunctions(validatorFunctions, (StructureItemBinding)iter.next());
            }
            for (IFunctionBinding iFunctionBinding : validatorFunctions) {
                if (iFunctionBinding.isSystemFunction()) continue;
                this.dependencyRequestor.recordTopLevelFunctionBinding(iFunctionBinding);
            }
        }
    }

    private void addValidatorFunctions(Set functionBindings, StructureItemBinding sItemBinding) {
        IAnnotationBinding aBinding = sItemBinding.getAnnotation(new String[]{"egl", "ui"}, "RunValidatorFromProgram");
        if (aBinding != null && Boolean.NO == aBinding.getValue() && (aBinding = sItemBinding.getAnnotation(new String[]{"egl", "ui"}, "ValidatorFunction")) != null && aBinding.getValue() != null && IBinding.NOT_FOUND_BINDING != aBinding.getValue()) {
            functionBindings.add(aBinding.getValue());
        }
        Iterator iter = sItemBinding.getChildren().iterator();
        while (iter.hasNext()) {
            this.addValidatorFunctions(functionBindings, (StructureItemBinding)iter.next());
        }
    }

    @Override
    public boolean visit(StructureItem item) {
        if (item.hasSettingsBlock()) {
            item.getSettingsBlock().accept(this);
        }
        if (item.hasInitializer()) {
            item.getInitializer().accept(this);
        }
        this.resolveProgramAndRecordName(item);
        return false;
    }

    private void resolveProgramAndRecordName(StructureItem item) {
        IAnnotationBinding ann;
        if (Binding.isValidBinding(item.resolveBinding()) && Binding.isValidBinding(ann = item.resolveBinding().getAnnotation(new String[]{"egl", "ui", "webTransaction"}, "programLinkData"))) {
            AnnotationFieldBinding fb;
            IDataBinding field = ann.findData(InternUtil.intern((String)"programName"));
            if (Binding.isValidBinding(field)) {
                fb = (AnnotationFieldBinding)field;
                fb.setValue(this.resolveProgramName(fb.getValue()), null, null, this.compilerOptions, false);
            }
            if (Binding.isValidBinding(field = ann.findData(InternUtil.intern((String)"uiRecordName")))) {
                fb = (AnnotationFieldBinding)field;
                fb.setValue(this.resolveUIRecordName(fb.getValue()), null, null, this.compilerOptions, false);
            }
        }
    }

    private Object resolveProgramName(Object obj) {
        if (!(obj instanceof String)) {
            return obj;
        }
        String nameString = (String)obj;
        Name name = new ExpressionParser(this.compilerOptions).parseAsName(nameString);
        if (name == null) {
            return nameString;
        }
        try {
            ITypeBinding type = this.bindTypeName(name);
            if (type.getKind() == 13) {
                return type;
            }
        }
        catch (ResolutionException resolutionException) {}
        return nameString;
    }

    private Object resolveUIRecordName(Object obj) {
        if (!(obj instanceof String)) {
            return obj;
        }
        String nameString = (String)obj;
        Name name = new ExpressionParser(this.compilerOptions).parseAsName(nameString);
        if (name == null) {
            return nameString;
        }
        try {
            ITypeBinding type = this.bindTypeName(name);
            if (type.getKind() == 6) {
                return type;
            }
        }
        catch (ResolutionException resolutionException) {}
        return nameString;
    }

    @Override
    public boolean visit(Assignment assignment) {
        Scope currentScopeParent = this.currentScope.getParentScope();
        this.currentScope.setParentScope(new DefaultScope());
        assignment.getLeftHandSide().accept(this);
        this.currentScope.setParentScope(currentScopeParent);
        assignment.getRightHandSide().accept(this);
        return false;
    }

    private static class UIRecordFunctionContainerBinding
    extends FunctionContainerBinding {
        FixedRecordBinding recordBinding;
        private ICompilerOptions compilerOptions;
        private Scope currentScope;

        public UIRecordFunctionContainerBinding(FixedRecordBinding recordBinding, ICompilerOptions compilerOptions, Scope currentScope) {
            super(recordBinding.getPackageName(), recordBinding.getCaseSensitiveName());
            this.recordBinding = recordBinding;
            this.compilerOptions = compilerOptions;
            this.currentScope = currentScope;
        }

        @Override
        public boolean isStructurallyEqual(IPartBinding anotherPartBinding) {
            return false;
        }

        @Override
        public int getKind() {
            return 13;
        }

        @Override
        public IDataBinding findData(String simpleName) {
            if (simpleName == this.recordBinding.getName()) {
                TypeReferenceClassFieldBinding result = new TypeReferenceClassFieldBinding(this.recordBinding.getCaseSensitiveName(), this, this.recordBinding);
                return result;
            }
            IDataBinding result = (IDataBinding)this.recordBinding.getSimpleNamesToDataBindingsMap().get(simpleName);
            return result == null ? IBinding.NOT_FOUND_BINDING : result;
        }

        @Override
        public IAnnotationBinding getAnnotation(IAnnotationTypeBinding annotationType) {
            if (FixedRecordBinder.annotationIs(annotationType, new String[]{"egl", "core"}, "AllowUnqualifiedItemReferences")) {
                AnnotationBinding aBinding = new AnnotationBinding(InternUtil.internCaseSensitive((String)""), this, new AnnotationTypeBindingImpl((FlexibleRecordBinding)this.currentScope.findPackage(InternUtil.intern((String)"egl")).resolvePackage(InternUtil.intern((String)"core")).resolveType(InternUtil.intern((String)"allowUnqualifiedItemReferences")), this.recordBinding));
                aBinding.setValue(Boolean.YES, NullProblemRequestor.getInstance(), new SimpleName("yes", 0, 0), this.compilerOptions, false);
                return aBinding;
            }
            return this.recordBinding.getAnnotation(annotationType);
        }

        @Override
        public IAnnotationBinding getAnnotation(String[] packageName, String annotationName) {
            if (packageName == InternUtil.intern((String[])new String[]{"egl", "core"}) && annotationName == InternUtil.intern((String)"AllowUnqualifiedItemReferences")) {
                AnnotationBinding aBinding = new AnnotationBinding(InternUtil.internCaseSensitive((String)""), this.recordBinding, new AnnotationTypeBindingImpl((FlexibleRecordBinding)this.currentScope.findPackage(InternUtil.intern((String)"egl")).resolvePackage(InternUtil.intern((String)"core")).resolveType(InternUtil.intern((String)"allowUnqualifiedItemReferences")), this.recordBinding));
                aBinding.setValue(Boolean.YES, NullProblemRequestor.getInstance(), new SimpleName("yes", 0, 0), this.compilerOptions, false);
                return aBinding;
            }
            return this.recordBinding.getAnnotation(packageName, annotationName);
        }

        @Override
        public ITypeBinding primGetNullableInstance() {
            return this;
        }
    }
}

