/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup.System;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.edt.compiler.binding.AmbiguousSystemLibraryFieldDataBinding;
import org.eclipse.edt.compiler.binding.DataBindingWithImplicitQualifier;
import org.eclipse.edt.compiler.binding.FunctionBindingWithImplicitQualifier;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.LibraryBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.OverloadedFunctionSet;
import org.eclipse.edt.compiler.binding.VariableBinding;

public class SystemLibraryManager {
    private Map libraries = new HashMap();
    private Map libraryData = new HashMap();
    private Map libraryFunctions = new HashMap();

    public SystemLibraryManager(SystemLibraryManager parentLib) {
        if (parentLib != null) {
            this.libraries.putAll(parentLib.libraries);
            this.libraryData.putAll(parentLib.libraryData);
            this.libraryFunctions.putAll(parentLib.libraryFunctions);
        }
    }

    public ITypeBinding findType(String simpleName) {
        return (ITypeBinding)this.getLibraries().get(simpleName);
    }

    public IDataBinding findData(String simpleName) {
        return (IDataBinding)this.getLibraryData().get(simpleName);
    }

    public IFunctionBinding findFunction(String simpleName) {
        return (IFunctionBinding)this.getLibraryFunctions().get(simpleName);
    }

    public Map getLibraries() {
        return this.libraries;
    }

    private Map getLibraryData() {
        return this.libraryData;
    }

    private Map getLibraryFunctions() {
        return this.libraryFunctions;
    }

    public void addSystemLibrary(LibraryBinding libraryBinding) {
        this.libraries.put(libraryBinding.getName(), libraryBinding);
        this.addLibraryData(libraryBinding);
        this.addLibraryFunctions(libraryBinding);
    }

    private void addLibraryData(LibraryBinding library) {
        for (VariableBinding var : library.getClassFields()) {
            this.putLibraryData(var.getName(), new DataBindingWithImplicitQualifier(var, library.getStaticLibraryDataBinding()));
        }
        for (NestedFunctionBinding newFunction : library.getDeclaredFunctions()) {
            OverloadedFunctionSet functionSet;
            IDataBinding existingFunction = (IDataBinding)this.libraryData.get(newFunction.getName());
            if (existingFunction == null) {
                this.putLibraryData(newFunction.getName(), new DataBindingWithImplicitQualifier(newFunction, library.getStaticLibraryDataBinding()));
                continue;
            }
            if ((existingFunction = ((DataBindingWithImplicitQualifier)existingFunction).getWrappedDataBinding()) instanceof OverloadedFunctionSet) {
                functionSet = (OverloadedFunctionSet)existingFunction;
            } else {
                functionSet = new OverloadedFunctionSet();
                functionSet.setName(newFunction.getCaseSensitiveName());
                functionSet.addNestedFunctionBinding(existingFunction);
            }
            functionSet.addNestedFunctionBinding(newFunction);
            this.putLibraryData(newFunction.getName(), new DataBindingWithImplicitQualifier(functionSet, library.getStaticLibraryDataBinding()));
        }
    }

    private void putLibraryData(String name, IDataBinding dBinding) {
        IDataBinding existingDBinding = (IDataBinding)this.libraryData.get(name);
        if (existingDBinding == null || 23 == dBinding.getKind()) {
            this.libraryData.put(name, dBinding);
        } else {
            AmbiguousSystemLibraryFieldDataBinding ambigFieldBinding;
            if (24 == existingDBinding.getKind()) {
                ambigFieldBinding = (AmbiguousSystemLibraryFieldDataBinding)existingDBinding;
            } else {
                ambigFieldBinding = new AmbiguousSystemLibraryFieldDataBinding();
                ambigFieldBinding.addAllowedQualifier(existingDBinding.getDeclaringPart().getName());
            }
            ambigFieldBinding.addAllowedQualifier(dBinding.getDeclaringPart().getName());
            this.libraryData.put(name, ambigFieldBinding);
        }
    }

    private void addLibraryFunctions(LibraryBinding library) {
        Iterator i = library.getDeclaredFunctions().iterator();
        while (i.hasNext()) {
            IFunctionBinding function = (IFunctionBinding)((NestedFunctionBinding)i.next()).getType();
            this.libraryFunctions.put(function.getName(), new FunctionBindingWithImplicitQualifier(function, library.getStaticLibraryDataBinding()));
        }
    }
}

