/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup.System;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.binding.DictionaryBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBindingImpl;
import org.eclipse.edt.compiler.binding.FlexibleRecordFieldBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.lookup.SystemEnvironmentPackageNames;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class SystemPartManager {
    private static Map systemParts = Collections.EMPTY_MAP;
    public static final IPartBinding ANYEXCEPTION_BINDING = SystemPartManager.createAnyExceptionBinding();
    public static final IPartBinding INTERNALREF_BINDING = SystemPartManager.createEGLCoreReflectBinding("InternalRef");
    public static final IPartBinding FIELDREF_BINDING = SystemPartManager.createEGLCoreReflectBinding("FieldRef");
    public static final IPartBinding FIELDINTARGETREF_BINDING = SystemPartManager.createEGLCoreReflectBinding("FieldInTargetRef");
    public static final IPartBinding FUNCTIONREF_BINDING = SystemPartManager.createEGLCoreReflectBinding("FunctionRef");
    public static final IPartBinding FUNCTIONMEMBERREF_BINDING = SystemPartManager.createEGLCoreReflectBinding("FunctionMemberRef");
    public static final IPartBinding RECORDREF_BINDING = SystemPartManager.createEGLCoreReflectBinding("RecordRef");
    public static final IPartBinding SERVICEREF_BINDING = SystemPartManager.createEGLCoreReflectBinding("ServiceRef");
    public static final IPartBinding SQLSTRING_BINDING = SystemPartManager.createEGLCoreReflectBinding("SQLString");
    public static final IPartBinding TYPEREF_BINDING = SystemPartManager.createEGLCoreReflectBinding("TypeRef");

    public static ITypeBinding findType(String simpleName) {
        return (ITypeBinding)SystemPartManager.getSystemParts().get(simpleName);
    }

    public static Map getSystemParts() {
        if (systemParts == Collections.EMPTY_MAP) {
            SystemPartManager.initializeSystemParts();
        }
        return systemParts;
    }

    private static void initializeSystemParts() {
        systemParts = new HashMap();
        systemParts.put(InternUtil.intern((String)"dictionary"), DictionaryBinding.INSTANCE);
        systemParts.put(InternUtil.intern((String)"InternalRef"), INTERNALREF_BINDING);
        systemParts.put(InternUtil.intern((String)"FieldRef"), FIELDREF_BINDING);
        systemParts.put(InternUtil.intern((String)"FieldInTargetRef"), FIELDINTARGETREF_BINDING);
        systemParts.put(InternUtil.intern((String)"FunctionRef"), FUNCTIONREF_BINDING);
        systemParts.put(InternUtil.intern((String)"FunctionMemberRef"), FUNCTIONMEMBERREF_BINDING);
        systemParts.put(InternUtil.intern((String)"RecordRef"), RECORDREF_BINDING);
        systemParts.put(InternUtil.intern((String)"ServiceRef"), SERVICEREF_BINDING);
        systemParts.put(InternUtil.intern((String)"SQLString"), SQLSTRING_BINDING);
        systemParts.put(InternUtil.intern((String)"TypeRef"), TYPEREF_BINDING);
    }

    private static void addFlexibleRecordField(FlexibleRecordBinding rBinding, String fieldName, ITypeBinding type) {
        SystemPartManager.addFlexibleRecordField(rBinding, fieldName, type, false);
    }

    private static void addFlexibleRecordField(FlexibleRecordBinding rBinding, String fieldName, ITypeBinding type, boolean isReadOnly) {
        FlexibleRecordFieldBinding rb = new FlexibleRecordFieldBinding(InternUtil.internCaseSensitive((String)fieldName), rBinding, type);
        rb.setIsReadOnly(isReadOnly);
        rBinding.addField(rb);
    }

    private static void addStructureItem(FixedRecordBinding rBinding, String fieldName, ITypeBinding type) {
        SystemPartManager.addStructureItem(rBinding, fieldName, type, false);
    }

    private static void addStructureItem(FixedRecordBinding rBinding, String fieldName, ITypeBinding type, boolean isReadOnly) {
        StructureItemBinding si = new StructureItemBinding(InternUtil.internCaseSensitive((String)fieldName), rBinding, type);
        si.setIsReadOnly(isReadOnly);
        rBinding.addStructureItem(si);
    }

    private static IPartBinding createEGLCoreReflectBinding(String name) {
        ExternalTypeBinding result = new ExternalTypeBinding(SystemEnvironmentPackageNames.EGL_CORE_REFLECT, InternUtil.internCaseSensitive((String)name));
        result.setValid(true);
        return result;
    }

    private static IPartBinding createAnyExceptionBinding() {
        FlexibleRecordBindingImpl result = new FlexibleRecordBindingImpl(SystemEnvironmentPackageNames.EGL_CORE, InternUtil.internCaseSensitive((String)"AnyException"));
        SystemPartManager.addFlexibleRecordField(result, "message", PrimitiveTypeBinding.getInstance(Primitive.STRING));
        result.setValid(true);
        return result;
    }
}

