/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.AnnotationFieldBinding;
import org.eclipse.edt.compiler.binding.AnnotationValidationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.DataItemBinding;
import org.eclipse.edt.compiler.binding.DataItemPropertiesProblemsProblemRequestor;
import org.eclipse.edt.compiler.binding.FieldContentValidationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PartContentValidationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.UsedTypeBinding;
import org.eclipse.edt.compiler.binding.ValueValidationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.BasicFormGroupAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.EGLNotInCurrentReleaseAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.StereotypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.ConstantFormField;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.FormGroup;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.core.ast.VariableFormField;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DataItemPropertiesFieldContentRule;
import org.eclipse.edt.compiler.internal.core.validation.statement.LValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.RValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class AnnotationValidator {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private IProblemRequestor storedProblemRequestor;

    public AnnotationValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    private IProblemRequestor restoreProblemRequestor() {
        IProblemRequestor result = this.storedProblemRequestor;
        this.storedProblemRequestor = null;
        return result;
    }

    private IProblemRequestor specializeProblemRequestor(IProblemRequestor problemRequestor, Node target, IAnnotationBinding annotation) {
        return this.specializeProblemRequestor(problemRequestor, target, annotation.getAnnotationType());
    }

    private IProblemRequestor specializeProblemRequestor(IProblemRequestor problemRequestor, Node target, IAnnotationTypeBinding annotationType) {
        this.storedProblemRequestor = problemRequestor;
        IProblemRequestor result = problemRequestor;
        if (target instanceof DataItem) {
            result = new DataItemPropertiesProblemsProblemRequestor(problemRequestor, ((DataItem)target).getName().resolveBinding(), annotationType);
        }
        return result;
    }

    public void validateAnnotationTarget(Node target) {
        target.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(Record record) {
                IAnnotationTypeBinding partSubTypeBinding = null;
                IAnnotationBinding bindingWithAnnotations = null;
                IBinding binding = record.getName().resolveBinding();
                if (binding.isTypeBinding() && ((ITypeBinding)binding).isPartBinding()) {
                    partSubTypeBinding = ((IPartBinding)binding).getSubType();
                    bindingWithAnnotations = binding.getAnnotation(partSubTypeBinding);
                    if (partSubTypeBinding != null) {
                        partSubTypeBinding = partSubTypeBinding.getValidationProxy();
                    }
                }
                if (partSubTypeBinding == null) {
                    return false;
                }
                if (partSubTypeBinding != null && bindingWithAnnotations != null) {
                    AnnotationValidator.this.processPartSubTypeSubAnnotations(record.getName(), record, bindingWithAnnotations, partSubTypeBinding.getAnnotations());
                    AnnotationValidator.this.processPartSubTypeFields(record, record.getContents(), partSubTypeBinding);
                    AnnotationValidator.this.processPartSubType(record, partSubTypeBinding);
                }
                AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(record);
                return false;
            }

            @Override
            public boolean visit(TopLevelForm form) {
                IDataBinding subTypeBinding;
                Name subType = form.getSubType();
                if (subType != null && IBinding.NOT_FOUND_BINDING != (subTypeBinding = subType.resolveDataBinding())) {
                    AnnotationValidator.this.processPartSubTypeSubAnnotations(form.getName(), form, subTypeBinding, ((IAnnotationTypeBinding)subTypeBinding.getType()).getValidationProxy().getAnnotations());
                    AnnotationValidator.this.processPartSubTypeFields(form, form.getContents(), ((IAnnotationTypeBinding)subTypeBinding.getType()).getValidationProxy());
                    AnnotationValidator.this.processPartSubType(form, ((IAnnotationTypeBinding)subTypeBinding.getType()).getValidationProxy());
                }
                AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(form);
                return false;
            }

            @Override
            public boolean visit(NestedForm form) {
                IDataBinding subTypeBinding;
                Name subType = form.getSubType();
                if (subType != null && IBinding.NOT_FOUND_BINDING != (subTypeBinding = subType.resolveDataBinding())) {
                    AnnotationValidator.this.processPartSubTypeSubAnnotations(form.getName(), form, subTypeBinding, ((IAnnotationTypeBinding)subTypeBinding.getType()).getValidationProxy().getAnnotations());
                    AnnotationValidator.this.processPartSubTypeFields(form, form.getContents(), ((IAnnotationTypeBinding)subTypeBinding.getType()).getValidationProxy());
                    AnnotationValidator.this.processPartSubType(form.getName(), form, form.getContents(), ((IAnnotationTypeBinding)subTypeBinding.getType()).getValidationProxy());
                }
                AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(form);
                return false;
            }

            public boolean visitFunctionContainer(Part functionContainerPart, Name subType) {
                IAnnotationTypeBinding partSubTypeBinding = null;
                IAnnotationBinding bindingWithAnnotations = null;
                IBinding binding = functionContainerPart.getName().resolveBinding();
                if (binding.isTypeBinding() && ((ITypeBinding)binding).isPartBinding()) {
                    partSubTypeBinding = ((IPartBinding)binding).getSubType();
                    bindingWithAnnotations = binding.getAnnotation(partSubTypeBinding);
                    if (partSubTypeBinding != null) {
                        partSubTypeBinding = partSubTypeBinding.getValidationProxy();
                    }
                }
                if (partSubTypeBinding == null) {
                    return false;
                }
                AnnotationValidator.this.processPartSubTypeSubAnnotations(functionContainerPart.getName(), functionContainerPart, bindingWithAnnotations, partSubTypeBinding.getAnnotations());
                AnnotationValidator.this.processPartSubTypeFields(functionContainerPart, functionContainerPart.getContents(), partSubTypeBinding);
                AnnotationValidator.this.processPartSubType(functionContainerPart, partSubTypeBinding);
                AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(functionContainerPart);
                return false;
            }

            @Override
            public boolean visit(Program program) {
                this.visitFunctionContainer(program, program.getSubType());
                return false;
            }

            @Override
            public boolean visit(Library library) {
                this.visitFunctionContainer(library, library.getSubType());
                return false;
            }

            @Override
            public boolean visit(Handler handler) {
                this.visitFunctionContainer(handler, handler.getSubType());
                return false;
            }

            @Override
            public boolean visit(Interface interfaceNode) {
                this.visitFunctionContainer(interfaceNode, interfaceNode.getSubType());
                return false;
            }

            @Override
            public boolean visit(Service serviceNode) {
                this.visitFunctionContainer(serviceNode, serviceNode.getSubType());
                return false;
            }

            @Override
            public boolean visit(NestedFunction function) {
                IDataBinding db = function.getName().resolveDataBinding();
                if (Binding.isValidBinding(db)) {
                    AnnotationValidator.this.processAnnotations(function, db.getType(), db);
                }
                return false;
            }

            @Override
            public boolean visit(ExternalType externalType) {
                this.visitFunctionContainer(externalType, externalType.getSubType());
                return false;
            }

            @Override
            public boolean visit(DataItem dataItem) {
                DataItemBinding binding = (DataItemBinding)dataItem.getName().resolveBinding();
                AnnotationValidator.this.processAnnotations(dataItem, binding == null ? null : binding.getPrimitiveTypeBinding(), null);
                AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(dataItem);
                return false;
            }

            @Override
            public boolean visit(FormGroup formGroup) {
                AnnotationValidator.this.processPartSubTypeSubAnnotations(formGroup.getName(), formGroup, formGroup.getName().resolveBinding(), null);
                AnnotationValidator.this.processPartSubTypeFields(formGroup, formGroup.getContents(), BasicFormGroupAnnotationTypeBinding.getInstance());
                AnnotationValidator.this.processPartSubType(formGroup, null);
                AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(formGroup);
                return false;
            }

            @Override
            public boolean visit(StructureItem structureItem) {
                AnnotationValidator.this.processAnnotations(structureItem, (IDataBinding)structureItem.resolveBinding());
                if (structureItem.hasSettingsBlock()) {
                    AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(structureItem.getSettingsBlock());
                }
                return false;
            }

            @Override
            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                AnnotationValidator.this.processAnnotations(classDataDeclaration, this.getType(classDataDeclaration.getType().resolveTypeBinding()), null);
                if (classDataDeclaration.hasSettingsBlock()) {
                    AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(classDataDeclaration.getSettingsBlockOpt());
                }
                return false;
            }

            @Override
            public boolean visit(UseStatement useStatement) {
                UsedTypeBinding usedTypeBinding = useStatement.getUsedTypeBinding();
                if (usedTypeBinding != null) {
                    AnnotationValidator.this.processAnnotations(useStatement, this.getType(usedTypeBinding.getType()), null);
                }
                return false;
            }

            private ITypeBinding getType(ITypeBinding binding) {
                if (binding != null && IBinding.NOT_FOUND_BINDING != binding) {
                    switch (binding.getKind()) {
                        case 17: {
                            binding = ((DataItemBinding)binding).getPrimitiveTypeBinding();
                            return binding;
                        }
                        case 2: {
                            return ArrayTypeBinding.getInstance(this.getType(((ArrayTypeBinding)binding).getElementType()));
                        }
                    }
                }
                return binding;
            }

            @Override
            public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                AnnotationValidator.this.processAnnotations(functionDataDeclaration, this.getType(functionDataDeclaration.getType().resolveTypeBinding()), null);
                if (functionDataDeclaration.hasSettingsBlock()) {
                    AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(functionDataDeclaration.getSettingsBlockOpt());
                }
                return false;
            }

            @Override
            public boolean visit(VariableFormField variableFormField) {
                AnnotationValidator.this.processAnnotations(variableFormField, variableFormField.getName().resolveDataBinding());
                if (variableFormField.hasSettingsBlock()) {
                    AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(variableFormField.getSettingsBlock());
                }
                return false;
            }

            @Override
            public boolean visit(ConstantFormField constantFormField) {
                AnnotationValidator.this.processAnnotations(constantFormField, constantFormField.resolveBinding());
                return false;
            }
        });
    }

    private void processAnnotations(Node target, IDataBinding targetBinding) {
        this.processAnnotations(target, targetBinding == null || IBinding.NOT_FOUND_BINDING == targetBinding ? null : targetBinding.getType(), null);
    }

    private void processAnnotations(final Node target, final ITypeBinding targetTypeBinding, IDataBinding targetDataBinding) {
        target.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                if (classDataDeclaration.hasSettingsBlock()) {
                    classDataDeclaration.getSettingsBlockOpt().accept(this);
                }
                return false;
            }

            @Override
            public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                if (functionDataDeclaration.hasSettingsBlock()) {
                    functionDataDeclaration.getSettingsBlockOpt().accept(this);
                }
                return false;
            }

            @Override
            public boolean visit(NestedFunction nestedFunction) {
                final 2 superVisitor = this;
                DefaultASTVisitor visitor = new DefaultASTVisitor(){

                    @Override
                    public boolean visit(NestedFunction nestedFunction) {
                        return true;
                    }

                    @Override
                    public boolean visit(SettingsBlock settingsBlock) {
                        settingsBlock.accept(superVisitor);
                        return false;
                    }
                };
                nestedFunction.accept(visitor);
                return false;
            }

            @Override
            public boolean visit(UseStatement useStatement) {
                if (useStatement.hasSettingsBlock()) {
                    useStatement.getSettingsBlock().accept(this);
                }
                return false;
            }

            @Override
            public boolean visit(StructureItem structureItem) {
                if (structureItem.hasSettingsBlock()) {
                    structureItem.getSettingsBlock().accept(this);
                }
                return false;
            }

            @Override
            public boolean visit(VariableFormField variableFormField) {
                if (variableFormField.hasSettingsBlock()) {
                    variableFormField.getSettingsBlock().accept(this);
                }
                return false;
            }

            @Override
            public boolean visit(ConstantFormField constantFormField) {
                if (constantFormField.hasSettingsBlock()) {
                    constantFormField.getSettingsBlock().accept(this);
                }
                return false;
            }

            @Override
            public boolean visit(AnnotationExpression annotationExpression) {
                IDataBinding annotationExpressionDBinding = annotationExpression.resolveDataBinding();
                if (IBinding.NOT_FOUND_BINDING != annotationExpressionDBinding && annotationExpressionDBinding.getKind() == 13) {
                    AnnotationValidator.this.processSubAnnotations(annotationExpression, target, targetTypeBinding, null, (IAnnotationBinding)annotationExpression.resolveDataBinding(), ((IAnnotationTypeBinding)annotationExpression.resolveTypeBinding()).getValidationProxy().getAnnotations());
                }
                return false;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                Expression annotationExpression = setValuesExpression.getExpression();
                IDataBinding annotationExpressionDBinding = annotationExpression.resolveDataBinding();
                if (Binding.isValidBinding(annotationExpressionDBinding) && annotationExpressionDBinding.getKind() == 13) {
                    SettingsBlock settingsBlock = setValuesExpression.getSettingsBlock();
                    ITypeBinding annotationExpressionTBinding = annotationExpressionDBinding.getType();
                    if (annotationExpressionTBinding != null && !((IAnnotationTypeBinding)annotationExpressionTBinding).hasSingleValue()) {
                        AnnotationValidator.this.processSubAnnotations(annotationExpression, target, targetTypeBinding, null, (IAnnotationBinding)annotationExpressionDBinding, ((IAnnotationTypeBinding)annotationExpressionTBinding).getValidationProxy().getAnnotations());
                        AnnotationValidator.this.processComplexAnnotationFields(target, settingsBlock, (IAnnotationTypeBinding)annotationExpressionTBinding);
                    }
                }
                return false;
            }

            @Override
            public boolean visit(Assignment assignment) {
                IAnnotationBinding aBinding = assignment.resolveBinding();
                if (aBinding != null) {
                    AnnotationFieldBinding annField;
                    IAnnotationTypeBinding validationProxy = aBinding.getAnnotationType().getValidationProxy();
                    AnnotationValidator.this.processSubAnnotations(assignment, target, targetTypeBinding, null, aBinding, validationProxy.getAnnotations());
                    AnnotationValidator.this.processSimpleAnnotationFields(target, assignment, validationProxy);
                    if (aBinding.isAnnotationField() && (annField = (AnnotationFieldBinding)aBinding).getEnclosingAnnotationType() != null && annField.getEnclosingAnnotationType().getValidationProxy() != null) {
                        AnnotationValidator.this.processComplexAnnotationFields(target, assignment, annField.getEnclosingAnnotationType().getValidationProxy());
                    }
                }
                return false;
            }

            @Override
            public boolean visitExpression(final Expression expression) {
                target.accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(ClassDataDeclaration classDataDeclaration) {
                        classDataDeclaration.getType().accept(this);
                        return false;
                    }

                    @Override
                    public boolean visit(StructureItem structureItem) {
                        structureItem.getType().accept(this);
                        return false;
                    }

                    @Override
                    public boolean visit(ArrayType arrayType) {
                        ITypeBinding exprType;
                        if (arrayType.hasInitialSize() && targetTypeBinding != null && 2 == targetTypeBinding.getKind() && (exprType = expression.resolveTypeBinding()) != null && !TypeCompatibilityUtil.isMoveCompatible(((ArrayTypeBinding)targetTypeBinding).getElementType(), exprType, null, AnnotationValidator.this.compilerOptions)) {
                            AnnotationValidator.this.problemRequestor.acceptProblem((Node)expression, 6653, new String[]{exprType.getCaseSensitiveName(), ((ArrayTypeBinding)targetTypeBinding).getElementType().getCaseSensitiveName(), expression.getCanonicalString()});
                        }
                        return false;
                    }
                });
                return false;
            }
        });
    }

    private void processOverriddenAnnotationsAndSetValues(final Node target) {
        target.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(Record record) {
                return true;
            }

            @Override
            public boolean visit(NestedForm nestedForm) {
                return true;
            }

            @Override
            public boolean visit(TopLevelForm topLevelForm) {
                return true;
            }

            @Override
            public boolean visit(Program program) {
                return true;
            }

            @Override
            public boolean visit(Library library) {
                return true;
            }

            @Override
            public boolean visit(Handler handler) {
                return true;
            }

            @Override
            public boolean visit(DataItem dataItem) {
                return true;
            }

            @Override
            public boolean visit(FormGroup formGroup) {
                return true;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                final Expression annotationExpression = setValuesExpression.getExpression();
                final IDataBinding annotationExpressionDBinding = annotationExpression.resolveDataBinding();
                if (IBinding.NOT_FOUND_BINDING != annotationExpressionDBinding && annotationExpressionDBinding != null) {
                    if (5 == annotationExpressionDBinding.getKind() || 7 == annotationExpressionDBinding.getKind()) {
                        setValuesExpression.getSettingsBlock().accept(new DefaultASTVisitor(){

                            @Override
                            public boolean visit(SettingsBlock settingsBlock) {
                                return true;
                            }

                            @Override
                            public boolean visit(Assignment assignment) {
                                IAnnotationBinding aBinding = assignment.resolveBinding();
                                if (aBinding != null) {
                                    List ruleAnnotations = ((IAnnotationTypeBinding)aBinding.getType()).getValidationProxy().getAnnotations();
                                    AnnotationValidator.this.processSubAnnotations(assignment, annotationExpression, annotationExpressionDBinding.getType(), null, aBinding, ruleAnnotations);
                                }
                                return false;
                            }
                        });
                    }
                    AnnotationValidator.this.processOverriddenAnnotationsAndSetValues(setValuesExpression.getSettingsBlock());
                    if (annotationExpressionDBinding.getAnnotation(EGLNotInCurrentReleaseAnnotationTypeBinding.getInstance()) != null) {
                        AnnotationValidator.this.problemRequestor.acceptProblem((Node)(annotationExpression instanceof AnnotationExpression ? ((AnnotationExpression)annotationExpression).getName() : annotationExpression), 3459, new String[]{annotationExpressionDBinding.getType().getCaseSensitiveName()});
                    }
                }
                return false;
            }

            @Override
            public boolean visit(final Assignment assignment) {
                IAnnotationBinding aBinding = assignment.resolveBinding();
                if (aBinding == null) {
                    ITypeBinding lhType = assignment.getLeftHandSide().resolveTypeBinding();
                    ITypeBinding rhType = assignment.getRightHandSide().resolveTypeBinding();
                    if (StatementValidator.isValidBinding(lhType) && StatementValidator.isValidBinding(rhType) && 18 != lhType.getKind()) {
                        IDataBinding rhDBinding;
                        if ((Assignment.Operator.CONCAT == assignment.getOperator() || Assignment.Operator.NULLCONCAT == assignment.getOperator()) && 2 == lhType.getKind()) {
                            lhType = ((ArrayTypeBinding)lhType).getElementType();
                        }
                        if (!(TypeCompatibilityUtil.isMoveCompatible(lhType, rhType, assignment.getRightHandSide(), AnnotationValidator.this.compilerOptions) || rhType.isDynamic() || TypeCompatibilityUtil.areCompatibleExceptions(rhType, lhType, AnnotationValidator.this.compilerOptions))) {
                            AnnotationValidator.this.problemRequestor.acceptProblem((Node)assignment.getRightHandSide(), 6653, new String[]{StatementValidator.getShortTypeString(lhType), StatementValidator.getShortTypeString(rhType), String.valueOf(assignment.getLeftHandSide().getCanonicalString()) + "=" + assignment.getRightHandSide().getCanonicalString()});
                        }
                        target.accept(new DefaultASTVisitor(){

                            @Override
                            public boolean visit(Record record) {
                                IDataBinding lhDBinding = assignment.getLeftHandSide().resolveDataBinding();
                                if (StatementValidator.isValidBinding(lhDBinding) && 5 == lhDBinding.getKind() && !((StructureItemBinding)lhDBinding).getChildren().isEmpty()) {
                                    AnnotationValidator.this.problemRequestor.acceptProblem(assignment.getLeftHandSide(), 7753);
                                }
                                return false;
                            }
                        });
                        IDataBinding lhDBinding = assignment.getLeftHandSide().resolveDataBinding();
                        if (StatementValidator.isValidBinding(lhDBinding)) {
                            new LValueValidator(AnnotationValidator.this.problemRequestor, AnnotationValidator.this.compilerOptions, lhDBinding, assignment.getLeftHandSide(), new LValueValidator.DefaultLValueValidationRules(){

                                @Override
                                public boolean canAssignToReadOnlyVariables() {
                                    return true;
                                }
                            }).validate();
                        }
                        if (StatementValidator.isValidBinding(rhDBinding = assignment.getRightHandSide().resolveDataBinding())) {
                            new RValueValidator(AnnotationValidator.this.problemRequestor, AnnotationValidator.this.compilerOptions, rhDBinding, assignment.getRightHandSide()).validate();
                        }
                    }
                } else {
                    IDataBinding lhDBinding = assignment.getLeftHandSide().resolveDataBinding();
                    if (StatementValidator.isValidBinding(lhDBinding) && lhDBinding.getAnnotation(EGLNotInCurrentReleaseAnnotationTypeBinding.getInstance()) != null) {
                        AnnotationValidator.this.problemRequestor.acceptProblem((Node)assignment.getLeftHandSide(), 3459, new String[]{lhDBinding.getCaseSensitiveName()});
                    }
                }
                return false;
            }
        });
    }

    private void processComplexAnnotationFields(final Node target, SettingsBlock settingsBlock, final IAnnotationTypeBinding complexType) {
        settingsBlock.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                AnnotationValidator.this.processAnnotations(setValuesExpression, null, null);
                return false;
            }

            @Override
            public boolean visit(AnnotationExpression annotationExpression) {
                AnnotationValidator.this.processAnnotations(annotationExpression, null, null);
                return false;
            }

            @Override
            public boolean visit(Assignment assignment) {
                AnnotationValidator.this.processComplexAnnotationFields(target, assignment, complexType);
                return true;
            }
        });
    }

    private void processComplexAnnotationFields(Node target, Assignment assignment, IAnnotationTypeBinding complexType) {
        List annotations;
        Object value;
        IAnnotationBinding aBinding = assignment.resolveBinding();
        if (aBinding != null && complexType != null && (value = aBinding.getValue()) != null && IBinding.NOT_FOUND_BINDING != value && (annotations = complexType.getValidationProxy().getFieldAnnotations(aBinding.getName())) != null) {
            for (ValueValidationAnnotationTypeBinding nextRule : annotations) {
                nextRule.validate(assignment.getRightHandSide(), target, aBinding, this.problemRequestor, this.compilerOptions);
            }
        }
    }

    private void processSimpleAnnotationFields(Node target, Assignment assignment, IAnnotationTypeBinding simpleType) {
        List valueAnnotations = simpleType.getValueAnnotations();
        for (ValueValidationAnnotationTypeBinding nextRule : valueAnnotations) {
            IAnnotationBinding resolveBinding = assignment.resolveBinding();
            Object value = resolveBinding.getValue();
            if (value == null || IBinding.NOT_FOUND_BINDING == value) continue;
            this.problemRequestor = this.specializeProblemRequestor(this.problemRequestor, target, simpleType);
            nextRule.validate(assignment.getRightHandSide(), target, resolveBinding, this.problemRequestor, this.compilerOptions);
            this.problemRequestor = this.restoreProblemRequestor();
        }
    }

    private void processSubAnnotations(Node errorNode, Node target, ITypeBinding targetTypeBinding, IDataBinding targetDataBinding, IAnnotationBinding annotation, List rules) {
        HashMap<String, IDataBinding> allAnnotationsMap = new HashMap<String, IDataBinding>();
        allAnnotationsMap.put(annotation.getName(), annotation);
        if (((IAnnotationTypeBinding)annotation.getType()).isComplex()) {
            List fields = annotation.getAnnotations();
            for (IDataBinding annotationBinding : fields) {
                allAnnotationsMap.put(((Binding)((Object)annotationBinding)).getName(), annotationBinding);
            }
            fields = annotation.getAnnotationFields();
            for (IDataBinding annotationBinding : fields) {
                allAnnotationsMap.put(annotationBinding.getName(), annotationBinding);
            }
        }
        if (rules != null) {
            for (AnnotationValidationAnnotationTypeBinding nextRule : rules) {
                this.problemRequestor = this.specializeProblemRequestor(this.problemRequestor, target, annotation);
                nextRule.validate(errorNode, target, targetTypeBinding, allAnnotationsMap, this.problemRequestor, this.compilerOptions);
                this.problemRequestor = this.restoreProblemRequestor();
            }
        }
    }

    private void processPartSubTypeSubAnnotations(Node errorNode, Node target, IBinding subTypeBinding, List rules) {
        ArrayList fields = new ArrayList();
        fields.addAll(subTypeBinding.getAnnotations());
        if (subTypeBinding.isAnnotationBinding()) {
            fields.addAll(((IAnnotationBinding)subTypeBinding).getAnnotationFields());
        }
        HashMap<String, AnnotationBinding> allAnnotationsMap = new HashMap<String, AnnotationBinding>();
        for (AnnotationBinding annotationBinding : fields) {
            allAnnotationsMap.put(annotationBinding.getName(), annotationBinding);
        }
        if (rules != null) {
            for (Object next : rules) {
                if (!(next instanceof AnnotationValidationAnnotationTypeBinding)) continue;
                AnnotationValidationAnnotationTypeBinding nextRule = (AnnotationValidationAnnotationTypeBinding)next;
                nextRule.validate(errorNode, target, null, allAnnotationsMap, this.problemRequestor, this.compilerOptions);
            }
        }
    }

    private void processPartSubTypeFields(final Part part, final IAnnotationTypeBinding partSubType) {
        part.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(Record record) {
                return true;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                AnnotationValidator.this.processAnnotations(setValuesExpression, null, null);
                return false;
            }

            @Override
            public boolean visit(Assignment assignment) {
                List annotations = partSubType.getFieldAnnotations(((IAnnotationTypeBinding)assignment.resolveBinding().getType()).getName());
                if (annotations != null) {
                    for (ValueValidationAnnotationTypeBinding rule : annotations) {
                        rule.validate(assignment, part, assignment.resolveBinding(), AnnotationValidator.this.problemRequestor, AnnotationValidator.this.compilerOptions);
                    }
                }
                return false;
            }
        });
    }

    private void processPartSubTypeFields(final Node target, List partContents, final IAnnotationTypeBinding partSubType) {
        for (Node content : partContents) {
            content.accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(SettingsBlock settingsBlock) {
                    AnnotationValidator.this.processComplexAnnotationFields(target, settingsBlock, partSubType);
                    return false;
                }
            });
        }
    }

    private void processPartSubType(Part part, IAnnotationTypeBinding subTypeAnnotation) {
        this.processPartSubType(part.getName(), part, part.getContents(), subTypeAnnotation);
    }

    private void processPartSubType(Name partName, Node partNode, List partContents, final IAnnotationTypeBinding subTypeAnnotation) {
        final HashMap allPartAnnotations = new HashMap();
        for (Node node : partContents) {
            node.accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(StructureItem structureItem) {
                    IDataBinding structureItemBinding = (IDataBinding)structureItem.resolveBinding();
                    if (structureItemBinding != null && IBinding.NOT_FOUND_BINDING != structureItemBinding) {
                        String canonicalItemName;
                        Node nodeForErrors;
                        List annotations = structureItemBinding.getAnnotations();
                        if (structureItem.isFiller()) {
                            nodeForErrors = new Node(structureItem.getOffset(), structureItem.getOffset() + 1);
                            canonicalItemName = "*";
                        } else if (structureItem.isEmbedded()) {
                            nodeForErrors = structureItem.getType();
                            canonicalItemName = structureItem.getType().getCanonicalName();
                        } else {
                            nodeForErrors = structureItem.getName();
                            canonicalItemName = structureItem.getName().getCanonicalName();
                        }
                        this.processContentAnnotations(structureItem, nodeForErrors, structureItemBinding, canonicalItemName, annotations);
                    }
                    return false;
                }

                @Override
                public boolean visit(VariableFormField variableFormField) {
                    IDataBinding fieldBinding = (IDataBinding)variableFormField.getName().resolveBinding();
                    if (fieldBinding != null) {
                        List annotations = fieldBinding.getAnnotations();
                        this.processContentAnnotations(variableFormField, variableFormField.getName(), fieldBinding, variableFormField.getName().getCanonicalName(), annotations);
                    }
                    return false;
                }

                @Override
                public boolean visit(ConstantFormField constantFormField) {
                    FormFieldBinding fieldBinding = constantFormField.resolveBinding();
                    if (fieldBinding != null) {
                        List annotations = fieldBinding.getAnnotations();
                        this.processContentAnnotations(constantFormField, constantFormField, fieldBinding, "*", annotations);
                    }
                    return false;
                }

                @Override
                public boolean visit(ClassDataDeclaration classDataDeclaration) {
                    List names = classDataDeclaration.getNames();
                    for (Name name : names) {
                        IDataBinding classBinding = name.resolveDataBinding();
                        if (IBinding.NOT_FOUND_BINDING == classBinding || classBinding == null) continue;
                        List annotations = classBinding.getAnnotations();
                        this.processContentAnnotations(classDataDeclaration, name, classBinding, name.getCanonicalName(), annotations);
                    }
                    return false;
                }

                @Override
                public boolean visit(Constructor constructor) {
                    for (FunctionParameter param : constructor.getParameters()) {
                        IDataBinding paramBinding = param.getName().resolveDataBinding();
                        if (!Binding.isValidBinding(paramBinding)) continue;
                        Iterator annIter = subTypeAnnotation.getPartSubTypeAnnotations().iterator();
                        while (annIter.hasNext()) {
                            ((FieldContentValidationAnnotationTypeBinding)annIter.next()).validateFunctionParameter(param, paramBinding, AnnotationValidator.this.problemRequestor, AnnotationValidator.this.compilerOptions);
                        }
                    }
                    return false;
                }

                @Override
                public boolean visit(NestedFunction nestedFunction) {
                    IDataBinding nestedFunctionBinding;
                    Type returnType;
                    ITypeBinding returnTypeBinding;
                    for (FunctionParameter param : nestedFunction.getFunctionParameters()) {
                        IDataBinding paramBinding = param.getName().resolveDataBinding();
                        if (!Binding.isValidBinding(paramBinding)) continue;
                        Iterator annIter = subTypeAnnotation.getPartSubTypeAnnotations().iterator();
                        while (annIter.hasNext()) {
                            ((FieldContentValidationAnnotationTypeBinding)annIter.next()).validateFunctionParameter(param, paramBinding, AnnotationValidator.this.problemRequestor, AnnotationValidator.this.compilerOptions);
                        }
                    }
                    if (nestedFunction.hasReturnType() && Binding.isValidBinding(returnTypeBinding = (returnType = nestedFunction.getReturnType()).resolveTypeBinding())) {
                        Iterator annIter = subTypeAnnotation.getPartSubTypeAnnotations().iterator();
                        while (annIter.hasNext()) {
                            ((FieldContentValidationAnnotationTypeBinding)annIter.next()).validateFunctionReturnType(returnType, returnTypeBinding, (IPartBinding)((Part)nestedFunction.getParent()).getName().resolveBinding(), AnnotationValidator.this.problemRequestor, AnnotationValidator.this.compilerOptions);
                        }
                    }
                    if (Binding.isValidBinding(nestedFunctionBinding = nestedFunction.getName().resolveDataBinding())) {
                        this.processContentAnnotations(nestedFunction, nestedFunction.getName(), nestedFunctionBinding, nestedFunction.getName().getCanonicalName(), nestedFunctionBinding.getAnnotations());
                    }
                    return false;
                }

                private void processContentAnnotations(Node field, Node nodeForErrors, IDataBinding containerBinding, String canonicalContainerName, List annotations) {
                    IAnnotationBinding memberAnnotationsABinding;
                    Map allAnnotationsMap = AnnotationValidator.this.getAllAnnotationsMap(annotations, allPartAnnotations, nodeForErrors, containerBinding);
                    for (FieldContentValidationAnnotationTypeBinding rule : subTypeAnnotation.getPartSubTypeAnnotations()) {
                        AnnotationValidator.this.runFieldContentRuleOnBindingAndChildren(rule, containerBinding, containerBinding, nodeForErrors, field, canonicalContainerName, allAnnotationsMap, allPartAnnotations, AnnotationValidator.this.problemRequestor, false);
                    }
                    IAnnotationTypeBinding enclosingSubtype = this.getEnclosingSubtype(containerBinding);
                    if (Binding.isValidBinding(enclosingSubtype) && Binding.isValidBinding(memberAnnotationsABinding = this.getMemberAnnotationsForSubtype(enclosingSubtype))) {
                        DataItemPropertiesFieldContentRule rule = new DataItemPropertiesFieldContentRule(enclosingSubtype, (Object[])memberAnnotationsABinding.getValue());
                        AnnotationValidator.this.runFieldContentRuleOnBindingAndChildren(rule, containerBinding, containerBinding, nodeForErrors, field, canonicalContainerName, allAnnotationsMap, allPartAnnotations, AnnotationValidator.this.problemRequestor, true);
                    }
                }

                private IAnnotationTypeBinding getEnclosingSubtype(IDataBinding containerBinding) {
                    IPartBinding declaringPart = containerBinding.getDeclaringPart();
                    IAnnotationBinding subTypeAnnotationBinding = declaringPart.getSubTypeAnnotationBinding();
                    if (Binding.isValidBinding(subTypeAnnotationBinding)) {
                        return subTypeAnnotationBinding.getAnnotationType();
                    }
                    return null;
                }

                private IAnnotationBinding getMemberAnnotationsForSubtype(IAnnotationTypeBinding annotationType) {
                    IAnnotationBinding annotation = annotationType.getAnnotation(StereotypeAnnotationTypeBinding.getInstance());
                    if (Binding.isValidBinding(annotation)) {
                        return (IAnnotationBinding)annotation.findData("memberAnnotations");
                    }
                    return null;
                }
            });
        }
        if (subTypeAnnotation != null) {
            for (PartContentValidationAnnotationTypeBinding rule : subTypeAnnotation.getPartTypeAnnotations()) {
                rule.validate(partName, partNode, allPartAnnotations, this.problemRequestor);
            }
        }
    }

    private Map getAllAnnotationsMap(List annotations, HashMap allPartAnnotations, Node field, IDataBinding targetDBinding) {
        HashMap<String, AnnotationBinding> allAnnotationsMap = new HashMap<String, AnnotationBinding>();
        for (AnnotationBinding annotationBinding : annotations) {
            allAnnotationsMap.put(annotationBinding.getName(), annotationBinding);
            LinkedHashMap<AnnotationBinding, Object[]> allAnnotationsForName = (LinkedHashMap<AnnotationBinding, Object[]>)allPartAnnotations.get(annotationBinding.getName());
            if (allAnnotationsForName == null) {
                allAnnotationsForName = new LinkedHashMap<AnnotationBinding, Object[]>();
                allPartAnnotations.put(annotationBinding.getName(), allAnnotationsForName);
            }
            allAnnotationsForName.put(annotationBinding, new Object[]{field, targetDBinding});
        }
        return allAnnotationsMap;
    }

    private void runFieldContentRuleOnBindingAndChildren(FieldContentValidationAnnotationTypeBinding rule, IDataBinding topLevelDBinding, IDataBinding dBinding, Node nodeForErrors, Node target, String canonicalContainerName, Map allAnnotationsMap, HashMap allPartAnnotations, IProblemRequestor problemRequestor, boolean recurseIntoStructureItems) {
        this.runFieldContentRuleOnBindingAndChildren(rule, topLevelDBinding, new Stack(), topLevelDBinding, nodeForErrors, target, canonicalContainerName, allAnnotationsMap, allPartAnnotations, problemRequestor, recurseIntoStructureItems);
    }

    private void runFieldContentRuleOnBindingAndChildren(FieldContentValidationAnnotationTypeBinding rule, IDataBinding topLevelDBinding, Stack pathFromTopLevelDBinding, IDataBinding dBinding, Node nodeForErrors, Node target, String canonicalContainerName, Map allAnnotationsMap, HashMap allPartAnnotations, IProblemRequestor problemRequestor, boolean recurseIntoStructureItems) {
        rule.validate(nodeForErrors, target, dBinding, canonicalContainerName, allAnnotationsMap, problemRequestor, this.compilerOptions);
        ITypeBinding tBinding = dBinding.getType();
        if (tBinding != null) {
            this.runFieldContentRuleOnBindingAndChildren(rule, tBinding, topLevelDBinding, pathFromTopLevelDBinding, nodeForErrors, target, allPartAnnotations, problemRequestor);
        }
        if (recurseIntoStructureItems && 5 == dBinding.getKind()) {
            for (IDataBinding nextChild : ((StructureItemBinding)dBinding).getChildren()) {
                pathFromTopLevelDBinding.push(nextChild);
                allAnnotationsMap = this.getAllAnnotationsMap(topLevelDBinding.getAnnotationsFor(pathFromTopLevelDBinding.toArray(new IDataBinding[0])), allPartAnnotations, nodeForErrors, nextChild);
                pathFromTopLevelDBinding.pop();
                this.runFieldContentRuleOnBindingAndChildren(rule, topLevelDBinding, pathFromTopLevelDBinding, nextChild, nodeForErrors, target, nextChild.getName(), allAnnotationsMap, allPartAnnotations, problemRequestor, true);
            }
        }
    }

    private void runFieldContentRuleOnBindingAndChildren(FieldContentValidationAnnotationTypeBinding rule, ITypeBinding tBinding, IDataBinding topLevelDBinding, Stack pathFromTopLevelDBinding, Node nodeForErrors, Node target, HashMap allPartAnnotations, IProblemRequestor problemRequestor) {
        block3: {
            block2: {
                if (6 != tBinding.getKind()) break block2;
                for (IDataBinding nextChild : ((FixedRecordBinding)tBinding).getStructureItems()) {
                    pathFromTopLevelDBinding.push(nextChild);
                    Map allAnnotationsMap = this.getAllAnnotationsMap(topLevelDBinding.getAnnotationsFor(pathFromTopLevelDBinding.toArray(new IDataBinding[0])), allPartAnnotations, nodeForErrors, nextChild);
                    pathFromTopLevelDBinding.pop();
                    this.runFieldContentRuleOnBindingAndChildren(rule, topLevelDBinding, pathFromTopLevelDBinding, nextChild, nodeForErrors, target, nextChild.getName(), allAnnotationsMap, allPartAnnotations, problemRequestor, true);
                }
                break block3;
            }
            if (7 != tBinding.getKind()) break block3;
            for (IDataBinding nextChild : ((FlexibleRecordBinding)tBinding).getDeclaredFields()) {
                pathFromTopLevelDBinding.push(nextChild);
                Map allAnnotationsMap = this.getAllAnnotationsMap(topLevelDBinding.getAnnotationsFor(pathFromTopLevelDBinding.toArray(new IDataBinding[0])), allPartAnnotations, nodeForErrors, nextChild);
                this.runFieldContentRuleOnBindingAndChildren(rule, topLevelDBinding, pathFromTopLevelDBinding, nextChild, nodeForErrors, target, nextChild.getName(), allAnnotationsMap, allPartAnnotations, problemRequestor, true);
                pathFromTopLevelDBinding.pop();
            }
        }
    }
}

