/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class BaseAnnotationValidator
implements IAnnotationValidationRule {
    private static Map xsdBaseValuesToValidEGLPrimitives = new TreeMap();

    static {
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"string"), new Primitive[]{Primitive.STRING, Primitive.CHAR, Primitive.DBCHAR, Primitive.MBCHAR, Primitive.UNICODE});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"integer"), new Primitive[]{Primitive.NUM});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"int"), new Primitive[]{Primitive.INT});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"long"), new Primitive[]{Primitive.BIGINT});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"short"), new Primitive[]{Primitive.SMALLINT});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"decimal"), new Primitive[]{Primitive.DECIMAL, Primitive.MONEY, Primitive.NUM, Primitive.NUMC, Primitive.PACF});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"float"), new Primitive[]{Primitive.SMALLFLOAT});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"double"), new Primitive[]{Primitive.FLOAT});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"boolean"), new Primitive[]{Primitive.SMALLINT});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"byte"), new Primitive[]{Primitive.HEX});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"unsignedInt"), new Primitive[]{Primitive.BIGINT});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"unsignedShort"), new Primitive[]{Primitive.INT});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"unsignedByte"), new Primitive[]{Primitive.HEX});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"QName"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"dateTime"), new Primitive[]{Primitive.TIMESTAMP});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"date"), new Primitive[]{Primitive.DATE});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"time"), new Primitive[]{Primitive.TIME});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"anyURI"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"base64Binary"), new Primitive[]{Primitive.HEX});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"hexBinary"), new Primitive[]{Primitive.HEX});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"anySimpleType"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"duration"), new Primitive[]{Primitive.MONTHSPAN_INTERVAL, Primitive.SECONDSPAN_INTERVAL});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"gYearMonth"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"gYear"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"gMonthDay"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"gDay"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"gMonth"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"normalizedString"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"token"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"language"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"Name"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"NCName"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"ID"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"NMTOKEN"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"NMTOKENS"), new Primitive[]{Primitive.STRING});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"nonPositiveInteger"), new Primitive[]{Primitive.DECIMAL});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"negativeInteger"), new Primitive[]{Primitive.DECIMAL});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"nonNegativeInteger"), new Primitive[]{Primitive.DECIMAL});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"unsignedLong"), new Primitive[]{Primitive.DECIMAL});
        xsdBaseValuesToValidEGLPrimitives.put(InternUtil.intern((String)"positiveInteger"), new Primitive[]{Primitive.DECIMAL});
    }

    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (targetTypeBinding != null && 3 == targetTypeBinding.getBaseType().getKind()) {
            String val;
            Primitive[] validPrimitives;
            PrimitiveTypeBinding myPrimitiveType = (PrimitiveTypeBinding)targetTypeBinding.getBaseType();
            Primitive myPrimitive = myPrimitiveType.getPrimitive();
            IAnnotationBinding aBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"derivationBase"));
            if (aBinding != null && (validPrimitives = (Primitive[])xsdBaseValuesToValidEGLPrimitives.get(val = InternUtil.intern((String)aBinding.getValue().toString()))) != null && !BaseAnnotationValidator.containsType(validPrimitives, BaseAnnotationValidator.equivalentPrimitive(myPrimitiveType))) {
                problemRequestor.acceptProblem(errorNode, 7817, new String[]{val, myPrimitive == Primitive.BIN ? myPrimitiveType.getCaseSensitiveName() : myPrimitive.getName()});
            }
        }
    }

    private static boolean containsType(Primitive[] primAry, Primitive prim) {
        int i = 0;
        while (i < primAry.length) {
            if (primAry[i] == prim) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Primitive equivalentPrimitive(PrimitiveTypeBinding primType) {
        Primitive prim = primType.getPrimitive();
        if (prim == Primitive.BIN) {
            if (primType.getDecimals() == 0) {
                if (primType.getLength() == 4) {
                    return Primitive.SMALLINT;
                }
                if (primType.getLength() == 9) {
                    return Primitive.INT;
                }
                if (primType.getLength() == 18) {
                    return Primitive.BIGINT;
                }
            } else {
                return Primitive.DECIMAL;
            }
        }
        return prim;
    }
}

