/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IAnnotationValidationRule;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class JSFHandlerOnPrerenderFunctionAndOnConstructionFunctionValidator
implements IAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding onPrerenderFunctionABinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"onPreRenderFunction"));
        IAnnotationBinding onPostrenderFunctionABinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"onPostRenderFunction"));
        IAnnotationBinding onConstructionFunctionABinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"onConstructionFunction"));
        this.validateAgainstOnConstructionFunction(onPrerenderFunctionABinding, onConstructionFunctionABinding, errorNode, problemRequestor, compilerOptions);
        this.validateAgainstOnConstructionFunction(onPostrenderFunctionABinding, onConstructionFunctionABinding, errorNode, problemRequestor, compilerOptions);
    }

    private void validateAgainstOnConstructionFunction(IAnnotationBinding onPreorPostrenderFunctionABinding, IAnnotationBinding onConstructionFunctionABinding, Node errorNode, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (onPreorPostrenderFunctionABinding != null && onConstructionFunctionABinding != null) {
            Object onPreOrPostrenderFunctionValue = onPreorPostrenderFunctionABinding.getValue();
            Object onConstructionFunctionValue = onConstructionFunctionABinding.getValue();
            if (onPreOrPostrenderFunctionValue instanceof IFunctionBinding && Binding.isValidBinding((IBinding)onPreOrPostrenderFunctionValue) && onConstructionFunctionValue instanceof IFunctionBinding && Binding.isValidBinding((IBinding)onConstructionFunctionValue)) {
                IFunctionBinding onPreOrPostrenderFunction = (IFunctionBinding)onPreOrPostrenderFunctionValue;
                IFunctionBinding onConstructionFunction = (IFunctionBinding)onConstructionFunctionValue;
                List onPreOrPostrenderFunctionParameters = onPreOrPostrenderFunction.getParameters();
                List onConstructionFunctionParameters = onConstructionFunction.getParameters();
                if (onPreOrPostrenderFunctionParameters.size() != 0 && onConstructionFunctionParameters.size() != 0) {
                    if (onPreOrPostrenderFunctionParameters.size() != onConstructionFunctionParameters.size()) {
                        problemRequestor.acceptProblem(errorNode, 7685, new String[]{onPreOrPostrenderFunction.getCaseSensitiveName(), Integer.toString(onPreOrPostrenderFunctionParameters.size()), onConstructionFunction.getCaseSensitiveName(), Integer.toString(onConstructionFunctionParameters.size())});
                    } else {
                        int i = 0;
                        while (i < onPreOrPostrenderFunctionParameters.size()) {
                            ITypeBinding nextOnConstructionParm;
                            ITypeBinding nextOnPrerenderParm = ((IDataBinding)onPreOrPostrenderFunctionParameters.get(i)).getType();
                            if (!TypeCompatibilityUtil.typesAreIdentical(nextOnPrerenderParm, nextOnConstructionParm = ((IDataBinding)onConstructionFunctionParameters.get(i)).getType(), compilerOptions)) {
                                problemRequestor.acceptProblem(errorNode, 7686, new String[]{Integer.toString(i + 1), onPreOrPostrenderFunction.getCaseSensitiveName(), StatementValidator.getTypeString(nextOnPrerenderParm), onConstructionFunction.getCaseSensitiveName(), StatementValidator.getTypeString(nextOnConstructionParm)});
                            }
                            ++i;
                        }
                    }
                }
            }
        }
    }
}

