/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.HashSet;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IValueValidationRule;
import org.eclipse.edt.compiler.internal.core.validation.annotation.TypeNameUtility;

public class NumElementsItemForSerialMessageOrIndexedRecordValidator
implements IValueValidationRule {
    private static final HashSet validLengthItemTypes = new HashSet();

    static {
        validLengthItemTypes.add(Primitive.BIN);
        validLengthItemTypes.add(Primitive.NUM);
        validLengthItemTypes.add(Primitive.NUMC);
        validLengthItemTypes.add(Primitive.PACF);
        validLengthItemTypes.add(Primitive.DECIMAL);
        validLengthItemTypes.add(Primitive.INT);
        validLengthItemTypes.add(Primitive.SMALLINT);
    }

    @Override
    public void validate(Node errorNode, Node target, IAnnotationBinding annotationBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        String canonicalRecordName = TypeNameUtility.getName(target);
        StructureItemBinding structureItemBinding = null;
        if (annotationBinding.getValue() instanceof StructureItemBinding) {
            structureItemBinding = (StructureItemBinding)annotationBinding.getValue();
        } else if (annotationBinding.getValue() instanceof Expression && ((Expression)annotationBinding.getValue()).resolveDataBinding() instanceof StructureItemBinding) {
            structureItemBinding = (StructureItemBinding)((Expression)annotationBinding.getValue()).resolveDataBinding();
        }
        if (structureItemBinding != null) {
            if (structureItemBinding.getType().getKind() == 3) {
                PrimitiveTypeBinding primitiveTypeBinding = (PrimitiveTypeBinding)structureItemBinding.getType();
                if (!validLengthItemTypes.contains(primitiveTypeBinding.getPrimitive())) {
                    problemRequestor.acceptProblem(errorNode, 3207, new String[]{"\"" + structureItemBinding.getCaseSensitiveName() + "\"", canonicalRecordName, primitiveTypeBinding.getPrimitive().getName()});
                } else {
                    if (primitiveTypeBinding.getLength() > 9) {
                        problemRequestor.acceptProblem(errorNode, 3208, new String[]{"\"" + structureItemBinding.getCaseSensitiveName() + "\"", canonicalRecordName, primitiveTypeBinding.getName()});
                    }
                    if (primitiveTypeBinding.getDecimals() > 0) {
                        problemRequestor.acceptProblem(errorNode, 3209, new String[]{"\"" + structureItemBinding.getCaseSensitiveName() + "\"", canonicalRecordName});
                    }
                }
            } else {
                problemRequestor.acceptProblem(errorNode, 3207, new String[]{"\"" + structureItemBinding.getCaseSensitiveName() + "\"", canonicalRecordName, "char"});
            }
            this.validateNumElementsItem(errorNode, target, canonicalRecordName, structureItemBinding, problemRequestor);
        }
    }

    private void validateNumElementsItem(Node errorNode, Node target, String canonicalRecordName, StructureItemBinding numElementsItem, IProblemRequestor problemRequestor) {
        ITypeBinding typeBinding = TypeNameUtility.getType(target);
        if (typeBinding != null && 6 == typeBinding.getKind()) {
            FixedRecordBinding recordBinding = (FixedRecordBinding)typeBinding;
            StructureItemBinding structureItem = (StructureItemBinding)recordBinding.getStructureItems().get(recordBinding.getStructureItems().size() - 1);
            if (structureItem == numElementsItem) {
                problemRequestor.acceptProblem(errorNode, 3212, new String[]{canonicalRecordName, "\"" + numElementsItem.getCaseSensitiveName() + "\""});
            } else if (!structureItem.definedWithOccurs()) {
                problemRequestor.acceptProblem(errorNode, 3210, new String[]{canonicalRecordName, "\"" + numElementsItem.getCaseSensitiveName() + "\"", Integer.toString(0), structureItem.getName()});
            }
            StructureItemBinding parentItem = numElementsItem.getParentItem();
            while (parentItem != null) {
                if (parentItem == structureItem) {
                    problemRequestor.acceptProblem(errorNode, 3214, new String[]{"\"" + numElementsItem.getCaseSensitiveName() + "\"", canonicalRecordName});
                    break;
                }
                parentItem = parentItem.getParentItem();
            }
        }
    }
}

