/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.AnnotationValidationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.ConstantFormField;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.VariableFormField;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class PropertyApplicableForCertainPrimitiveTypeOnlyAnnotationValidator
extends AnnotationValidationAnnotationTypeBinding {
    protected IAnnotationTypeBinding annotationType;
    protected String canonicalAnnotationName;

    protected PropertyApplicableForCertainPrimitiveTypeOnlyAnnotationValidator(IAnnotationTypeBinding annotationType, String canonicalAnnotationName) {
        super(InternUtil.internCaseSensitive((String)"PropertyApplicableForCertainPrimitiveOnly"));
        this.annotationType = annotationType;
        this.canonicalAnnotationName = canonicalAnnotationName;
    }

    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(this.annotationType.getName());
        if (annotationBinding.getValue() != null && annotationBinding.getValue() != IBinding.NOT_FOUND_BINDING && targetTypeBinding != null && IBinding.NOT_FOUND_BINDING != targetTypeBinding && 3 == targetTypeBinding.getKind()) {
            this.validatePrimitiveType(errorNode, annotationBinding, problemRequestor, ((PrimitiveTypeBinding)targetTypeBinding).getPrimitive(), this.getCanonicalName(target));
        }
    }

    protected abstract void validatePrimitiveType(Node var1, IAnnotationBinding var2, IProblemRequestor var3, Primitive var4, String var5);

    private String getCanonicalName(Node node) {
        final String[] result = new String[]{""};
        node.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(StructureItem structureItem) {
                result[0] = structureItem.isFiller() || structureItem.isEmbedded() ? "*" : structureItem.getName().getCanonicalName();
                return false;
            }

            @Override
            public boolean visit(VariableFormField variableFormField) {
                result[0] = variableFormField.getName().getCanonicalName();
                return false;
            }

            @Override
            public boolean visit(ConstantFormField constantFormField) {
                result[0] = "*";
                return false;
            }

            @Override
            public boolean visit(SimpleName simpleName) {
                result[0] = simpleName.getCanonicalName();
                return false;
            }

            @Override
            public boolean visit(QualifiedName qualifiedName) {
                result[0] = qualifiedName.getCanonicalName();
                return false;
            }

            @Override
            public boolean visit(DataItem dataItem) {
                result[0] = dataItem.getName().getCanonicalName();
                return false;
            }
        });
        return result[0];
    }
}

