/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.ProgramBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.ProgramParameter;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.ProgramParameterValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FunctionContainerValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ProgramValidator
extends FunctionContainerValidator {
    ProgramBinding programBinding = null;
    Program program = null;

    public ProgramValidator(IProblemRequestor problemRequestor, ProgramBinding partBinding, ICompilerOptions compilerOptions) {
        super(problemRequestor, partBinding, compilerOptions);
        this.programBinding = partBinding;
    }

    @Override
    public boolean visit(Program aprogram) {
        IAnnotationBinding aBinding;
        this.program = aprogram;
        this.partNode = aprogram;
        EGLNameValidator.validate(this.program.getName(), 2, this.problemRequestor, this.compilerOptions);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(this.program);
        this.validateProgramFunctions();
        this.validateProgramParameters();
        if (this.program.isCallable()) {
            this.problemRequestor.acceptProblem((Node)this.program.getName(), 3458, new String[]{this.program.getIdentifier()});
        }
        if ((aBinding = this.programBinding.getAnnotation(new String[]{"egl", "ui", "webTransaction"}, "VGWebTransaction")) != null) {
            this.validateWebtransName(this.program);
        }
        return true;
    }

    private void validateWebtransName(Program program) {
        String name;
        boolean hasAlias = false;
        IAnnotationBinding aliasBinding = this.programBinding.getAnnotation(new String[]{"egl", "core"}, "alias");
        if (Binding.isValidBinding(aliasBinding)) {
            name = (String)aliasBinding.getValue();
            hasAlias = true;
        } else {
            name = program.getName().getCanonicalName();
        }
        String aliasedName = name;
        if (aliasedName.length() > 8) {
            Node node = program.getName();
            if (hasAlias) {
                final Node[] aliasNode = new Node[1];
                DefaultASTVisitor sbVisitor = new DefaultASTVisitor(){

                    @Override
                    public boolean visit(Program program) {
                        return true;
                    }

                    @Override
                    public boolean visit(SettingsBlock settingsBlock) {
                        if (aliasNode[0] == null) {
                            AbstractASTVisitor assVisitor = new AbstractASTVisitor(){

                                @Override
                                public boolean visit(Assignment assignment) {
                                    IAnnotationBinding annBinding = assignment.resolveBinding();
                                    if (annBinding != null && annBinding.getName() == InternUtil.intern((String)"alias")) {
                                        aliasNode[0] = assignment.getRightHandSide();
                                    }
                                    return false;
                                }
                            };
                            settingsBlock.accept(assVisitor);
                        }
                        return false;
                    }
                };
                program.accept(sbVisitor);
                if (aliasNode[0] != null) {
                    node = aliasNode[0];
                }
            }
            this.problemRequestor.acceptProblem(node, 7761, new String[]{name});
        }
    }

    @Override
    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        super.visit(classDataDeclaration);
        return false;
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        super.visit(nestedFunction);
        return false;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        super.visit(settingsBlock);
        return false;
    }

    @Override
    public boolean visit(UseStatement useStatement) {
        super.visit(useStatement);
        return false;
    }

    protected void validateProgramParameters() {
        this.program.accept(new AbstractASTVisitor(){
            int parmcount = 0;

            @Override
            public boolean visit(ProgramParameter programParameter) {
                ITypeBinding typeBinding;
                IDataBinding binding = (IDataBinding)programParameter.getName().resolveBinding();
                if (StatementValidator.isValidBinding(binding) && StatementValidator.isValidBinding(typeBinding = binding.getType())) {
                    if (typeBinding.getKind() == 7 || typeBinding.getKind() == 6) {
                        boolean error = false;
                        if (typeBinding.getKind() == 7 && ((FlexibleRecordBinding)typeBinding).getDeclaredFields().size() == 0 && ((FlexibleRecordBinding)typeBinding).getDefaultSuperType() == null) {
                            error = true;
                        }
                        if (typeBinding.getKind() == 6 && ((FixedRecordBinding)typeBinding).getStructureItems().size() == 0 && ((FixedRecordBinding)typeBinding).getDefaultSuperType() == null) {
                            error = true;
                        }
                        if (error) {
                            ProgramValidator.this.problemRequestor.acceptProblem((Node)programParameter, 3118, new String[]{programParameter.getName().getCanonicalName(), programParameter.getName().getCanonicalName()});
                        }
                    } else if (typeBinding.getKind() == 8 && InternUtil.intern((String)typeBinding.getName()) != InternUtil.intern((String)programParameter.getName().getCanonicalName())) {
                        ProgramValidator.this.problemRequestor.acceptProblem((Node)programParameter, 4901, new String[]{programParameter.getName().getCanonicalName(), typeBinding.getCaseSensitiveName()});
                    }
                    new ProgramParameterValidator(ProgramValidator.this.problemRequestor).validate(typeBinding, programParameter.getType());
                    ProgramValidator.this.checkParmTypeNotStaticArray(programParameter, programParameter.getType());
                }
                return false;
            }
        });
    }

    private void checkParmTypeNotStaticArray(ProgramParameter parm, Type parmType) {
        if (parmType.isNullableType()) {
            this.checkParmTypeNotStaticArray(parm, parmType.getBaseType());
        }
        if (parmType.isArrayType()) {
            if (((ArrayType)parmType).hasInitialSize()) {
                this.problemRequestor.acceptProblem((Node)parmType, 3069, new String[]{parm.getName().getCanonicalName()});
            } else {
                this.checkParmTypeNotStaticArray(parm, ((ArrayType)parmType).getElementType());
            }
        }
    }

    protected void validateProgramFunctions() {
        this.program.accept(new AbstractASTVisitor(){
            boolean main = false;

            @Override
            public boolean visit(NestedFunction nestedFunction) {
                if (InternUtil.intern((String)nestedFunction.getName().getCanonicalName()) == InternUtil.intern((String)"main")) {
                    this.main = true;
                    if (nestedFunction.getFunctionParameters().size() > 0) {
                        ProgramValidator.this.problemRequestor.acceptProblem((Node)nestedFunction.getFunctionParameters().get(0), 4924, new String[]{ProgramValidator.this.program.getName().getCanonicalName()});
                    }
                }
                return false;
            }

            @Override
            public void endVisit(Program aprogram) {
                if (!this.main) {
                    ProgramValidator.this.problemRequestor.acceptProblem((Node)aprogram.getName(), 4922, new String[]{aprogram.getName().getCanonicalName()});
                }
            }
        });
    }
}

