/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.CaseStatement;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IsNotExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SubstringAccess;
import org.eclipse.edt.compiler.core.ast.WhenClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class CaseStatementValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;

    public CaseStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(final CaseStatement caseStatement) {
        caseStatement.accept(new DefaultASTVisitor(){
            boolean visitingWhenClause = false;

            @Override
            public boolean visit(CaseStatement caseStatement) {
                ITypeBinding criterionType;
                if (caseStatement.hasCriterion() && StatementValidator.isValidBinding(criterionType = caseStatement.getCriterion().resolveTypeBinding()) && criterionType.getAnnotation(new String[]{"egl", "io", "dli"}, "PSBRecord") != null) {
                    CaseStatementValidator.this.problemRequestor.acceptProblem((Node)caseStatement.getCriterion(), 7932, new String[]{"case"});
                }
                return true;
            }

            @Override
            public boolean visit(WhenClause whenClause) {
                this.visitingWhenClause = true;
                return true;
            }

            @Override
            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                CaseStatementValidator.this.problemRequestor.acceptProblem(setValuesExpression, this.visitingWhenClause ? 7514 : 7513);
                return true;
            }
        });
        for (WhenClause whenClause : caseStatement.getWhenClauses()) {
            for (Expression expression : whenClause.getExpr_plus()) {
                expression.accept(new AbstractASTExpressionVisitor(){

                    @Override
                    public boolean visit(IsNotExpression isNotExpression) {
                        return false;
                    }

                    @Override
                    public boolean visit(SetValuesExpression setValuesExpression) {
                        return false;
                    }

                    @Override
                    public boolean visitExpression(Expression expr) {
                        boolean criterionExisits;
                        boolean bl = criterionExisits = caseStatement.getCriterion() != null && caseStatement.getCriterion().resolveTypeBinding() != IBinding.NOT_FOUND_BINDING;
                        if (expr.resolveTypeBinding() != null && expr.resolveTypeBinding() != null) {
                            Primitive type;
                            ITypeBinding binding = expr.resolveTypeBinding();
                            if (binding.getKind() == 3 && (type = ((PrimitiveTypeBinding)binding).getPrimitive()) != Primitive.BOOLEAN && !criterionExisits) {
                                CaseStatementValidator.this.problemRequestor.acceptProblem(expr, 5078);
                                return false;
                            }
                            if (criterionExisits && StatementValidator.isValidBinding(caseStatement.getCriterion().resolveTypeBinding()) && StatementValidator.isValidBinding(expr.resolveTypeBinding())) {
                                boolean compatible = TypeCompatibilityUtil.isMoveCompatible(caseStatement.getCriterion().resolveTypeBinding(), binding, expr, CaseStatementValidator.this.compilerOptions);
                                if (compatible && caseStatement.getCriterion().resolveTypeBinding().getAnnotation(new String[]{"egl", "io", "dli"}, "PSBRecord") != null && binding.getAnnotation(new String[]{"egl", "io", "dli"}, "PSBRecord") != null) {
                                    compatible = false;
                                }
                                if (!compatible) {
                                    CaseStatementValidator.this.problemRequestor.acceptProblem((Node)expr, 5089, new String[]{expr.getCanonicalString(), caseStatement.getCriterion().getCanonicalString()});
                                }
                            }
                        }
                        return false;
                    }
                });
            }
        }
        this.checkNoSubstringWithSpecialCriterion(caseStatement);
        return false;
    }

    private void checkNoSubstringWithSpecialCriterion(CaseStatement caseStatement) {
        if (caseStatement.hasCriterion()) {
            caseStatement.getCriterion().accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                    return true;
                }

                @Override
                public boolean visit(SubstringAccess substringAccess) {
                    boolean criterionIsSpecial = false;
                    IDataBinding dBinding = substringAccess.getPrimary().resolveDataBinding();
                    if (dBinding != null) {
                        boolean bl = criterionIsSpecial = AbstractBinder.dataBindingIs(dBinding, new String[]{"egl", "core"}, "SysVar", "SYSTEMTYPE") || AbstractBinder.dataBindingIs(dBinding, new String[]{"egl", "ui", "text"}, "ConverseVar", "EVENTKEY");
                    }
                    if (criterionIsSpecial) {
                        CaseStatementValidator.this.problemRequestor.acceptProblem(substringAccess, 3364);
                    }
                    return false;
                }
            });
        }
    }
}

