/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.ForExpressionClause;
import org.eclipse.edt.compiler.core.ast.ForUpdateClause;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.WithIDClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.SQLStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class OpenStatementValidator
extends IOStatementValidator {
    OpenStatement openStatement;

    public OpenStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(problemRequestor, compilerOptions);
    }

    @Override
    public boolean visit(final OpenStatement aopenStatement) {
        this.openStatement = aopenStatement;
        StatementValidator.validateIOTargetsContainer(aopenStatement.getIOObjects(), this.problemRequestor);
        aopenStatement.accept(new AbstractASTVisitor(){
            Node forupdate = null;
            Node into = null;
            Node using = null;
            Node usingkeys = null;
            Node withid = null;
            WithInlineSQLClause inlinesql = null;
            Node foroption = null;
            Node sqlprepare = null;

            @Override
            public boolean visit(ForExpressionClause forExpressionClause) {
                Expression expr = forExpressionClause.getExpression();
                ITypeBinding typeBinding = expr.resolveTypeBinding();
                if (StatementValidator.isValidBinding(typeBinding)) {
                    if (typeBinding.getKind() == 2) {
                        typeBinding = typeBinding.getBaseType();
                    }
                    typeBinding.getAnnotation(EGLIOSQL, "SQLRecord");
                }
                if (this.foroption != null) {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)forExpressionClause, 6510, new String[]{"open".toUpperCase(), "for".toUpperCase()});
                } else {
                    this.foroption = forExpressionClause;
                }
                return false;
            }

            @Override
            public boolean visit(ForUpdateClause forUpdateClause) {
                if (this.forupdate != null) {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)forUpdateClause, 6510, new String[]{"open".toUpperCase(), "forUpdate".toUpperCase()});
                } else {
                    this.forupdate = forUpdateClause;
                }
                return false;
            }

            @Override
            public boolean visit(IntoClause intoClause) {
                if (this.into != null) {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)intoClause, 6511, new String[]{"open".toUpperCase(), "into".toUpperCase()});
                } else {
                    this.into = intoClause;
                    intoClause.accept(new AbstractASTExpressionVisitor(){

                        @Override
                        public boolean visitExpression(Expression expression) {
                            StatementValidator.validateItemInIntoClause(expression, (this).OpenStatementValidator.this.problemRequestor);
                            return false;
                        }
                    });
                }
                return false;
            }

            @Override
            public boolean visit(UsingClause usingClause) {
                if (this.using != null) {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)usingClause, 6511, new String[]{"open".toUpperCase(), "using".toUpperCase()});
                } else {
                    this.using = usingClause;
                    StatementValidator.validateNodesInUsingClause(usingClause.getExpressions(), OpenStatementValidator.this.problemRequestor);
                }
                return false;
            }

            @Override
            public boolean visit(UsingKeysClause usingKeysClause) {
                if (this.usingkeys != null) {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)usingKeysClause, 6511, new String[]{"open".toUpperCase(), "usingKeys".toUpperCase()});
                } else {
                    this.usingkeys = usingKeysClause;
                    final List sqlRecordObjectDataBindings = StatementValidator.getSQLRecordIOObjects(aopenStatement);
                    usingKeysClause.accept(new AbstractASTExpressionVisitor(){
                        IDataBinding qualifierDBinding;

                        @Override
                        public boolean visitExpression(Expression expression) {
                            StatementValidator.validateNodeAsDataItemReferences(expression, (this).OpenStatementValidator.this.problemRequestor);
                            if (sqlRecordObjectDataBindings.contains(this.qualifierDBinding)) {
                                (this).OpenStatementValidator.this.problemRequestor.acceptProblem((Node)expression, 6542, new String[]{expression.getCanonicalString()});
                            }
                            return false;
                        }

                        @Override
                        public boolean visitName(Name name) {
                            name.accept(new DefaultASTVisitor(){

                                @Override
                                public boolean visit(SimpleName simpleName) {
                                    qualifierDBinding = (IDataBinding)simpleName.getAttribute(Name.IMPLICIT_QUALIFIER_DATA_BINDING);
                                    return false;
                                }

                                @Override
                                public boolean visit(QualifiedName qualifiedName) {
                                    qualifierDBinding = qualifiedName.getQualifier().resolveDataBinding();
                                    return false;
                                }
                            });
                            return this.visitExpression(name);
                        }

                        @Override
                        public boolean visit(FieldAccess fieldAccess) {
                            this.qualifierDBinding = fieldAccess.getPrimary().resolveDataBinding();
                            return this.visitExpression(fieldAccess);
                        }
                    });
                }
                return false;
            }

            @Override
            public boolean visit(WithIDClause withIDClause) {
                if (this.withid != null) {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)withIDClause, 6513, new String[]{"open".toUpperCase()});
                } else {
                    this.withid = withIDClause;
                    this.sqlprepare = withIDClause;
                }
                EGLNameValidator.validate(withIDClause.getID(), 19, OpenStatementValidator.this.problemRequestor, withIDClause, OpenStatementValidator.this.compilerOptions);
                return false;
            }

            @Override
            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                if (this.inlinesql != null) {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6512, new String[]{"open".toUpperCase()});
                } else if (StatementValidator.isClauseEmpty(withInlineSQLClause.getSqlStmt().getValue())) {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6500, new String[]{"open".toUpperCase()});
                } else {
                    this.sqlprepare = withInlineSQLClause;
                    this.inlinesql = withInlineSQLClause;
                    SQLStatementValidator.checkGetAndOpenClauses(withInlineSQLClause, aopenStatement.getSqlInfo().getParser(), OpenStatementValidator.this.problemRequestor, "open", this.isOpenArray());
                }
                return false;
            }

            private boolean isOpenArray() {
                Expression expr;
                ITypeBinding tb;
                if (OpenStatementValidator.this.openStatement == null) {
                    return false;
                }
                List list = OpenStatementValidator.this.openStatement.getIOObjects();
                return list.size() > 0 && Binding.isValidBinding(tb = (expr = (Expression)list.get(0)).resolveTypeBinding()) && tb.getKind() == 2;
            }

            @Override
            public void endVisit(OpenStatement openStatement) {
                if (this.usingkeys != null && this.foroption == null) {
                    OpenStatementValidator.this.problemRequestor.acceptProblem(this.usingkeys, 6530, new String[]{"open".toUpperCase()});
                }
                if (this.forupdate != null && this.inlinesql != null) {
                    if (aopenStatement.getSqlInfo().getParser().getCallClause() != null) {
                        OpenStatementValidator.this.problemRequestor.acceptProblem(this.forupdate, 6637);
                    } else {
                        SQLStatementValidator.checkForUpdateClause(this.inlinesql, aopenStatement.getSqlInfo().getParser().getSqlClauseKeywordsUsed(), OpenStatementValidator.this.problemRequestor, "open");
                    }
                }
                if (this.into != null && this.inlinesql != null && aopenStatement.getSqlInfo().getParser().getCallClause() != null) {
                    OpenStatementValidator.this.problemRequestor.acceptProblem(this.into, 6526, new String[]{"open".toUpperCase()});
                }
                if (this.inlinesql != null && this.withid != null) {
                    OpenStatementValidator.this.problemRequestor.acceptProblem(this.sqlprepare, 6509, new String[]{"open".toUpperCase()});
                }
                if (this.inlinesql == null && this.withid == null && this.foroption == null) {
                    OpenStatementValidator.this.problemRequestor.acceptProblem((Node)openStatement, 6524, new String[]{"open".toUpperCase()});
                }
                if (this.using != null && this.withid == null) {
                    OpenStatementValidator.this.problemRequestor.acceptProblem(this.using, 6514, new String[]{"open".toUpperCase()});
                }
                openStatement = null;
            }
        });
        return false;
    }
}

