/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.AnnotationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.DataItemBinding;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordFieldBinding;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.LocalVariableBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.binding.annotationType.StereotypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.ArrayAccess;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.BinaryExpression;
import org.eclipse.edt.compiler.core.ast.BooleanLiteral;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.CaseStatement;
import org.eclipse.edt.compiler.core.ast.CharLiteral;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.CloseStatement;
import org.eclipse.edt.compiler.core.ast.ContinueStatement;
import org.eclipse.edt.compiler.core.ast.ConverseStatement;
import org.eclipse.edt.compiler.core.ast.DBCharLiteral;
import org.eclipse.edt.compiler.core.ast.DecimalLiteral;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.DisplayStatement;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.ExitStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.FloatLiteral;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.ForwardStatement;
import org.eclipse.edt.compiler.core.ast.FreeSQLStatement;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.GetByPositionStatement;
import org.eclipse.edt.compiler.core.ast.GotoStatement;
import org.eclipse.edt.compiler.core.ast.HexLiteral;
import org.eclipse.edt.compiler.core.ast.IfStatement;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.MBCharLiteral;
import org.eclipse.edt.compiler.core.ast.MoveStatement;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.NullableType;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.OpenUIStatement;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.PrepareStatement;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.PrintStatement;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.ReturnStatement;
import org.eclipse.edt.compiler.core.ast.SetStatement;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.ShowStatement;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.core.ast.SubstringAccess;
import org.eclipse.edt.compiler.core.ast.ThrowStatement;
import org.eclipse.edt.compiler.core.ast.TransferStatement;
import org.eclipse.edt.compiler.core.ast.TryStatement;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.WhileStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemPartManager;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.statement.AssignmentStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.LValueValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class StatementValidator
implements IOStatementValidatorConstants {
    private static HashSet CONTAINER_TYPEBINDING_KINDS = new HashSet<Integer>(Arrays.asList(new Integer(6), new Integer(7), new Integer(5), new Integer(8), new Integer(28), new Integer(6)));

    public static ITypeBinding getBaseType(ITypeBinding tb) {
        while (tb.isReference()) {
            tb = tb.getBaseType();
        }
        return tb;
    }

    public static String getTypeString(ITypeBinding binding) {
        StringBuffer result = new StringBuffer();
        switch (binding.getKind()) {
            case 22: {
                result.append("arrayDictionary");
                break;
            }
            case 21: {
                result.append("dictionary");
                break;
            }
            case 2: {
                result.append(String.valueOf(StatementValidator.getShortTypeString(((ArrayTypeBinding)binding).getElementType(), true)) + "[]");
                break;
            }
            case 18: {
                result.append("@");
                result.append(binding.getCaseSensitiveName());
                break;
            }
            default: {
                result.append(binding.getCaseSensitiveName());
            }
        }
        if (binding.isNullable()) {
            result.append("?");
        }
        return result.toString();
    }

    public static String getShortTypeString(ITypeBinding binding) {
        return StatementValidator.getShortTypeString(binding, false);
    }

    public static String getShortTypeString(ITypeBinding binding, boolean includeLengthForPrimitives) {
        StringBuffer result = new StringBuffer();
        if (3 == binding.getKind()) {
            Primitive prim = ((PrimitiveTypeBinding)binding).getPrimitive();
            if (includeLengthForPrimitives || Primitive.MONTHSPAN_INTERVAL == prim || Primitive.SECONDSPAN_INTERVAL == prim) {
                result = new StringBuffer(StatementValidator.getTypeString(binding));
            } else {
                result = new StringBuffer(((PrimitiveTypeBinding)binding).getPrimitive().getName());
                if (binding.isNullable()) {
                    result.append("?");
                }
            }
        } else {
            result = new StringBuffer(StatementValidator.getTypeString(binding));
        }
        return result.toString();
    }

    public static boolean isMultiplyOccuring(IDataBinding dataBinding) {
        if (dataBinding == null) {
            return false;
        }
        if (dataBinding.getKind() == 7) {
            return ((FormFieldBinding)dataBinding).isMultiplyOccuring();
        }
        if (dataBinding.getKind() == 5) {
            return ((StructureItemBinding)dataBinding).isMultiplyOccuring();
        }
        return false;
    }

    public static boolean isArray(IDataBinding dataBinding) {
        if (dataBinding == null) {
            return false;
        }
        return dataBinding.getType() != null && dataBinding.getType().getKind() == 2;
    }

    public static boolean isArrayOrMultiplyOccuring(IDataBinding dataBinding) {
        return StatementValidator.isArray(dataBinding) || StatementValidator.isMultiplyOccuring(dataBinding);
    }

    public static String getParmListString(ITypeBinding[] types) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < types.length) {
            if (types[i] != null) {
                sb.append(StatementValidator.getTypeString(types[i]));
                if (i < types.length - 1) {
                    sb.append(", ");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean isValidBinding(IBinding binding) {
        return binding != null && binding != IBinding.NOT_FOUND_BINDING;
    }

    public static boolean isStringCompatible(ITypeBinding aTypeBinding) {
        Primitive prim;
        return StatementValidator.isValidBinding(aTypeBinding) && aTypeBinding.getKind() == 3 && ((prim = ((PrimitiveTypeBinding)aTypeBinding).getPrimitive()) == Primitive.CHAR || prim == Primitive.DBCHAR || prim == Primitive.HEX || prim == Primitive.MBCHAR || prim == Primitive.UNICODE || prim == Primitive.STRING || prim == Primitive.ANY);
    }

    public static boolean isIntegerCompatible(ITypeBinding aTypeBinding) {
        if (StatementValidator.isValidBinding(aTypeBinding) && aTypeBinding.getKind() == 3) {
            Primitive prim = ((PrimitiveTypeBinding)aTypeBinding).getPrimitive();
            if (prim == Primitive.BIGINT || prim == Primitive.INT || prim == Primitive.SMALLINT) {
                return true;
            }
            if (prim == Primitive.BIN || prim == Primitive.DECIMAL || prim == Primitive.NUM || prim == Primitive.NUMC || prim == Primitive.PACF) {
                return ((PrimitiveTypeBinding)aTypeBinding).getDecimals() == 0;
            }
            if (prim == Primitive.ANY) {
                return true;
            }
        }
        return false;
    }

    public static boolean isRecordOrRecordArray(ITypeBinding typeBinding) {
        return typeBinding.getKind() == 7 || typeBinding.getKind() == 6 || typeBinding.getKind() == 2 && StatementValidator.isRecordOrRecordArray(typeBinding.getBaseType());
    }

    protected static boolean isClauseEmpty(String clause) {
        int i = 0;
        while (i < clause.length()) {
            if (!Character.isWhitespace(clause.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean checkArguments(ITypeBinding[] toArgs, ITypeBinding[] fromArgs, ICompilerOptions compilerOptions) {
        boolean ok = true;
        if (toArgs.length != fromArgs.length) {
            ok = false;
        } else {
            int i = 0;
            while (i < toArgs.length) {
                boolean compatible;
                if (StatementValidator.isValidBinding(toArgs[i]) && StatementValidator.isValidBinding(fromArgs[i]) && !(compatible = TypeCompatibilityUtil.isMoveCompatible(toArgs[i], fromArgs[i], null, compilerOptions))) {
                    ok = false;
                    break;
                }
                ++i;
            }
        }
        return ok;
    }

    public static String getQualifiedName(ITypeBinding typeBinding) {
        StringBuffer typeName = new StringBuffer();
        String[] packageName = typeBinding.getPackageName();
        int i = 0;
        while (i < packageName.length) {
            typeName.append(packageName[i]);
            typeName.append(".");
            ++i;
        }
        typeName.append(typeBinding.getName());
        return typeName.toString();
    }

    public static void validateNodesAsDataItemReferences(List nodes, IProblemRequestor pr) {
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            StatementValidator.validateNodeAsDataItemReferences((Node)iter.next(), pr);
        }
    }

    public static boolean validateNodeAsDataItemReferences(Node node, final IProblemRequestor problemRequestor) {
        final boolean[] isValid = new boolean[]{true};
        node.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visitExpression(Expression expression) {
                ITypeBinding typeBinding = expression.resolveTypeBinding();
                IDataBinding dataBinding = expression.resolveDataBinding();
                if (StatementValidator.isValidBinding(typeBinding) && StatementValidator.isValidBinding(dataBinding) && (typeBinding.getKind() != 3 || dataBinding.getKind() == 3 && ((ClassFieldBinding)dataBinding).isConstant() || dataBinding.getKind() == 2 && ((LocalVariableBinding)dataBinding).isConstant())) {
                    problemRequestor.acceptProblem((Node)expression, 6622, new String[]{expression.getCanonicalString()});
                    isValid[0] = false;
                }
                return false;
            }

            @Override
            public boolean visit(SubstringAccess substringAccess) {
                problemRequestor.acceptProblem(substringAccess, 3364);
                isValid[0] = false;
                return false;
            }
        });
        return isValid[0];
    }

    public static void validateNodesInUsingClause(List nodes, IProblemRequestor pr) {
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            StatementValidator.validateNodeInUsingClause((Expression)iter.next(), pr);
        }
    }

    protected static void validateNodeInUsingClause(Expression node, IProblemRequestor problemRequestor) {
        if (StatementValidator.validateNodeAsDataItemReferences(node, problemRequestor)) {
            final boolean[] exprValid = new boolean[1];
            node.accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                    return true;
                }

                @Override
                public boolean visit(SimpleName simpleName) {
                    exprValid[0] = true;
                    return false;
                }

                @Override
                public boolean visit(QualifiedName qualifiedName) {
                    exprValid[0] = true;
                    return false;
                }

                @Override
                public boolean visit(ArrayAccess arrayAccess) {
                    exprValid[0] = true;
                    return false;
                }

                @Override
                public boolean visit(SubstringAccess substringAccess) {
                    exprValid[0] = true;
                    return false;
                }

                @Override
                public boolean visit(FieldAccess fieldAccess) {
                    exprValid[0] = true;
                    return false;
                }

                @Override
                public boolean visit(StringLiteral stringLiteral) {
                    exprValid[0] = true;
                    return false;
                }

                @Override
                public boolean visit(CharLiteral charLiteral) {
                    exprValid[0] = true;
                    return false;
                }

                @Override
                public boolean visit(DBCharLiteral dBCharLiteral) {
                    exprValid[0] = true;
                    return false;
                }

                @Override
                public boolean visit(FloatLiteral floatLiteral) {
                    exprValid[0] = true;
                    return false;
                }

                @Override
                public boolean visit(HexLiteral hexLiteral) {
                    exprValid[0] = true;
                    return false;
                }

                @Override
                public boolean visit(MBCharLiteral mBCharLiteral) {
                    exprValid[0] = true;
                    return false;
                }

                @Override
                public boolean visit(IntegerLiteral integerLiteral) {
                    exprValid[0] = true;
                    return false;
                }

                @Override
                public boolean visit(DecimalLiteral decimalLiteral) {
                    exprValid[0] = true;
                    return false;
                }

                @Override
                public boolean visit(BooleanLiteral booleanLiteral) {
                    exprValid[0] = true;
                    return false;
                }

                @Override
                public boolean visit(BinaryExpression binaryExpression) {
                    exprValid[0] = this.isStringLiteral(binaryExpression);
                    return false;
                }

                private boolean isStringLiteral(Expression expr) {
                    final boolean[] result = new boolean[1];
                    expr.accept(new DefaultASTVisitor(){

                        @Override
                        public boolean visit(StringLiteral stringLiteral) {
                            result[0] = true;
                            return false;
                        }

                        @Override
                        public boolean visit(BinaryExpression binaryExpression) {
                            result[0] = BinaryExpression.Operator.PLUS == binaryExpression.getOperator() && this.isStringLiteral(binaryExpression.getFirstExpression()) && this.isStringLiteral(binaryExpression.getSecondExpression());
                            return false;
                        }
                    });
                    return result[0];
                }
            });
            if (!exprValid[0]) {
                problemRequestor.acceptProblem((Node)node, 6609, new String[]{node.getCanonicalString()});
            }
        }
    }

    public static void validateItemInIntoClause(Node node, final IProblemRequestor problemRequestor) {
        node.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }

            @Override
            public boolean visit(ArrayAccess arrayAccess) {
                Iterator iter = arrayAccess.getIndices().iterator();
                while (iter.hasNext()) {
                    ((Node)iter.next()).accept(new AbstractASTVisitor(){

                        @Override
                        public void endVisit(FunctionInvocation functionInvocation) {
                            problemRequestor.acceptProblem(functionInvocation, 3377);
                        }
                    });
                }
                return false;
            }
        });
        node.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visitExpression(Expression expression) {
                ITypeBinding typeBinding = expression.resolveTypeBinding();
                IDataBinding dataBinding = expression.resolveDataBinding();
                if (StatementValidator.isValidBinding(typeBinding)) {
                    boolean isValid = true;
                    if (this.isContainer(typeBinding)) {
                        isValid = true;
                    } else if (dataBinding == null) {
                        isValid = false;
                    } else if (dataBinding.getKind() == 3) {
                        isValid = !((ClassFieldBinding)dataBinding).isConstant();
                    } else if (dataBinding.getKind() == 2) {
                        boolean bl = isValid = !((LocalVariableBinding)dataBinding).isConstant();
                    }
                    if (!isValid) {
                        problemRequestor.acceptProblem((Node)expression, 3454, new String[]{expression.getCanonicalString()});
                    } else if (typeBinding.isDynamic()) {
                        problemRequestor.acceptProblem(expression, 3378);
                    }
                }
                return false;
            }

            private boolean isContainer(ITypeBinding typeBinding) {
                return CONTAINER_TYPEBINDING_KINDS.contains(new Integer(typeBinding.getKind()));
            }

            @Override
            public boolean visit(SubstringAccess substringAccess) {
                problemRequestor.acceptProblem(substringAccess, 3364);
                return false;
            }
        });
    }

    public static void validateIOTargetsContainer(List targets, IProblemRequestor problemRequestor) {
        StatementValidator.validateIOTargetsContainer(targets, problemRequestor, new DefaultTargetsContainerChecker());
    }

    public static void validateIOTargetsContainer(List targets, final IProblemRequestor problemRequestor, final ITargetsContainerChecker checker) {
        for (Expression expr : targets) {
            expr.accept(new AbstractASTExpressionVisitor(){

                @Override
                public boolean visit(SimpleName simpleName) {
                    IDataBinding db;
                    IDataBinding dataBinding = (IDataBinding)simpleName.getAttribute(Name.IMPLICIT_QUALIFIER_DATA_BINDING);
                    if (StatementValidator.isValidBinding(dataBinding) && dataBinding.getKind() == 11 && !checker.isLibraryDataAllowed(db = simpleName.resolveDataBinding())) {
                        this.addError(simpleName);
                    }
                    return false;
                }

                @Override
                public boolean visit(QualifiedName qualifiedName) {
                    Name name = qualifiedName;
                    IBinding binding = null;
                    while (name != null) {
                        binding = name.resolveBinding();
                        if (!StatementValidator.isValidBinding(binding)) {
                            return false;
                        }
                        if (binding.isDataBinding() && ((IDataBinding)binding).getKind() == 11 || binding.isTypeBinding() && ((ITypeBinding)binding).getKind() == 11) {
                            IDataBinding db = qualifiedName.resolveDataBinding();
                            if (checker.isLibraryDataAllowed(db)) break;
                            this.addError(qualifiedName);
                            break;
                        }
                        if (!((Name)name).isQualifiedName()) break;
                        name = name.getQualifier();
                    }
                    return false;
                }

                @Override
                public boolean visit(FieldAccess fieldAccess) {
                    return true;
                }

                @Override
                public boolean visit(ArrayAccess arrayAccess) {
                    return false;
                }

                protected void addError(Expression node) {
                    problemRequestor.acceptProblem(node, 6710);
                }

                @Override
                public boolean visitExpression(Expression expression) {
                    return true;
                }
            });
        }
    }

    public static void validateDataDeclarationInitializer(Node dataDeclaration, final IProblemRequestor problemRequestor, final ICompilerOptions compilerOptions) {
        dataDeclaration.accept(new AbstractASTVisitor(){
            Expression lhs = null;
            Expression rhs = null;
            ITypeBinding lhsBinding = null;
            ITypeBinding rhsBinding = null;
            IDataBinding lhsDataBinding = null;
            IDataBinding rhsDataBinding = null;

            @Override
            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                if (classDataDeclaration.getNames().size() > 0) {
                    SimpleName name = (SimpleName)classDataDeclaration.getNames().get(0);
                    this.lhs = name;
                    IBinding binding = name.resolveBinding();
                    if (StatementValidator.isValidBinding(binding)) {
                        if (binding.isTypeBinding()) {
                            this.lhsBinding = (ITypeBinding)binding;
                        } else if (binding.isDataBinding()) {
                            this.lhsDataBinding = (IDataBinding)binding;
                            this.lhsBinding = this.lhsDataBinding.getType();
                        }
                    }
                }
                if (classDataDeclaration.hasInitializer()) {
                    this.rhs = classDataDeclaration.getInitializer();
                    this.rhsBinding = this.rhs.resolveTypeBinding();
                    this.rhsDataBinding = this.rhs.resolveDataBinding();
                }
                return false;
            }

            @Override
            public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                if (functionDataDeclaration.getNames().size() > 0) {
                    SimpleName name = (SimpleName)functionDataDeclaration.getNames().get(0);
                    this.lhs = name;
                    IBinding binding = name.resolveBinding();
                    if (StatementValidator.isValidBinding(binding)) {
                        if (binding.isTypeBinding()) {
                            this.lhsBinding = (ITypeBinding)binding;
                        } else if (binding.isDataBinding()) {
                            this.lhsDataBinding = (IDataBinding)binding;
                            this.lhsBinding = this.lhsDataBinding.getType();
                        }
                    }
                }
                if (functionDataDeclaration.hasInitializer()) {
                    this.rhs = functionDataDeclaration.getInitializer();
                    this.rhsBinding = this.rhs.resolveTypeBinding();
                    this.rhsDataBinding = this.rhs.resolveDataBinding();
                }
                return false;
            }

            @Override
            public void endVisit(ClassDataDeclaration classDataDeclaration) {
                if (classDataDeclaration.hasInitializer()) {
                    this.validate();
                }
            }

            @Override
            public void endVisit(FunctionDataDeclaration functionDataDeclaration) {
                this.validate();
            }

            protected void validate() {
                new AssignmentStatementValidator(problemRequestor, compilerOptions, null).validateAssignment(Assignment.Operator.ASSIGN, this.lhs, this.rhs, this.lhsBinding, this.rhsBinding, this.lhsDataBinding, this.rhsDataBinding, true, false, new LValueValidator.DefaultLValueValidationRules(){

                    @Override
                    public boolean canAssignToConstantVariables() {
                        return true;
                    }
                });
            }
        });
    }

    public static void validatePrimitiveConstant(Type type, IProblemRequestor problemRequestor) {
        if (type.isArrayType()) {
            type = ((ArrayType)type).getBaseType();
        }
        if (type.isNullableType()) {
            StatementValidator.validatePrimitiveConstant(((NullableType)type).getBaseType(), problemRequestor);
        }
        if (type.isPrimitiveType()) {
            return;
        }
        if (type.isNameType()) {
            Name name = ((NameType)type).getName();
            IBinding binding = name.resolveBinding();
            ITypeBinding typeBinding = null;
            if (StatementValidator.isValidBinding(binding)) {
                if (binding.isDataBinding()) {
                    typeBinding = ((IDataBinding)binding).getType();
                } else if (binding.isTypeBinding() && Binding.isValidBinding(typeBinding = (ITypeBinding)binding) && typeBinding.getKind() == 17) {
                    typeBinding = ((DataItemBinding)typeBinding).getPrimitiveTypeBinding();
                }
            }
            if (StatementValidator.isValidBinding(typeBinding) && typeBinding.getKind() != 3) {
                problemRequestor.acceptProblem(type, 4954);
            }
        }
    }

    public static void validateDataDeclarationType(Type type, IProblemRequestor problemRequestor, IPartBinding declaringPart) {
        ITypeBinding typeBinding;
        ITypeBinding tbinding;
        if (type.isArrayType()) {
            ITypeBinding typeBinding2 = ((ArrayType)type).resolveTypeBinding();
            Type thistype = type;
            while (StatementValidator.isValidBinding(typeBinding2) && typeBinding2.getKind() == 2) {
                if (thistype.isNullableType()) {
                    NullableType nullType = (NullableType)thistype;
                    thistype = nullType.getBaseType();
                    typeBinding2 = thistype.resolveTypeBinding();
                    continue;
                }
                ArrayType atype = (ArrayType)thistype;
                if (atype.hasInitialSize()) {
                    problemRequestor.acceptProblem(type, 3248);
                }
                thistype = atype.getElementType();
                typeBinding2 = ((ArrayTypeBinding)typeBinding2).getElementType();
            }
        }
        if (Binding.isValidBinding(tbinding = type.resolveTypeBinding()) && tbinding.getKind() == 2 && StatementValidator.isValidBinding(typeBinding = tbinding.getBaseType())) {
            if (typeBinding.getAnnotation(EGLUIWEBTRANSACTION, "VGUIRecord") != null) {
                problemRequestor.acceptProblem(type, 7773);
            }
            if (14 == typeBinding.getKind() || 15 == typeBinding.getKind() && SystemPartManager.findType(typeBinding.getName()) != typeBinding) {
                problemRequestor.acceptProblem(type, 7820);
            }
        }
        if ((type = type.getBaseType()).isPrimitiveType()) {
            return;
        }
        if (type.isNameType()) {
            Name name = ((NameType)type).getName();
            IBinding binding = name.resolveBinding();
            ITypeBinding typeBinding3 = null;
            if (StatementValidator.isValidBinding(binding)) {
                if (binding.isDataBinding()) {
                    typeBinding3 = ((IDataBinding)binding).getType();
                } else if (binding.isTypeBinding()) {
                    typeBinding3 = (ITypeBinding)binding;
                } else if (binding.isFunctionBinding()) {
                    typeBinding3 = (ITypeBinding)binding;
                }
            }
            if (StatementValidator.isValidBinding(typeBinding3) && typeBinding3.getKind() != 3 && typeBinding3.getKind() != 22 && !typeBinding3.isReference() && typeBinding3.getKind() != 6 && typeBinding3.getKind() != 7 && typeBinding3.getKind() != 17 && typeBinding3.getKind() != 10 && typeBinding3.getKind() != 21 && typeBinding3.getKind() != 27 && typeBinding3.getKind() != 19) {
                problemRequestor.acceptProblem((Node)type, 4926, new String[]{typeBinding3.getPackageQualifiedName()});
            }
            if (StatementValidator.isAnnotationRecord(typeBinding3) && !StatementValidator.isAnnotationRecord(declaringPart)) {
                problemRequestor.acceptProblem((Node)type, 4926, new String[]{typeBinding3.getPackageQualifiedName()});
            }
        }
    }

    public static boolean isAnnotationRecord(IBinding binding) {
        if (!Binding.isValidBinding(binding)) {
            return false;
        }
        if (!binding.isTypeBinding()) {
            return false;
        }
        if (((ITypeBinding)binding).getKind() != 7) {
            return false;
        }
        return ((FlexibleRecordBinding)binding).isAnnotationRecord();
    }

    public static void validateDeclarationForStereotypeContext(IDataBinding dBinding, IProblemRequestor problemRequestor, Node nodeForErrors) {
        IAnnotationBinding aBinding;
        IPartSubTypeAnnotationTypeBinding subType;
        ITypeBinding type = dBinding.getType();
        if (Binding.isValidBinding(type) && Binding.isValidBinding(type = type.getBaseType()) && type.isPartBinding() && (subType = ((IPartBinding)type).getSubType()) != null && IBinding.NOT_FOUND_BINDING != subType && (aBinding = dBinding.getAnnotation(subType).getAnnotation(AnnotationAnnotationTypeBinding.getInstance())) != null && (aBinding = aBinding.getAnnotation(StereotypeAnnotationTypeBinding.getInstance())) != null && IBinding.NOT_FOUND_BINDING != (aBinding = (IAnnotationBinding)aBinding.findData("stereotypeContexts"))) {
            boolean declaringSubtypeIsValid = false;
            IPartBinding declaringType = dBinding.getDeclaringPart();
            if (declaringType != null) {
                ITypeBinding declaringSubtype = declaringType.getSubType();
                if (declaringSubtype instanceof AnnotationTypeBindingImpl) {
                    declaringSubtype = ((AnnotationTypeBindingImpl)declaringSubtype).getAnnotationRecord();
                }
                Object[] value = (Object[])aBinding.getValue();
                int i = 0;
                while (i < value.length && !declaringSubtypeIsValid) {
                    if (value[i] == declaringSubtype) {
                        declaringSubtypeIsValid = true;
                    }
                    ++i;
                }
            }
            if (!declaringSubtypeIsValid) {
                problemRequestor.acceptProblem(nodeForErrors, 3410, new String[]{StatementValidator.getTypeString(type), dBinding.getDeclaringPart().getCaseSensitiveName()});
            }
        }
    }

    protected static boolean validateRecordParamDimensions(StructureItemBinding sBinding, IProblemRequestor problemRequestor, Node node, String name, String typename, int level) {
        if (StatementValidator.isValidBinding(sBinding)) {
            if (++level == 7) {
                problemRequestor.acceptProblem(node, 5034, new String[]{name, typename});
                return false;
            }
            List children = sBinding.getChildren();
            for (StructureItemBinding childbinding : children) {
                boolean bContinue;
                if (!StatementValidator.isValidBinding(childbinding) || (bContinue = StatementValidator.validateRecordParamDimensions(childbinding, problemRequestor, node, name, typename, level))) continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean validateRecordParamDimensions(ArrayTypeBinding typeBinding, IProblemRequestor problemRequestor, Node node, String name, String typename, int level) {
        if (StatementValidator.isValidBinding(typeBinding) && typeBinding.getKind() == 2) {
            boolean bContinue;
            List list;
            if (++level == 7) {
                problemRequestor.acceptProblem(node, 5034, new String[]{name, typename});
                return false;
            }
            ITypeBinding baseBinding = typeBinding.getBaseType();
            if (baseBinding.getKind() == 7) {
                list = ((FlexibleRecordBinding)baseBinding).getDeclaredFields();
                for (FlexibleRecordFieldBinding fbinding : list) {
                    if (!StatementValidator.isValidBinding(fbinding.getType()) || fbinding.getType().getKind() != 2 || (bContinue = StatementValidator.validateRecordParamDimensions((ArrayTypeBinding)fbinding.getType(), problemRequestor, node, name, typename, level))) continue;
                    return false;
                }
            }
            if (baseBinding.getKind() == 6) {
                list = ((FixedRecordBinding)baseBinding).getStructureItems();
                for (StructureItemBinding sbinding : list) {
                    bContinue = StatementValidator.validateRecordParamDimensions(sbinding, problemRequestor, node, name, typename, level);
                    if (bContinue) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void validateRecordParamDimensions(Type type, IProblemRequestor problemRequestor, Node node, String name) {
        ITypeBinding typeBinding;
        if (type.isArrayType() && StatementValidator.isValidBinding(typeBinding = ((ArrayType)type).resolveTypeBinding())) {
            String typename = typeBinding.getBaseType().getName();
            StatementValidator.validateRecordParamDimensions((ArrayTypeBinding)typeBinding, problemRequestor, node, name, typename, 0);
        }
    }

    public static List getSQLRecordIOObjects(Statement statement) {
        ArrayList<IDataBinding> sqlRecordObjectDataBindings = new ArrayList<IDataBinding>();
        List IOObjects = statement.getIOObjects();
        Iterator iter = IOObjects.iterator();
        while (iter.hasNext()) {
            ITypeBinding type;
            IDataBinding nextDBinding = ((Expression)iter.next()).resolveDataBinding();
            if (nextDBinding == null || IBinding.NOT_FOUND_BINDING == nextDBinding || (type = nextDBinding.getType()) == null || 2 != type.getKind() || ((ArrayTypeBinding)type).getElementType().getAnnotation(EGLIOSQL, "SQLRecord") == null) continue;
            sqlRecordObjectDataBindings.add(nextDBinding);
        }
        return sqlRecordObjectDataBindings;
    }

    public static void validateRequiredFieldsInCUIDeclaration(Type declType, SettingsBlock settingsBlock, IProblemRequestor problemRequestor) {
        StatementValidator.validateRequiredFieldsInCUIDeclaration(declType, settingsBlock, false, problemRequestor);
    }

    public static void validateRequiredFieldsInCUIDeclaration(Type declType, SettingsBlock settingsBlock, boolean isConstantConsoleFormField, IProblemRequestor problemRequestor) {
        ITypeBinding declTypeBinding = declType.resolveTypeBinding();
        if (IBinding.NOT_FOUND_BINDING != declTypeBinding && declTypeBinding != null) {
            Iterator iter;
            declTypeBinding = declTypeBinding.getBaseType();
            if (settingsBlock != null && AbstractBinder.typeIs(declTypeBinding, new String[]{"egl", "ui", "console"}, "Menu")) {
                final boolean[] hasLabelKeyOrLabelText = new boolean[1];
                iter = settingsBlock.getSettings().iterator();
                while (!hasLabelKeyOrLabelText[0] && iter.hasNext()) {
                    ((Node)iter.next()).accept(new DefaultASTVisitor(){

                        @Override
                        public boolean visit(Assignment assignment) {
                            assignment.getLeftHandSide().accept(new AbstractASTExpressionVisitor(){

                                @Override
                                public boolean visitName(Name name) {
                                    String identifier = name.getIdentifier();
                                    if (InternUtil.intern((String)"labelKey") == identifier || InternUtil.intern((String)"labelText") == identifier) {
                                        hasLabelKeyOrLabelText[0] = true;
                                    }
                                    return false;
                                }
                            });
                            return false;
                        }
                    });
                }
                if (!hasLabelKeyOrLabelText[0]) {
                    problemRequestor.acceptProblem((Node)declType, 7724, new String[]{"labelText"});
                }
            }
            if (AbstractBinder.typeIs(declTypeBinding, new String[]{"egl", "ui", "console"}, "ConsoleField") && !isConstantConsoleFormField && !declType.isArrayType()) {
                final boolean[] hasFieldLenOrSegements = new boolean[1];
                if (settingsBlock != null) {
                    iter = settingsBlock.getSettings().iterator();
                    while (!hasFieldLenOrSegements[0] && iter.hasNext()) {
                        ((Node)iter.next()).accept(new DefaultASTVisitor(){

                            @Override
                            public boolean visit(Assignment assignment) {
                                assignment.getLeftHandSide().accept(new AbstractASTExpressionVisitor(){

                                    @Override
                                    public boolean visitName(Name name) {
                                        String identifier = name.getIdentifier();
                                        if (InternUtil.intern((String)"fieldLen") == identifier || InternUtil.intern((String)"segments") == identifier) {
                                            hasFieldLenOrSegements[0] = true;
                                        }
                                        return false;
                                    }
                                });
                                return false;
                            }
                        });
                    }
                }
                if (!hasFieldLenOrSegements[0]) {
                    problemRequestor.acceptProblem((Node)declType, 7722, new String[]{"fieldLen"});
                }
            }
        }
    }

    public static String getName(Statement statement) {
        final String[] result = new String[1];
        statement.accept(new DefaultASTVisitor(){

            @Override
            public void endVisit(AddStatement addStatement) {
                result[0] = "add";
            }

            @Override
            public void endVisit(CallStatement callStatement) {
                result[0] = "call";
            }

            @Override
            public void endVisit(CaseStatement caseStatement) {
                result[0] = "case";
            }

            @Override
            public void endVisit(CloseStatement closeStatement) {
                result[0] = "close";
            }

            @Override
            public void endVisit(ContinueStatement continueStatement) {
                result[0] = "continue";
            }

            @Override
            public void endVisit(ConverseStatement converseStatement) {
                result[0] = "converse";
            }

            @Override
            public void endVisit(DeleteStatement deleteStatement) {
                result[0] = "delete";
            }

            @Override
            public void endVisit(DisplayStatement displayStatement) {
                result[0] = "display";
            }

            @Override
            public void endVisit(ExecuteStatement executeStatement) {
                result[0] = "execute";
            }

            @Override
            public void endVisit(ExitStatement exitStatement) {
                result[0] = "exit";
            }

            @Override
            public void endVisit(ForEachStatement forEachStatement) {
                result[0] = "forEach";
            }

            @Override
            public void endVisit(ForStatement forStatement) {
                result[0] = "for";
            }

            @Override
            public void endVisit(ForwardStatement forwardStatement) {
                result[0] = "forward";
            }

            @Override
            public void endVisit(FreeSQLStatement freeSQLStatement) {
                result[0] = "freeSql";
            }

            @Override
            public void endVisit(GetByKeyStatement getByKeyStatement) {
                result[0] = "get";
            }

            @Override
            public void endVisit(GetByPositionStatement getByPositionStatement) {
                result[0] = "get";
            }

            @Override
            public void endVisit(GotoStatement gotoStatement) {
                result[0] = "goto";
            }

            @Override
            public void endVisit(IfStatement ifStatement) {
                result[0] = "if";
            }

            @Override
            public void endVisit(MoveStatement moveStatement) {
                result[0] = "move";
            }

            @Override
            public void endVisit(OpenStatement openStatement) {
                result[0] = "open";
            }

            @Override
            public void endVisit(OpenUIStatement openUIStatement) {
                result[0] = "openUI";
            }

            @Override
            public void endVisit(PrintStatement printStatement) {
                result[0] = "print";
            }

            @Override
            public void endVisit(ReplaceStatement replaceStatement) {
                result[0] = "replace";
            }

            @Override
            public void endVisit(ShowStatement showStatement) {
                result[0] = "show";
            }

            @Override
            public void endVisit(ThrowStatement throwStatement) {
                result[0] = "throw";
            }

            @Override
            public void endVisit(TransferStatement transferStatement) {
                result[0] = "transfer";
            }

            @Override
            public void endVisit(TryStatement tryStatement) {
                result[0] = "try";
            }

            @Override
            public void endVisit(WhileStatement whileStatement) {
                result[0] = "while";
            }

            @Override
            public void endVisit(ReturnStatement returnStatement) {
                result[0] = "return";
            }

            @Override
            public void endVisit(SetStatement setStatement) {
                result[0] = "set";
            }

            @Override
            public void endVisit(PrepareStatement prepareStatement) {
                result[0] = "prepare";
            }
        });
        if (result[0] == null) {
            throw new RuntimeException("Must define visit() for class " + statement.getClass() + " in StatementValidator::getName()");
        }
        return result[0];
    }

    public static boolean isFlexibleBasicOrSQL(ITypeBinding typeBinding) {
        if (Binding.isValidBinding(typeBinding)) {
            return typeBinding.getKind() == 7 && (typeBinding.getAnnotation(EGLCORE, "BasicRecord") != null || typeBinding.getAnnotation(EGLIOSQL, "SQLRecord") != null);
        }
        return false;
    }

    public static class DefaultTargetsContainerChecker
    implements ITargetsContainerChecker {
        @Override
        public boolean isLibraryDataAllowed(IDataBinding dataBinding) {
            return false;
        }
    }

    public static interface ITargetsContainerChecker {
        public boolean isLibraryDataAllowed(IDataBinding var1);
    }
}

