/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.edt.compiler.internal.io.IIOBufferReader;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;

public abstract class CommonZipFileIOBufferReader
implements IIOBufferReader {
    public abstract File getFile();

    @Override
    public InputStream getInputStream(String name) throws IOException {
        File cacheFile = this.getFile();
        if (cacheFile.exists()) {
            ZipFile zipFile = new ZipFile(cacheFile);
            ZipEntry entry = zipFile.getEntry(IRFileNameUtility.toIRFileName(name));
            if (entry == null) {
                zipFile.close();
                return null;
            }
            return zipFile.getInputStream(entry);
        }
        return null;
    }

    @Override
    public List getEntries() throws IOException {
        ArrayList<String> entries = new ArrayList<String>();
        File file = this.getFile();
        if (file.exists()) {
            ZipFile zipFile = new ZipFile(file);
            try {
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    entries.add(enumeration.nextElement().getName());
                }
            }
            finally {
                zipFile.close();
            }
        }
        return entries;
    }
}

